# Document - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example Bundle: Document



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "bun-document-example",
  "meta" : {
    "profile" : [
      "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Bundle-document-twcore"
    ]
  },
  "identifier" : {
    "system" : "https://www.tph.mohw.gov.tw",
    "value" : "01010905170415100000000"
  },
  "type" : "document",
  "timestamp" : "2023-11-18T12:34:56.000Z",
  "entry" : [
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Composition/com-example",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "com-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_com-example\"> </a><h3><b>陳加玲的病摘</b></h3><p><b>臨床狀態</b>：Final <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">(<a href=\"http://hl7.org/fhir/composition-status\">CompositionStatus</a>#final)</span></p><p><b>種類</b>：Medical records <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://loinc.org\">LOINC</a>#11503-0)</span></p><p><b>分類</b>： Hospital Admission history and physical note <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://loinc.org\">LOINC</a>#47039-3)</span></p><p><b>病人</b>：<a href=\"Patient-pat-example.html\">Patient/pat-example</a> &quot;陳加玲&quot;</p><p><b>編輯時間</b>：2023-09-10T10:30:00</p><p><b>病摘創建者</b>：<a href=\"Practitioner-pra-dr-example.html\">Practitioner/pra-dr-example</a> &quot;王依昇&quot;</p><p><b>根據特定技術領域的定義</b>：restricted <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://terminology.hl7.org/CodeSystem/v3-Confidentiality/\">v3 Code System Confidentiality</a>#R)</span></p><p><b>證明準確性</b>：</p><blockquote><p><b>認證者提供的認證類型</b>：Personal <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/composition-attestation-mode/\">CompositionAttestationMode</a>#personal)</span></p><p><b>被證明的時間</b>：2023-09-10T11:00:00</p><p><b>負責證明的人員</b>：<a href=\"Practitioner-pra-dr-example.html\">Practitioner/pra-dr-example</a> &quot;王依昇&quot;</p><p><b>負責維護機構</b>：<a href=\"Organization-org-hosp-example.html\">Organization/org-hosp-example</a> &quot;衛生福利部臺北醫院&quot;</p></blockquote><p><b>正在記錄的臨床服務</b>：</p><blockquote><p><b>被記錄的主要臨床行為代碼</b>：medication list <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://terminology.hl7.org/CodeSystem/v3-ActCode/\">ActCode</a>#MEDLIST)</span></p><p><b>文件所涵蓋的時間區間</b>：2023-09-10T08:00:00 ～ 2023-09-15T09:30:00</p></blockquote><p><b>病摘小節內容：</b></p><blockquote><p><b>section.entry[Observation]</b>：<a href=\"Observation-obs-bloodPressure-example.html\">Observation/obs-bloodPressure-example</a></p><p><b>section.entry[Practitioner]</b>：<a href=\"Practitioner-pra-dr-example.html\">Practitioner/pra-dr-example</a></p><p><b>section.entry[MedicationRequest]</b>：<a href=\"MedicationRequest-med-req-cod-example.html\">MedicationRequest/med-req-cod-example</a></p></blockquote></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11503-0",
              "display" : "Medical records"
            }
          ]
        },
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://loinc.org",
                "code" : "47039-3"
              }
            ]
          }
        ],
        "subject" : {
          "reference" : "Patient/pat-example"
        },
        "date" : "2023-09-10T10:30:00Z",
        "author" : [
          {
            "reference" : "Practitioner/pra-dr-example"
          }
        ],
        "title" : "陳加玲的病摘",
        "confidentiality" : "R",
        "attester" : [
          {
            "mode" : "personal",
            "time" : "2023-09-10T11:00:00Z",
            "party" : {
              "reference" : "Practitioner/pra-dr-example"
            }
          }
        ],
        "custodian" : {
          "reference" : "Organization/org-hosp-example"
        },
        "event" : [
          {
            "code" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
                    "code" : "MEDLIST",
                    "display" : "medication list"
                  }
                ]
              }
            ],
            "period" : {
              "start" : "2023-09-10T08:00:00Z",
              "end" : "2023-09-15T09:30:00Z"
            }
          }
        ],
        "section" : [
          {
            "entry" : [
              {
                "reference" : "Practitioner/pra-dr-example"
              },
              {
                "reference" : "Observation/obs-bloodPressure-example"
              },
              {
                "reference" : "MedicationRequest/med-req-cod-example"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Practitioner/pra-dr-example",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "pra-dr-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_pra-dr-example\"> </a><h3><b>醫師基本資料</b></h3><blockquote><p><b>識別碼型別</b>：National Person Identifier <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#NNxxx）</span><br/><b>身分證字號（official）</b>：D123456789 （http://www.moi.gov.tw）</p></blockquote><blockquote><p><b>識別碼型別</b>：Medical License number <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#MD）</span><br/><b>員工編號（official）</b>：KP00017 （https://www.tph.mohw.gov.tw）</p></blockquote><p><b>健康照護服務提供者的紀錄（active）</b>：使用中</p><p><b>姓名（official）</b>：王依昇 Wang, Yi Sheng</p><p><b>性別</b>：男性</p><p><b>出生日期</b>：1980-11-11</p><p><b>聯絡方式</b>：Phone<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0993277826<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>聯絡地址</b>：(330)桃園市桃園區五福五街31號<br/><b>郵遞區號（postalCode）[extension: <a href=\"StructureDefinition-tw-postal-code.html\">tw-postal-code</a>]</b>：<a href=\"CodeSystem-postal-code3-tw.html\">330</a><br/><b>縣/市（district）</b>：桃園市<br/><b>鄉/鎮/市/區（city）</b>：桃園區<br/><b>路/街（line）</b>：五福五街<br/><b>號（number）[extension: <a href=\"StructureDefinition-tw-number.html\">tw-number</a>]</b>：31號<br/><b>國家（country）</b>：臺灣<br/></p><p><b>資格證書的型別</b>：西醫師 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://snomed.info/sct\">SNOMED CT</a>#394802001）</span><br/><b>資格證書的開始日期</b>：2005-05-25</p><p><b>照護服務提供人員影像</b>： <a href=\"https://1.bp.blogspot.com/-6dSaKA-5r0c/UZSs9HLyutI/AAAAAAAATBc/lxpq2MB3_mc/s400/doctor.png\">doctor.png</a><br/><img src=\"https://1.bp.blogspot.com/-6dSaKA-5r0c/UZSs9HLyutI/AAAAAAAATBc/lxpq2MB3_mc/s400/doctor.png\" width=\"250px\"/></p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NNxxx"
                }
              ]
            },
            "system" : "http://www.moi.gov.tw",
            "value" : "D123456789"
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MD"
                }
              ]
            },
            "system" : "https://www.tph.mohw.gov.tw",
            "value" : "KP00017"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "text" : "王依昇",
            "family" : "Wang",
            "given" : ["Yi Sheng"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0993277826",
            "use" : "mobile",
            "period" : {
              "start" : "2022-07-31",
              "end" : "2024-07-31"
            }
          }
        ],
        "address" : [
          {
            "extension" : [
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
                "valueString" : "31號"
              }
            ],
            "text" : "桃園市桃園區五福五街31號",
            "line" : ["五福五街"],
            "city" : "桃園區",
            "district" : "桃園市",
            "_postalCode" : {
              "extension" : [
                {
                  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                        "code" : "330"
                      }
                    ]
                  }
                }
              ]
            },
            "country" : "TW"
          }
        ],
        "gender" : "male",
        "birthDate" : "1980-11-11",
        "photo" : [
          {
            "contentType" : "image/png",
            "data" : "TWFuIGlzIGRpc3Rpbmd1aXNoZWQsIG5vdCBvbmx5IGJ5IGhpcyByZWFzb24sIGJ1dCBieSB0aGlzIHNpbmd1bGFyIHBhc3Npb24gZnJvbSBvdGhlciBhbmltYWxzLCB3aGljaCBpcyBhIGx1c3Qgb2YgdGhlIG1pbmQsIHRoYXQgYnkgYSBwZXJzZXZlcmFuY2Ugb2YgZGVsaWdodCBpbiB0aGUgY29udGludWVkIGFuZCBpbmRlZmF0aWdhYmxlIGdlbmVyYXRpb24gb2Yga25vd2xlZGdlLCBleGNlZWRzIHRoZSBzaG9ydCB2ZWhlbWVuY2Ugb2YgYW55IGNhcm5hbCBwbGVhc3VyZS4=",
            "url" : "doctor.png"
          }
        ],
        "qualification" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://snomed.info/sct",
                  "code" : "394802001",
                  "display" : "General medicine"
                }
              ]
            },
            "period" : {
              "start" : "2005-05-25"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Patient/pat-example",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "pat-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_pat-example\"> </a><h3><b>病人基本資料-身分證字號及病歷號</b></h3><blockquote><p><b>識別碼型別</b>：National Person Identifier <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#NNxxx <b>[extension: <a href=\"StructureDefinition-identifier-suffix.html\">Identifier Suffix</a>]：</b>TWN）</span><br/><b>身分證字號（official）</b>：A123456789 （http://www.moi.gov.tw）</p></blockquote><blockquote><p><b>識別碼型別</b>：Medical record number <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">Identifier Type Codes</a>#MR）</span><br/><b>病歷號（official）</b>：8862168 （https://www.tph.mohw.gov.tw）</p></blockquote><p><b>病人的紀錄（active）</b>：使用中</p><p><b>姓名（official）</b>：陳加玲 Chan, Chia Lin</p><p><b>性別</b>：女性</p><p><b>出生日期</b>：1990-01-01</p><p><b>年齡[extension: <a href=\"StructureDefinition-person-age.html\">person-age</a>]</b>：32</p><p><b>國籍[extension: <a href=\"http://hl7.org/fhir/StructureDefinition/patient-nationality\">patient-nationality</a>]</b>：<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://terminology.hl7.org/CodeSystem-ISO3166Part1.html\">ISO3166Part1</a>#TW）</span></p><p><b>聯絡方式</b>：Phone <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0911327999 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>聯絡地址</b>：(103)臺北市大同區大有里19鄰承德路三段52巷6弄210號2樓B室<br/><b>郵遞區號（postalCode） [extension: <a href=\"StructureDefinition-tw-postal-code.html\">tw-postal-code</a>] </b>： <a href=\"CodeSystem-postal-code3-tw.html\">103</a><br/><b>縣/市（district）</b>：臺北市<br/><b>鄉/鎮/市/區（city）</b>：大同區<br/><b>村(里)（village） [extension: <a href=\"StructureDefinition-tw-village.html\">tw-village</a>] </b>：大有里<br/><b>鄰（neighborhood） [extension: <a href=\"StructureDefinition-tw-neighborhood.html\">tw-neighborhood</a>] </b>：19鄰<br/><b>路/街（line）</b>：承德路<br/><b>段(section) [extension: <a href=\"StructureDefinition-tw-section.html\">tw-section</a>] </b>：三段<br/><b>巷/衖（lane） [extension: <a href=\"StructureDefinition-tw-lane.html\">tw-lane</a>] </b>：52巷<br/><b>弄（alley） [extension: <a href=\"StructureDefinition-tw-alley.html\">tw-alley</a>] </b>：6弄<br/><b>號（number） [extension: <a href=\"StructureDefinition-tw-number.html\">tw-number</a>] </b>：210號<br/><b>樓（floor） [extension: <a href=\"StructureDefinition-tw-floor.html\">tw-floor</a>] </b>：2樓<br/><b>室（room） [extension: <a href=\"StructureDefinition-tw-room.html\">tw-room</a>] </b>：B室<br/><b>國家（country）</b>：臺灣<br/><br/></p><p><b>婚姻狀態</b>：unmarried <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v3-MaritalStatus\">臺灣婚姻狀態值集</a>#U）</span></p><p><b>聯絡人（official）</b>：李立偉 Li, Li Wei<br/><b>關係</b>：father <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v3-RoleCode\">PatientRelationshipType</a>#FTH）</span><br/><b>聯絡方式</b>：Phone <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：（Mobile）0917159753 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"https://build.fhir.org/codesystem-contact-point-use.html\">ContactPointUse</a>#mobile）</span><br/><b>聯絡電話使用效期</b>：2022-07-31至2024-07-31</p><p><b>向病人說明健康狀態時所使用的語言</b>：中文</p><p><b>紀錄的保管機構</b>： <a href=\"Organization-org-hosp-example.html\">Organization/org-hosp-example</a> &quot;衛生福利部臺北醫院&quot;</p><p><b>病人影像</b>： <a href=\"https://2.bp.blogspot.com/-v3yEwItkXKQ/VaMN_1Nx6TI/AAAAAAAAvhM/zDXN_eZw_UE/s800/youngwoman_42.png\">patient.png</a><br/><img src=\"https://2.bp.blogspot.com/-v3yEwItkXKQ/VaMN_1Nx6TI/AAAAAAAAvhM/zDXN_eZw_UE/s800/youngwoman_42.png\" width=\"250px\"/></p></div>"
        },
        "extension" : [
          {
            "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/person-age",
            "valueAge" : {
              "value" : 32,
              "system" : "http://unitsofmeasure.org",
              "code" : "a"
            }
          },
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "TW"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-nationality"
          }
        ],
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "NNxxx",
                  "_code" : {
                    "extension" : [
                      {
                        "extension" : [
                          {
                            "url" : "suffix",
                            "valueString" : "TWN"
                          },
                          {
                            "url" : "valueSet",
                            "valueCanonical" : "http://hl7.org/fhir/ValueSet/iso3166-1-3"
                          }
                        ],
                        "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix"
                      }
                    ]
                  }
                }
              ]
            },
            "system" : "http://www.moi.gov.tw",
            "value" : "A123456789"
          },
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "MR"
                }
              ]
            },
            "system" : "https://www.tph.mohw.gov.tw",
            "value" : "8862168"
          }
        ],
        "active" : true,
        "name" : [
          {
            "use" : "official",
            "text" : "陳加玲",
            "family" : "Chen",
            "given" : ["Chia Lin"]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0911327999",
            "use" : "mobile",
            "period" : {
              "start" : "2022-07-31",
              "end" : "2024-07-31"
            }
          }
        ],
        "gender" : "female",
        "birthDate" : "1990-01-01",
        "address" : [
          {
            "extension" : [
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-section",
                "valueString" : "三段"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-number",
                "valueString" : "210號"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-village",
                "valueString" : "大有里"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-neighborhood",
                "valueString" : "19鄰"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-lane",
                "valueString" : "52巷"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-alley",
                "valueString" : "6弄"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-floor",
                "valueString" : "2樓"
              },
              {
                "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-room",
                "valueString" : "B室"
              }
            ],
            "text" : "臺北市大同區大有里19鄰承德路三段52巷6弄210號2樓B室",
            "line" : ["承德路"],
            "city" : "大同區",
            "district" : "臺北市",
            "_postalCode" : {
              "extension" : [
                {
                  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
                  "valueCodeableConcept" : {
                    "coding" : [
                      {
                        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw",
                        "code" : "103"
                      }
                    ]
                  }
                }
              ]
            },
            "country" : "TW"
          }
        ],
        "maritalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/v3-MaritalStatus",
              "code" : "U"
            }
          ]
        },
        "photo" : [
          {
            "contentType" : "image/jpeg",
            "url" : "patient.png"
          }
        ],
        "contact" : [
          {
            "relationship" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                    "code" : "FTH"
                  }
                ]
              }
            ],
            "name" : {
              "use" : "official",
              "text" : "李立偉",
              "family" : "Li",
              "given" : ["Li Wei"]
            },
            "telecom" : [
              {
                "system" : "phone",
                "value" : "0917159753",
                "use" : "mobile",
                "period" : {
                  "start" : "2022-07-31",
                  "end" : "2024-07-31"
                }
              }
            ]
          }
        ],
        "communication" : [
          {
            "language" : {
              "coding" : [
                {
                  "system" : "urn:ietf:bcp:47",
                  "code" : "zh-TW"
                }
              ]
            }
          }
        ],
        "managingOrganization" : {
          "reference" : "Organization/org-hosp-example"
        }
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Observation/obs-lab-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-lab-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_obs-lab-example\"> </a><h3><b>檢驗檢查資料</b></h3><p><b>狀態</b>：最終版(final)</p><p><b>分類</b>：Laboratory <span style=\"background: LightGoldenRodYellow; margin：4px; border：1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-observation-category.html\">Observation Category Codes</a>#laboratory)</span></p><p><b>檢驗項目</b>：血中尿素氮 <span style=\"background: LightGoldenRodYellow; margin：4px; border：1px solid khaki\">( <a href=\"CodeSystem-medical-service-payment-tw.html\">臺灣醫療服務給付項目</a>#09002C)</span></p><p><b>病人</b>： <a href=\"Patient-pat-example.html\">Patient/pat-example</a> &quot;陳加玲&quot;</p><p><b>執行日期</b>：2022-07-31</p><p><b>負責機構</b>： <a href=\"Organization-org-hosp-example.html\">Organization/org-hosp-example</a> &quot;衛生福利部臺北醫院&quot;</p><p><b>檢驗值</b>：16.6 mg/dL</p></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "laboratory"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
              "code" : "09002C"
            }
          ],
          "text" : "血中尿素氮"
        },
        "subject" : {
          "reference" : "Patient/pat-example"
        },
        "effectiveDateTime" : "2022-07-31",
        "performer" : [
          {
            "reference" : "Organization/org-hosp-example"
          }
        ],
        "valueQuantity" : {
          "value" : 16.6,
          "unit" : "mg/dL"
        }
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Observation/obs-bloodPressure-example",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "obs-bloodPressure-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-bloodPressure-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_obs-bloodPressure-example\"> </a><h3><b>檢驗檢查資料</b></h3><p><b>狀態</b>：final</p><p><b>分類</b>：Vital Signs <span style=\"background: LightGoldenRodYellow; margin：4px; border：1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-observation-category.html\">Observation Category Codes</a>#vital-signs)</span></p><p><b>檢驗項目</b>：Blood pressure panel with all children optional <span style=\"background: LightGoldenRodYellow; margin：4px; border：1px solid khaki\">( <a href=\"http://loinc.org\">LOINC</a>#85354-9 &quot;Blood pressure panel with all children optional&quot;)</span></p><p><b>病人</b>： <a href=\"Patient-pat-example.html\">Patient/pat-example</a> &quot;陳加玲&quot;</p><p><b>檢查者</b>：<a href=\"Practitioner-pra-dr-example.html\">Practitioner/pra-dr-example</a> &quot;王依昇&quot;</p><p><b>執行日期</b>：2022-07-31</p><p><b>檢驗結果</b></p><blockquote><p><b>檢驗項目</b>：Systolic blood pressure <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://loinc.org\">LOINC</a>#8480-6)</span></p><p><b>檢驗值</b>：110 mmHg <span style=\"background: LightGoldenRodYellow\"/></p></blockquote><blockquote><p><b>檢驗項目</b>：Diastolic blood pressure <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://loinc.org\">LOINC</a>#8462-4)</span></p><p><b>檢驗值</b>：56 mmHg</p></blockquote></div>"
        },
        "status" : "final",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
                "code" : "vital-signs",
                "display" : "Vital Signs"
              }
            ]
          }
        ],
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "85354-9",
              "display" : "Blood pressure panel with all children optional"
            }
          ],
          "text" : "Blood pressure panel with all children optional"
        },
        "subject" : {
          "reference" : "Patient/pat-example"
        },
        "effectiveDateTime" : "2022-07-31",
        "performer" : [
          {
            "reference" : "Practitioner/pra-dr-example"
          }
        ],
        "component" : [
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8480-6",
                  "display" : "Systolic blood pressure"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 110,
              "unit" : "mmHg",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          },
          {
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "8462-4",
                  "display" : "Diastolic blood pressure"
                }
              ]
            },
            "valueQuantity" : {
              "value" : 56,
              "unit" : "mmHg",
              "system" : "http://unitsofmeasure.org",
              "code" : "mm[Hg]"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Organization/org-hosp-example",
      "resource" : {
        "resourceType" : "Organization",
        "id" : "org-hosp-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-hosp-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Organization_org-hosp-example\"> </a><h3><b>醫事機構基本資料</b></h3><p><b>機構名稱</b>：衛生福利部臺北醫院</p><p><b>識別碼型別</b>：Provider number<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">（ <a href=\"http://terminology.hl7.org/CodeSystem/v2-0203\">IdentifierType</a>#PRN）</span><br/><b>機構代碼（official）</b>：0131060029 (https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw)</p><p><b>機構種類</b>：Healthcare Provider <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-organization-type.html\">OrganizationType</a>#prov)</span></p><p><b>聯絡方式</b>：Phone<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/><b>聯絡電話</b>：0222765566</p></div>"
        },
        "identifier" : [
          {
            "use" : "official",
            "type" : {
              "coding" : [
                {
                  "system" : "http://terminology.hl7.org/CodeSystem/v2-0203",
                  "code" : "PRN"
                }
              ]
            },
            "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw",
            "value" : "0131060029"
          }
        ],
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
                "code" : "prov"
              }
            ]
          }
        ],
        "name" : "衛生福利部臺北醫院",
        "telecom" : [
          {
            "system" : "phone",
            "value" : "0222765566"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/MedicationRequest/med-req-cod-example",
      "resource" : {
        "resourceType" : "MedicationRequest",
        "id" : "med-req-cod-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationRequest_med-req-cod-example\"> </a><h3><b>藥品請求的詳細資料</b></h3><p><b>藥品請求的識別碼</b>：7077 （http://www.moi.gov.tw）</p><p><b>藥品請求的狀態</b>：Active <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason\">MedicationRequest Status Reason Codes</a>#clarif)</span></p><p><b>藥品請求的意圖</b>：Order <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/CodeSystem/medicationrequest-intent\">medicationRequest Intent</a>#order)</span></p><p><b>藥品請求的類別</b>：Discharge <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://terminology.hl7.org/CodeSystem/medicationrequest-category\">MedicationRequest Category Codes</a>#discharge)</span></p><p><b>藥品</b>：阿立批挫 <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"CodeSystem-medication-fda-tw.html\">臺灣藥品及醫療器材代碼值集</a>#衛署藥輸字第025485號)</span></p><p><b>病人</b>：<a href=\"Patient-pat-example.html\">Patient/pat-example</a> &quot;陳加玲&quot;</p><p><b>就醫事件</b>：<a href=\"Encounter-enc-example.html\">Encounter/enc-example</a></p><p><b>最初請求時間</b>：2022-08-01 06:00:14-0500</p><p><b>提出藥品請求請求者</b>：<a href=\"Practitioner-pra-dr-example.html\">Practitioner/pra-dr-example</a> &quot;王依昇&quot;</p><p><b>開立處方的原因</b>：<a href=\"Observation-obs-lab-example.html\">Observation/obs-lab-example</a></p><p><b>處方可用以配藥的有效期限</b>：2022-08-01 06:00:14-0500 --&gt; 2022-08-08 06:00:14-0500</p></div>"
        },
        "identifier" : [
          {
            "system" : "http://www.moi.gov.tw",
            "value" : "7077"
          }
        ],
        "status" : "active",
        "statusReason" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-status-reason",
              "code" : "clarif"
            }
          ]
        },
        "intent" : "order",
        "category" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/medicationrequest-category",
                "code" : "discharge"
              }
            ]
          }
        ],
        "medicationCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-fda-tw",
              "code" : "衛署藥輸字第025485號",
              "display" : "阿立批挫"
            }
          ],
          "text" : "阿立批挫"
        },
        "subject" : {
          "reference" : "Patient/pat-example"
        },
        "encounter" : {
          "reference" : "Encounter/enc-example"
        },
        "authoredOn" : "2022-08-01T18:00:14+08:00",
        "requester" : {
          "reference" : "Practitioner/pra-dr-example"
        },
        "reasonReference" : [
          {
            "reference" : "Observation/obs-lab-example"
          }
        ],
        "dosageInstruction" : [
          {
            "text" : "三餐飯後，口服",
            "timing" : {
              "code" : {
                "coding" : [
                  {
                    "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-frequency-nhi-tw",
                    "code" : "PC"
                  }
                ],
                "text" : "三餐飯後"
              }
            },
            "route" : {
              "coding" : [
                {
                  "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-path-tw",
                  "code" : "PO"
                }
              ]
            },
            "doseAndRate" : [
              {
                "type" : {
                  "coding" : [
                    {
                      "system" : "http://terminology.hl7.org/CodeSystem/dose-rate-type",
                      "code" : "ordered"
                    }
                  ]
                }
              }
            ]
          }
        ],
        "dispenseRequest" : {
          "validityPeriod" : {
            "start" : "2022-08-01T18:00:14+08:00",
            "end" : "2022-08-08T18:00:14+08:00"
          }
        }
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Encounter/enc-example",
      "resource" : {
        "resourceType" : "Encounter",
        "id" : "enc-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Encounter_enc-example\"> </a><h3><b>就醫資料</b></h3><p><b>識別碼</b>：E22081702</p><p><b>就醫現況</b>：finished</p><p><b>就醫分類</b>：pre-admission <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"https://terminology.hl7.org/4.0.0/ValueSet-v3-ActEncounterCode.html\">ActEncounterCode</a>#PRENC)</span></p><p><b>就醫種類</b>：Annual diabetes mellitus screening <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-encounter-type.html\">Encounter type</a>#ADMS)</span></p><p><b>服務型別</b>：腎臟內科(Nephrology (qualifier value)) <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://snomed.info/sct\">Service type</a>#394589003)</span></p><p><b>病人</b>：<a href=\"Patient-pat-example.html\">Patient/pat-example</a> &quot;陳加玲&quot;</p><p><b>出院後的地點</b>：Home <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-encounter-discharge-disposition.html\">Discharge disposition</a>#home)</span></p><p><b>就醫發生的地點</b>：<a href=\"Location-loc-ent-example.html\">Location/loc-ent-example</a> &quot;衛生福利部臺北醫院&quot;</p><h3>參與就醫的健康照護服務提供者</h3><table class=\"grid\"><tr><td>-</td><td><b>角色</b></td><td><b>參與時段</b></td><td><b>參與人</b></td></tr><tr><td>*</td><td>primary performer <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"https://terminology.hl7.org/4.0.0/CodeSystem-v3-ParticipationType.html\">ParticipationType</a>#PPRF)</span></td><td>2022-08-01 17:00:14+08:00 --&gt; 2022-08-01 18:00:14+08:00</td><td><a href=\"Practitioner-pra-dr-example.html\">Practitioner/pra-dr-example</a> &quot;王依昇&quot;</td></tr></table><p><b>就醫的開始和結束時間</b>：2022-08-01 17:00:14+08:00 --&gt; 2022-08-01T18:00:14 08:00</p><p><b>就醫原因</b>：FH: Diabetes mellitus <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"https://browser.ihtsdotools.org/\">SNOMED CT</a>#160303001)</span></p></div>"
        },
        "identifier" : [
          {
            "system" : "http://healthcare.example.org/identifiers/enocunter",
            "value" : "E22081702"
          }
        ],
        "status" : "finished",
        "class" : {
          "system" : "http://terminology.hl7.org/CodeSystem/v3-ActCode",
          "code" : "PRENC"
        },
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/encounter-type",
                "code" : "ADMS"
              }
            ]
          }
        ],
        "serviceType" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "394589003",
              "display" : "Nephrology (qualifier value)"
            }
          ],
          "text" : "腎臟內科"
        },
        "subject" : {
          "reference" : "Patient/pat-example"
        },
        "participant" : [
          {
            "type" : [
              {
                "coding" : [
                  {
                    "system" : "http://terminology.hl7.org/CodeSystem/v3-ParticipationType",
                    "code" : "PPRF"
                  }
                ]
              }
            ],
            "period" : {
              "start" : "2022-08-01T17:00:14+08:00",
              "end" : "2022-08-01T18:00:14+08:00"
            },
            "individual" : {
              "reference" : "Practitioner/pra-dr-example"
            }
          }
        ],
        "period" : {
          "start" : "2022-08-01T17:00:14+08:00",
          "end" : "2022-08-01T18:00:14+08:00"
        },
        "reasonCode" : [
          {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "code" : "160303001",
                "display" : "FH: Diabetes mellitus"
              }
            ]
          }
        ],
        "hospitalization" : {
          "dischargeDisposition" : {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/discharge-disposition",
                "code" : "home"
              }
            ]
          }
        },
        "location" : [
          {
            "location" : {
              "reference" : "Location/loc-ent-example"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://twcore.mohw.gov.tw/ig/twcore/Location/loc-ent-example",
      "resource" : {
        "resourceType" : "Location",
        "id" : "loc-ent-example",
        "meta" : {
          "profile" : [
            "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Location_loc-ent-example\"> </a><h3><b>衛生福利部臺北醫院耳鼻喉科</b></h3><p><b>地點狀態</b>: Active <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/codesystem-location-status.html\">LocationStatus</a>#active)</span></p><p><b>地點類別</b>: Kind <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"http://hl7.org/fhir/R4/valueset-location-mode.html\">LocationMode</a>#kind)</span></p><p><b>地點類型</b>: Otorhinolaryngology clinic <span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\">( <a href=\"https://terminology.hl7.org/CodeSystem-v3-RoleCode.html\">RoleCode</a>#ENT)</span></p><p><b>地點資訊</b>: 診治各種耳、鼻、咽、喉等上呼吸道疾病及頭頸部腫瘤 , 包括 : 感冒、咳嗽、頭痛、喉嚨痛、聲音沙啞、吞嚥困難、呼吸不順、鼻塞、鼻竇炎、鼻過敏、鼻息肉、扁桃腺肥大、耳鳴、耳痛、中耳炎、顏面神經麻痺、顎顳關節痛、口乾舌燥、打鼾、語言障礙、食道異物取出、頭頸部腫瘤、舌及口咽腫瘤手術。</p><p><b>負責維護地點的機構</b>: <a href=\"Organization-org-hosp-example.html\">Organization/org-hosp-example</a> &quot;衛生福利部臺北醫院&quot;</p><p><b>聯絡方式</b>：Phone<span style=\"background: LightGoldenRodYellow; margin: 4px; border: 1px solid khaki\"> （ <a href=\"https://hl7.org/fhir/R4/valueset-contact-point-system.html\">ContactPointSystem</a>#phone）</span><br/></p><p><b>聯絡電話（work）</b>：02-2276-5566</p><p><b>聯絡地址（work）</b>：242新北市新莊區思源路127號</p><p><b>地點開放時間</b>：週一 ～ 週五 ， 全天</p></div>"
        },
        "status" : "active",
        "name" : "衛生福利部臺北醫院耳鼻喉科",
        "description" : "診治各種耳、鼻、咽、喉等上呼吸道疾病及頭頸部腫瘤 , 包括 : 感冒、咳嗽、頭痛、喉嚨痛、聲音沙啞、吞嚥困難、呼吸不順、鼻塞、鼻竇炎、鼻過敏、鼻息肉、扁桃腺肥大、耳鳴、耳痛、中耳炎、顏面神經麻痺、顎顳關節痛、口乾舌燥、打鼾、語言障礙、食道異物取出、頭頸部腫瘤、舌及口咽腫瘤手術",
        "mode" : "kind",
        "type" : [
          {
            "coding" : [
              {
                "system" : "http://terminology.hl7.org/CodeSystem/v3-RoleCode",
                "code" : "ENT",
                "display" : "Otorhinolaryngology clinic"
              }
            ]
          }
        ],
        "telecom" : [
          {
            "system" : "phone",
            "value" : "02-2276-5566",
            "use" : "work"
          }
        ],
        "address" : {
          "use" : "work",
          "type" : "both",
          "text" : "242新北市新莊區思源路127號",
          "line" : ["思源路127號"],
          "city" : "新莊區",
          "district" : "新北市",
          "postalCode" : "242"
        },
        "position" : {
          "longitude" : 25.043085494729105,
          "latitude" : 121.45941895179722
        },
        "managingOrganization" : {
          "reference" : "Organization/org-hosp-example"
        },
        "hoursOfOperation" : [
          {
            "daysOfWeek" : ["mon", "tue", "wed", "thu", "fri"],
            "allDay" : true
          }
        ]
      }
    }
  ]
}

```
