# 貓毛過敏或不耐症 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Example AllergyIntolerance: 貓毛過敏或不耐症

### 貓毛過敏

**臨床狀態**：Active ([AllergyIntoleranceClinicalStatusCodes](http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical)#active)

**驗證狀態**：Confirmed ([AllergyIntoleranceVerificationStatusCodes](http://terminology.hl7.org/CodeSystem/allergyintolerance-verification)#confirmed)

**根本原因或運作機制**：Allergy ([AllergyIntoleranceType](http://hl7.org/fhir/allergy-intolerance-type)#allergy)

**確定的物質的類別**：Environment ([AllergyIntoleranceCategory](http://hl7.org/fhir/allergy-intolerance-category)#environment)

**嚴重程度**：High Risk ([AllergyIntoleranceCriticality](http://hl7.org/fhir/allergy-intolerance-criticality)#high)

**過敏或不耐症的識別**：患者對貓毛過敏，可能導致打噴嚏、呼吸急促(Allergy to animal protein) ([SNOMED CT](http://snomed.info/sct)#717234006)

**過敏或不耐症被識別的時間**：2023-12-05T14:00:00

**病人**：[Patient/pat-example](Patient-pat-example.md) "陳加玲"

**紀錄者**：[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md) "王依昇"

**被記錄的日期**：2023-12-05T15:30:00

**關於過敏的資訊來源**：[Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md) "陳莉"

**最後一次已知反應發生的日期與時間**：2023-12-05T15:30:00

**暴露於此過敏或不耐症物質的不良反應**：

> **與此事件相關的臨床症狀/體徵**：Upper respiratory tract hypersensitivity reaction([SNOMED CT](http://snomed.info/sct)#490008)**對整個過敏事件的描述**：打噴嚏、呼吸急促**嚴重程度**：Mild([AllergyIntoleranceSeverity](http://hl7.org/fhir/reaction-event-severity)#mild)**如何接觸到該物質**：呼吸道途徑(Respiratory tract route)([SNOMED CT](http://snomed.info/sct)#447694001)**備註**：患者接觸貓毛後出現打噴嚏和呼吸急促，症狀於2023年12月5日下午3:30發作



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "all-cat-example",
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ],
    "text" : "Active"
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed",
        "display" : "Confirmed"
      }
    ],
    "text" : "Confirmed"
  },
  "type" : "allergy",
  "category" : ["environment"],
  "criticality" : "high",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "717234006",
        "display" : "Allergy to animal protein"
      }
    ],
    "text" : "對貓毛過敏"
  },
  "patient" : {
    "reference" : "Patient/pat-example",
    "display" : "陳加玲"
  },
  "onsetDateTime" : "2023-12-05T14:00:00+08:00",
  "recordedDate" : "2023-12-05T15:30:00+08:00",
  "recorder" : {
    "reference" : "Practitioner/pra-dr-example",
    "display" : "王依昇"
  },
  "asserter" : {
    "reference" : "Practitioner/pra-nurse-example",
    "display" : "陳莉"
  },
  "lastOccurrence" : "2023-12-05T15:30:00+08:00",
  "note" : [
    {
      "text" : "患者對貓毛過敏，可能導致打噴嚏、呼吸急促"
    }
  ],
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "490008",
              "display" : "Upper respiratory tract hypersensitivity reaction"
            }
          ]
        }
      ],
      "description" : "打噴嚏、呼吸急促",
      "severity" : "mild",
      "exposureRoute" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "447694001",
            "display" : "Respiratory tract route"
          }
        ],
        "text" : "呼吸道途徑"
      },
      "note" : [
        {
          "text" : "患者接觸貓毛後出現打噴嚏和呼吸急促，症狀於2023年12月5日下午3:30發作"
        }
      ]
    }
  ]
}

```
