# 查詢參數及操作定義 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## 查詢參數及操作定義

以下為臺灣核心實作指引（TW Core IG）使用到的所有操作定義（OperationDefinition）。

### Patient

* [$everything](OperationDefinition-Patient-everything.md)

-------

以下為臺灣核心實作指引（TW Core IG）使用到的所有查詢參數（SearchParameter）。

### AllergyIntolerance

* [_id](SearchParameter-AllergyIntolerance-id.md)
* [clinical-status](SearchParameter-AllergyIntolerance-clinical-status.md)

### Bundle

* [_id](SearchParameter-Bundle-id.md)
* [identifier](SearchParameter-Bundle-identifier.md)

### CarePlan

* [patient](SearchParameter-CarePlan-patient.md)
* [category](SearchParameter-CarePlan-category.md)
* [date](SearchParameter-CarePlan-date.md)
* [status](SearchParameter-CarePlan-status.md)

### CareTeam

* [patient](SearchParameter-CareTeam-patient.md)
* [status](SearchParameter-CareTeam-status.md)
* [role](SearchParameter-CareTeam-role.md)

### Composition

* [_id](SearchParameter-Composition-id.md)
* [status](SearchParameter-Composition-status.md)
* [type](SearchParameter-Composition-type.md)
* [subject](SearchParameter-Composition-subject.md)

### Condition

* [_id](SearchParameter-Condition-id.md)
* [clinical-status](SearchParameter-Condition-clinical-status.md)
* [code](SearchParameter-Condition-code.md)
* [subject](SearchParameter-Condition-subject.md)
* [onset-date](SearchParameter-Condition-onset-date.md)
* [abatement-date](SearchParameter-Condition-abatement-date.md)
* [severity](SearchParameter-Condition-severity.md)

### Coverage

* [patient](SearchParameter-Coverage-patient.md)

### Device

* [patient](SearchParameter-Device-patient.md)
* [type](SearchParameter-Device-type.md)
* [status](SearchParameter-Device-status.md)

### DiagnosticReport

* [_id](SearchParameter-DiagnosticReport-id.md)
* [status](SearchParameter-DiagnosticReport-status.md)
* [subject](SearchParameter-DiagnosticReport-subject.md)
* [category](SearchParameter-DiagnosticReport-category.md)
* [code](SearchParameter-DiagnosticReport-code.md)
* [date](SearchParameter-DiagnosticReport-date.md)

### DocumentReference

* [_id](SearchParameter-DocumentReference-id.md)
* [status](SearchParameter-DocumentReference-status.md)
* [subject](SearchParameter-DocumentReference-subject.md)

### Encounter

* [_id](SearchParameter-Encounter-id.md)
* [class](SearchParameter-Encounter-class.md)
* [date](SearchParameter-Encounter-date.md)
* [identifier](SearchParameter-Encounter-identifier.md)
* [location](SearchParameter-Encounter-location.md)
* [subject](SearchParameter-Encounter-subject.md)
* [status](SearchParameter-Encounter-status.md)

### Goal

* [patient](SearchParameter-Goal-patient.md)
* [lifecycle-status](SearchParameter-Goal-lifecycle-status.md)
* [target-date](SearchParameter-Goal-target-date.md)
* [description](SearchParameter-Goal-description.md)

### ImagingStudy

* [_id](SearchParameter-ImagingStudy-id.md)
* [status](SearchParameter-ImagingStudy-status.md)
* [subject](SearchParameter-ImagingStudy-subject.md)
* [encounter](SearchParameter-ImagingStudy-encounter.md)
* [started](SearchParameter-ImagingStudy-started.md)

### Immunization

* [patient](SearchParameter-Immunization-patient.md)
* [date](SearchParameter-Immunization-date.md)
* [status](SearchParameter-Immunization-status.md)

### Location

* [_id](SearchParameter-Location-id.md)
* [address](SearchParameter-Location-address.md)
* [name](SearchParameter-Location-name.md)

### Media

* [_id](SearchParameter-Media-id.md)
* [status](SearchParameter-Media-status.md)
* [subject](SearchParameter-Media-subject.md)

### Medication

* [_id](SearchParameter-Medication-id.md)
* [code](SearchParameter-Medication-code.md)

### MedicationRequest

* [_id](SearchParameter-MedicationRequest-id.md)
* [status](SearchParameter-MedicationRequest-status.md)
* [intent](SearchParameter-MedicationRequest-intent.md)
* [subject](SearchParameter-MedicationRequest-subject.md)
* [medication](SearchParameter-MedicationRequest-medication.md)
* [encounter](SearchParameter-MedicationRequest-encounter.md)
* [authoredon](SearchParameter-MedicationRequest-authoredon.md)

### MedicationDispense

* [_id](SearchParameter-MedicationDispense-id.md)
* [status](SearchParameter-MedicationDispense-status.md)
* [subject](SearchParameter-MedicationDispense-subject.md)
* [medication](SearchParameter-MedicationDispense-medication.md)

### MedicationStatement

* [_id](SearchParameter-MedicationStatement-id.md)
* [status](SearchParameter-MedicationStatement-status.md)
* [subject](SearchParameter-MedicationStatement-subject.md)
* [medication](SearchParameter-MedicationStatement-medication.md)

### MessageHeader

* [_id](SearchParameter-MessageHeader-id.md)
* [author](SearchParameter-MessageHeader-author.md)
* [sender](SearchParameter-MessageHeader-sender.md)

### Observation

* [_id](SearchParameter-Observation-id.md)
* [category](SearchParameter-Observation-category.md)
* [code](SearchParameter-Observation-clinical-code.md)
* [date](SearchParameter-Observation-date.md)
* [performer](SearchParameter-Observation-performer.md)
* [status](SearchParameter-Observation-status.md)
* [subject](SearchParameter-Observation-subject.md)
* [patient](SearchParameter-Observation-patient.md)
* [_lastUpdated](SearchParameter-Observation-lastupdated.md)

### Organization

* [_id](SearchParameter-Organization-id.md)
* [identifier](SearchParameter-Organization-identifier.md)
* [name](SearchParameter-Organization-name.md)
* [type](SearchParameter-Organization-type.md)

### Patient

* [_id](SearchParameter-Patient-id.md)
* [birthdate](SearchParameter-Patient-birthdate.md)
* [gender](SearchParameter-Patient-gender.md)
* [identifier](SearchParameter-Patient-identifier.md)
* [name](SearchParameter-Patient-name.md)

### Practitioner

* [_id](SearchParameter-Practitioner-id.md)
* [identifier](SearchParameter-Practitioner-identifier.md)
* [name](SearchParameter-Practitioner-name.md)

### PractitionerRole

* [_id](SearchParameter-PractitionerRole-id.md)
* [identifier](SearchParameter-PractitionerRole-identifier.md)
* [specialty](SearchParameter-PractitionerRole-specialty.md)

### Procedure

* [_id](SearchParameter-Procedure-id.md)
* [code](SearchParameter-Procedure-code.md)
* [status](SearchParameter-Procedure-status.md)
* [subject](SearchParameter-Procedure-subject.md)
* [date](SearchParameter-Procedure-date.md)

#### Provenance

* [_id](SearchParameter-Provenance-id.md)
* [patient](SearchParameter-Provenance-patient.md)

### QuestionnaireResponse

* [_id](SearchParameter-QuestionnaireResponse-id.md)
* [patient](SearchParameter-QuestionnaireResponse-patient.md)
* [status](SearchParameter-QuestionnaireResponse-status.md)
* [authored](SearchParameter-QuestionnaireResponse-authored.md)
* [questionnaire](SearchParameter-QuestionnaireResponse-questionnaire.md)

### RelatedPerson

* [_id](SearchParameter-RelatedPerson-id.md)
* [patient](SearchParameter-RelatedPerson-patient.md)
* [name](SearchParameter-RelatedPerson-name.md)

### ServiceRequest

* [_id](SearchParameter-ServiceRequest-id.md)
* [patient](SearchParameter-ServiceRequest-patient.md)
* [category](SearchParameter-ServiceRequest-category.md)
* [authored](SearchParameter-ServiceRequest-authored.md)
* [status](SearchParameter-ServiceRequest-status.md)
* [code](SearchParameter-ServiceRequest-code.md)

### Specimen

* [_id](SearchParameter-Specimen-id.md)
* [status](SearchParameter-Specimen-status.md)
* [identifier](SearchParameter-Specimen-identifier.md)
* [subject](SearchParameter-Specimen-subject.md)

