# FHIR Profiles及Extensions - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## FHIR Profiles及Extensions

### Resources之Profiles

以下為臺灣核心實作指引（TW Core IG）使用到的所有Profiles。

#### AllergyIntolerance

* [臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）](StructureDefinition-AllergyIntolerance-twcore.md)

#### Bundle

* [臺灣核心-資料交換基本單位（TW Core Bundle）](StructureDefinition-Bundle-twcore.md) 
* [臺灣核心-資料交換基本單位-文件（TW Core Bundle Document）](StructureDefinition-Bundle-document-twcore.md)
* [臺灣核心-資料交換基本單位-訊息（TW Core Bundle Message）](StructureDefinition-Bundle-message-twcore.md)
 

#### CarePlan

* [臺灣核心-照護計畫（TW Core CarePlan）](StructureDefinition-CarePlan-twcore.md)

#### CareTeam

* [臺灣核心-照護團隊（TW Core CareTeam）](StructureDefinition-CareTeam-twcore.md)

#### Composition

* [臺灣核心-臨床文件架構（TW Core Composition）](StructureDefinition-Composition-twcore.md)

#### Condition

* [臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)

#### Coverage

* [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md)

#### Device

* [臺灣核心-植入式裝置（TW Core Implantable Device）](StructureDefinition-Device-twcore.md)

#### DiagnosticReport

* [臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md)

#### DocumentReference

* [臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md)

#### Encounter

* [臺灣核心-就醫事件（TW Core Encounter）](StructureDefinition-Encounter-twcore.md)

#### Goal

* [臺灣核心-目標（TW Core Goal）](StructureDefinition-Goal-twcore.md)

#### ImagingStudy

* [臺灣核心-影像檢查（TW Core ImagingStudy）](StructureDefinition-ImagingStudy-twcore.md)

#### Immunization

* [臺灣核心-疫苗接種（TW Core Immunization）](StructureDefinition-Immunization-twcore.md)

#### Location

* [臺灣核心-地點（TW Core Location)](StructureDefinition-Location-twcore.md)

#### Media

* [臺灣核心-多媒體（TW Core Media）](StructureDefinition-Media-twcore.md)

#### Medication

* [臺灣核心-藥品（TW Core Medication）](StructureDefinition-Medication-twcore.md)

#### MedicationRequest

* [臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md)

#### MedicationDispense

* [臺灣核心-配藥或藥品調劑（TW Core MedicationDispense）](StructureDefinition-MedicationDispense-twcore.md)

#### MedicationStatement

* [臺灣核心-用藥聲明（TW Core MedicationStatement）](StructureDefinition-MedicationStatement-twcore.md)

#### MessageHeader

* [臺灣核心-訊息表頭（TW Core MessageHeader）](StructureDefinition-MessageHeader-twcore.md)

#### Observation

* [臺灣核心-平均血壓（TW Core Observation Average Blood Pressure）](StructureDefinition-Observation-averageBloodPressure-twcore.md)
* [臺灣核心-病人照護偏好註記（TW Core Observation Care Experience Preference）](StructureDefinition-Observation-careExperiencePreference-twcore.md)
* [臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result）](StructureDefinition-Observation-clinical-result-twcore.md) 
* [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)
 
* [臺灣核心-心電圖（TW Core Observation ECG）](StructureDefinition-Observation-ecg-twcore.md)
* [臺灣核心-職業（TW Core Observation Occupation）](StructureDefinition-Observation-occupation-twcore.md)
* [臺灣核心-妊娠計畫（TW Core Observation Pregnancy Intent）](StructureDefinition-Observation-pregnancy-intent-twcore.md)
* [臺灣核心-妊娠狀態（TW Core Observation Pregnancy Status）](StructureDefinition-Observation-pregnancy-status-twcore.md)
* [臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)
* [臺灣核心-性傾向（TW Core Observation Sexual Orientation）](StructureDefinition-Observation-sexual-orientation-twcore.md)
* [臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)
* [臺灣核心-吸菸狀態（TW Core Smoking Status Observation）](StructureDefinition-Observation-smoking-status-twcore.md)
* [臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference）](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)
* [臺灣核心-生命體徵（TW Core Observation Vital Signs）](StructureDefinition-Observation-vitalSigns-twcore.md) 
* [臺灣核心-兒童及青少年身體質量指數（TW Core Pediatric BMI for Age Observation）](StructureDefinition-Observation-pediatric-bmi-age-twcore.md)
* [臺灣核心-兒童生長曲線（TW Core Pediatric Weight for Height Observation）](StructureDefinition-Observation-pediatric-weight-height-twcore.md)
* [臺灣核心-血壓（TW Core Observation Blood Pressure）](StructureDefinition-Observation-bloodPressure-twcore.md)
* [臺灣核心-身體質量指數（TW Core Observation BMI）](StructureDefinition-Observation-bmi-twcore.md)
* [臺灣核心-身高（TW Core Observation Body Height）](StructureDefinition-Observation-body-height-twcore.md)
* [臺灣核心-體溫（TW Core Observation Body Temperature）](StructureDefinition-Observation-body-temperature-twcore.md)
* [臺灣核心-體重（TW Core Observation Body Weight）](StructureDefinition-Observation-body-weight-twcore.md)
* [臺灣核心-頭圍（TW Core Observation Head Circumference）](StructureDefinition-Observation-head-circumference-twcore.md)
* [臺灣核心-心率（TW Core Observation Heart Rate）](StructureDefinition-Observation-heart-rate-twcore.md)
* [臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）](StructureDefinition-Observation-pulse-oximetry-twcore.md)
* [臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）](StructureDefinition-Observation-respiratory-rate-twcore.md)
* [臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile）](StructureDefinition-Observation-pediatric-head-circumference-twcore.md)
 

#### Organization

* [臺灣核心-機構（TW Core Organization）](StructureDefinition-Organization-twcore.md) 
* [臺灣核心-政府機構（TW Core Organization Government）](StructureDefinition-Organization-govt-twcore.md)
* [臺灣核心-醫事機構（TW Core Organization Hospital Department）](StructureDefinition-Organization-hosp-twcore.md)
* [臺灣核心-公司行號（TW Core Organization Company）](StructureDefinition-Organization-co-twcore.md)
 

#### Patient

* [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md)

#### Practitioner

* [臺灣核心-健康照護服務提供者（TW Core Practitioner）](StructureDefinition-Practitioner-twcore.md)

#### PractitionerRole

* [臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）](StructureDefinition-PractitionerRole-twcore.md)

#### Procedure

* [臺灣核心-處置或手術（TW Core Procedure）](StructureDefinition-Procedure-twcore.md)

#### Provenance

* [臺灣核心-出處（TW Core Provenance）](StructureDefinition-Provenance-twcore.md)

#### QuestionnaireResponse

* [臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md)

#### RelatedPerson

* [臺灣核心-相關人士（TW Core RelatedPerson）](StructureDefinition-RelatedPerson-twcore.md)

#### ServiceRequest

* [臺灣核心-服務請求（TW Core ServiceRequest）](StructureDefinition-ServiceRequest-twcore.md)

#### Specimen

* [臺灣核心-檢體（TW Core Specimen）](StructureDefinition-Specimen-twcore.md)

-------

### Data Types之Profiles

* [TW Coding](StructureDefinition-Coding-tw.md)
* [TW CodeableConcept](StructureDefinition-CodeableConcept-tw.md)
* [臺灣核心-地址（TW Core Address）](StructureDefinition-Address-tw.md)

-------

### Extensions

以下[Extensions](http://hl7.org/fhir/R4/extensibility.html)已定義為臺灣核心實作指引（TW Core IG）的一部分。

* [識別碼後綴詞（Identifier Suffix）](StructureDefinition-identifier-suffix.md)
* [年齡（Person Age）](StructureDefinition-person-age.md)
* [臺灣郵遞區號（TW Postal code）](StructureDefinition-tw-postal-code.md)
* [臺灣地址欄位-村（里)（TW Village）](StructureDefinition-tw-village.md)
* [臺灣地址欄位-鄰（TW Neighborhood）](StructureDefinition-tw-neighborhood.md)
* [臺灣地址欄位-段（TW Section）](StructureDefinition-tw-section.md)
* [臺灣地址欄位-巷（TW Lane）](StructureDefinition-tw-lane.md)
* [臺灣地址欄位-弄（TW Alley）](StructureDefinition-tw-alley.md)
* [臺灣地址欄位-號（TW Number）](StructureDefinition-tw-number.md)
* [臺灣地址欄位-樓（TW Floor）](StructureDefinition-tw-floor.md)
* [臺灣地址欄位-室（TW Room）](StructureDefinition-tw-room.md)
* [Questionnaire Url](StructureDefinition-questionnaire-url.md)

