# tw.gov.mohw.twcore#1.0.0: 臺灣核心實作指引(TW Core IG)

## Pages

* [應用說明](index.md)
* [範例](examples.md)
* [FHIR Profiles及Extensions](profiles-and-extensions.md)
* [專門術語](terminologies.md)
* [安全性](security.md)
* [驗證教學](validates.md)
* [能力聲明](capabilitystatements.md)
* [TWCDI](TWCDI.md)
* [TW Core ImplementationGuide Resource](ImplementationGuide-tw.gov.mohw.twcore.md)
* [查詢參數及操作定義](searchparameters-and-operation.md)
* [規範文件](artifacts.md)
* [邏輯模型](models.md)
* [結構定義與範例檔下載頁](downloads.md)

## Resources

### CodeSystems

* [臺灣衛福部資訊處照護計畫類別](CodeSystem-careplan-category-tw.md)
* [臺灣衛福部資訊處類型代碼](CodeSystem-category-code-tw.md)
* [臺灣醫事司醫事人員類別](CodeSystem-health-professional-tw.md)
* [臺灣健保署2014年中文版ICD-10-CM](CodeSystem-icd-10-cm-2014-tw.md)
* [臺灣健保署2021年中文版ICD-10-CM](CodeSystem-icd-10-cm-2021-tw.md)
* [臺灣健保署2023年中文版ICD-10-CM](CodeSystem-icd-10-cm-2023-tw.md)
* [臺灣健保署2014年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2014-tw.md)
* [臺灣健保署2021年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2021-tw.md)
* [臺灣健保署2023年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2023-tw.md)
* [臺灣健保署2001年中文版ICD-9-CM](CodeSystem-icd-9-cm-2001-tw.md)
* [行政院主計總處行業分類](CodeSystem-industry-dgbas-tw.md)
* [臺灣戶政司婚姻狀態](CodeSystem-marital-status-tw.md)
* [臺灣食藥署藥品藥理治療分類ATC碼](CodeSystem-medcation-atc-tw.md)
* [臺灣健保署就醫科別](CodeSystem-medical-consultation-department-nhi-tw.md)
* [臺灣健保署醫療服務給付項目](CodeSystem-medical-service-payment-tw.md)
* [臺灣健保署診療科別](CodeSystem-medical-treatment-department-nhi-tw.md)
* [臺灣食藥署醫療器材許可證](CodeSystem-medication-device-fda-tw.md)
* [臺灣食藥署藥品許可證](CodeSystem-medication-fda-tw.md)
* [臺灣健保署藥品使用頻率](CodeSystem-medication-frequency-nhi-tw.md)
* [臺灣健保署用藥品項](CodeSystem-medication-nhi-tw.md)
* [臺灣健保署給藥途徑](CodeSystem-medication-path-tw.md)
* [臺灣健保署中藥用藥品項](CodeSystem-nhi-medication-ch-herb-tw.md)
* [臺灣壽險公會傷害保險個人職業分類表](CodeSystem-occupation-lia-roc-tw.md)
* [臺灣勞動部職業標準分類](CodeSystem-occupation-mol-tw.md)
* [臺灣醫事司醫事機構代碼](CodeSystem-organization-identifier-tw.md)
* [臺灣中華郵政3碼郵遞區號](CodeSystem-postal-code3-tw.md)
* [臺灣中華郵政5碼郵遞區號](CodeSystem-postal-code5-tw.md)
* [臺灣中華郵政6碼郵遞區號](CodeSystem-postal-code6-tw.md)
* [臺灣衛福部資訊處Provenance參與類型](CodeSystem-provenance-participant-type-tw.md)
* [臺灣衛福部資訊處識別碼類型](CodeSystem-v2-0203.md)

### ValueSets

* [Acquisition Modality](ValueSet-AcquisitionModality.md)
* [臺灣衛福部資訊處類型代碼值集](ValueSet-category-code-tw.md)
* [SNOMED CT診斷代碼值集](ValueSet-condition-code-sct-tw.md)
* [SNOMED CT + 臺灣醫事司醫事人員類別值集](ValueSet-health-professional-sct-tw.md)
* [臺灣醫事司醫事人員類別值集](ValueSet-health-professional-tw.md)
* [臺灣健保署2014年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2014-tw.md)
* [臺灣健保署2021年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2021-tw.md)
* [臺灣健保署2023年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2023-tw.md)
* [臺灣健保署2014年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2014-tw.md)
* [臺灣健保署2021年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2021-tw.md)
* [臺灣健保署2023年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2023-tw.md)
* [臺灣健保署2001年中文版ICD-9-CM值集](ValueSet-icd-9-cm-2001-tw.md)
* [IdentifierType + 臺灣衛福部資訊處識別碼類型值集](ValueSet-identifier-type-tw.md)
* [行政院主計總處行業分類值集](ValueSet-industry-dgbas-tw.md)
* [臺灣健保署醫療服務給付項目-檢驗值集](ValueSet-laboratory-category-tw.md)
* [臺灣核心-實驗室檢驗檢查值集](ValueSet-laboratory-code-tw.md)
* [LOINC Code Document Section值集](ValueSet-loinc-doc-section-code.md)
* [LOINC Document Class值集](ValueSet-loinc-document-classcodes.md)
* [LOINC實驗室檢驗檢查值集](ValueSet-loinc-observation-code.md)
* [LOINC +  HL7 NullFlavor妊娠計畫值集](ValueSet-loinc-pregnancy-intent-code.md)
* [LOINC篩檢與評估值集](ValueSet-loinc-survey-codes.md)
* [LOINC Code Document Type值集](ValueSet-loinc-type-doc-code.md)
* [臺灣戶政司婚姻狀態值集](ValueSet-marital-status-tw.md)
* [臺灣食藥署藥品藥理治療分類ATC碼值集](ValueSet-medcation-atc-tw.md)
* [臺灣健保署就醫科別值集](ValueSet-medical-consultation-department-nhi-tw.md)
* [無法對應至SNOMED CT之臺灣健保署就醫科別值集](ValueSet-medical-consultation-department-tw.md)
* [對應至 SNOMED CT之就醫科別 + 診療科別值集](ValueSet-medical-department-sct-tw.md)
* [臺灣健保署診療科別值集](ValueSet-medical-treatment-department-nhi-tw.md)
* [無法對應至SNOMED CT之臺灣健保署診療科別值集](ValueSet-medical-treatment-department-tw.md)
* [臺灣食藥署藥品及醫療器材代碼值集](ValueSet-medication-fda-tw.md)
* [HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集](ValueSet-medication-frequency-hl7-tw.md)
* [臺灣健保署藥品使用頻率值集](ValueSet-medication-frequency-nhi-tw.md)
* [臺灣健保署用藥品項代碼值集](ValueSet-medication-nhi-tw.md)
* [SNOMED CT + 臺灣健保署給藥途徑值集](ValueSet-medication-path-sct-tw.md)
* [臺灣健保署給藥途徑值集](ValueSet-medication-path-tw.md)
* [RxNorm藥品代碼值集](ValueSet-medication-rxnorm-tw.md)
* [臺灣衛福部資訊處Narrative狀態值集](ValueSet-narrative-status.md)
* [臺灣健保署中藥用藥品項值集](ValueSet-nhi-medication-ch-herb-tw.md)
* [臺灣衛福部資訊處Observation Clinical Result類型值集](ValueSet-observation-clinical-result-category.md)
* [臺灣衛福部資訊處Observation Screening Assessment類型值集](ValueSet-observation-screening-assessment-category.md)
* [臺灣壽險公會傷害保險個人職業分類表值集](ValueSet-occupation-lia-roc-tw.md)
* [臺灣勞動部職業標準分類值集](ValueSet-occupation-mol-tw.md)
* [臺灣醫事司醫事機構代碼值集](ValueSet-organization-identifier-tw.md)
* [臺灣中華郵政3碼郵遞區號值集](ValueSet-postal-code3-tw.md)
* [臺灣中華郵政5碼郵遞區號值集](ValueSet-postal-code5-tw.md)
* [臺灣中華郵政6碼郵遞區號值集](ValueSet-postal-code6-tw.md)
* [臺灣健保署醫療服務給付項目-處置或手術值集](ValueSet-procedure-tw.md)
* [HL7 Provenance participant type + 臺灣衛福部資訊處Provenance參與類型](ValueSet-provenance-participant-type-hl7-tw.md)
* [臺灣衛福部資訊處ServiceRequest類型值集](ValueSet-serviceRequest-category.md)
* [SNOMED CT 吸菸狀態綜合評估值集](ValueSet-smoking-status-comprehensive-code.md)
* [SNOMED CT + LOINC 吸菸狀態種類向值集](ValueSet-smoking-status-type-code.md)
* [SNOMED CT + HL7 NullFlavor妊娠狀態值集](ValueSet-snomed-pregnancy-status-code.md)
* [SNOMED CT + HL7 NullFlavor 性傾向值集](ValueSet-snomed-sexual-orientation-code.md)
* [HL7 OrderableDrugForm藥品劑型值集](ValueSet-v3-orderableDrugForm.md)
* [LOINC生命體徵值集](ValueSet-vital-signs-tw.md)

### Logicals

* [臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型](StructureDefinition-TWAllergyIntolerance.md)
* [臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型](StructureDefinition-TWBundle.md)
* [臺灣核心-臨床文件架構(TW Core Composition) 之資料模型](StructureDefinition-TWComposition.md)
* [臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型](StructureDefinition-TWCondition.md)
* [臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型](StructureDefinition-TWDiagnosticReport.md)
* [臺灣核心-文件參照(TW Core DocumentReference) 之資料模型](StructureDefinition-TWDocumentReference.md)
* [臺灣核心-就醫事件(TW Core Encounter) 之資料模型](StructureDefinition-TWEncounter.md)
* [臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型](StructureDefinition-TWImagingStudy.md)
* [臺灣核心-地點(TW Core Location) 之資料模型](StructureDefinition-TWLocation.md)
* [臺灣核心-多媒體(TW Core Media) 之資料模型](StructureDefinition-TWMedia.md)
* [臺灣核心-藥品(TW Core Medication) 之資料模型](StructureDefinition-TWMedication.md)
* [臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型](StructureDefinition-TWMedicationDispense.md)
* [臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型](StructureDefinition-TWMedicationRequest.md)
* [臺灣核心-用藥聲明(TW Core  MedicationStatement) 之資料模型](StructureDefinition-TWMedicationStatement.md)
* [臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型](StructureDefinition-TWMessageHeader.md)
* [臺灣核心-檢驗檢查(TW Core Observation) 之資料模型](StructureDefinition-TWObservation.md)
* [臺灣核心-機構(TW Core Organization)之資料模型](StructureDefinition-TWOrganization.md)
* [臺灣核心-病人(TW Core Patient)之資料模型](StructureDefinition-TWPatient.md)
* [臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型](StructureDefinition-TWPractitioner.md)
* [臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型](StructureDefinition-TWPractitionerRole.md)
* [臺灣核心-處置或手術(TW Core Procedure)之資料模型](StructureDefinition-TWProcedure.md)
* [臺灣核心-檢體(TW Core Specimen) 之資料模型](StructureDefinition-TWSpecimen.md)

### Complex-type Profiles

* [TW Core Address](StructureDefinition-Address-tw.md)
* [TW CodeableConcept](StructureDefinition-CodeableConcept-tw.md)
* [TW Coding](StructureDefinition-Coding-tw.md)

### Resource Profiles

* [TW Core AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md)
* [TW Core Bundle Document](StructureDefinition-Bundle-document-twcore.md)
* [TW Core Bundle Message](StructureDefinition-Bundle-message-twcore.md)
* [TW Core Bundle](StructureDefinition-Bundle-twcore.md)
* [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md)
* [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md)
* [TW Core Composition](StructureDefinition-Composition-twcore.md)
* [TW Core Condition](StructureDefinition-Condition-twcore.md)
* [TW Core Coverage](StructureDefinition-Coverage-twcore.md)
* [TW Core Implantable Device](StructureDefinition-Device-twcore.md)
* [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)
* [TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md)
* [TW Core Encounter](StructureDefinition-Encounter-twcore.md)
* [TW Core Goal](StructureDefinition-Goal-twcore.md)
* [TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)
* [TW Core Immunization](StructureDefinition-Immunization-twcore.md)
* [TW Core  Location](StructureDefinition-Location-twcore.md)
* [TW Core Media](StructureDefinition-Media-twcore.md)
* [TW Core Medication](StructureDefinition-Medication-twcore.md)
* [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)
* [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [TW Core  MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)
* [TW Core MessageHeader](StructureDefinition-MessageHeader-twcore.md)
* [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md)
* [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md)
* [TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md)
* [TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md)
* [TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md)
* [TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md)
* [TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md)
* [TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md)
* [TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md)
* [TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md)
* [TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md)
* [TW Core Observation Laboratory Result](StructureDefinition-Observation-laboratoryResult-twcore.md)
* [TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md)
* [TW Core Pediatric BMI for Age Observation](StructureDefinition-Observation-pediatric-bmi-age-twcore.md)
* [TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile](StructureDefinition-Observation-pediatric-head-circumference-twcore.md)
* [TW Core Pediatric Weight for Height Observation](StructureDefinition-Observation-pediatric-weight-height-twcore.md)
* [TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md)
* [TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md)
* [TW Core Observation Pulse Oximetry](StructureDefinition-Observation-pulse-oximetry-twcore.md)
* [TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md)
* [TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md)
* [TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md)
* [TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md)
* [TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md)
* [TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)
* [TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)
* [TW Core Organization Company](StructureDefinition-Organization-co-twcore.md)
* [TW Core Organization Government](StructureDefinition-Organization-govt-twcore.md)
* [TW Core Organization Hospital Department](StructureDefinition-Organization-hosp-twcore.md)
* [TW Core Organization](StructureDefinition-Organization-twcore.md)
* [TW Core Patient](StructureDefinition-Patient-twcore.md)
* [TW Core Practitioner](StructureDefinition-Practitioner-twcore.md)
* [TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md)
* [TW Core Procedure](StructureDefinition-Procedure-twcore.md)
* [TW Core Provenance](StructureDefinition-Provenance-twcore.md)
* [TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md)
* [TW Core RelatedPerson](StructureDefinition-RelatedPerson-twcore.md)
* [TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* [TW Core Specimen](StructureDefinition-Specimen-twcore.md)

### Extensions

* [Identifier Suffix](StructureDefinition-identifier-suffix.md)
* [Person Age](StructureDefinition-person-age.md)
* [Questionnaire Url](StructureDefinition-questionnaire-url.md)
* [TW Alley](StructureDefinition-tw-alley.md)
* [TW Floor](StructureDefinition-tw-floor.md)
* [TW Lane](StructureDefinition-tw-lane.md)
* [TW Neighborhood](StructureDefinition-tw-neighborhood.md)
* [TW Number](StructureDefinition-tw-number.md)
* [TW Postal code](StructureDefinition-tw-postal-code.md)
* [TW Room](StructureDefinition-tw-room.md)
* [TW Section](StructureDefinition-tw-section.md)
* [TW Village](StructureDefinition-tw-village.md)

### CapabilityStatements

* [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md)
* [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

### ConceptMaps

* [臺灣醫事司醫事人員類別代碼對應SNOMED CT及臺灣醫事司醫事人員類別](ConceptMap-health-professional-tw.md)
* [臺灣戶政司婚姻狀態代碼對應HL7 MaritalStatus](ConceptMap-marital-status-tw.md)
* [臺灣健保署就醫科別代碼對應SNOMED CT](ConceptMap-medical-consultation-department-nhi-tw.md)
* [臺灣健保署診療科別代碼對應SNOMED CT](ConceptMap-medical-treatment-department-nhi-tw.md)
* [臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation](ConceptMap-medication-frequency-tw.md)
* [臺灣健保署給藥途徑代碼對應SNOMED CT](ConceptMap-medication-path-tw.md)

### ImplementationGuides

* [臺灣核心實作指引(TW Core IG)](index.md)

### OperationDefinitions

* [讀取病人(Patient)紀錄](OperationDefinition-Patient-everything.md)

### SearchParameters

* [AllergyIntoleranceClinicalStatus](SearchParameter-AllergyIntolerance-clinical-status.md)
* [AllergyIntoleranceID](SearchParameter-AllergyIntolerance-id.md)
* [BundleID](SearchParameter-Bundle-id.md)
* [Bundleidentifier](SearchParameter-Bundle-identifier.md)
* [CarePlanCategory](SearchParameter-CarePlan-category.md)
* [CarePlanDate](SearchParameter-CarePlan-date.md)
* [CarePlanPatient](SearchParameter-CarePlan-patient.md)
* [CarePlanStatus](SearchParameter-CarePlan-status.md)
* [CareTeamPatient](SearchParameter-CareTeam-patient.md)
* [CareTeamRole](SearchParameter-CareTeam-role.md)
* [CareTeamStatus](SearchParameter-CareTeam-status.md)
* [CompositionID](SearchParameter-Composition-id.md)
* [CompositionStatus](SearchParameter-Composition-status.md)
* [CompositionSubject](SearchParameter-Composition-subject.md)
* [CompositionType](SearchParameter-Composition-type.md)
* [ConditionAbatementDate](SearchParameter-Condition-abatement-date.md)
* [ConditionClinicalStatus](SearchParameter-Condition-clinical-status.md)
* [ConditionCode](SearchParameter-Condition-code.md)
* [ConditionID](SearchParameter-Condition-id.md)
* [ConditionOnsetDate](SearchParameter-Condition-onset-date.md)
* [ConditionSeverity](SearchParameter-Condition-severity.md)
* [ConditionSubject](SearchParameter-Condition-subject.md)
* [CoveragePatient](SearchParameter-Coverage-patient.md)
* [DevicePatient](SearchParameter-Device-patient.md)
* [DeviceStatus](SearchParameter-Device-status.md)
* [DeviceType](SearchParameter-Device-type.md)
* [DiagnosticreportCategory](SearchParameter-DiagnosticReport-category.md)
* [DiagnosticreportCode](SearchParameter-DiagnosticReport-code.md)
* [DiagnosticreportDate](SearchParameter-DiagnosticReport-date.md)
* [DiagnosticReportID](SearchParameter-DiagnosticReport-id.md)
* [DiagnosticreportStatus](SearchParameter-DiagnosticReport-status.md)
* [DiagnosticreportSubject](SearchParameter-DiagnosticReport-subject.md)
* [DocumentReferenceID](SearchParameter-DocumentReference-id.md)
* [DocumentReferenceStatus](SearchParameter-DocumentReference-status.md)
* [DocumentReferenceSubject](SearchParameter-DocumentReference-subject.md)
* [EncounterClass](SearchParameter-Encounter-class.md)
* [EncounterDate](SearchParameter-Encounter-date.md)
* [EncounterID](SearchParameter-Encounter-id.md)
* [EncounterIdentifier](SearchParameter-Encounter-identifier.md)
* [EncounterLocation](SearchParameter-Encounter-location.md)
* [EncounterStatus](SearchParameter-Encounter-status.md)
* [EncounterSubject](SearchParameter-Encounter-subject.md)
* [GoalDescription](SearchParameter-Goal-description.md)
* [GoalLifecycleStatus](SearchParameter-Goal-lifecycle-status.md)
* [GoalPatient](SearchParameter-Goal-patient.md)
* [GoalTargetDate](SearchParameter-Goal-target-date.md)
* [ImagingStudyEncounter](SearchParameter-ImagingStudy-encounter.md)
* [ImagingStudyID](SearchParameter-ImagingStudy-id.md)
* [ImagingStudyStarted](SearchParameter-ImagingStudy-started.md)
* [ImagingStudyStatus](SearchParameter-ImagingStudy-status.md)
* [ImagingStudySubject](SearchParameter-ImagingStudy-subject.md)
* [ImmunizationDate](SearchParameter-Immunization-date.md)
* [ImmunizationPatient](SearchParameter-Immunization-patient.md)
* [ImmunizationStatus](SearchParameter-Immunization-status.md)
* [LocationAddress](SearchParameter-Location-address.md)
* [LocationID](SearchParameter-Location-id.md)
* [LocationName](SearchParameter-Location-name.md)
* [MediaID](SearchParameter-Media-id.md)
* [MediaStatus](SearchParameter-Media-status.md)
* [MediaSubject](SearchParameter-Media-subject.md)
* [MedicationCode](SearchParameter-Medication-code.md)
* [MedicationID](SearchParameter-Medication-id.md)
* [MedicationDispenseID](SearchParameter-MedicationDispense-id.md)
* [MedicationDispenseMedication](SearchParameter-MedicationDispense-medication.md)
* [MedicationDispenseStatus](SearchParameter-MedicationDispense-status.md)
* [MedicationDispenseSubject](SearchParameter-MedicationDispense-subject.md)
* [MedicationrequestAuthoredon](SearchParameter-MedicationRequest-authoredon.md)
* [MedicationrequestEncounter](SearchParameter-MedicationRequest-encounter.md)
* [MedicationRequestID](SearchParameter-MedicationRequest-id.md)
* [MedicationrequestIntent](SearchParameter-MedicationRequest-intent.md)
* [MedicationrequestMedication](SearchParameter-MedicationRequest-medication.md)
* [MedicationrequestStatus](SearchParameter-MedicationRequest-status.md)
* [MedicationrequestSubject](SearchParameter-MedicationRequest-subject.md)
* [MedicationStatementID](SearchParameter-MedicationStatement-id.md)
* [MedicationStatementMedication](SearchParameter-MedicationStatement-medication.md)
* [MedicationStatementStatus](SearchParameter-MedicationStatement-status.md)
* [MedicationStatementSubject](SearchParameter-MedicationStatement-subject.md)
* [MessageHeaderAuthor](SearchParameter-MessageHeader-author.md)
* [MessageHeaderID](SearchParameter-MessageHeader-id.md)
* [MessageHeaderSender](SearchParameter-MessageHeader-sender.md)
* [ObservationCategory](SearchParameter-Observation-category.md)
* [ObservationClinicalCode](SearchParameter-Observation-clinical-code.md)
* [ObservationDate](SearchParameter-Observation-date.md)
* [ObservationID](SearchParameter-Observation-id.md)
* [ObservationLastUpdated](SearchParameter-Observation-lastupdated.md)
* [ObservationPatient](SearchParameter-Observation-patient.md)
* [ObservationPerformer](SearchParameter-Observation-performer.md)
* [ObservationStatus](SearchParameter-Observation-status.md)
* [ObservationSubject](SearchParameter-Observation-subject.md)
* [OrganizationID](SearchParameter-Organization-id.md)
* [OrganizationIdentifier](SearchParameter-Organization-identifier.md)
* [OrganizationName](SearchParameter-Organization-name.md)
* [OrganizationType](SearchParameter-Organization-type.md)
* [PatientBirthdate](SearchParameter-Patient-birthdate.md)
* [PatientGender](SearchParameter-Patient-gender.md)
* [PatientID](SearchParameter-Patient-id.md)
* [PatientIdentifier](SearchParameter-Patient-identifier.md)
* [PatientName](SearchParameter-Patient-name.md)
* [PractitionerID](SearchParameter-Practitioner-id.md)
* [PractitionerIdentifier](SearchParameter-Practitioner-identifier.md)
* [PractitionerName](SearchParameter-Practitioner-name.md)
* [PractitionerRoleID](SearchParameter-PractitionerRole-id.md)
* [PractitionerRoleIdentifier](SearchParameter-PractitionerRole-identifier.md)
* [PractitionerRoleSpecialty](SearchParameter-PractitionerRole-specialty.md)
* [ProcedureCode](SearchParameter-Procedure-code.md)
* [ProcedureDate](SearchParameter-Procedure-date.md)
* [ProcedureID](SearchParameter-Procedure-id.md)
* [ProcedureStatus](SearchParameter-Procedure-status.md)
* [ProcedureSubject](SearchParameter-Procedure-subject.md)
* [ProvenanceID](SearchParameter-Provenance-id.md)
* [ProvenancePatient](SearchParameter-Provenance-patient.md)
* [QuestionnaireResponseAuthored](SearchParameter-QuestionnaireResponse-authored.md)
* [QuestionnaireResponseID](SearchParameter-QuestionnaireResponse-id.md)
* [QuestionnaireResponsePatient](SearchParameter-QuestionnaireResponse-patient.md)
* [QuestionnaireResponseQuestionnaire](SearchParameter-QuestionnaireResponse-questionnaire.md)
* [QuestionnaireResponseStatus](SearchParameter-QuestionnaireResponse-status.md)
* [RelatedPersonID](SearchParameter-RelatedPerson-id.md)
* [RelatedPersonname](SearchParameter-RelatedPerson-name.md)
* [RelatedPersonPatient](SearchParameter-RelatedPerson-patient.md)
* [ServiceRequestAuthored](SearchParameter-ServiceRequest-authored.md)
* [ServiceRequestCategory](SearchParameter-ServiceRequest-category.md)
* [ServiceRequestCode](SearchParameter-ServiceRequest-code.md)
* [ServiceRequestID](SearchParameter-ServiceRequest-id.md)
* [ServiceRequestPatient](SearchParameter-ServiceRequest-patient.md)
* [ServiceRequestStatus](SearchParameter-ServiceRequest-status.md)
* [SpecimenID](SearchParameter-Specimen-id.md)
* [SpecimenIdentifier](SearchParameter-Specimen-identifier.md)
* [SpecimenStatus](SearchParameter-Specimen-status.md)
* [SpecimenSubject](SearchParameter-Specimen-subject.md)

### Examples

* [all-cat-example (AllergyIntolerance)](AllergyIntolerance-all-cat-example.md)
* [all-medication-example (AllergyIntolerance)](AllergyIntolerance-all-medication-example.md)
* [all-nut-example (AllergyIntolerance)](AllergyIntolerance-all-nut-example.md)
* [all-seafood-example (AllergyIntolerance)](AllergyIntolerance-all-seafood-example.md)
* [bun-document-example (Bundle)](Bundle-bun-document-example.md)
* [bun-document-uuid-example (Bundle)](Bundle-bun-document-uuid-example.md)
* [bun-example (Bundle)](Bundle-bun-example.md)
* [bun-message-request-example (Bundle)](Bundle-bun-message-request-example.md)
* [bun-message-response-example (Bundle)](Bundle-bun-message-response-example.md)
* [careplan-example (CarePlan)](CarePlan-careplan-example.md)
* [careteam-example (CareTeam)](CareTeam-careteam-example.md)
* [陳加玲的病摘 (Composition)](Composition-com-example.md)
* [手術摘要報告 (Composition)](Composition-com-surgery-example.md)
* [con-example (Condition)](Condition-con-example.md)
* [coverage-example (Coverage)](Coverage-coverage-example.md)
* [dev-example (Device)](Device-dev-example.md)
* [dia-example (DiagnosticReport)](DiagnosticReport-dia-example.md)
* [doc-outpatient-example (DocumentReference)](DocumentReference-doc-outpatient-example.md)
* [doc-wound-example (DocumentReference)](DocumentReference-doc-wound-example.md)
* [enc-example (Encounter)](Encounter-enc-example.md)
* [goa-example (Goal)](Goal-goa-example.md)
* [img-ct-example (ImagingStudy)](ImagingStudy-img-ct-example.md)
* [img-example (ImagingStudy)](ImagingStudy-img-example.md)
* [img-mr-example (ImagingStudy)](ImagingStudy-img-mr-example.md)
* [img-pet-example (ImagingStudy)](ImagingStudy-img-pet-example.md)
* [img-sm-example (ImagingStudy)](ImagingStudy-img-sm-example.md)
* [imm-example (Immunization)](Immunization-imm-example.md)
* [衛生福利部臺北醫院耳鼻喉科 (Location)](Location-loc-ent-example.md)
* [衛生福利部臺北醫院急診室 (Location)](Location-loc-er-example.md)
* [衛生福利部臺北醫院X光室 (Location)](Location-loc-hrad-example.md)
* [明捷眼科診所 (Location)](Location-loc-oph-example.md)
* [第二藥局 (Location)](Location-loc-pharm-example.md)
* [media-example (Media)](Media-media-example.md)
* [med-example (Medication)](Medication-med-example.md)
* [med-dis-drop-example (MedicationDispense)](MedicationDispense-med-dis-drop-example.md)
* [med-dis-inflamed-example (MedicationDispense)](MedicationDispense-med-dis-inflamed-example.md)
* [med-dis-injection-example (MedicationDispense)](MedicationDispense-med-dis-injection-example.md)
* [med-dis-ref-example (MedicationDispense)](MedicationDispense-med-dis-ref-example.md)
* [med-req-cod-example (MedicationRequest)](MedicationRequest-med-req-cod-example.md)
* [med-req-ref-example (MedicationRequest)](MedicationRequest-med-req-ref-example.md)
* [med-sta-drop-example (MedicationStatement)](MedicationStatement-med-sta-drop-example.md)
* [med-sta-example (MedicationStatement)](MedicationStatement-med-sta-example.md)
* [med-sta-inflamed-example (MedicationStatement)](MedicationStatement-med-sta-inflamed-example.md)
* [med-sta-injection-example (MedicationStatement)](MedicationStatement-med-sta-injection-example.md)
* [mes-request-example (MessageHeader)](MessageHeader-mes-request-example.md)
* [mes-response-example (MessageHeader)](MessageHeader-mes-response-example.md)
* [obs-averageBloodPressure-example (Observation)](Observation-obs-averageBloodPressure-example.md)
* [obs-bloodPressure-example (Observation)](Observation-obs-bloodPressure-example.md)
* [obs-bmi-example (Observation)](Observation-obs-bmi-example.md)
* [obs-careExp-example (Observation)](Observation-obs-careExp-example.md)
* [obs-clinical-result-example (Observation)](Observation-obs-clinical-result-example.md)
* [obs-ecg-example (Observation)](Observation-obs-ecg-example.md)
* [obs-head-circumference-example (Observation)](Observation-obs-head-circumference-example.md)
* [obs-heart-rate-example (Observation)](Observation-obs-heart-rate-example.md)
* [obs-height-example (Observation)](Observation-obs-height-example.md)
* [obs-lab-example (Observation)](Observation-obs-lab-example.md)
* [obs-loinc-example (Observation)](Observation-obs-loinc-example.md)
* [obs-occupation-example (Observation)](Observation-obs-occupation-example.md)
* [obs-ofc-percentile-example (Observation)](Observation-obs-ofc-percentile-example.md)
* [obs-pediatric-bmi-age-example (Observation)](Observation-obs-pediatric-bmi-age-example.md)
* [obs-pediatric-weight-height-example (Observation)](Observation-obs-pediatric-weight-height-example.md)
* [obs-pregnancy-intent-example (Observation)](Observation-obs-pregnancy-intent-example.md)
* [obs-pregnancy-status-example (Observation)](Observation-obs-pregnancy-status-example.md)
* [obs-pulse-oximetry-example (Observation)](Observation-obs-pulse-oximetry-example.md)
* [obs-respiratory-rate-example (Observation)](Observation-obs-respiratory-rate-example.md)
* [obs-screening-assessment-example (Observation)](Observation-obs-screening-assessment-example.md)
* [obs-sexual-orientation-example (Observation)](Observation-obs-sexual-orientation-example.md)
* [obs-simple-example (Observation)](Observation-obs-simple-example.md)
* [obs-smoking-status-example (Observation)](Observation-obs-smoking-status-example.md)
* [obs-temperature-example (Observation)](Observation-obs-temperature-example.md)
* [obs-treatment-intervention-preference-example (Observation)](Observation-obs-treatment-intervention-preference-example.md)
* [obs-vital (Observation)](Observation-obs-vital.md)
* [obs-weight-example (Observation)](Observation-obs-weight-example.md)
* [莉梓股份有限公司 (Organization)](Organization-org-co-example.md)
* [衛生福利部桃園醫院 (Organization)](Organization-org-example.md)
* [衛生福利部 (Organization)](Organization-org-govt-example.md)
* [衛生福利部臺北醫院 (Organization)](Organization-org-hosp-example.md)
* [pat-child-example (Patient)](Patient-pat-child-example.md)
* [pat-example (Patient)](Patient-pat-example.md)
* [pat-residentNumber-example (Patient)](Patient-pat-residentNumber-example.md)
* [pra-dr-example (Practitioner)](Practitioner-pra-dr-example.md)
* [pra-nurse-example (Practitioner)](Practitioner-pra-nurse-example.md)
* [pra-phc-example (Practitioner)](Practitioner-pra-phc-example.md)
* [pra-radio-example (Practitioner)](Practitioner-pra-radio-example.md)
* [praro-dr-example (PractitionerRole)](PractitionerRole-praro-dr-example.md)
* [praro-nurse-example (PractitionerRole)](PractitionerRole-praro-nurse-example.md)
* [praro-phc-example (PractitionerRole)](PractitionerRole-praro-phc-example.md)
* [praro-radio-example (PractitionerRole)](PractitionerRole-praro-radio-example.md)
* [pro-appendectomy-example (Procedure)](Procedure-pro-appendectomy-example.md)
* [pro-example (Procedure)](Procedure-pro-example.md)
* [pov-example (Provenance)](Provenance-pov-example.md)
* [qr-example (QuestionnaireResponse)](QuestionnaireResponse-qr-example.md)
* [rel-example (RelatedPerson)](RelatedPerson-rel-example.md)
* [sr-example (ServiceRequest)](ServiceRequest-sr-example.md)
* [spe-ance-example (Specimen)](Specimen-spe-ance-example.md)
* [spe-blood-example (Specimen)](Specimen-spe-blood-example.md)
* [spe-stool-example (Specimen)](Specimen-spe-stool-example.md)
* [spe-ur-example (Specimen)](Specimen-spe-ur-example.md)
