# 應用說明 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## 應用說明

| | |
| :--- | :--- |
|  | *Computable Name*: |

因考量實作需求，於2025/12/09異動以下內容：
1. 修正多項QA錯誤：
* 包含CapabilityStatement列表顯示、Immunization範例、新增AcquisitionModality定義、移除ConceptMap版本限制，並優化ImagingStudy與Observation Profile。
* 修正 TW Core Observation Treatment Intervention Preference 範例 (`obs-treatment-intervention-preference-example`)，`performer` 參照由 Patient 改為 Practitioner。
* TW Core Observation Occupation Profile：修正 `MolOccupation` 資料項目中職業代碼系統網址 (CodeSystem URL) 為 `https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/occupation-mol-tw`。
* 修正 臺灣健保署2023年中文版ICD-10-CM 與 臺灣健保署2023年中文版ICD-10-PCS 代碼系統網址 (CodeSystem URL)。
* 修正 臺灣健保署2014年中文版ICD-10-PCS、臺灣健保署中藥用藥品項 與 臺灣健保署健保用藥品項代碼 拼字錯誤。

1. 強化代碼集(ValueSet)內容：
* LOINC相關代碼 (LOINC Observation Code、LOINC Survey Code)：調整篩選條件 (CLASSTYPE) 的值，由文字描述 ("Laboratory class", "Clinical class", "Surveys") 改為對應的代碼 ("1", "2", "4")。
* TW Core Medication Path SCT：新增「口服」代碼 (`$TWMedicationPath#PO`)。
* TW Core Vital Signs：新增 4 項 LOINC 代碼，包含血氧 (`59408-5`)、頭圍百分位 (`8289-1`)、BMI百分位 (`59576-9`) 及體重身長比 (`77606-2`)。

1. 新增臺灣核心-心電圖(TW Core Observation ECG) Profile及相關範例。
1. 新增臺灣核心-實驗室檢驗檢查值集。
1. 更新 TWCDI。
1. 更新代碼系統臺灣健保署用藥品項。
請留意這些異動，以避免影響您的實作。

### 介紹

臺灣核心實作指引（Taiwan Core Implementation Guide，簡稱TW core IG）採用HL7® FHIR® standard（Fast Healthcare Interoperability Resources）IG建置方法，在[FHIR R4.0.1](http://hl7.org/fhir/R4/)之標準基礎上，參考了[國際病人摘要（International Patient Summary，IPS）1.1.0-CI Build](https://build.fhir.org/ig/HL7/fhir-ips/)及[美國核心實作指引（US Core Implementation Guide）](https://www.hl7.org/fhir/us/core/)，進一步定義適用於臺灣健康照護資料交換需求的Resources（類似資料表）、其中的資料項目（意即欄位）、基數（意即0..1、0..*、1..1或1..*）、資料類型（文字、日期時間、代碼等）、可綁定的代碼（及其綁定的強制程度）及查詢參數等，旨在提供健康照護資訊系統開發與實作者以TW Core IG為基礎，再進一步訂定其實務專案所需之資料交換格式以應用於專案中。TW Core IG的實作方式有兩種：

1. **僅支援Profiles**：系統僅支援TW Core Profiles以呈現健康照護相關資料。
1. **支援Profiles + RESTful互動**：系統支援TW Core Profiles及RESTful互動以呈現健康照護相關資料。

### 背景

TW Core IG由衛生福利部(以下簡稱衛福部)資訊處2022年3月招標之「111年度智慧健康雲專案辦公室營運案專案」及2025年3月招標之「114年度次世代數位醫療平臺專案辦公室」經費支應下建置，TW Core IG註冊於[國際平臺](http://fhir.org/guides/registry/)及衛生福利部資訊處之[IG管理平臺](https://twcore.mohw.gov.tw/twregistry/#/data)以供查找與參考。

鑑於TW Core IG設計之初，FHIR R5處於投票階段、國際應用多採用 R4 、以及R5相關配套工具尚未成熟，故TW Core IG的設計主要以FHIR R4.0.1 為基礎，並同時參考其他國家作法以規劃TW Core IG 網站。為使制訂之IG符合臺灣的實作需求，TW Core IG 內容將在未來的版本中持續更新，各版本亦將附有版本異動說明。

### 衛福部資訊處在 TW Core IG 的角色與發展主責

衛福部資訊處作為台灣醫療及健康照護資訊標準化的主要推動單位，在TW Core IG的制定和發展中扮演了核心角色，主要包括：
* **領導 TW Core IG 的標準制定**：積極協調其所屬機關、平行機構、醫療機構、學術單位及相關專業組織，以確保 TW Core IG 能夠滿足台灣的醫療服務、健康照護、公共衛生、臨床研究等領域資訊交換的核心資料需求，並與國際標準（如 FHIR及相關配套專門術語標準）接軌。
* **監督國際標準專門術語之維護與運作**：負責監督國際標準專門術語（如 SNOMED CT、LOINC 等）的維護與更新，確保這些術語在 TW Core IG 的應用中保持一致性與準確性，並且與國際標準的變動同步發展，以促進台灣醫療資訊體系的國際接軌。
* **納入資訊安全相關規範於TW Core IG**：積極將各種交易的稽核日誌(audit logs)、[FHIR通訊安全（Communications Security）](https://http://hl7.org/fhir/R4/security.html#http)、[SMART App執行框架（launch framework）](http://www.hl7.org/fhir/smart-app-launch/history.cfml)納入TW Core IG的資訊安全性規範，以提升台灣醫療機構在智慧型應用程式和跨機構數據共享中的應用能力，從而支持更安全且一致的健康資訊交換，強化互通性和資料整合。
* **推廣 TW Core IG 於實務專案的應用**：致力於推動相關補助計畫，提供可公用的標準技術工具、並鼓勵醫療機構及相關機構採用及繼承 TW Core IG，實現台灣醫療資料的高度互通與共享，以增進資料使用效率及醫療品質。

衛福部資訊處的長期任務：

* **持續更新與維護**：根據國內外醫療需求、技術進步及國際標準的變化，定期更新TW Core IG及相關國際標準專門術語，並適時納入必要的規範，以確保 TW Core 標準不僅符合當前醫療資訊技術的發展，亦能滿足未來醫療服務的需求。
* **推廣與應用**：協助全台醫療機構及相關單位採用並遵循 TW Core 標準，以確保這些標準被廣泛應用於臨床與公共衛生資料的傳輸與共享，促進台灣醫療資訊的整體應用效率。
* **促進全台醫療資訊的可互通性**：持續強化台灣醫療資訊的標準化，確保醫療資料能在不同機構間無縫共享，以提升醫療服務品質。

### 繼承 TW Core IG 版本的考量

關於實務專案型FHIR IG是否需要繼承最新版本TW Core IG或者要等[TW Core IG持續建置版本 (CI-build)](https://build.fhir.org/ig/cctwFHIRterm/MOHW_TWCoreIG_Build/index.html)正式定版後作繼承？通常，各專案可依據各自專案的需求決定，但 IG 設計師需審慎評估，以決定是否繼承最新版TW Core IG： 
(1) 須留意TW Core IG的CI-build版本是否影響專案資料欄位或值集範圍設計，建議可預先在設計階段納入CI-build的設計概念及內容，待CI-Build發布新版時可直接繼承，以減少更新繼承對規格設計造成影響、 
(2) 須評估專案型IG是否需要[申請註冊](https://emr.mohw.gov.tw/myemr/Html/EmrInfo#emrinfo_0)於衛生福利部資訊處 [IG 管理平臺](https://twcore.mohw.gov.tw/twregistry/#/data)以供各界參閱以及讓您的專案IG出現於國際HL7提供的線上免費驗證工具 ([https://validator.fhir.org/](https://validator.fhir.org/)) 中的IG驗證清單中，增加驗證的方便性。若要申請註冊且無特殊理由下，則建議使用審查期間最新版之TW Core IG版本。 

不論如何，基於全國健康照護資料標準化及促進資料可互通，**「強力建議」**實務專案型IG 繼承最新版TW Core IG，以確保您的IG規格與全國一致，亦可避免後續人工檢核專案IG與TW Core IG是否一致之工作量。 

2024年5月起依據衛生福利部資訊處電子病歷標準發展工作小組決議，預計每年正式更版一至二次，由於資料標準化是一個持續演進的過程，TW Core IG 亦會持續接受各界意見並評估適用性後放修改於[TW Core IG持續建置版本 (CI-build)](https://build.fhir.org/ig/cctwFHIRterm/MOHW_TWCoreIG_Build/index.html)，經確認後才會更新為正式版本，需請 IG 設計師 留意此一異動對您所設計IG之影響。

### 如何閱讀這個實作指引（IG）

TW Core IG之網站架構圖如下圖所示。各功能說明如下：

* **[應用說明](index.md)**：TW Core IG介紹及背景說明。
* **[規範文件](artifacts.md)** 
* **[能力聲明](capabilitystatements.md)**：應用TW Core IG於建置業務目的使用的FHIR Server時，該FHIR Server必須及建議應該支援的操作功能。 
* **[查詢參數及操作定義](searchparameters-and-operation.md)**：查詢FHIR Server的Profiles時，針對各Profiles可使用的查詢參數及操作定義。 
* **[邏輯模型](models.md)**：TW Core IG的所有邏輯模型（Logical Models），各邏輯模型會定義相應情境下使用的所有資料欄位。為了便於實作者快速理解，資料欄位會使用易於理解的命名，實作者再透過邏輯模型中的功能頁籤「Mappings」瞭解各資料欄位實際使用本IG的哪個Profiles的哪個資料項目（element）。 
* **[FHIR Profiles及Extensions](profiles-and-extensions.md)**： 
* TW Core IG的所有Profiles之定義與範例及Extensions。
* 各資料項目不同實作強制程度的Terminology。
* 各資料項目的限制（Constraints）。
* 查詢依據TW Core IG實作之FHIR Server的特定Profiles時，可使用的查詢參數。
* 有哪些Profiles具有查詢參數以及Server必須支援哪些必要的查詢參數功能。
 
* **[專門術語](terminologies.md)**：TW Core IG網站所使用的專門術語，包括代碼系統（Code Systems）及值集（Value Sets），內容主要依據全國專門術語服務平臺（TW terminology services）建置。 
 
* **[範例](examples.md)**：遵從TW Core IG所定義Profiles之範例。
* **[結構定義與範例檔下載](downloads.md)**：實作者若不偏好使用FHIR RESTful API驗證資料是否遵從Profiles，可直接下載所需的格式驗證檔，包括XML、JSON及Turtle三種格式，亦可於此下載完整範例。
* **[安全性](security.md)**：主要說明採用TW Core IG網站進行實作時，有關資料存取授權的作法。
* **[驗證教學](validates.md)**：如何驗證實作檔是否遵從TW Core IG規範。
* **[版本異動](https://twcore.mohw.gov.tw/ig/twcore/history.html)**：若TW Core IG網站的版本有所異動，皆可透過[異動說明頁](https://twcore.mohw.gov.tw/ig/twcore/history.html)得以瞭解版本間的異動差異。

-------

### 專有名詞定義

#### Profiles 相關

| | | |
| :--- | :--- | :--- |
| Name | 名稱 | resource的資料項目名稱（意即XML元素名稱；JSON或RDF屬性名稱）。有些名稱末端為[x]，圖示為，意即可以選擇適用的資料類型表述該資料項目內容值,故需依據資料類型填入適當的內容值，例如Patient.multipleBirth[x]。![](index/multipleX.png)如果系統只知病人是否多胞胎，則資料項目名稱為multipleBirthBoolean，內容值為「true」；如果系統中有病人多胞胎之出生順序為第2序位，則資料項目名稱為multipleBirthInteger，內容值為「2」。更多符號說明，請參閱[FHIR官網相關說明](http://hl7.org/fhir/R4/formats.html#table)。 |
| Flags | 標記 | 一組有關影響實作者如何操作資料項目的資訊，範例如下。 |
| ![](index/MustSupport.png) | 必須支援（MustSupport），表示用戶端（Client）所傳送之資料項目，伺服端（Server）必須有能力接收並儲存此資料項目。繼承使用時可再依據專案需求，對MS做出延伸定義，但必須於應用說明說明其延伸定義的具體說明。詳可參閱[MustSupport](http://hl7.org/fhir/R4/conformance-rules.html#mustSupport)。 | |
| ![](index/modifier.png) | 表示此資料項目可能會完全修正或改變其他資料項目的意涵，需特別留意。詳可參閱[Modifier](http://hl7.org/fhir/R4/conformance-rules.html#isModifier)。 | |
| ![](index/summary.png) | 表示此資料項目為摘要的一部分，詳可參閱[Summary searches](http://hl7.org/fhir/R4/search.html#summary)。 | |
| ![](index/constraints.png) | 表示此資料項目受規範設定的限制（constraints）影響，例如：Patient.name的限制為「name.text（完整中文姓名）」或name.family（英文姓）或者兩者必須填寫」，詳可參閱[Constraints](http://hl7.org/fhir/R4/conformance-rules.html#constraints)。![](index/constraints_example1.png) | |
| Card. | 基數 | 此資料項目允許出現在這個resource的最小至最大次數，意即例如某一資料項目的基數若為0..1，表示可不填寫或至多填入1筆；若為1..1，表示必須（只能）填入1筆；若為0..*，表示可不填寫或填入多筆（不限筆數）；若為1..*，表示至少要填入1筆或填入多筆（不限筆數）。 |
| Type | 資料類型 | 資料項目的資料類型（可超連結至該型別的定義），例如：boolean、integer、dateTime等。 |
| Description &Constraints | 描述與限制 | 此資料項目的描述及詳細的限制。尤其編碼的資料項目可使用何種代碼填寫，如果有特定需要綁定的代碼，則會以Binding陳述。 |

#### 限制與綁定值集（ValueSet）

如下圖所示，Patient.name的限制為「name.text（完整中文姓名）」或name.family（英文姓）或者兩者必須填寫」；Patient.name.use要求使用NameUse這個值集，而且要求使用（Required）使用該值集中的任一代碼，TW Core Patient規定必須填入「official」。
![](index/constraints_example2.png)

#### 綁定值集（value set）的強度

| | | |
| :--- | :--- | :--- |
| Required | 要求使用 | 應填入值集中的其中一個代碼 |
| Extensible | 可擴充 | 應填入值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。 |
| Preferred | 鼓勵使用 | 鼓勵使用值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。 |
| Example | 範例 | 可參考值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。 |
如下圖所示，telecom.system應使用ContactPointSystem代碼表（或稱代碼系統）中的其中一個代碼，telecom.use及gender也都有應該搭配使用的代碼表，否則以此IG驗證格式時會出現錯誤訊息。

#### 遵從度用語（Conformance Language），或可理解為「應遵從規範的程度」

FHIR使用RFC 2119中定義的遵從度動詞**必須（SHALL）**、**建議應該（SHOULD）**和**可能可以（MAY）**。而FHIR與RFC 2119不同的是，FHIR允許不同的應用程式因使用可選功能的方式而無法達到可互操作性，特別是： 

1. **必須（SHALL）**：所有實作絕對要遵從要求。

2. **必須沒有（SHALL NOT）**：所有實作絕對禁止的要求。

3. **建議應該（SHOULD）/建議不應該（SHOULD NOT）**：實作者在特定實作的情境下考慮的最佳或建議實作方法；雖然忽略一個項目可能有正當理由，但在選擇不同的程序之前，必須了解並慎重衡量所有含義。 

4. **可能可以（MAY）**：這是實作者真正可選的要求；可根據實作者的決定使用或不使用，不會造成任何影響。

#### FHIR 發佈和版本劃分

（資料來源：[Versions - FHIR v4.3.0 （hl7.org）](https://www.hl7.org/fhir/versions.html)） 

FHIR的新版本的發佈週期約為18-24個月，此頻率主要基於需向實作者諮詢、開發和審查新內容、以及ANSI批准的標準所需的正式投票和核對過程所需的時間，這個發佈週期也確保了有機會將實作者對標準規範早期版本的回饋意見納入後續版本，在滿足實作者需求的情況下，偶爾也會出現時間較短的有限範圍的發佈。 

每個新版本都有一個獨特的版本號。FHIR的版本政策是基於[Semantic versioning](http://semver.org/)（或可閱讀下表精簡整理），但由於FHIR是一個標準規範，而不是一個軟體API，因此有一些區別。


FHIR有單一的開發版本，它經由HL7管理的開發週期，每個主要的開發週期都透過正式投票（或不止一次）後才發佈新的標準規範。從版本控管的角度來看，每份發佈的標準規範都是開發主幹的一個分支，然後隨著HL7對發佈的標準規範的維護，其本身可能會發生進一步的改變（儘管這種改變通常是最小的，僅限於必要的技術修正或安全警示）。 

每個FHIR版本由4個部分組成的字串來識別：major.minor.patch-label。 IG的實作亦遵循此規則，其中的major異動將由「**電子病歷交換標準工作小組**」決定，minor及patch可由相關工作小組討論後作調整：

* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: major
  * ?: 當HL7將FHIR作為一個重要的新規格版本發佈時，如FHIR試用版（Trial Use）或標準規範版（Normative），就會增加此序號。
  * ?: 
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第1次的試用版（Trial Use）是第0版
  * ?: 以0.1.0開始進行版本控管
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第2次發行（DSTU）是第1版
  * ?: 當所有profiles為FMM2時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第3次發行（STU）是第3版（依據實作者要求以統一major序號故跳過「2」）
  * ?: 當所有profiles為FMM3時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第4次發行（Normative + STU）是第4版
  * ?: 當所有profiles為FMM4時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 第5次發行（STU）是第5版
  * ?: 當所有profiles為FMM5時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: minor
  * ?: 包括微小實質改變的修改（可能包括有限的破壞性改變）
  * ?: 在既有版本上，新增StructureDefinition內容時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 只要有新版本（major）發佈，minor就重置為0，而在開發分支中為1。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● HL7不會對已發佈的版本進行重大改變（技術性修正），所以這些版本總是有一個版本號X.n.0。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 開發中的版本是持續分析、辯論、投票和反復修改，因此可預期STU內容可能會有改變。 FHIR第4B版（僅STU改變）為4.3.0版本。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: patch
  * ?: 表示更新，包括對先前版本的技術性修正
  * ?: 針對既有版本的StructureDefinition作修改及刪除時
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 只要minor版本改變，patch就會被重置為0例如：4.0.1代表對4.0.0版本的第一次技術性修正 。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: label
  * ?: 版本末端有一個標籤，代表一個正在建立的標準規範的 「工作 」版本，並正在建立到指定的發行版本；例如，5.0.0-ballot1、5.0.0-snapshot2等。
  * ?: 目前仍持續在修訂與新增TW Core IG內容，故label為cibuild。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● 標籤前端的序號表示在投票、審查結束後的「預期」版本序號。
* ○ 「**normative+trial-use**」：同時包含試用與正式內容的混合發佈。: ● label可以是任何字串，然而典型的標籤是：

### 作者與貢獻者

| | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- |
| 作者 | v1.0.0 | 衛生福利部資訊處 | 次世代數位醫療平臺專案辦公室 | 次世代數位醫療平臺專案辦公室 | [medstandard@itri.org.tw](mailto:medstandard@itri.org.tw)[線上提問專區 | 臺灣醫療資訊標準大平台](https://medstandard.mohw.gov.tw/online-inquiry) |
| 貢獻者 | v0.1.1、v0.2.0、v0.2.1、v0.2.2、v0.3.0、v0.3.1、v0.3.2 | 李麗惠（Li-Hui Lee） | 國立臺北護理健康大學－健康事業管理系（Department of Health Care Management, National Taipei University of Nursing and Health Sciences） | [cclhlee@gmail.com](mailto:cclhlee@gmail.com)[cclhlee@ntunhs.edu.tw](mailto:cclhlee@ntunhs.edu.tw) | |
| 貢獻者 | v0.1.1、v0.2.0、v0.2.1、v0.2.2、v0.3.0、v0.3.1、v0.3.2 | 曾鈺珈（Yu-Jia Tseng） | [yujia151645@gmail.com](mailto:yujia151645@gmail.com) | | |
| 貢獻者 | v0.1.1、v0.2.0 | 林伃瑤（Yu-Yao Lin） | [a28485251@gmail.com](mailto:yujia151645@gmail.com)[082114224@ntunhs.edu.tw](mailto:082114224@ntunhs.edu.tw) | | |
| 貢獻者 | v0.2.0、v0.2.1、v0.2.2、v0.3.0、v0.3.1、v0.3.2 | 李奇安（Chi-An Lee） | [ec460520@gmail.com](mailto:ec460520@gmail.com) | | |
| 貢獻者 | v0.1.1 | 歐陽渝（Yang-Yu Ou） | [ouyangyu0326@gmail.com](mailto:ouyangyu0326@gmail.com) | | |
| 貢獻者 | v0.1.1、v0.2.0 | 連中岳（Chung-Yueh Lien） | 國立臺北護理健康大學－資訊管理系（Department of Information Management, National Taipei University of Nursing and Health Sciences） | [chungyueh@ntunhs.edu.tw](mailto:chungyueh@ntunhs.edu.tw) | |
| 貢獻者 | v0.1.1 | 徐建業（Chien-Yeh Hsu） | [cyhsu@ntunhs.edu.tw](mailto:cyhsu@ntunhs.edu.tw) | | |
| 貢獻者 | v0.1.1 | 陳欣怡（Hsin-Yi Chen） | [c86976@gmail.com](mailto:c86976@gmail.com) | | |
| 貢獻者 | v0.1.1 | 郭俐君（Li-Chun Kuo） | [lily220487@gmail.com](mailto:lily220487@gmail.com) | | |
| 貢獻者 | v0.1.1 | 丁子芸（Tzu-Yun Ting） | [aewqoo832456@gmail.com](mailto:aewqoo832456@gmail.com) | | |
| 貢獻者 | v0.2.0 | 陳杏宜（Hsin-Yi Chen） | [bii901231@gmail.com](mailto:aewqoo832456@gmail.com) | | |
| 貢獻者 | v0.2.0 | 蔡姍紜（Shan-Yun Tsai） | [appletsai319@gmail.com](mailto:aewqoo832456@gmail.com) | | |
| 貢獻者 | v0.2.0 | 黃睿駿（Hrui-Jun Huang） | [a27114171@gmail.com](mailto:aewqoo832456@gmail.com) | | |
| | | | | | |

