# 規範文件 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## 規範文件

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Capability Statements 

The following artifacts define the specific capabilities that different types of systems are expected to have in order to comply with this implementation guide. Systems conforming to this implementation guide are expected to declare conformance to one or more of the following capability statements.

| | |
| :--- | :--- |
| [臺灣核心-伺服端(TW Core Server)](CapabilityStatement-CapabilityStatementTWCoreServer.md) | 臺灣核心實作指引(TW Core IG)伺服端(Server)之能力聲明 |
| [臺灣核心-用戶端(TW Core Client)](CapabilityStatement-CapabilityStatementTWCoreClient.md) | 臺灣核心實作指引(TW Core IG)用戶端(Client)之能力聲明 |

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [讀取病人(Patient)紀錄](OperationDefinition-Patient-everything.md) | 此操作用於回傳與調用與病人相關的所有Resources。回傳的Bundle type為「searchset」。至少將會回傳病人Resource本身，以及伺服器中具有的與病人相關且可供給使用者使用的任何其他Resources。伺服器將回傳支援紀錄所需的任何Resources，例如：相關的健康照護服務提供者(Practitioners)、藥品(Medications)、位置(Locations)及機構(Organizations)等。使用此項操作(operation)的目的是提供病人存取他們的完整紀錄，或者給健康照護提供結或其他使用者執行大量資料下載。伺服器建議應該(SHOULD)至少回傳它所擁有的、已確定的病人compartment的resources、以及從這些resources所參照的任何resources。包括二進制文件和附件。在臺灣，目前沒有強制的規定，但不排除未來有其他專案要求使用。 |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [AllergyIntolerance Clinical-Status](SearchParameter-AllergyIntolerance-clinical-status.md) | 過敏或不耐症的臨床狀態(clinicalStatus) |
| [AllergyIntolerance ID](SearchParameter-AllergyIntolerance-id.md) | 過敏或不耐症的邏輯性ID |
| [Bundle ID](SearchParameter-Bundle-id.md) | Bundle的邏輯性ID |
| [Bundle identifier](SearchParameter-Bundle-identifier.md) | Bundle的唯一識別碼(identifier) |
| [CarePlan category](SearchParameter-CarePlan-category.md) | 照護計畫的類別(category) |
| [CarePlan date](SearchParameter-CarePlan-date.md) | 照護計畫的期間(period) |
| [CarePlan patient](SearchParameter-CarePlan-patient.md) | 照護計畫的對象(patient) |
| [CarePlan status](SearchParameter-CarePlan-status.md) | 照護計畫的狀態(status) |
| [CareTeam patient](SearchParameter-CareTeam-patient.md) | 照護團隊的對象(patient) |
| [CareTeam role](SearchParameter-CareTeam-role.md) | 照護團隊的角色(role) |
| [CareTeam status](SearchParameter-CareTeam-status.md) | 照護團隊的狀態(status) |
| [Composition ID](SearchParameter-Composition-id.md) | 臨床文件架構的邏輯性ID |
| [Composition status](SearchParameter-Composition-status.md) | 臨床文件架構的狀態(status) |
| [Composition subject](SearchParameter-Composition-subject.md) | 臨床文件架構的病人(subject) |
| [Composition type](SearchParameter-Composition-type.md) | 臨床文件架構的型別(type) |
| [Condition AbatementDate](SearchParameter-Condition-abatement-date.md) | 病情、問題或診斷解決/緩解的日期(abatement) |
| [Condition ClinicalStatus](SearchParameter-Condition-clinical-status.md) | 病情、問題或診斷的臨床狀態(clinicalStatus) |
| [Condition Code](SearchParameter-Condition-code.md) | 病情、問題或診斷的識別(code) |
| [Condition ID](SearchParameter-Condition-id.md) | 病情、問題或診斷的邏輯性ID |
| [Condition OnsetDate](SearchParameter-Condition-onset-date.md) | 病情、問題或診斷的日期(onset) |
| [Condition Severity](SearchParameter-Condition-severity.md) | 病情、問題或診斷的主觀嚴重程度(severity) |
| [Condition Subject](SearchParameter-Condition-subject.md) | 有此病情、問題或診斷的病人(subject) |
| [Coverage patient](SearchParameter-Coverage-patient.md) | 保險的對象(patient) |
| [Device patient](SearchParameter-Device-patient.md) | 裝置的使用對象(patient) |
| [Device status](SearchParameter-Device-status.md) | 裝置的狀態(status) |
| [Device type](SearchParameter-Device-type.md) | 裝置的類型(type) |
| [DiagnosticReport Category](SearchParameter-DiagnosticReport-category.md) | 診斷報告的類別(category) |
| [DiagnosticReport Code](SearchParameter-DiagnosticReport-code.md) | 診斷報告的代碼(code) |
| [DiagnosticReport Date](SearchParameter-DiagnosticReport-date.md) | 診斷報告的時間(date) |
| [DiagnosticReport ID](SearchParameter-DiagnosticReport-id.md) | 診斷報告的邏輯性ID |
| [DiagnosticReport Status](SearchParameter-DiagnosticReport-status.md) | 診斷報告的狀態(status) |
| [DiagnosticReport Subject](SearchParameter-DiagnosticReport-subject.md) | 診斷報告的對象(subject) |
| [DocumentReference ID](SearchParameter-DocumentReference-id.md) | 文件參照的邏輯性ID |
| [DocumentReference Status](SearchParameter-DocumentReference-status.md) | 文件參照的狀態(status) |
| [DocumentReference Subject](SearchParameter-DocumentReference-subject.md) | 文件參照的對象(subject) |
| [Encounter Class](SearchParameter-Encounter-class.md) | 病人就醫的分類(class) |
| [Encounter Date](SearchParameter-Encounter-date.md) | 就醫的時間(date) |
| [Encounter ID](SearchParameter-Encounter-id.md) | 就醫的邏輯性ID |
| [Encounter Identifier](SearchParameter-Encounter-identifier.md) | 就醫事件的識別碼(identifier) |
| [Encounter Location](SearchParameter-Encounter-location.md) | 病人曾去過的一個或多個地點(location) |
| [Encounter Status](SearchParameter-Encounter-status.md) | 就醫現況(status) |
| [Encounter Subject](SearchParameter-Encounter-subject.md) | 就醫的病人(subject) |
| [Goal description](SearchParameter-Goal-description.md) | 描述目標的代碼或文字(description) |
| [Goal lifecycle status](SearchParameter-Goal-lifecycle-status.md) | 目標在其整個生命週期中的狀態(lifecycle-status) |
| [Goal patient](SearchParameter-Goal-patient.md) | 目標的對象(patient) |
| [Goal target date](SearchParameter-Goal-target-date.md) | 目標的預計達成時間(target.dueDate) |
| [ImagingStudy ID](SearchParameter-ImagingStudy-id.md) | 影像檢查的邏輯性ID |
| [ImagingStudy Status](SearchParameter-ImagingStudy-status.md) | 影像檢查的狀態(status) |
| [ImagingStudy Subject](SearchParameter-ImagingStudy-subject.md) | 影像檢查的對象(subject) |
| [ImagingStudy encounter](SearchParameter-ImagingStudy-encounter.md) | 影像檢查的就醫事件(encounter) |
| [ImagingStudy started](SearchParameter-ImagingStudy-started.md) | 影像檢查的開始日期（時間）(started) |
| [Immunization date](SearchParameter-Immunization-date.md) | 疫苗接種的時間(occurrence) |
| [Immunization patient](SearchParameter-Immunization-patient.md) | 疫苗接種的對象(patient) |
| [Immunization status](SearchParameter-Immunization-status.md) | 疫苗接種的狀態(status) |
| [Location ID](SearchParameter-Location-id.md) | 地點的邏輯性ID |
| [Location address](SearchParameter-Location-address.md) | 地點的地址(address) |
| [Location name](SearchParameter-Location-name.md) | 地點的名稱(name) |
| [Media ID](SearchParameter-Media-id.md) | 多媒體的邏輯性ID |
| [Media Status](SearchParameter-Media-status.md) | 多媒體的狀態(status) |
| [Media Subject](SearchParameter-Media-subject.md) | 多媒體的對象(subject) |
| [Medication Code](SearchParameter-Medication-code.md) | 藥品的代碼(code) |
| [Medication ID](SearchParameter-Medication-id.md) | 藥品的邏輯性ID |
| [MedicationDispense ID](SearchParameter-MedicationDispense-id.md) | 配藥/調劑藥品的邏輯性ID |
| [MedicationDispense Status](SearchParameter-MedicationDispense-status.md) | 配藥/調劑藥品的狀態(status) |
| [MedicationDispense Subject](SearchParameter-MedicationDispense-subject.md) | 配藥/調劑藥品的對象(subject) |
| [MedicationDispense medication](SearchParameter-MedicationDispense-medication.md) | 配藥/調劑藥品的藥品(medication) |
| [MedicationRequest Authoredon](SearchParameter-MedicationRequest-authoredon.md) | 藥品請求的最初請求時間(authoredon) |
| [MedicationRequest Encounter](SearchParameter-MedicationRequest-encounter.md) | 藥品請求的就醫事件(encounter) |
| [MedicationRequest ID](SearchParameter-MedicationRequest-id.md) | 藥品請求的邏輯性ID |
| [MedicationRequest Intent](SearchParameter-MedicationRequest-intent.md) | 藥品請求的意圖(intent) |
| [MedicationRequest Status](SearchParameter-MedicationRequest-status.md) | 藥品請求的狀態(status) |
| [MedicationRequest Subject](SearchParameter-MedicationRequest-subject.md) | 藥品請求的對象(subject) |
| [MedicationRequest medication](SearchParameter-MedicationRequest-medication.md) | 藥品請求的藥品(medication) |
| [MedicationStatement ID](SearchParameter-MedicationStatement-id.md) | 用藥聲明的邏輯性ID |
| [MedicationStatement Status](SearchParameter-MedicationStatement-status.md) | 用藥聲明的狀態(status) |
| [MedicationStatement Subject](SearchParameter-MedicationStatement-subject.md) | 用藥聲明的對象(subject) |
| [MedicationStatement medication](SearchParameter-MedicationStatement-medication.md) | 用藥聲明的藥品(medication) |
| [MessageHeader Author](SearchParameter-MessageHeader-author.md) | 訊息表頭的撰寫者(author) |
| [MessageHeader ID](SearchParameter-MessageHeader-id.md) | 訊息表頭的邏輯性ID |
| [MessageHeader sender](SearchParameter-MessageHeader-sender.md) | 訊息表頭的傳送單位(sender) |
| [Observation Category](SearchParameter-Observation-category.md) | 檢驗檢查的類別(category) |
| [Observation Code](SearchParameter-Observation-clinical-code.md) | 檢驗檢查項目(code) |
| [Observation Date](SearchParameter-Observation-date.md) | 檢驗檢查的日期（時間）(effective) |
| [Observation ID](SearchParameter-Observation-id.md) | 檢驗檢查的邏輯性ID |
| [Observation Performer](SearchParameter-Observation-performer.md) | 執行檢驗檢查的人員(performer) |
| [Observation Status](SearchParameter-Observation-status.md) | 檢驗檢查的狀態(status) |
| [Observation Subject](SearchParameter-Observation-subject.md) | 檢驗檢查有關的對象及（或）事物(subject) |
| [Observation lastupdated](SearchParameter-Observation-lastupdated.md) | 檢驗檢查的最後更新日期（時間）(lastupdated) |
| [Observation patient](SearchParameter-Observation-patient.md) | 檢驗檢查有關的對象(patient) |
| [Organization ID](SearchParameter-Organization-id.md) | 機構的邏輯性ID |
| [Organization Identifier](SearchParameter-Organization-identifier.md) | 機構的唯一識別碼(identifier) |
| [Organization Name](SearchParameter-Organization-name.md) | 機構的名稱(name) |
| [Organization Type](SearchParameter-Organization-type.md) | 機構的型別(type) |
| [Patient Birthdate](SearchParameter-Patient-birthdate.md) | 病人的出生日期(birthdate) |
| [Patient Gender](SearchParameter-Patient-gender.md) | 病人的性別(gender) |
| [Patient ID](SearchParameter-Patient-id.md) | 病人的邏輯性ID |
| [Patient Identifier](SearchParameter-Patient-identifier.md) | 病人的身份識別碼(identifier) |
| [Patient Name](SearchParameter-Patient-name.md) | 病人的姓名(name) |
| [Practitioner ID](SearchParameter-Practitioner-id.md) | 健康照護服務提供者的邏輯性ID |
| [Practitioner Identifier](SearchParameter-Practitioner-identifier.md) | 健康照護服務提供者的識別碼(identifier) |
| [Practitioner Name](SearchParameter-Practitioner-name.md) | 健康照護服務提供者的姓名(name) |
| [PractitionerRole ID](SearchParameter-PractitionerRole-id.md) | 健康照護服務提供者角色的邏輯性ID |
| [PractitionerRole Identifier](SearchParameter-PractitionerRole-identifier.md) | 健康照護服務提供者角色的識別碼(identifier) |
| [PractitionerRole Specialty](SearchParameter-PractitionerRole-specialty.md) | 健康照護服務提供者角色的專業(specialty) |
| [Procedure Code](SearchParameter-Procedure-code.md) | 處置或手術的識別碼(code) |
| [Procedure Date](SearchParameter-Procedure-date.md) | 處置或手術的日期(date) |
| [Procedure ID](SearchParameter-Procedure-id.md) | 處置或手術的邏輯性ID |
| [Procedure Status](SearchParameter-Procedure-status.md) | 處置或手術或的狀態(status) |
| [Procedure Subject](SearchParameter-Procedure-subject.md) | 處置或手術服務的對象(subject) |
| [Provenance ID](SearchParameter-Provenance-id.md) | 出處的邏輯性ID |
| [Provenance Patient](SearchParameter-Provenance-patient.md) | 出處的對象(patient) |
| [QuestionnaireResponse authored](SearchParameter-QuestionnaireResponse-authored.md) | 問卷題目回覆的日期(authored) |
| [QuestionnaireResponse id](SearchParameter-QuestionnaireResponse-id.md) | 問卷題目回覆的邏輯性ID |
| [QuestionnaireResponse patient](SearchParameter-QuestionnaireResponse-patient.md) | 問卷題目回覆的對象(patient) |
| [QuestionnaireResponse questionnaire](SearchParameter-QuestionnaireResponse-questionnaire.md) | 問卷題目回覆的問卷(questionnaire) |
| [QuestionnaireResponse status](SearchParameter-QuestionnaireResponse-status.md) | 問卷題目回覆的狀態(status) |
| [RelatedPerson ID](SearchParameter-RelatedPerson-id.md) | 相關人士的邏輯性ID |
| [RelatedPerson name](SearchParameter-RelatedPerson-name.md) | 相關人士的姓名(name)，該查詢可能與 HumanName 中的任何字串匹配，包括完整的中文姓名(text)、英文姓(family)、英文名(given)、姓名前面的頭銜(prefix)、姓名後面的稱謂(suffix)。 |
| [RelatedPerson patient](SearchParameter-RelatedPerson-patient.md) | 與該相關人士有關係的病人(patient) |
| [ServiceRequest authored](SearchParameter-ServiceRequest-authored.md) | 簽署服務請求的日期(authored) |
| [ServiceRequest category](SearchParameter-ServiceRequest-category.md) | 服務請求的類別(category) |
| [ServiceRequest code](SearchParameter-ServiceRequest-code.md) | 服務請求項目(code) |
| [ServiceRequest id](SearchParameter-ServiceRequest-id.md) | 服務請求的邏輯性ID |
| [ServiceRequest patient](SearchParameter-ServiceRequest-patient.md) | 服務請求的對象(patient) |
| [ServiceRequest status](SearchParameter-ServiceRequest-status.md) | 服務請求的狀態(status) |
| [Specimen ID](SearchParameter-Specimen-id.md) | 檢體的邏輯性ID |
| [Specimen Status](SearchParameter-Specimen-status.md) | 檢體的狀態(status) |
| [Specimen identifier](SearchParameter-Specimen-identifier.md) | 檢體的識別碼(identifier) |
| [Specimen subject](SearchParameter-Specimen-subject.md) | 檢體的病人(subject) |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型](StructureDefinition-TWPractitioner.md) | 臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型 |
| [臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型](StructureDefinition-TWPractitionerRole.md) | 臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) 之資料模型 |
| [臺灣核心-地點(TW Core Location) 之資料模型](StructureDefinition-TWLocation.md) | 臺灣核心-地點(TW Core Location) 之資料模型 |
| [臺灣核心-多媒體(TW Core Media) 之資料模型](StructureDefinition-TWMedia.md) | 臺灣核心-多媒體(TW Core Media) 之資料模型 |
| [臺灣核心-就醫事件(TW Core Encounter) 之資料模型](StructureDefinition-TWEncounter.md) | 臺灣核心-就醫事件(TW Core Encounter) 之資料模型 |
| [臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型](StructureDefinition-TWImagingStudy.md) | 臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型 |
| [臺灣核心-文件參照(TW Core DocumentReference) 之資料模型](StructureDefinition-TWDocumentReference.md) | 臺灣核心-文件參照(TW Core DocumentReference) 之資料模型 |
| [臺灣核心-機構(TW Core Organization)之資料模型](StructureDefinition-TWOrganization.md) | 臺灣核心-機構(TW Core Organization)之資料模型 |
| [臺灣核心-檢驗檢查(TW Core Observation) 之資料模型](StructureDefinition-TWObservation.md) | 臺灣核心-檢驗檢查(TW Core Observation) 之資料模型 |
| [臺灣核心-檢體(TW Core Specimen) 之資料模型](StructureDefinition-TWSpecimen.md) | 臺灣核心-檢體(TW Core Specimen) 之資料模型 |
| [臺灣核心-用藥聲明(TW Core MedicationStatement) 之資料模型](StructureDefinition-TWMedicationStatement.md) | 臺灣核心-用藥聲明(TW Core MedicationStatement) 之資料模型 |
| [臺灣核心-病人(TW Core Patient)之資料模型](StructureDefinition-TWPatient.md) | 臺灣核心-病人(TW Core Patient)之資料模型 |
| [臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型](StructureDefinition-TWCondition.md) | 臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型 |
| [臺灣核心-臨床文件架構(TW Core Composition) 之資料模型](StructureDefinition-TWComposition.md) | 臺灣核心-臨床文件架構(TW Core Composition) 之資料模型 |
| [臺灣核心-藥品(TW Core Medication) 之資料模型](StructureDefinition-TWMedication.md) | 臺灣核心-藥品(TW Core Medication) 之資料模型 |
| [臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型](StructureDefinition-TWMedicationRequest.md) | 臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型 |
| [臺灣核心-處置或手術(TW Core Procedure)之資料模型](StructureDefinition-TWProcedure.md) | 臺灣核心-處置或手術(TW Core Procedure)之資料模型 |
| [臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型](StructureDefinition-TWMessageHeader.md) | 臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型 |
| [臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型](StructureDefinition-TWDiagnosticReport.md) | 臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型 |
| [臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型](StructureDefinition-TWBundle.md) | 臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型 |
| [臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型](StructureDefinition-TWAllergyIntolerance.md) | 臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) 之資料模型 |
| [臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型](StructureDefinition-TWMedicationDispense.md) | 臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型 |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [TW Core Location](StructureDefinition-Location-twcore.md) | 此臺灣核心-地點（TW Core Location） Profile說明本IG如何進一步定義FHIR的Location Resource以呈現地點的詳細資料。 |
| [TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md) | 此臺灣核心-用藥聲明（TW Core MedicationStatement） Profile說明本IG如何進一步定義FHIR的MedicationStatement Resource以呈現用藥聲明的詳細資料。 |
| [TW Core AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md) | 此臺灣核心-過敏或不耐症（TW Core AllergyIntolerance） Profile說明本IG如何進一步定義FHIR的AllergyIntolerance Resource以呈現過敏與不耐症的詳細資料。 |
| [TW Core Bundle](StructureDefinition-Bundle-twcore.md) | 此臺灣核心-資料交換基本單位（TW Core Bundle） Profile說明本IG如何進一步定義FHIR的Bundle Resource以呈現資料交換基本單位的詳細資料。 |
| [TW Core Bundle Document](StructureDefinition-Bundle-document-twcore.md) | 此臺灣核心-資料交換基本單位-文件（TW Core Bundle Document） Profile說明本IG如何進一步定義臺灣核心-資料交換基本單位(TW Core Bundle） Profile以呈現 Bundle 文件 的詳細資料。 |
| [TW Core Bundle Message](StructureDefinition-Bundle-message-twcore.md) | 此臺灣核心-資料交換基本單位-訊息（TW Core Bundle Message） Profile說明本IG如何進一步定義臺灣核心-資料交換基本單位(TW Core Bundle） Profile以呈現 Bundle Message 的詳細資料。 |
| [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md) | 此臺灣核心-照護計畫(TW Core CarePlan) Profile 說明本 IG 如何進一步定義 FHIR 的 CarePlan Resource 以呈現照護計畫資料。 |
| [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md) | 此臺灣核心-照護團隊(TW Core CareTeam) Profile 說明本 IG 如何進一步定義 FHIR 的 CareTeam Resource 以呈現照護團隊資料。 |
| [TW Core Composition](StructureDefinition-Composition-twcore.md) | 此臺灣核心-臨床文件架構（TW Core Composition） Profile說明本IG如何進一步定義FHIR的Composition Resource以呈現臨床文件架構的詳細資料。 |
| [TW Core Condition](StructureDefinition-Condition-twcore.md) | 此臺灣核心-病情、問題或診斷（TW Core Condition） Profile說明本IG如何進一步定義FHIR的Condition Resource以呈現有關病情、問題或診斷的詳細資料。 |
| [TW Core Coverage](StructureDefinition-Coverage-twcore.md) | 此臺灣核心-給付範圍(TW Core Coverage) Profile 說明本 IG 如何進一步定義 FHIR 的 Coverage Resource 以呈現給付範圍資料。 |
| [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md) | 此臺灣核心-診斷報告（TW Core DiagnosticReport） Profile說明本IG如何進一步定義FHIR的DiagnosticReport Resource以呈現診斷報告。 |
| [TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md) | 此臺灣核心-文件參照（TW Core DocumentReference） Profile說明本IG如何進一步定義FHIR的DocumentReference Resource以呈現文件參照的詳細資料。 |
| [TW Core Encounter](StructureDefinition-Encounter-twcore.md) | 此臺灣核心-就醫事件（TW Core Encounter） Profile說明本IG如何進一步定義FHIR的Encounter Resource以呈現就醫事件。 |
| [TW Core Goal](StructureDefinition-Goal-twcore.md) | 此臺灣核心-目標（TW Core Goal） Profile說明本IG如何進一步定義FHIR的Goal Resource以呈現目標資料。 |
| [TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md) | 此臺灣核心-影像檢查（TW Core ImagingStudy） Profile說明本IG如何進一步定義FHIR的ImagingStudy Resource以呈現影像檢查的詳細資料。 |
| [TW Core Immunization](StructureDefinition-Immunization-twcore.md) | 此臺灣核心-疫苗接種 (TW Core Immunization) Profile 說明本 IG 如何進一步定義 FHIR 的 Immunization Resource 以呈現疫苗接種資料。 |
| [TW Core Implantable Device](StructureDefinition-Device-twcore.md) | 此臺灣核心-植入式裝置（TW Core Implantable Device） Profile說明本IG如何進一步定義FHIR的Device Resource以呈現植入式裝置資料。 |
| [TW Core Media](StructureDefinition-Media-twcore.md) | 此臺灣核心-多媒體（TW Core Media） Profile說明本IG如何進一步定義FHIR的Media Resource以呈現多媒體的詳細資料。 |
| [TW Core Medication](StructureDefinition-Medication-twcore.md) | 此臺灣核心-藥品（TW Core Medication） Profile說明本IG如何進一步定義FHIR的Medication Resource以呈現藥品的詳細資料。 |
| [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md) | 此臺灣核心-配藥或藥品調劑（TW Core MedicationDispense） Profile說明本IG如何進一步定義FHIR的MedicationDispense Resource以呈現配藥或藥品調劑的詳細資料。 |
| [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md) | 此臺灣核心-藥品請求（TW Core MedicationRequest） Profile說明本IG如何進一步定義FHIR的MedicationRequest Resource以呈現藥品請求的詳細資料。 |
| [TW Core MessageHeader](StructureDefinition-MessageHeader-twcore.md) | 此臺灣核心-訊息表頭（TW Core MessageHeader） Profile說明本IG如何進一步定義FHIR的MessageHeader Resource以呈現訊息表頭的詳細資料。 |
| [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md) | 此臺灣核心-平均血壓（TW Core Observation Average Blood Pressure）Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現平均血壓資料。 |
| [TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md) | 此臺灣核心-身體質量指數（TW Core Observation BMI） Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現身體質量指數資料。 |
| [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md) | 此臺灣核心-血壓（TW Core Observation Blood Pressure） Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現血壓資料。 |
| [TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md) | 此臺灣核心-身高 (TW Core Observation Body Height) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現身高資料。 |
| [TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md) | 此臺灣核心-體溫 (TW Core Observation Body Temperature) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現體溫資料。 |
| [TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md) | 此臺灣核心-體重（TW Core Observation Body Weight）Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs）Profile 以呈現體重資料。 |
| [TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md) | 此臺灣核心-病人照護偏好註記（TW Core Observation Care Experience Preference）Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現照護經驗偏好資料。(可填寫文字或代碼等說明) |
| [TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md) | 此臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現臨床檢驗檢查資料。 |
| [TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md) | 此臺灣核心-心電圖（TW Core Observation ECG） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現心電圖（ECG/EKG）資料。 |
| [TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md) | 此臺灣核心-頭圍（TW Core Observation Head Circumference） Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現頭圍資料。 |
| [TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md) | 此臺灣核心-心率 (TW Core Observation Heart Rate) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現心率資料。 |
| [TW Core Observation Laboratory Result](StructureDefinition-Observation-laboratoryResult-twcore.md) | 此臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現檢驗檢查資料。 |
| [TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md) | 此臺灣核心-職業（TW Core Observation Occupation） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現職業資料。 |
| [TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile](StructureDefinition-Observation-pediatric-head-circumference-twcore.md) | 此臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile） Profile 說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile 以呈現兒童頭圍百分位數資料。 |
| [TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md) | 此臺灣核心-妊娠計畫（TW Core Observation Pregnancy Intent） Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現妊娠計畫資料。 |
| [TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md) | 此臺灣核心-妊娠狀態 (TW Core Observation Pregnancy Status) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現妊娠狀態資料。 |
| [TW Core Observation Pulse Oximetry](StructureDefinition-Observation-pulse-oximetry-twcore.md) | 此臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile 以呈現脈搏血氧飽和度資料。 |
| [TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md) | 此臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）Profile 說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile 以呈現呼吸速率資料。 |
| [TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md) | 此臺灣核心-健康狀態篩檢與評估 (TW Core Observation Screening Assessment) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現健康狀態篩檢與評估資料。 |
| [TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md) | 此臺灣核心-性傾向 (TW Core Observation Sexual Orientation) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現性傾向資料。 |
| [TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md) | 此臺灣核心-吸菸狀態 (TW Core Observation Smoking Status) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現吸菸狀態資料。 |
| [TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md) | 此臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference） Profile說明本IG如何進一步定義FHIR的Observation Profile以呈現病人治療偏好註記資料。 |
| [TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md) | 此臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile說明本IG如何進一步定義FHIR的Vital Signs Profile以呈現生命體徵資料。 |
| [TW Core Organization](StructureDefinition-Organization-twcore.md) | 此臺灣核心-機構（TW Core Organization）Profile說明本IG如何進一步定義FHIR的Organization Resource以呈現機構基本資料。 |
| [TW Core Organization Company](StructureDefinition-Organization-co-twcore.md) | 此臺灣核心-公司行號（TW Core Organization Company） Profile說明本IG如何進一步定義臺灣核心-機構（TW Core Organization） Profile以呈現機構基本資料。 |
| [TW Core Organization Government](StructureDefinition-Organization-govt-twcore.md) | 此臺灣核心-政府機構（TW Core Organization Government） Profile說明本IG如何進一步定義臺灣核心-機構（TW Core Organization） Profile以呈現機構基本資料。 |
| [TW Core Organization Hospital Department](StructureDefinition-Organization-hosp-twcore.md) | 此臺灣核心-醫事機構（TW Core Organization Hospital Department） Profile說明本IG如何進一步定義臺灣核心-機構（TW Core Organization） Profile以呈現機構基本資料。 |
| [TW Core Patient](StructureDefinition-Patient-twcore.md) | 此臺灣核心-病人（TW Core Patient） Profile說明本IG如何進一步定義FHIR的Patient Resource以呈現基本資料。 |
| [TW Core Pediatric BMI for Age Observation](StructureDefinition-Observation-pediatric-bmi-age-twcore.md) | 此臺灣核心-兒童及青少年身體質量指數 (TW Core Pediatric BMI for Age Observation) Profile 說明本 IG 如何進一步定義臺灣核心-生命體徵 (TW Core Observation Vital Signs) Profile 以呈現兒童及青少年身體質量指數資料。 |
| [TW Core Pediatric Weight for Height Observation](StructureDefinition-Observation-pediatric-weight-height-twcore.md) | 此臺灣核心-兒童生長曲線（TW Core Pediatric Weight for Height Observation）Profile說明本IG如何進一步定義臺灣核心-生命體徵（TW Core Observation Vital Signs） Profile以呈現兒童生長曲線資料。 |
| [TW Core Practitioner](StructureDefinition-Practitioner-twcore.md) | tifier:residentNumber欄位的identifier.system改為 = http://www.immigration.gov.tw。此臺灣核心-健康照護服務提供者（TW Core Practitioner） Profile說明本IG如何進一步定義FHIR的Practitioner Resource以呈現健康照護服務提供者基本資料。 |
| [TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md) | 此臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole） Profile說明本IG如何進一步定義FHIR的PractitionerRole Resource以呈現健康照護服務提供者角色的詳細資料。 |
| [TW Core Procedure](StructureDefinition-Procedure-twcore.md) | 此臺灣核心-處置或手術（TW Core Procedure） Profile說明本IG如何進一步定義FHIR的Procedure Resource以呈現處置或手術基本資料。 |
| [TW Core Provenance](StructureDefinition-Provenance-twcore.md) | 此臺灣核心-出處（TW Core Provenance） Profile說明本IG如何進一步定義FHIR的Provenance Resource以呈現出處資料。 |
| [TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md) | 此臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）Profile說明本IG如何進一步定義FHIR的QuestionnaireResponse Resource以呈現問卷題目回覆資料。 |
| [TW Core RelatedPerson](StructureDefinition-RelatedPerson-twcore.md) | 此臺灣核心-相關人士（TW Core RelatedPerson） Profile說明本IG如何進一步定義FHIR的RelatedPerson Resource以呈現相關人士資料。 |
| [TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md) | 此臺灣核心-服務請求（TW Core ServiceRequest） Profile說明本IG如何進一步定義FHIR的ServiceRequest Resource以呈現服務請求資料。 |
| [TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md) | 此臺灣核心-通用檢驗檢查（TW Core Simple Observation） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現通用檢驗檢查資料。 |
| [TW Core Specimen](StructureDefinition-Specimen-twcore.md) | 此臺灣核心-檢體（TW Core Specimen） Profile說明本IG如何進一步定義FHIR的Specimen Resource以呈現檢體的詳細資料。 |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [TW CodeableConcept](StructureDefinition-CodeableConcept-tw.md) | 此臺灣CodeableConcept Profile說明本IG如何進一步定義FHIR的CodeableConcept資料類型以呈現CodeableConcept [[**FMM1**](http://build.fhir.org/versions.html#maturity)] |
| [TW Coding](StructureDefinition-Coding-tw.md) | 此臺灣Coding Profile說明本IG如何進一步定義FHIR的Coding資料類型以呈現Coding [[**FMM1**](http://build.fhir.org/versions.html#maturity)] |
| [TW Core Address](StructureDefinition-Address-tw.md) | 此臺灣核心-地址（TW Core Address） Profile說明本IG如何進一步定義FHIR的Address資料類型以呈現臺灣地址。本Profile之擴充的資料項目（Extension）為參照[初診基本資料表](https://www.eck.org.tw/wp-content/uploads/2019/10/ECK_FIRSTVIEW_INFOR.pdf)之欄位與[中華郵政地址英譯寫法](https://www.post.gov.tw/post/internet/Postal/sz_a_e_ta1.jsp)，若貴機構有詳細地址資訊之需求，可依情況填選；若無需區分詳細地址資訊，可使用原生欄位`text`、`line`、`district`呈現。 |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Identifier Suffix](StructureDefinition-identifier-suffix.md) | * 增加Practitioner.identifier.type.coding.code欄位也可使用此Extension，以利實務專案使用
識別碼後綴詞 |
| [Person Age](StructureDefinition-person-age.md) | 年齡 |
| [Questionnaire Url](StructureDefinition-questionnaire-url.md) | Questionnaire URI |
| [TW Alley](StructureDefinition-tw-alley.md) | 臺灣地址欄位-弄 |
| [TW Floor](StructureDefinition-tw-floor.md) | 臺灣地址欄位-樓 |
| [TW Lane](StructureDefinition-tw-lane.md) | 臺灣地址欄位-巷 |
| [TW Neighborhood](StructureDefinition-tw-neighborhood.md) | 臺灣地址欄位-鄰 |
| [TW Number](StructureDefinition-tw-number.md) | 臺灣地址欄位-號 |
| [TW Postal code](StructureDefinition-tw-postal-code.md) | 臺灣郵遞區號 |
| [TW Room](StructureDefinition-tw-room.md) | 臺灣地址欄位-室 |
| [TW Section](StructureDefinition-tw-section.md) | 臺灣地址欄位-段 |
| [TW Village](StructureDefinition-tw-village.md) | 臺灣地址欄位-村(里) |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Acquisition Modality](ValueSet-AcquisitionModality.md) | 此值集為 DICOM CID 29 Acquisition Modality 的本地定義，用於解決 IG Publisher 無法解析外部連結的問題。 |
| [HL7 OrderableDrugForm藥品劑型值集](ValueSet-v3-orderableDrugForm.md) | HL7 OrderableDrugForm藥品劑型值集。資料所屬單位：Health Level 7 |
| [HL7 Provenance participant type + 臺灣衛福部資訊處Provenance參與類型](ValueSet-provenance-participant-type-hl7-tw.md) | HL7 Provenance participant type + 臺灣衛福部資訊處Provenance參與類型 |
| [HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集](ValueSet-medication-frequency-hl7-tw.md) | HL7 TimingAbbreviation + 臺灣健保署藥品使用頻率值集。 |
| [IdentifierType + 臺灣衛福部資訊處識別碼類型值集](ValueSet-identifier-type-tw.md) | IdentifierType + 臺灣衛福部資訊處識別碼類型值集 |
| [LOINC + HL7 NullFlavor妊娠計畫值集](ValueSet-loinc-pregnancy-intent-code.md) | LOINC + HL7 NullFlavor妊娠計畫值集。 |
| [LOINC Code Document Section值集](ValueSet-loinc-doc-section-code.md) | LOINC Code Document Section值集。 代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。 |
| [LOINC Code Document Type值集](ValueSet-loinc-type-doc-code.md) | LOINC Code Document Type值集。代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。 |
| [LOINC Document Class值集](ValueSet-loinc-document-classcodes.md) | LOINC Document Class值集。 代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。 |
| [LOINC實驗室檢驗檢查值集](ValueSet-loinc-observation-code.md) | LOINC實驗室檢驗檢查值集。代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。 |
| [LOINC生命體徵值集](ValueSet-vital-signs-tw.md) | LOINC生命體徵值集。 |
| [LOINC篩檢與評估值集](ValueSet-loinc-survey-codes.md) | LOINC篩檢與評估值集。 代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。 |
| [RxNorm藥品代碼值集](ValueSet-medication-rxnorm-tw.md) | RxNorm藥品代碼值集資料所屬單位：Unified Medical Language System® (UMLS®) |
| [SNOMED CT + HL7 NullFlavor 性傾向值集](ValueSet-snomed-sexual-orientation-code.md) | SNOMED CT + HL7 NullFlavor 性傾向值集。 |
| [SNOMED CT + HL7 NullFlavor妊娠狀態值集](ValueSet-snomed-pregnancy-status-code.md) | SNOMED CT + HL7 NullFlavor妊娠狀態值集。 |
| [SNOMED CT + LOINC 吸菸狀態種類向值集](ValueSet-smoking-status-type-code.md) | SNOMED CT + LOINC 吸菸狀態種類向值集。 |
| [SNOMED CT + 臺灣健保署給藥途徑值集](ValueSet-medication-path-sct-tw.md) | SNOMED CT + 臺灣健保署給藥途徑值集。此值集優先採用國際標準碼，國際標準碼未能表述之概念，則以普遍被使用的臺灣健保署給藥途徑代碼表述，請實作者留意。 |
| [SNOMED CT + 臺灣醫事司醫事人員類別值集](ValueSet-health-professional-sct-tw.md) | SNOMED CT + 臺灣醫事司醫事人員類別值集。此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣醫事司醫事人員類別標準碼表述，請實作者留意。 |
| [SNOMED CT 吸菸狀態綜合評估值集](ValueSet-smoking-status-comprehensive-code.md) | SNOMED CT + HL7 NullFlavor 性傾向值集。 |
| [SNOMED CT診斷代碼值集](ValueSet-condition-code-sct-tw.md) | SNOMED CT診斷代碼值集。 |
| [對應至 SNOMED CT之就醫科別 + 診療科別值集](ValueSet-medical-department-sct-tw.md) | 因就醫科別與診療科別對應到之國際標準碼 SNOMED CT有共通代碼，因此本值集將兩者的對應代碼整合於同一值集中。另為便於使用者更清晰地辨識「[就醫科別](ValueSet-medical-department-sct-tw.md#就醫科別對應表)」及「[診療科別](ValueSet-medical-department-sct-tw.md#診療科別對應表)」的各別完整值集範圍，請參閱以下兩個表格，代碼使用原則為：若想表達的語意有國際代碼可表述，便採用國際代碼；若無對應的國際代碼可表述，則採用健保署編訂的代碼。 |
| [無法對應至SNOMED CT之臺灣健保署就醫科別值集](ValueSet-medical-consultation-department-tw.md) | 無法對應至SNOMED CT之臺灣健保署就醫科別值集。此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣健保署標準碼表述，請實作者留意。 |
| [無法對應至SNOMED CT之臺灣健保署診療科別值集](ValueSet-medical-treatment-department-tw.md) | 無法對應至SNOMED CT之臺灣健保署診療科別值集。此值集優先採用國際標準碼，國際標準碼未能表述之概念則以普遍被使用的臺灣健保署標準碼表述，請實作者留意。 |
| [臺灣中華郵政3碼郵遞區號值集](ValueSet-postal-code3-tw.md) | 臺灣中華郵政3碼郵遞區號值集。資料所屬單位：中華郵政。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣中華郵政5碼郵遞區號值集](ValueSet-postal-code5-tw.md) | 臺灣中華郵政5碼郵遞區號值集。資料所屬單位：中華郵政。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣中華郵政6碼郵遞區號值集](ValueSet-postal-code6-tw.md) | 臺灣中華郵政6碼郵遞區號值集。資料所屬單位：中華郵政。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)。 |
| [臺灣健保署2001年中文版ICD-9-CM值集](ValueSet-icd-9-cm-2001-tw.md) | 臺灣健保署2001年中文版ICD-9-CM值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－臺灣健保署2001年中文版ICD-9-CM值集](https://fhir.mohw.gov.tw/ts/valuesetRead.jsp?id=icd-9-cm-2001-tw&status=active&version=2023-05-09&metaId=1&composeId=0&composeSystem=0&composeVersion=0&pageSet=preview)查閱 |
| [臺灣健保署2014年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2014-tw.md) | 臺灣健保署2014年中文版ICD-10-CM值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣健保署2014年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2014-tw.md) | 臺灣健保署2014年中文版ICD-10-PCS值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣健保署2021年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2021-tw.md) | 臺灣健保署2021年中文版ICD-10-CM值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣健保署2021年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2021-tw.md) | 臺灣健保署2021年中文版ICD-10-PCS值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣健保署2023年中文版ICD-10-CM值集](ValueSet-icd-10-cm-2023-tw.md) | 臺灣健保署2023年中文版ICD-10-CM值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣健保署2023年中文版ICD-10-PCS值集](ValueSet-icd-10-pcs-2023-tw.md) | 臺灣健保署2023年中文版ICD-10-PCS值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣健保署中藥用藥品項值集](ValueSet-nhi-medication-ch-herb-tw.md) | 臺灣健保署中藥用藥品項值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－臺灣健保署健保中藥用藥品項值集](https://fhir.mohw.gov.tw/ts/valuesetRead.jsp?id=medication-nhi-tw&status=active&version=2022-07-28&metaId=1&composeId=0&composeSystem=0&composeVersion=0&pageSet=preview)查閱 |
| [臺灣健保署就醫科別值集](ValueSet-medical-consultation-department-nhi-tw.md) | 臺灣健保署就醫科別值集。 |
| [臺灣健保署用藥品項代碼值集](ValueSet-medication-nhi-tw.md) | 臺灣健保署用藥品項代碼值集 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣健保署給藥途徑值集](ValueSet-medication-path-tw.md) | 臺灣健保署給藥途徑值集資料所屬單位：衛生福利部中央健康保險署。 |
| [臺灣健保署藥品使用頻率值集](ValueSet-medication-frequency-nhi-tw.md) | 臺灣健保署藥品使用頻率值集資料所屬單位：衛生福利部中央健康保險署。 |
| [臺灣健保署診療科別值集](ValueSet-medical-treatment-department-nhi-tw.md) | 臺灣健保署診療科別值集。 |
| [臺灣健保署醫療服務給付項目-檢驗值集](ValueSet-laboratory-category-tw.md) | 臺灣健保署醫療服務給付項目-檢驗值集。 資料所屬單位：衛生福利部中央健康保險署。 |
| [臺灣健保署醫療服務給付項目-處置或手術值集](ValueSet-procedure-tw.md) | 臺灣健保署醫療服務給付項目-處置或手術值集。 資料所屬單位：衛生福利部中央健康保險署。 |
| [臺灣勞動部職業標準分類值集](ValueSet-occupation-mol-tw.md) | 臺灣勞動部職業標準分類值集 |
| [臺灣壽險公會傷害保險個人職業分類表值集](ValueSet-occupation-lia-roc-tw.md) | 臺灣壽險公會傷害保險個人職業分類表值集 |
| [臺灣戶政司婚姻狀態值集](ValueSet-marital-status-tw.md) | 臺灣戶政司婚姻狀態值集。 資料所屬單位：衛生福利部醫事司。 |
| [臺灣核心-實驗室檢驗檢查值集](ValueSet-laboratory-code-tw.md) | 臺灣核心-實驗室檢驗檢查值集，包含LOINC與臺灣健保署醫療服務給付項目-檢驗代碼。 |
| [臺灣衛福部資訊處Narrative狀態值集](ValueSet-narrative-status.md) | 臺灣衛福部資訊處Narrative狀態值集 |
| [臺灣衛福部資訊處Observation Clinical Result類型值集](ValueSet-observation-clinical-result-category.md) | 臺灣衛福部資訊處Observation Clinical Result類型值集 |
| [臺灣衛福部資訊處Observation Screening Assessment類型值集](ValueSet-observation-screening-assessment-category.md) | 臺灣衛福部資訊處Observation Screening Assessment類型值集 |
| [臺灣衛福部資訊處ServiceRequest類型值集](ValueSet-serviceRequest-category.md) | 臺灣衛福部資訊處ServiceRequest類型值集 |
| [臺灣衛福部資訊處類型代碼值集](ValueSet-category-code-tw.md) | 臺灣衛福部資訊處類型代碼值集 |
| [臺灣醫事司醫事人員類別值集](ValueSet-health-professional-tw.md) | 臺灣醫事人員類別值集。 資料所屬單位：衛生福利部醫事司。 |
| [臺灣醫事司醫事機構代碼值集](ValueSet-organization-identifier-tw.md) | 臺灣醫事司醫事機構代碼值集。 資料所屬單位：衛生福利部中央健康保險署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣食藥署藥品及醫療器材代碼值集](ValueSet-medication-fda-tw.md) | 臺灣食藥署藥品及醫療器材代碼值集資料所屬單位：衛生福利部食品藥物管理署。此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 |
| [臺灣食藥署藥品藥理治療分類ATC碼值集](ValueSet-medcation-atc-tw.md) | 臺灣食藥署藥品藥理治療分類ATC碼值集。 資料提供單位：衛生福利部食品藥物管理署。 |
| [行政院主計總處行業分類值集](ValueSet-industry-dgbas-tw.md) | 行政院主計總處行業分類值集 |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [臺灣中華郵政3碼郵遞區號](CodeSystem-postal-code3-tw.md) | 臺灣中華郵政3碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的「臺灣地區郵遞區號前3碼一覽表 103/12(Excel版)」。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。代碼出版日期：2015-01-22；資料所屬單位：中華郵政。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣中華郵政5碼郵遞區號](CodeSystem-postal-code5-tw.md) | 臺灣中華郵政5碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的『3+3郵遞區號查詢應用系統』。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。代碼出版日期：2022-06-21；資料所屬單位：中華郵政。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣中華郵政6碼郵遞區號](CodeSystem-postal-code6-tw.md) | 臺灣中華郵政6碼郵遞區號，參照自[郵遞區號(含轉碼軟體)](https://www.post.gov.tw/post/internet/Download/index.jsp?ID=220306)中的『3+3郵遞區號查詢應用系統』。屬性命名以與國際的等級一致為主，未採用中華郵政提供之英文名稱。代碼出版日期：2020-10-22；資料所屬單位：中華郵政。**因原始資料無代碼版本資訊，故使用其公開授權聲明之「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱。 |
| [臺灣健保署2001年中文版ICD-9-CM](CodeSystem-icd-9-cm-2001-tw.md) | 臺灣健保署2001年中文版ICD-9-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。代碼出版日期：2023-05-09；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署2014年中文版ICD-10-CM](CodeSystem-icd-10-cm-2014-tw.md) | 臺灣健保署2014年中文版ICD-10-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。代碼出版日期：2022-07-19；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署2014年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2014-tw.md) | 臺灣健保署2014年中文版ICD-10-PCS，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。代碼出版日期：2017-07-19；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署2021年中文版ICD-10-CM](CodeSystem-icd-10-cm-2021-tw.md) | 臺灣健保署2021年中文版ICD-10-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。代碼出版日期：2022-07-29；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署2021年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2021-tw.md) | 臺灣健保署2021年中文版ICD-10-PCS，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。代碼出版日期：2022-07-29；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署2023年中文版ICD-10-CM](CodeSystem-icd-10-cm-2023-tw.md) | 臺灣健保署2023年中文版ICD-10-CM，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。代碼出版日期：2024-01-31；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署2023年中文版ICD-10-PCS](CodeSystem-icd-10-pcs-2023-tw.md) | 臺灣健保署2023年中文版ICD-10-PCS，參照至[國際疾病分類第 10 版](https://www.nhi.gov.tw/ch/np-3049-1.html)，由於資料會隨代碼更新而變動，本資料的來源位置可能已更新為最新版代碼，原資料已被覆蓋。代碼出版日期：2024-01-31；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署中藥用藥品項](CodeSystem-nhi-medication-ch-herb-tw.md) | 臺灣健保署中藥用藥品項，參照自[中藥用藥品項表](https://www.nhi.gov.tw/ch/cp-14300-03585-2467-1.html)中的「單方(113.06.01更新)」及「複方(113.04.01更新)」。 代碼出版日期：2024-05-31；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署就醫科別](CodeSystem-medical-consultation-department-nhi-tw.md) | 臺灣健保署就醫科別，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「就醫科別（2022/8/2版本）」。代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [臺灣健保署用藥品項](CodeSystem-medication-nhi-tw.md) | 臺灣健保署用藥品項代碼，參照自[健保用藥品項](https://www.nhi.gov.tw/ch/lp-2466-1.html)中的「健保用藥品項114年5月查詢檔(帶走所有壓縮檔114.4.30更新)」。代碼出版日期：2025-04-30；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處僅擷取部分代碼，完整代碼可至完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣健保署給藥途徑](CodeSystem-medication-path-tw.md) | 臺灣健保署給藥途徑，[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「給藥途徑/作用部位（2022/8/2版本）」。代碼出版日期：2024-06-04；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [臺灣健保署藥品使用頻率](CodeSystem-medication-frequency-nhi-tw.md) | 臺灣健保署藥品使用頻率，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「藥品使用頻率（2022/8/2版本）」。代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [臺灣健保署診療科別](CodeSystem-medical-treatment-department-nhi-tw.md) | 臺灣健保署診療科別，參照至[健保署檔案譯碼簿](https://www.nhi.gov.tw/ch/cp-1880-20811-3142-1.html)中的「診療科別（2022/8/2版本）」。代碼出版日期：2024-05-27；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [臺灣健保署醫療服務給付項目](CodeSystem-medical-service-payment-tw.md) | 臺灣健保署醫療服務給付項目，參照至[全民健康保險醫療服務給付項目及支付標準](https://www.nhi.gov.tw/ch/cp-5943-f1cce-2821-1.html)中的「醫療服務給付項目(113.05.01生效) (113.04.23更新)」。代碼出版日期：2022-07-01；資料所屬單位：衛生福利部中央健康保險署。**因原始資料無代碼版本資訊，故使用其「生效日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣勞動部職業標準分類](CodeSystem-occupation-mol-tw.md) | 臺灣勞動部職業標準分類，參照至[中華民國勞動部](https://www.mol.gov.tw/1607/2458/2510/)的[職業標準分類(第6次修訂)](https://statdb.mol.gov.tw/html/svy12/1236menu.htm)代碼出版日期：2010-05-01；資料所屬單位：中華民國勞動部。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [臺灣壽險公會傷害保險個人職業分類表](CodeSystem-occupation-lia-roc-tw.md) | 臺灣壽險公會傷害保險個人職業分類表，參照至[中華民國人壽保險商業同業公會](https://www.lia-roc.org.tw/)代碼出版日期：2023-06-01；資料所屬單位：中華民國人壽保險商業同業公會。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [臺灣戶政司婚姻狀態](CodeSystem-marital-status-tw.md) | 臺灣戶政司婚姻狀態，參照至[戶役政資訊系統資料代碼內容清單](https://www.ris.gov.tw/documents/html/5/1/168.html)中的「婚姻狀況代碼」。代碼出版日期：2019-05-22；資料所屬單位：內政部戶政司。代碼文字標示之施行法，係指司法院釋字第748號解釋施行法。**因原始資料無代碼版本資訊，故使用其法規「公布日期」作為版本資訊。** |
| [臺灣衛福部資訊處Provenance參與類型](CodeSystem-provenance-participant-type-tw.md) | 臺灣衛福部資訊處Provenance參與類型。 |
| [臺灣衛福部資訊處照護計畫類別](CodeSystem-careplan-category-tw.md) | 臺灣衛福部資訊處照護計畫類別 |
| [臺灣衛福部資訊處識別碼類型](CodeSystem-v2-0203.md) | 臺灣衛福部資訊處識別碼類型，代碼出版日期：2022-07-31；資料所屬單位：衛生福利部資訊處。 |
| [臺灣衛福部資訊處類型代碼](CodeSystem-category-code-tw.md) | 臺灣衛福部資訊處類型代碼， 代碼出版日期：2024-08-31；資料所屬單位：衛生福利部資訊處。 |
| [臺灣醫事司醫事人員類別](CodeSystem-health-professional-tw.md) | 臺灣醫事司醫事人員類別，參照至[醫事人員基本資料檔](https://www.google.com/url?client=internal-element-cse&cx=012254495936870409035:lzvyrg0mtim&q=https://www.mohw.gov.tw/dl-40452-1441ca2e-cde9-4345-b681-f9a20d5176b5.html&sa=U&ved=2ahUKEwjg5MCYrZn5AhUTI6YKHV6mC_s4FBAWegQIBBAC&usg=AOvVaw1q62t2W0hhdi0WC6e_nh1m)中的「人員類別（2022/01/28修訂）」。代碼出版日期：2022-01-28；資料所屬單位：衛生福利部醫事司。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [臺灣醫事司醫事機構代碼](CodeSystem-organization-identifier-tw.md) | 臺灣醫事司醫事機構代碼，參照至[衛生福利部醫事司](https://dep.mohw.gov.tw/DOMA/cp-4926-54415-106.html)的[醫療機構與人員基本資料20231231.csv](https://www.mohw.gov.tw/dl-87760-1a0f2eab-c96a-4839-950d-beb93d903b6f.html)[醫事機構代碼查詢系統](https://rao.mohw.gov.tw/AgencyCode.aspx?FD1=txtAgency_qry&FD2=txtAgencyName_qry)代碼出版日期：2020-06-11；資料所屬單位：衛生福利部醫事司。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣食藥署藥品藥理治療分類ATC碼](CodeSystem-medcation-atc-tw.md) | 臺灣食藥署藥品藥理治療分類ATC碼，參照至[藥品藥理治療分類ATC碼資料集](https://data.gov.tw/dataset/9119)，資料提供單位：衛生福利部食品藥物管理署。此代碼為WHO ATC(http://www.whocc.no/atc)中未涵蓋之代碼，為符合國內代碼使用，故將未被定義之代碼另外呈現。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |
| [臺灣食藥署藥品許可證](CodeSystem-medication-fda-tw.md) | 臺灣食藥署藥品許可證，參照自[https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=36](https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=36)代碼出版日期：2022-08-03-03；資料所屬單位：衛生福利部食品藥物管理署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱 |
| [臺灣食藥署醫療器材許可證](CodeSystem-medication-device-fda-tw.md) | 臺灣食藥署醫療器材許可證，參照自[https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=68](https://data.fda.gov.tw/frontsite/data/DataAction.do?method=doDetail&infoId=68)代碼出版日期：2022-08-08-08；資料所屬單位：衛生福利部食品藥物管理署。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。**因代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－臺灣食藥署醫療器材許可證](https://fhir.mohw.gov.tw/ts/codesystemRead.jsp?id=medication-device-fda-tw&status=active&version=2022-08-08-08&metaId=1&codeStatus=use&show=Y)查閱* 2024/7/8異動說明：2024-06-06版的臺灣食藥署醫療器材許可證代碼中新增、刪除、修改代碼量較大會使載入頁面時間較長，完整異動代碼說明請至[全國專門術語服務平臺－代碼系統(Code System)](https://fhir.mohw.gov.tw/ts/codesystem.jsp)查閱。
 |
| [行政院主計總處行業分類](CodeSystem-industry-dgbas-tw.md) | 行政院主計總處行業分類，參照至行政院主計總處的[行業統計分類(第11次修正)](https://ws.dgbas.gov.tw/001/Upload/463/attachment/11195/90015/012221854690wg0x9i.pdf)代碼出版日期：2021-01-01；資料所屬單位：行政院主計總處。**因原始資料無代碼版本資訊，故使用其「更新日期」作為版本資訊。** |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [臺灣健保署就醫科別代碼對應SNOMED CT](ConceptMap-medical-consultation-department-nhi-tw.md) | 此對應表為臺灣健保署就醫科別代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。 |
| [臺灣健保署給藥途徑代碼對應SNOMED CT](ConceptMap-medication-path-tw.md) | 此對應表為臺灣健保署給藥途徑代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。 |
| [臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation](ConceptMap-medication-frequency-tw.md) | 此對應表為臺灣健保署藥品使用頻率代碼對應對應HL7 TimingAbbreviation，供實作者於撰寫程式以自動化對應或轉代碼時使用。 |
| [臺灣健保署診療科別代碼對應SNOMED CT](ConceptMap-medical-treatment-department-nhi-tw.md) | 此對應表為臺灣健保署診療科別代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。 |
| [臺灣戶政司婚姻狀態代碼對應HL7 MaritalStatus](ConceptMap-marital-status-tw.md) | 此對應表為臺灣戶政司婚姻狀態代碼對應至國際標準碼HL7 MaritalStatus，供實作者於撰寫程式以自動化對應或轉代碼時使用。 |
| [臺灣醫事司醫事人員類別代碼對應SNOMED CT及臺灣醫事司醫事人員類別](ConceptMap-health-professional-tw.md) | 此對應表為臺灣醫事司醫事人員類別代碼對應至國際標準碼SNOMED CT，供實作者於撰寫程式以自動化對應或轉代碼時使用。 |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [Document](Bundle-bun-document-example.md) | 依據臺灣核心-資料交換基本單位-文件 (TW Core Bundle Document) Profile呈現資料交換基本單位 type=document之範例 |
| [Document(uuid)](Bundle-bun-document-uuid-example.md) | 依據臺灣核心-資料交換基本單位-文件 (TW Core Bundle Document) Profile呈現資料交換基本單位 type=document之範例 |
| [Message request(傳送)](Bundle-bun-message-request-example.md) | 依據臺灣核心-資料交換基本單位-訊息傳送(TW Core Bundle Message) Profile呈現資料交換基本單位 type=message request之範例 |
| [Message response(回應)](Bundle-bun-message-response-example.md) | 依據臺灣核心-資料交換基本單位-訊息傳送(TW Core Bundle Message) Profile呈現資料交換基本單位 type=message response之範例 |
| [Positron emission tomography](ImagingStudy-img-pet-example.md) | 依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現Positron emission tomography之範例 |
| [Slide Microscopy](ImagingStudy-img-sm-example.md) | 依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現Slide Microscopy之範例 |
| [Transaction](Bundle-bun-example.md) | 依據臺灣核心-資料交換基本單位(TW Core Bundle) Profile呈現資料交換基本單位 type=transaction之範例 |
| [健康狀態篩檢與評估](Observation-obs-screening-assessment-example.md) | 依據臺灣核心-健康狀態篩檢與評估(TW Core Observation Screening Assessment) Profile呈現健康狀態篩檢與評估之範例 |
| [公司行號基本資料](Organization-org-co-example.md) | 依據臺灣核心-公司行號(TW Core Organization Company) Profile呈現公司行號基本資料之範例 |
| [出處](Provenance-pov-example.md) | 依據臺灣核心-出處（TW Core Provenance）Profile呈現出處之範例 |
| [吸菸狀態](Observation-obs-smoking-status-example.md) | 依據臺灣核心-吸菸狀態（TW Core Smoking Status Observation）Profile呈現吸菸狀態之範例 |
| [問卷題目回覆](QuestionnaireResponse-qr-example.md) | 依據臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）Profile呈現問卷題目回覆之範例 |
| [堅果過敏或不耐症](AllergyIntolerance-all-nut-example.md) | 依據臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) Profile呈現堅果過敏之範例 |
| [妊娠狀態](Observation-obs-pregnancy-status-example.md) | 依據臺灣核心-妊娠狀態(TW Core Observation Pregnancy Status) Profile呈現妊娠狀態之範例 |
| [妊娠計畫](Observation-obs-pregnancy-intent-example.md) | 依據臺灣核心-妊娠計畫(TW Core Observation Pregnancy Intent) Profile呈現妊娠計畫之範例 |
| [子宮超音波](Procedure-pro-example.md) | 依據臺灣核心-處置或手術(TW Core Procedure) Profile呈現子宮超音波之範例 |
| [實驗室檢驗檢查-使用LOINC實驗室檢驗檢查代碼](Observation-obs-loinc-example.md) | 依據臺灣核心-檢驗檢查(TW Core Observation Laboratory Result) Profile呈現檢驗檢查之範例 |
| [實驗室檢驗檢查-使用臺灣醫療服務給付項目-檢驗值集代碼](Observation-obs-lab-example.md) | 依據臺灣核心-檢驗檢查(TW Core Observation Laboratory Result) Profile呈現檢驗檢查之範例 |
| [就醫資料](Encounter-enc-example.md) | 依據臺灣核心-就醫事件(TW Core Encounter) Profile呈現就醫之範例 |
| [尿液檢體](Specimen-spe-ur-example.md) | 依據臺灣核心-檢體(TW Core Specimen) Profile呈現尿液檢體之範例 |
| [平均血壓](Observation-obs-averageBloodPressure-example.md) | 依據臺灣核心-平均血壓(TW Core Observation Average Blood Pressure) Profile呈現平均血壓之範例 |
| [心電圖檢查](Observation-obs-ecg-example.md) | 依據臺灣核心-心電圖(TW Core Observation ECG) Profile呈現心電圖檢查之範例 |
| [性傾向](Observation-obs-sexual-orientation-example.md) | 依據臺灣核心-性傾向(TW Core Observation Sexual Orientation)呈現性傾向之範例 |
| [慢性結膜炎的用藥聲明資料](MedicationStatement-med-sta-inflamed-example.md) | 依據臺灣核心-用藥聲明(TW Core MedicationStatement) Profile呈現慢性結膜炎的用藥聲明資料之範例 |
| [手術摘要報告](Composition-com-surgery-example.md) | 依據臺灣核心-臨床文件架構(TW Core Composition) Profile呈現手術摘要報告之範例 |
| [政府機構基本資料](Organization-org-govt-example.md) | 依據臺灣核心-政府機構(TW Core Organization Government) Profile呈現政府機構基本資料之範例 |
| [明捷眼科診所地點資料](Location-loc-oph-example.md) | 依據臺灣核心-地點(TW Core Location) Profile呈現明捷眼科診所之範例 |
| [服務請求](ServiceRequest-sr-example.md) | 依據臺灣核心-服務請求（TW Core ServiceRequest）Profile呈服務請求之範例 |
| [植入式裝置](Device-dev-example.md) | 依據臺灣核心-植入式裝置(TW Core Simple Observation) Profile呈現植入式裝置之範例 |
| [機構基本資料](Organization-org-example.md) | 依據臺灣核心-機構(TW Core Organization) Profile呈現機構基本資料之範例 |
| [每瞳令-普益點眼液藥品配藥資料](MedicationDispense-med-dis-drop-example.md) | 依據臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) Profile呈現每瞳令-普益點眼液藥品配藥資料之範例 |
| [海鮮過敏或不耐症](AllergyIntolerance-all-seafood-example.md) | 依據臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) Profile呈現海鮮過敏之範例 |
| [照護團隊](CareTeam-careteam-example.md) | 依據臺灣核心-照護團隊（TW Core CareTeam）Profile呈現照護團隊之範例 |
| [照護計畫](CarePlan-careplan-example.md) | 依據臺灣核心-照護計畫（TW Core CarePlan）Profile呈現照護計畫之範例 |
| [爽胰達注射劑100單位+50微克藥品配藥資料](MedicationDispense-med-dis-injection-example.md) | 依據臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) Profile呈現爽胰達注射劑100單位+50微克藥品配藥資料之範例 |
| [生命體徵資料-兒童及青少年身體質量指數](Observation-obs-pediatric-bmi-age-example.md) | 依據臺灣核心-兒童及青少年身體質量指數(TW Core Pediatric BMI for Age Observation)呈現兒童及青少年身體質量指數之範例 |
| [生命體徵資料-兒童生長曲線](Observation-obs-pediatric-weight-height-example.md) | 依據臺灣核心-兒童生長曲線（TW Core Pediatric Weight for Height Observation）呈現兒童生長曲線之範例 |
| [生命體徵資料-心率](Observation-obs-heart-rate-example.md) | 依據臺灣核心-心率(TW Core Observation Heart Rate)呈現心率之範例 |
| [生命體徵資料-脈搏血氧飽和度](Observation-obs-pulse-oximetry-example.md) | 依據臺灣核心-脈搏血氧飽和度(TW Core Observation Pulse Oximetry)呈現脈搏血氧飽和度之範例 |
| [生命體徵資料-臺灣核心-兒童頭圍百分位數](Observation-obs-ofc-percentile-example.md) | 依據臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile）Profile呈現兒童頭圍百分位數之範例 |
| [生命體徵資料-臺灣核心-呼吸速率](Observation-obs-respiratory-rate-example.md) | 依據臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）Profile呈現呼吸速率之範例 |
| [生命體徵資料-血壓](Observation-obs-bloodPressure-example.md) | 依據臺灣核心-血壓(TW Core Observation Blood Pressure) Profile呈現血壓之範例 |
| [生命體徵資料-身體質量指數](Observation-obs-bmi-example.md) | 依據臺灣核心-身體質量指數(TW Core Observation BMI) Profile呈現身體質量指數之範例 |
| [生命體徵資料-身體質量指數](Observation-obs-vital.md) | 依據臺灣核心-生命體徵(TW Core Observation Vital Signs) Profile呈現身體質量指數之範例 |
| [生命體徵資料-身高](Observation-obs-height-example.md) | 依據臺灣核心-身高(TW Core Observation Body Height)呈現身高之範例 |
| [生命體徵資料-頭圍](Observation-obs-head-circumference-example.md) | 依據臺灣核心-頭圍(TW Core Observation Head Circumference)呈現頭圍之範例 |
| [生命體徵資料-體溫](Observation-obs-temperature-example.md) | 依據臺灣核心-體溫(TW Core Observation Body Temperature)呈現體溫之範例 |
| [生命體徵資料-體重](Observation-obs-weight-example.md) | 依據臺灣核心-體重(TW Core Observation Body Weight)呈現體重之範例 |
| [疫苗接種](Immunization-imm-example.md) | 依據臺灣核心-疫苗接種（TW Core Immunization）Profile呈現疫苗接種之範例 |
| [病人(兒童)基本資料-身分證字號及病歷號](Patient-pat-child-example.md) | 依據臺灣核心-病人(TW Core Patient) Profile呈現病人(兒童)基本資料之範例 |
| [病人基本資料-居留證號碼及病歷號](Patient-pat-residentNumber-example.md) | 依據臺灣核心-病人(TW Core Patient) Profile呈現病人基本資料之範例 |
| [病人基本資料-身分證字號及病歷號](Patient-pat-example.md) | 依據臺灣核心-病人(TW Core Patient) Profile呈現病人基本資料之範例 |
| [病人治療偏好註記](Observation-obs-treatment-intervention-preference-example.md) | 依據臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference）Profile呈現病人治療偏好註記之範例 |
| [病人照護偏好註記](Observation-obs-careExp-example.md) | 依據臺灣核心-病人照護偏好註記(TW Core Observation Care Experience Preference) Profile呈現病人照護偏好註記之範例 |
| [病情、問題或診斷資料](Condition-con-example.md) | 依據臺灣核心-病情、問題或診斷(TW Core Condition) Profile呈現病情、問題或診斷之範例 |
| [目標](Goal-goa-example.md) | 依據臺灣核心-目標（TW Core Goal）Profile呈現目標之範例 |
| [相關人士](RelatedPerson-rel-example.md) | 依據臺灣核心-相關人士(TW Core RelatedPerson)呈現相關人士之範例 |
| [第一型糖尿病的用藥聲明資料](MedicationStatement-med-sta-injection-example.md) | 依據臺灣核心-用藥聲明(TW Core MedicationStatement) Profile呈現第一型糖尿病的用藥聲明資料之範例 |
| [第二藥局地點資料](Location-loc-pharm-example.md) | 依據臺灣核心-地點(TW Core Location) Profile呈現第二藥局之範例 |
| [糞便檢體](Specimen-spe-stool-example.md) | 依據臺灣核心-檢體(TW Core Specimen) Profile呈現糞便檢體之範例 |
| [組織檢體](Specimen-spe-ance-example.md) | 依據臺灣核心-檢體(TW Core Specimen) Profile呈現組織檢體採集之範例 |
| [給付範圍](Coverage-coverage-example.md) | 依據臺灣核心-給付範圍（TW Core Coverage）Profile呈現給付範圍之範例 |
| [職業](Observation-obs-occupation-example.md) | 依據臺灣核心-職業(TW Core Simple Observation) Profile呈現職業之範例 |
| [胰臟炎的用藥聲明資料](MedicationStatement-med-sta-example.md) | 依據臺灣核心-用藥聲明(TW Core MedicationStatement) Profile呈現胰臟炎的用藥聲明資料之範例 |
| [胸椎電腦斷層掃描](ImagingStudy-img-ct-example.md) | 依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現胸椎電腦斷層掃描之範例 |
| [腦部MRI](Media-media-example.md) | 依據臺灣核心-多媒體(TW Core Media) Profile呈現多媒體之範例 |
| [腹部超音波](ImagingStudy-img-example.md) | 依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現腹部超音波之範例 |
| [臨床檢驗檢查](Observation-obs-clinical-result-example.md) | 依據臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result）Profile呈現臨床檢驗檢查之範例 |
| [藥品請求資料(medicationCodeableConcept)](MedicationRequest-med-req-cod-example.md) | 依據臺灣核心-藥品請求(TW Core MedicationRequest) Profile呈現藥品請求(medicationCodeableConcept)之範例 |
| [藥品請求資料(medicationReference)](MedicationRequest-med-req-ref-example.md) | 依據臺灣核心-藥品請求(TW Core MedicationRequest) Profile呈現藥品請求(medicationReference)之範例 |
| [藥品資料](Medication-med-example.md) | 依據臺灣核心-藥品(TW Core Medication) Profile呈現藥品之範例 |
| [藥師](Practitioner-pra-phc-example.md) | 依據臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile呈現藥師基本資料之範例 |
| [藥師](PractitionerRole-praro-phc-example.md) | 依據臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) Profile呈現藥師基本資料之範例 |
| [藥物過敏或不耐症](AllergyIntolerance-all-medication-example.md) | 依據臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) Profile呈現藥物過敏之範例 |
| [血液檢體](Specimen-spe-blood-example.md) | 依據臺灣核心-檢體(TW Core Specimen) Profile呈現血液檢體之範例 |
| [衛生福利部臺北醫院X光室地點資料](Location-loc-hrad-example.md) | 依據臺灣核心-地點(TW Core Location) Profile呈現衛生福利部臺北醫院X光室之範例 |
| [衛生福利部臺北醫院急診室地點資料](Location-loc-er-example.md) | 依據臺灣核心-地點(TW Core Location) Profile呈現衛生福利部臺北醫院急診室之範例 |
| [衛生福利部臺北醫院耳鼻喉科地點資料](Location-loc-ent-example.md) | 依據臺灣核心-地點(TW Core Location) Profile呈現衛生福利部臺北醫院耳鼻喉科之範例 |
| [訊息表頭－request (傳送)](MessageHeader-mes-request-example.md) | 依據臺灣核心-訊息表頭(TW Core MessageHeader) Profile呈現訊息表頭－request資料之範例 |
| [訊息表頭－response (回應)](MessageHeader-mes-response-example.md) | 依據臺灣核心-訊息表頭(TW Core MessageHeader) Profile呈現訊息表頭－response資料之範例 |
| [診斷報告資料](DiagnosticReport-dia-example.md) | 依據臺灣核心-診斷報告(TW Core DiagnosticReport) Profile呈現診斷報告之範例 |
| [護士](Practitioner-pra-nurse-example.md) | 依據臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile呈現護士基本資料之範例 |
| [護士](PractitionerRole-praro-nurse-example.md) | 依據臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) Profile呈現護士基本資料之範例 |
| [貓毛過敏或不耐症](AllergyIntolerance-all-cat-example.md) | 依據臺灣核心-過敏或不耐症(TW Core AllergyIntolerance) Profile呈現貓毛過敏之範例 |
| [近視的用藥聲明資料](MedicationStatement-med-sta-drop-example.md) | 依據臺灣核心-用藥聲明(TW Core MedicationStatement) Profile呈現近視的用藥聲明資料之範例 |
| [通用檢驗檢查](Observation-obs-simple-example.md) | 依據臺灣核心-通用檢驗檢查(TW Core Simple Observation) Profile呈現通用檢驗檢查之範例 |
| [醫事放射師](Practitioner-pra-radio-example.md) | 依據臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile呈現醫事放射師基本資料之範例 |
| [醫事放射師](PractitionerRole-praro-radio-example.md) | 依據臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) Profile呈現醫事放射師基本資料之範例 |
| [醫事機構基本資料](Organization-org-hosp-example.md) | 依據臺灣核心-醫事機構(TW Core Organization Hospital Department) Profile呈現醫事機構基本資料之範例 |
| [醫師](Practitioner-pra-dr-example.md) | 依據臺灣核心-健康照護服務提供者(TW Core Practitioner) Profile呈現醫師基本資料之範例 |
| [醫師](PractitionerRole-praro-dr-example.md) | 依據臺灣核心-健康照護服務提供者角色(TW Core PractitionerRole) Profile呈現醫師基本資料之範例 |
| [門診紀錄](DocumentReference-doc-outpatient-example.md) | 依據臺灣核心-文件參照(TW Core DocumentReference) Profile呈現門診紀錄之範例 |
| [闌尾切除](Procedure-pro-appendectomy-example.md) | 依據臺灣核心-處置或手術(TW Core Procedure) Profile呈現闌尾切除之範例 |
| [阿立批挫藥品配藥資料](MedicationDispense-med-dis-ref-example.md) | 依據臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) Profile呈現阿立批挫藥品配藥資料之範例 |
| [陳加玲的病摘](Composition-com-example.md) | 依據臺灣核心-臨床文件架構(TW Core Composition) Profile呈現陳加玲的病摘之範例 |
| [雙側乳房磁振造影](ImagingStudy-img-mr-example.md) | 依據臺灣核心-影像檢查(TW Core ImagingStudy) Profile呈現雙側乳房磁振造影之範例 |
| [驗傷報告](DocumentReference-doc-wound-example.md) | 依據臺灣核心-文件參照(TW Core DocumentReference) Profile呈現驗傷報告之範例 |
| [鹽酸四環素眼藥膏藥品配藥資料](MedicationDispense-med-dis-inflamed-example.md) | 依據臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) Profile呈現鹽酸四環素眼藥膏藥品配藥資料之範例 |

