# LOINC生命體徵值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: LOINC生命體徵值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/vital-signs-tw | *Version*:0.3.0 |
| Active as of 2022-08-31 | *Computable Name*:TWVitalSigns |

 
LOINC生命體徵值集。 

 **References** 

* [TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "vital-signs-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/vital-signs-tw",
  "version" : "0.3.0",
  "name" : "TWVitalSigns",
  "title" : "LOINC生命體徵值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-08-31",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "LOINC生命體徵值集。",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "39156-5"
          },
          {
            "code" : "85353-1"
          },
          {
            "code" : "9279-1"
          },
          {
            "code" : "8867-4"
          },
          {
            "code" : "2708-6"
          },
          {
            "code" : "8310-5"
          },
          {
            "code" : "8302-2"
          },
          {
            "code" : "9843-4"
          },
          {
            "code" : "29463-7"
          },
          {
            "code" : "85354-9"
          },
          {
            "code" : "8480-6"
          },
          {
            "code" : "8462-4"
          },
          {
            "code" : "8478-0"
          },
          {
            "code" : "59408-5",
            "display" : "Oxygen saturation in Arterial blood by Pulse oximetry"
          },
          {
            "code" : "8289-1",
            "display" : "Head Occipital-frontal circumference Percentile"
          },
          {
            "code" : "59576-9",
            "display" : "Body mass index (BMI) [Percentile] Per age and sex"
          },
          {
            "code" : "77606-2",
            "display" : "Weight-for-length Per age and sex"
          }
        ]
      }
    ]
  }
}

```
