# HL7 OrderableDrugForm藥品劑型值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: HL7 OrderableDrugForm藥品劑型值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/v3-orderableDrugForm | *Version*:2.1.0 |
| Active as of 2019-03-20 | *Computable Name*:OrderableDrugForm |
| **Copyright/Legal**: Health Level 7 | |

 
HL7 OrderableDrugForm藥品劑型值集。
資料所屬單位：Health Level 7 

 **References** 

* [TW Core Medication](StructureDefinition-Medication-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "v3-orderableDrugForm",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/v3-orderableDrugForm",
  "version" : "2.1.0",
  "name" : "OrderableDrugForm",
  "title" : "HL7 OrderableDrugForm藥品劑型值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2019-03-20",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "HL7 OrderableDrugForm藥品劑型值集。   \n資料所屬單位：Health Level 7",
  "copyright" : "Health Level 7",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/v3-orderableDrugForm"
      }
    ]
  }
}

```
