# 臺灣醫事司醫事機構代碼值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: 臺灣醫事司醫事機構代碼值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/organization-identifier-tw | *Version*:2024-04-10 |
| Active as of 2024-04-10 | *Computable Name*:TWOrganizationIdentifier |
| **Copyright/Legal**: 衛生福利部醫事司 | |

 
臺灣醫事司醫事機構代碼值集。 資料所屬單位：衛生福利部中央健康保險署。 
此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 

 **References** 

* [TW Core Organization Hospital Department](StructureDefinition-Organization-hosp-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "organization-identifier-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/organization-identifier-tw",
  "version" : "2024-04-10",
  "name" : "TWOrganizationIdentifier",
  "title" : "臺灣醫事司醫事機構代碼值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-04-10",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣醫事司醫事機構代碼值集。 \n資料所屬單位：衛生福利部中央健康保險署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱\n",
  "copyright" : "衛生福利部醫事司",
  "compose" : {
    "include" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/organization-identifier-tw"
      }
    ]
  }
}

```
