# RxNorm藥品代碼值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: RxNorm藥品代碼值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-rxnorm-tw | *Version*:3.0.0 |
| Active as of 2020-11-03 | *Computable Name*:TWMedicationRXNORM |
| **Copyright/Legal**: RxNorm. RxNorm is copyright Unified Medical Language System® (UMLS®). Terms & Conditions in https://uts.nlm.nih.gov/license.html https://www.nlm.nih.gov/research/umls/rxnorm/docs/termsofservice.html. | |

 
RxNorm藥品代碼值集
資料所屬單位：Unified Medical Language System® (UMLS®) 

 **References** 

* [TW Core Medication](StructureDefinition-Medication-twcore.md)
* [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)
* [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "medication-rxnorm-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-rxnorm-tw",
  "version" : "3.0.0",
  "name" : "TWMedicationRXNORM",
  "title" : "RxNorm藥品代碼值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2020-11-03",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "RxNorm藥品代碼值集   \n資料所屬單位：Unified Medical Language System® (UMLS®)",
  "copyright" : "RxNorm. RxNorm is copyright Unified Medical Language System® (UMLS®). Terms & Conditions in https://uts.nlm.nih.gov/license.html https://www.nlm.nih.gov/research/umls/rxnorm/docs/termsofservice.html.",
  "compose" : {
    "include" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "filter" : [
          {
            "property" : "TTY",
            "op" : "in",
            "value" : "SCD,SBD,GPCK,BPCK"
          }
        ]
      }
    ]
  }
}

```
