# SNOMED CT + 臺灣健保署給藥途徑值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: SNOMED CT + 臺灣健保署給藥途徑值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-path-sct-tw | *Version*:0.3.0 |
| Active as of 2024-01-16 | *Computable Name*:TWMedicationPathSCT |
| **Copyright/Legal**: 衛生福利部 | |

 
SNOMED CT + 臺灣健保署給藥途徑值集。 
此值集優先採用國際標準碼，國際標準碼未能表述之概念，則以普遍被使用的臺灣健保署給藥途徑代碼表述，請實作者留意。 

 **References** 

* [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)
* [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* [TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "medication-path-sct-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-path-sct-tw",
  "version" : "0.3.0",
  "name" : "TWMedicationPathSCT",
  "title" : "SNOMED CT + 臺灣健保署給藥途徑值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-01-16",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "SNOMED CT + 臺灣健保署給藥途徑值集。\n\n此值集優先採用國際標準碼，國際標準碼未能表述之概念，則以普遍被使用的臺灣健保署給藥途徑代碼表述，請實作者留意。",
  "copyright" : "衛生福利部",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "filter" : [
          {
            "property" : "concept",
            "op" : "is-a",
            "value" : "284009009"
          }
        ]
      },
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "10547007"
          },
          {
            "code" : "1611000175109"
          },
          {
            "code" : "58100008"
          },
          {
            "code" : "372464004"
          },
          {
            "code" : "78421000"
          },
          {
            "code" : "47625008"
          },
          {
            "code" : "418401004"
          },
          {
            "code" : "46713006"
          },
          {
            "code" : "54485002"
          },
          {
            "code" : "26643006"
          },
          {
            "code" : "34206005"
          },
          {
            "code" : "416174007"
          },
          {
            "code" : "448598008"
          },
          {
            "code" : "37839007"
          },
          {
            "code" : "37161004"
          },
          {
            "code" : "6064005"
          },
          {
            "code" : "16857009"
          }
        ]
      },
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medication-path-tw",
        "concept" : [
          {
            "code" : "ET",
            "display" : "氣內切"
          },
          {
            "code" : "GAR",
            "display" : "潄口用"
          },
          {
            "code" : "IE",
            "display" : "脊髓硬膜內治射"
          },
          {
            "code" : "IMP",
            "display" : "植入"
          },
          {
            "code" : "INHL",
            "display" : "吸入"
          },
          {
            "code" : "IS",
            "display" : "滑膜內注射"
          },
          {
            "code" : "IT",
            "display" : "椎骨內注射"
          },
          {
            "code" : "LA",
            "display" : "局部麻醉"
          },
          {
            "code" : "LI",
            "display" : "局部注射"
          },
          {
            "code" : "SPI",
            "display" : "脊髓"
          },
          {
            "code" : "TPN",
            "display" : "全靜脈營養劑"
          },
          {
            "code" : "IRRIG",
            "display" : "沖洗(irrigation)"
          },
          {
            "code" : "PO",
            "display" : "口服"
          }
        ]
      }
    ]
  }
}

```
