# 對應至 SNOMED CT之就醫科別 + 診療科別值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: 對應至 SNOMED CT之就醫科別 + 診療科別值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-department-sct-tw | *Version*:0.3.0 |
| Active as of 2024-05-27 | *Computable Name*:TWMedicalDepartmentSCT |

 
因就醫科別與診療科別對應到之國際標準碼 SNOMED CT有共通代碼，因此本值集將兩者的對應代碼整合於同一值集中。 
另為便於使用者更清晰地辨識「[就醫科別](ValueSet-medical-department-sct-tw.md#就醫科別對應表)」及「[診療科別](ValueSet-medical-department-sct-tw.md#診療科別對應表)」的各別完整值集範圍，請參閱以下兩個表格，代碼使用原則為：若想表達的語意有國際代碼可表述，便採用國際代碼；若無對應的國際代碼可表述，則採用健保署編訂的代碼。 

 **References** 

* [TW Core Encounter](StructureDefinition-Encounter-twcore.md)
* [TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md)

### 就醫科別對應表

* 原健保署就醫科別: 00
  * 診療科別: 不分科
  * 上傳之code: 00
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: 01
  * 診療科別: 家醫科
  * 上傳之code: 419772000
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 02
  * 診療科別: 內科
  * 上傳之code: 419192003
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 03
  * 診療科別: 外科
  * 上傳之code: 394609007
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 04
  * 診療科別: 兒科
  * 上傳之code: 24251000087109
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 05
  * 診療科別: 婦產科
  * 上傳之code: 394585009
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 06
  * 診療科別: 骨科
  * 上傳之code: 24241000087106
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 07
  * 診療科別: 神經外科
  * 上傳之code: 394610002
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 08
  * 診療科別: 泌尿科
  * 上傳之code: 394612005
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 09
  * 診療科別: 耳鼻喉科
  * 上傳之code: 418960008
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 10
  * 診療科別: 眼科
  * 上傳之code: 394594003
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 11
  * 診療科別: 皮膚科
  * 上傳之code: 394582007
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 12
  * 診療科別: 神經科
  * 上傳之code: 394591006
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 13
  * 診療科別: 精神科
  * 上傳之code: 394587001
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 14
  * 診療科別: 復健科
  * 上傳之code: 394602003
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 15
  * 診療科別: 整形外科
  * 上傳之code: 394611003
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 22
  * 診療科別: 急診醫學科
  * 上傳之code: 773568002
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 23
  * 診療科別: 職業醫學科
  * 上傳之code: 394821009
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 2A
  * 診療科別: 結核科
  * 上傳之code: 2A
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: 2B
  * 診療科別: 洗腎科
  * 上傳之code: 2B
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: 40
  * 診療科別: 牙科
  * 上傳之code: 722163006
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 60
  * 診療科別: 中醫科
  * 上傳之code: 60
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: 81
  * 診療科別: 麻醉科
  * 上傳之code: 394577000
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 82
  * 診療科別: 放射線科
  * 上傳之code: 394914008
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 83
  * 診療科別: 病理科
  * 上傳之code: 394915009
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: 84
  * 診療科別: 核醫科
  * 上傳之code: 394649004
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: AA
  * 診療科別: 消化內科
  * 上傳之code: 394584008
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: AB
  * 診療科別: 心臟血管內科
  * 上傳之code: 394579002
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: AC
  * 診療科別: 胸腔內科
  * 上傳之code: AC
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: AD
  * 診療科別: 腎臟內科
  * 上傳之code: 394589003
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: AE
  * 診療科別: 風濕免疫科
  * 上傳之code: 394810000
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: AF
  * 診療科別: 血液腫瘤科
  * 上傳之code: AF
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: AG
  * 診療科別: 內分泌科
  * 上傳之code: 394583002
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: AH
  * 診療科別: 感染科
  * 上傳之code: 394807007
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: AI
  * 診療科別: 潛醫科
  * 上傳之code: 410005002
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: AJ
  * 診療科別: 胸腔暨重症加護
  * 上傳之code: AJ
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: AK
  * 診療科別: 老人醫學科
  * 上傳之code: 394811001
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: BA
  * 診療科別: 直腸外科
  * 上傳之code: 408464004
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: BB
  * 診療科別: 心臟血管外科
  * 上傳之code: 408466002
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: BC
  * 診療科別: 胸腔外科
  * 上傳之code: 408456005
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: BD
  * 診療科別: 消化外科
  * 上傳之code: 1284928005
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: CA
  * 診療科別: 小兒外科
  * 上傳之code: 394539006
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: CB
  * 診療科別: 新生兒科
  * 上傳之code: 408445005
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: DA
  * 診療科別: 疼痛科
  * 上傳之code: 394882004
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: EA
  * 診療科別: 居家照護
  * 上傳之code: EA
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: FA
  * 診療科別: 放射診斷科
  * 上傳之code: FA
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: FB
  * 診療科別: 放射腫瘤科
  * 上傳之code: 419815003
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: GA
  * 診療科別: 口腔顏面外科
  * 上傳之code: 408465003
  * 上傳之system: http://snomed.info/sct
* 原健保署就醫科別: HA
  * 診療科別: 脊椎骨科
  * 上傳之code: HA
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw
* 原健保署就醫科別: TB
  * 診療科別: 肺結核
  * 上傳之code: TB
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-consultation-department-nhi-tw

### 診療科別對應表

* 原健保署診療科別: 00
  * 診療科別: 不分科
  * 上傳之code: 00
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 01
  * 診療科別: 家醫科
  * 上傳之code: 419772000
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 02
  * 診療科別: 內科
  * 上傳之code: 419192003
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 03
  * 診療科別: 外科
  * 上傳之code: 394609007
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 04
  * 診療科別: 兒科
  * 上傳之code: 24251000087109
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 05
  * 診療科別: 婦產科
  * 上傳之code: 394585009
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 06
  * 診療科別: 骨科
  * 上傳之code: 24241000087106
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 07
  * 診療科別: 神經外科
  * 上傳之code: 394610002
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 08
  * 診療科別: 泌尿科
  * 上傳之code: 394612005
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 09
  * 診療科別: 耳鼻喉科
  * 上傳之code: 418960008
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 10
  * 診療科別: 眼科
  * 上傳之code: 394594003
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 11
  * 診療科別: 皮膚科
  * 上傳之code: 394582007
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 12
  * 診療科別: 神經科
  * 上傳之code: 394591006
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 13
  * 診療科別: 精神科
  * 上傳之code: 394587001
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 14
  * 診療科別: 復健科
  * 上傳之code: 394602003
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 15
  * 診療科別: 整形外科
  * 上傳之code: 394611003
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 16
  * 診療科別: 職業醫學科
  * 上傳之code: 394821009
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 22
  * 診療科別: 急診醫學科
  * 上傳之code: 773568002
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 2A
  * 診療科別: 結核科
  * 上傳之code: 2A
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 2B
  * 診療科別: 洗腎科
  * 上傳之code: 2B
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 40
  * 診療科別: 牙科
  * 上傳之code: 722163006
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 41
  * 診療科別: 牙體復形科
  * 上傳之code: 41
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 42
  * 診療科別: 牙髓病科
  * 上傳之code: 408441001
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 43
  * 診療科別: 牙周病科
  * 上傳之code: 408461007
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 44
  * 診療科別: 贋復補綴牙科
  * 上傳之code: 44
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 45
  * 診療科別: 齒顎矯正科
  * 上傳之code: 394608004
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 46
  * 診療科別: 兒童牙科
  * 上傳之code: 394607009
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 47
  * 診療科別: 口腔顎面外科
  * 上傳之code: 408465003
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 48
  * 診療科別: 口腔診斷科
  * 上傳之code: 48
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 49
  * 診療科別: 口腔病理科
  * 上傳之code: 49
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 50
  * 診療科別: 家庭牙醫科
  * 上傳之code: 50
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 51
  * 診療科別: 特殊需求者口腔醫學科
  * 上傳之code: 51
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 60
  * 診療科別: 中醫一般科
  * 上傳之code: 60
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 81
  * 診療科別: 麻醉科
  * 上傳之code: 394577000
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 82
  * 診療科別: 放射線科
  * 上傳之code: 394914008
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 83
  * 診療科別: 病理科
  * 上傳之code: 394915009
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 84
  * 診療科別: 核子醫學科
  * 上傳之code: 394649004
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 85
  * 診療科別: 放射腫瘤科
  * 上傳之code: 419815003
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 86
  * 診療科別: 放射診斷科
  * 上傳之code: 86
  * 上傳之system: https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-treatment-department-nhi-tw
* 原健保署診療科別: 87
  * 診療科別: 解剖病理科
  * 上傳之code: 1255732006
  * 上傳之system: http://snomed.info/sct
* 原健保署診療科別: 88
  * 診療科別: 臨床病理科
  * 上傳之code: 1255736009
  * 上傳之system: http://snomed.info/sct

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "medical-department-sct-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medical-department-sct-tw",
  "version" : "0.3.0",
  "name" : "TWMedicalDepartmentSCT",
  "title" : "對應至 SNOMED CT之就醫科別 + 診療科別值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-05-27",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "因就醫科別與診療科別對應到之國際標準碼 SNOMED CT有共通代碼，因此本值集將兩者的對應代碼整合於同一值集中。  \n\n另為便於使用者更清晰地辨識「[就醫科別](ValueSet-medical-department-sct-tw.html#就醫科別對應表)」及「[診療科別](ValueSet-medical-department-sct-tw.html#診療科別對應表)」的各別完整值集範圍，請參閱以下兩個表格，代碼使用原則為：若想表達的語意有國際代碼可表述，便採用國際代碼；若無對應的國際代碼可表述，則採用健保署編訂的代碼。\n\n",
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "419772000"
          },
          {
            "code" : "419192003"
          },
          {
            "code" : "394609007"
          },
          {
            "code" : "24251000087109"
          },
          {
            "code" : "394585009"
          },
          {
            "code" : "24241000087106"
          },
          {
            "code" : "394610002"
          },
          {
            "code" : "394612005"
          },
          {
            "code" : "418960008"
          },
          {
            "code" : "394594003"
          },
          {
            "code" : "394582007"
          },
          {
            "code" : "394591006"
          },
          {
            "code" : "394587001"
          },
          {
            "code" : "394602003"
          },
          {
            "code" : "394611003"
          },
          {
            "code" : "773568002"
          },
          {
            "code" : "394821009"
          },
          {
            "code" : "394589003"
          },
          {
            "code" : "722163006"
          },
          {
            "code" : "394577000"
          },
          {
            "code" : "394914008"
          },
          {
            "code" : "394915009"
          },
          {
            "code" : "394649004"
          },
          {
            "code" : "394584008"
          },
          {
            "code" : "394579002"
          },
          {
            "code" : "394810000"
          },
          {
            "code" : "23981000087108"
          },
          {
            "code" : "394583002"
          },
          {
            "code" : "394807007"
          },
          {
            "code" : "410005002"
          },
          {
            "code" : "394811001"
          },
          {
            "code" : "408464004"
          },
          {
            "code" : "408466002"
          },
          {
            "code" : "408456005"
          },
          {
            "code" : "1284928005"
          },
          {
            "code" : "394539006"
          },
          {
            "code" : "408445005"
          },
          {
            "code" : "394882004"
          },
          {
            "code" : "419815003"
          },
          {
            "code" : "408465003"
          },
          {
            "code" : "408441001"
          },
          {
            "code" : "408461007"
          },
          {
            "code" : "394608004"
          },
          {
            "code" : "394607009"
          },
          {
            "code" : "1255732006"
          },
          {
            "code" : "1255736009"
          }
        ]
      }
    ]
  }
}

```
