# LOINC Document Class值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: LOINC Document Class值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-document-classcodes | *Version*:2.81 |
| Active as of 2025-12-01 | *Computable Name*:LOINCDocumentClass |
| **Copyright/Legal**: This content LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use | |

 
LOINC Document Class值集。 代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。 

 **References** 

* [TW Core Composition](StructureDefinition-Composition-twcore.md)
* [TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "loinc-document-classcodes",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-document-classcodes",
  "version" : "2.81",
  "name" : "LOINCDocumentClass",
  "title" : "LOINC Document Class值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-01",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "LOINC Document Class值集。\n代碼版本：2.81；代碼更新日期：2025-12-01；資料所屬單位：Regenstrief Institute。",
  "copyright" : "This content LOINC® is copyright © 1995 Regenstrief Institute, Inc. and the LOINC Committee, and available at no cost under the license at http://loinc.org/terms-of-use",
  "compose" : {
    "include" : [
      {
        "system" : "http://loinc.org",
        "concept" : [
          {
            "code" : "11369-6",
            "display" : "History of Immunization"
          },
          {
            "code" : "11485-0",
            "display" : "Anesthesia records"
          },
          {
            "code" : "11486-8",
            "display" : "Chemotherapy records"
          },
          {
            "code" : "11488-4",
            "display" : "Consult Note"
          },
          {
            "code" : "11506-3",
            "display" : "Provider-unspecified progress note"
          },
          {
            "code" : "11543-6",
            "display" : "Nursery records"
          },
          {
            "code" : "15508-5",
            "display" : "Labor and delivery records"
          },
          {
            "code" : "18726-0",
            "display" : "Radiology studies (set)"
          },
          {
            "code" : "18761-7",
            "display" : "Provider-unspecified transfer summary"
          },
          {
            "code" : "18842-5",
            "display" : "Discharge summary"
          },
          {
            "code" : "26436-6",
            "display" : "Laboratory Studies (set)"
          },
          {
            "code" : "26441-6",
            "display" : "Cardiology studies (set)"
          },
          {
            "code" : "26442-4",
            "display" : "Obstetrical studies (set)"
          },
          {
            "code" : "27895-2",
            "display" : "Gastroenterology endoscopy studies (set)"
          },
          {
            "code" : "27896-0",
            "display" : "Pulmonary studies (set)"
          },
          {
            "code" : "27897-8",
            "display" : "Neuromuscular electrophysiology studies (set)"
          },
          {
            "code" : "27898-6",
            "display" : "Pathology studies (set)"
          },
          {
            "code" : "28570-0",
            "display" : "Provider-unspecified procedure note"
          },
          {
            "code" : "28619-5",
            "display" : "Ophthalmology/optometry studies (set)"
          },
          {
            "code" : "28634-4",
            "display" : "Miscellaneous studies (set)"
          },
          {
            "code" : "29749-9",
            "display" : "Dialysis records"
          },
          {
            "code" : "29750-7",
            "display" : "Neonatal intensive care records"
          },
          {
            "code" : "29751-5",
            "display" : "Critical care records"
          },
          {
            "code" : "29752-3",
            "display" : "Perioperative records"
          },
          {
            "code" : "34109-9",
            "display" : "Evaluation and management note"
          },
          {
            "code" : "34117-2",
            "display" : "Provider-unspecified, History and physical note"
          },
          {
            "code" : "34121-4",
            "display" : "Interventional procedure note"
          },
          {
            "code" : "34122-2",
            "display" : "Pathology procedure note"
          },
          {
            "code" : "34133-9",
            "display" : "Summarization of episode note"
          },
          {
            "code" : "34140-4",
            "display" : "Transfer of care referral note"
          },
          {
            "code" : "34748-4",
            "display" : "Telephone encounter note"
          },
          {
            "code" : "34775-7",
            "display" : "General surgery Pre-operative evaluation and management note"
          },
          {
            "code" : "47039-3",
            "display" : "Inpatient Admission history and physical note"
          },
          {
            "code" : "47042-7",
            "display" : "Counseling note"
          },
          {
            "code" : "47045-0",
            "display" : "Study report Document"
          },
          {
            "code" : "47046-8",
            "display" : "Summary of death"
          },
          {
            "code" : "47049-2",
            "display" : "Non-patient Communication"
          },
          {
            "code" : "57017-6",
            "display" : "Privacy Policy Organization Document"
          },
          {
            "code" : "57016-8",
            "display" : "Privacy Policy Acknowledgment Document"
          },
          {
            "code" : "56445-0",
            "display" : "Medication Summary Document"
          },
          {
            "code" : "53576-5",
            "display" : "Personal health monitoring report Document"
          },
          {
            "code" : "56447-6",
            "display" : "Plan of care note"
          },
          {
            "code" : "18748-4",
            "display" : "Diagnostic imaging study"
          },
          {
            "code" : "11504-8",
            "display" : "Surgical operation note"
          },
          {
            "code" : "57133-1",
            "display" : "Referral note"
          }
        ]
      }
    ]
  }
}

```
