# 臺灣健保署醫療服務給付項目-檢驗值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: 臺灣健保署醫療服務給付項目-檢驗值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/laboratory-category-tw | *Version*:2022-07-01 |
| Active as of 2022-07-01 | *Computable Name*:TWLaboratoryCategory |

 
臺灣健保署醫療服務給付項目-檢驗值集。 資料所屬單位：衛生福利部中央健康保險署。 

 **References** 

* Included into [TWLaboratoryCode](ValueSet-laboratory-code-tw.md)
* [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "laboratory-category-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/laboratory-category-tw",
  "version" : "2022-07-01",
  "name" : "TWLaboratoryCategory",
  "title" : "臺灣健保署醫療服務給付項目-檢驗值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-07-01",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署醫療服務給付項目-檢驗值集。\n資料所屬單位：衛生福利部中央健康保險署。\n",
  "compose" : {
    "include" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/medical-service-payment-tw",
        "concept" : [
          {
            "code" : "01076B"
          },
          {
            "code" : "01077B"
          },
          {
            "code" : "01078B"
          },
          {
            "code" : "06001C"
          },
          {
            "code" : "06002C"
          },
          {
            "code" : "06003C"
          },
          {
            "code" : "06004C"
          },
          {
            "code" : "06005C"
          },
          {
            "code" : "06006C"
          },
          {
            "code" : "06007C"
          },
          {
            "code" : "06008C"
          },
          {
            "code" : "06009C"
          },
          {
            "code" : "06010C"
          },
          {
            "code" : "06011B"
          },
          {
            "code" : "06012C"
          },
          {
            "code" : "06013C"
          },
          {
            "code" : "06014B"
          },
          {
            "code" : "06015C"
          },
          {
            "code" : "06016B"
          },
          {
            "code" : "06017B"
          },
          {
            "code" : "06503B"
          },
          {
            "code" : "06504C"
          },
          {
            "code" : "06505C"
          },
          {
            "code" : "06508B"
          },
          {
            "code" : "06509B"
          },
          {
            "code" : "06510C"
          },
          {
            "code" : "06511C"
          },
          {
            "code" : "06512B"
          },
          {
            "code" : "06513B"
          },
          {
            "code" : "07001C"
          },
          {
            "code" : "07002C"
          },
          {
            "code" : "07003C"
          },
          {
            "code" : "07004C"
          },
          {
            "code" : "07005C"
          },
          {
            "code" : "07006C"
          },
          {
            "code" : "07007C"
          },
          {
            "code" : "07008C"
          },
          {
            "code" : "07009C"
          },
          {
            "code" : "07010B"
          },
          {
            "code" : "07011C"
          },
          {
            "code" : "07012C"
          },
          {
            "code" : "07013C"
          },
          {
            "code" : "07015C"
          },
          {
            "code" : "07016C"
          },
          {
            "code" : "07017B"
          },
          {
            "code" : "07018C"
          },
          {
            "code" : "08001C"
          },
          {
            "code" : "08002C"
          },
          {
            "code" : "08003C"
          },
          {
            "code" : "08004C"
          },
          {
            "code" : "08005C"
          },
          {
            "code" : "08006C"
          },
          {
            "code" : "08007C"
          },
          {
            "code" : "08008C"
          },
          {
            "code" : "08009C"
          },
          {
            "code" : "08010C"
          },
          {
            "code" : "08011C"
          },
          {
            "code" : "08012C"
          },
          {
            "code" : "08013C"
          },
          {
            "code" : "08014C"
          },
          {
            "code" : "08015C"
          },
          {
            "code" : "08016C"
          },
          {
            "code" : "08017B"
          },
          {
            "code" : "08018C"
          },
          {
            "code" : "08019C"
          },
          {
            "code" : "08020C"
          },
          {
            "code" : "08021C"
          },
          {
            "code" : "08022B"
          },
          {
            "code" : "08023B"
          },
          {
            "code" : "08024B"
          },
          {
            "code" : "08025B"
          },
          {
            "code" : "08026C"
          },
          {
            "code" : "08027B"
          },
          {
            "code" : "08028B"
          },
          {
            "code" : "08029B"
          },
          {
            "code" : "08030C"
          },
          {
            "code" : "08031B"
          },
          {
            "code" : "08032B"
          },
          {
            "code" : "08033B"
          },
          {
            "code" : "08034B"
          },
          {
            "code" : "08035C"
          },
          {
            "code" : "08036C"
          },
          {
            "code" : "08037B"
          },
          {
            "code" : "08038B"
          },
          {
            "code" : "08039B"
          },
          {
            "code" : "08040B"
          },
          {
            "code" : "08041B"
          },
          {
            "code" : "08042C"
          },
          {
            "code" : "08043C"
          },
          {
            "code" : "08044B"
          },
          {
            "code" : "08045B"
          },
          {
            "code" : "08046B"
          },
          {
            "code" : "08047B"
          },
          {
            "code" : "08048B"
          },
          {
            "code" : "08049B"
          },
          {
            "code" : "08050B"
          },
          {
            "code" : "08051B"
          },
          {
            "code" : "08052B"
          },
          {
            "code" : "08053B"
          },
          {
            "code" : "08054B"
          },
          {
            "code" : "08055B"
          },
          {
            "code" : "08056B"
          },
          {
            "code" : "08057B"
          },
          {
            "code" : "08058B"
          },
          {
            "code" : "08059B"
          },
          {
            "code" : "08060B"
          },
          {
            "code" : "08061B"
          },
          {
            "code" : "08062B"
          },
          {
            "code" : "08063B"
          },
          {
            "code" : "08064B"
          },
          {
            "code" : "08065B"
          },
          {
            "code" : "08066B"
          },
          {
            "code" : "08067B"
          },
          {
            "code" : "08068B"
          },
          {
            "code" : "08069B"
          },
          {
            "code" : "08070B"
          },
          {
            "code" : "08071B"
          },
          {
            "code" : "08072B"
          },
          {
            "code" : "08073B"
          },
          {
            "code" : "08074B"
          },
          {
            "code" : "08075C"
          },
          {
            "code" : "08076B"
          },
          {
            "code" : "08077B"
          },
          {
            "code" : "08078B"
          },
          {
            "code" : "08079B"
          },
          {
            "code" : "08080B"
          },
          {
            "code" : "08081B"
          },
          {
            "code" : "08082C"
          },
          {
            "code" : "08083C"
          },
          {
            "code" : "08084C"
          },
          {
            "code" : "08085B"
          },
          {
            "code" : "08086B"
          },
          {
            "code" : "08087B"
          },
          {
            "code" : "08088B"
          },
          {
            "code" : "08089B"
          },
          {
            "code" : "08090B"
          },
          {
            "code" : "08091B"
          },
          {
            "code" : "08092B"
          },
          {
            "code" : "08093B"
          },
          {
            "code" : "08094B"
          },
          {
            "code" : "08095B"
          },
          {
            "code" : "08096B"
          },
          {
            "code" : "08097B"
          },
          {
            "code" : "08098B"
          },
          {
            "code" : "08099B"
          },
          {
            "code" : "08100B"
          },
          {
            "code" : "08101B"
          },
          {
            "code" : "08102B"
          },
          {
            "code" : "08103B"
          },
          {
            "code" : "08104B"
          },
          {
            "code" : "08105B"
          },
          {
            "code" : "08106B"
          },
          {
            "code" : "08107B"
          },
          {
            "code" : "08109B"
          },
          {
            "code" : "08111B"
          },
          {
            "code" : "08112B"
          },
          {
            "code" : "08113B"
          },
          {
            "code" : "08114B"
          },
          {
            "code" : "08115B"
          },
          {
            "code" : "08116B"
          },
          {
            "code" : "08117B"
          },
          {
            "code" : "08118B"
          },
          {
            "code" : "08119B"
          },
          {
            "code" : "08120B"
          },
          {
            "code" : "08122B"
          },
          {
            "code" : "08123B"
          },
          {
            "code" : "08124B"
          },
          {
            "code" : "08125B"
          },
          {
            "code" : "08126B"
          },
          {
            "code" : "08127C"
          },
          {
            "code" : "08128B"
          },
          {
            "code" : "08129C"
          },
          {
            "code" : "08130C"
          },
          {
            "code" : "08131C"
          },
          {
            "code" : "08132C"
          },
          {
            "code" : "08133B"
          },
          {
            "code" : "08134B"
          },
          {
            "code" : "09001C"
          },
          {
            "code" : "09002C"
          },
          {
            "code" : "09003C"
          },
          {
            "code" : "09004C"
          },
          {
            "code" : "09005C"
          },
          {
            "code" : "09006C"
          },
          {
            "code" : "09008B"
          },
          {
            "code" : "09009C"
          },
          {
            "code" : "09010C"
          },
          {
            "code" : "09011C"
          },
          {
            "code" : "09012C"
          },
          {
            "code" : "09013C"
          },
          {
            "code" : "09014C"
          },
          {
            "code" : "09015C"
          },
          {
            "code" : "09016C"
          },
          {
            "code" : "09017C"
          },
          {
            "code" : "09018B"
          },
          {
            "code" : "09019B"
          },
          {
            "code" : "09020C"
          },
          {
            "code" : "09021C"
          },
          {
            "code" : "09022C"
          },
          {
            "code" : "09023C"
          },
          {
            "code" : "09024C"
          },
          {
            "code" : "09025C"
          },
          {
            "code" : "09026C"
          },
          {
            "code" : "09027C"
          },
          {
            "code" : "09028C"
          },
          {
            "code" : "09029C"
          },
          {
            "code" : "09030C"
          },
          {
            "code" : "09031C"
          },
          {
            "code" : "09032C"
          },
          {
            "code" : "09033C"
          },
          {
            "code" : "09034B"
          },
          {
            "code" : "09035C"
          },
          {
            "code" : "09036B"
          },
          {
            "code" : "09037C"
          },
          {
            "code" : "09038C"
          },
          {
            "code" : "09039C"
          },
          {
            "code" : "09040C"
          },
          {
            "code" : "09041B"
          },
          {
            "code" : "09042C"
          },
          {
            "code" : "09043C"
          },
          {
            "code" : "09044C"
          },
          {
            "code" : "09046B"
          },
          {
            "code" : "09047B"
          },
          {
            "code" : "09048B"
          },
          {
            "code" : "09049B"
          },
          {
            "code" : "09050B"
          },
          {
            "code" : "09051C"
          },
          {
            "code" : "09052B"
          },
          {
            "code" : "09053B"
          },
          {
            "code" : "09054B"
          },
          {
            "code" : "09055B"
          },
          {
            "code" : "09056B"
          },
          {
            "code" : "09057B"
          },
          {
            "code" : "09058B"
          },
          {
            "code" : "09059B"
          },
          {
            "code" : "09060B"
          },
          {
            "code" : "09061B"
          },
          {
            "code" : "09062B"
          },
          {
            "code" : "09063B"
          },
          {
            "code" : "09064C"
          },
          {
            "code" : "09065B"
          },
          {
            "code" : "09066B"
          },
          {
            "code" : "09067B"
          },
          {
            "code" : "09068B"
          },
          {
            "code" : "09069B"
          },
          {
            "code" : "09070B"
          },
          {
            "code" : "09071C"
          },
          {
            "code" : "09072B"
          },
          {
            "code" : "09073B"
          },
          {
            "code" : "09074B"
          },
          {
            "code" : "09075B"
          },
          {
            "code" : "09076B"
          },
          {
            "code" : "09077B"
          },
          {
            "code" : "09078B"
          },
          {
            "code" : "09079C"
          },
          {
            "code" : "09080C"
          },
          {
            "code" : "09081C"
          },
          {
            "code" : "09082B"
          },
          {
            "code" : "09083B"
          },
          {
            "code" : "09084B"
          },
          {
            "code" : "09085C"
          },
          {
            "code" : "09086C"
          },
          {
            "code" : "09087B"
          },
          {
            "code" : "09088B"
          },
          {
            "code" : "09089B"
          },
          {
            "code" : "09090B"
          },
          {
            "code" : "09091B"
          },
          {
            "code" : "09092B"
          },
          {
            "code" : "09093B"
          },
          {
            "code" : "09094B"
          },
          {
            "code" : "09095B"
          },
          {
            "code" : "09096B"
          },
          {
            "code" : "09097B"
          },
          {
            "code" : "09098B"
          },
          {
            "code" : "09099C"
          },
          {
            "code" : "09100B"
          },
          {
            "code" : "09101B"
          },
          {
            "code" : "09102B"
          },
          {
            "code" : "09103C"
          },
          {
            "code" : "09104C"
          },
          {
            "code" : "09105C"
          },
          {
            "code" : "09106C"
          },
          {
            "code" : "09107C"
          },
          {
            "code" : "09108C"
          },
          {
            "code" : "09109C"
          },
          {
            "code" : "09110B"
          },
          {
            "code" : "09111C"
          },
          {
            "code" : "09112C"
          },
          {
            "code" : "09113C"
          },
          {
            "code" : "09114B"
          },
          {
            "code" : "09115B"
          },
          {
            "code" : "09116B"
          },
          {
            "code" : "09117C"
          },
          {
            "code" : "09118B"
          },
          {
            "code" : "09119B"
          },
          {
            "code" : "09120C"
          },
          {
            "code" : "09121C"
          },
          {
            "code" : "09122C"
          },
          {
            "code" : "09123B"
          },
          {
            "code" : "09124B"
          },
          {
            "code" : "09125C"
          },
          {
            "code" : "09126C"
          },
          {
            "code" : "09127C"
          },
          {
            "code" : "09128C"
          },
          {
            "code" : "09129C"
          },
          {
            "code" : "09130C"
          },
          {
            "code" : "09131C"
          },
          {
            "code" : "09132B"
          },
          {
            "code" : "09133B"
          },
          {
            "code" : "09134C"
          },
          {
            "code" : "09135B"
          },
          {
            "code" : "09136B"
          },
          {
            "code" : "09137B"
          },
          {
            "code" : "09138C"
          },
          {
            "code" : "09139C"
          },
          {
            "code" : "10001B"
          },
          {
            "code" : "10002B"
          },
          {
            "code" : "10003B"
          },
          {
            "code" : "10004B"
          },
          {
            "code" : "10005B"
          },
          {
            "code" : "10006B"
          },
          {
            "code" : "10007B"
          },
          {
            "code" : "10008B"
          },
          {
            "code" : "10009B"
          },
          {
            "code" : "10010B"
          },
          {
            "code" : "10011B"
          },
          {
            "code" : "10012B"
          },
          {
            "code" : "10501C"
          },
          {
            "code" : "10502B"
          },
          {
            "code" : "10503B"
          },
          {
            "code" : "10504B"
          },
          {
            "code" : "10505B"
          },
          {
            "code" : "10506B"
          },
          {
            "code" : "10507B"
          },
          {
            "code" : "10508B"
          },
          {
            "code" : "10509B"
          },
          {
            "code" : "10510C"
          },
          {
            "code" : "10511C"
          },
          {
            "code" : "10512B"
          },
          {
            "code" : "10515B"
          },
          {
            "code" : "10516B"
          },
          {
            "code" : "10517B"
          },
          {
            "code" : "10518B"
          },
          {
            "code" : "10519B"
          },
          {
            "code" : "10520C"
          },
          {
            "code" : "10521B"
          },
          {
            "code" : "10522B"
          },
          {
            "code" : "10523B"
          },
          {
            "code" : "10524B"
          },
          {
            "code" : "10525B"
          },
          {
            "code" : "10526B"
          },
          {
            "code" : "10527B"
          },
          {
            "code" : "10529B"
          },
          {
            "code" : "10530B"
          },
          {
            "code" : "10531B"
          },
          {
            "code" : "10532B"
          },
          {
            "code" : "10533B"
          },
          {
            "code" : "10534B"
          },
          {
            "code" : "10535B"
          },
          {
            "code" : "10536B"
          },
          {
            "code" : "10537C"
          },
          {
            "code" : "10801B"
          },
          {
            "code" : "10802B"
          },
          {
            "code" : "10803B"
          },
          {
            "code" : "10804B"
          },
          {
            "code" : "10805B"
          },
          {
            "code" : "10806B"
          },
          {
            "code" : "10807B"
          },
          {
            "code" : "10808B"
          },
          {
            "code" : "10809B"
          },
          {
            "code" : "10810B"
          },
          {
            "code" : "10811B"
          },
          {
            "code" : "10812B"
          },
          {
            "code" : "10813B"
          },
          {
            "code" : "10814B"
          },
          {
            "code" : "10815B"
          },
          {
            "code" : "10816B"
          },
          {
            "code" : "10817B"
          },
          {
            "code" : "10818B"
          },
          {
            "code" : "10819C"
          },
          {
            "code" : "11001C"
          },
          {
            "code" : "11002C"
          },
          {
            "code" : "11003C"
          },
          {
            "code" : "11004C"
          },
          {
            "code" : "11005B"
          },
          {
            "code" : "11006B"
          },
          {
            "code" : "11007B"
          },
          {
            "code" : "11008B"
          },
          {
            "code" : "11009B"
          },
          {
            "code" : "11010B"
          },
          {
            "code" : "11011B"
          },
          {
            "code" : "11012B"
          },
          {
            "code" : "12001C"
          },
          {
            "code" : "12002B"
          },
          {
            "code" : "12003C"
          },
          {
            "code" : "12004C"
          },
          {
            "code" : "12005B"
          },
          {
            "code" : "12006B"
          },
          {
            "code" : "12007C"
          },
          {
            "code" : "12008B"
          },
          {
            "code" : "12009C"
          },
          {
            "code" : "12010C"
          },
          {
            "code" : "12011C"
          },
          {
            "code" : "12012B"
          },
          {
            "code" : "12013C"
          },
          {
            "code" : "12014C"
          },
          {
            "code" : "12015C"
          },
          {
            "code" : "12016C"
          },
          {
            "code" : "12017B"
          },
          {
            "code" : "12018C"
          },
          {
            "code" : "12019B"
          },
          {
            "code" : "12020C"
          },
          {
            "code" : "12021C"
          },
          {
            "code" : "12022C"
          },
          {
            "code" : "12023B"
          },
          {
            "code" : "12024B"
          },
          {
            "code" : "12025B"
          },
          {
            "code" : "12026B"
          },
          {
            "code" : "12027B"
          },
          {
            "code" : "12028B"
          },
          {
            "code" : "12029B"
          },
          {
            "code" : "12030B"
          },
          {
            "code" : "12031C"
          },
          {
            "code" : "12032B"
          },
          {
            "code" : "12033B"
          },
          {
            "code" : "12034B"
          },
          {
            "code" : "12035B"
          },
          {
            "code" : "12036B"
          },
          {
            "code" : "12037B"
          },
          {
            "code" : "12038B"
          },
          {
            "code" : "12039B"
          },
          {
            "code" : "12040B"
          },
          {
            "code" : "12041B"
          },
          {
            "code" : "12042B"
          },
          {
            "code" : "12043B"
          },
          {
            "code" : "12044B"
          },
          {
            "code" : "12045B"
          },
          {
            "code" : "12046B"
          },
          {
            "code" : "12047B"
          },
          {
            "code" : "12048C"
          },
          {
            "code" : "12049B"
          },
          {
            "code" : "12050B"
          },
          {
            "code" : "12051B"
          },
          {
            "code" : "12052B"
          },
          {
            "code" : "12053C"
          },
          {
            "code" : "12054B"
          },
          {
            "code" : "12055B"
          },
          {
            "code" : "12056B"
          },
          {
            "code" : "12057B"
          },
          {
            "code" : "12058B"
          },
          {
            "code" : "12059B"
          },
          {
            "code" : "12060C"
          },
          {
            "code" : "12061B"
          },
          {
            "code" : "12062B"
          },
          {
            "code" : "12063B"
          },
          {
            "code" : "12064B"
          },
          {
            "code" : "12065B"
          },
          {
            "code" : "12066B"
          },
          {
            "code" : "12067B"
          },
          {
            "code" : "12068C"
          },
          {
            "code" : "12069B"
          },
          {
            "code" : "12070B"
          },
          {
            "code" : "12071B"
          },
          {
            "code" : "12072B"
          },
          {
            "code" : "12073C"
          },
          {
            "code" : "12074B"
          },
          {
            "code" : "12075B"
          },
          {
            "code" : "12076B"
          },
          {
            "code" : "12077C"
          },
          {
            "code" : "12078C"
          },
          {
            "code" : "12079C"
          },
          {
            "code" : "12080B"
          },
          {
            "code" : "12081C"
          },
          {
            "code" : "12082B"
          },
          {
            "code" : "12083B"
          },
          {
            "code" : "12084B"
          },
          {
            "code" : "12085B"
          },
          {
            "code" : "12086C"
          },
          {
            "code" : "12087B"
          },
          {
            "code" : "12088B"
          },
          {
            "code" : "12089B"
          },
          {
            "code" : "12090B"
          },
          {
            "code" : "12091B"
          },
          {
            "code" : "12092B"
          },
          {
            "code" : "12093B"
          },
          {
            "code" : "12094B"
          },
          {
            "code" : "12095B"
          },
          {
            "code" : "12096B"
          },
          {
            "code" : "12097B"
          },
          {
            "code" : "12098B"
          },
          {
            "code" : "12099B"
          },
          {
            "code" : "12100B"
          },
          {
            "code" : "12101B"
          },
          {
            "code" : "12102B"
          },
          {
            "code" : "12103B"
          },
          {
            "code" : "12104B"
          },
          {
            "code" : "12105B"
          },
          {
            "code" : "12106C"
          },
          {
            "code" : "12107C"
          },
          {
            "code" : "12108B"
          },
          {
            "code" : "12109B"
          },
          {
            "code" : "12110B"
          },
          {
            "code" : "12111C"
          },
          {
            "code" : "12112B"
          },
          {
            "code" : "12113B"
          },
          {
            "code" : "12114B"
          },
          {
            "code" : "12115B"
          },
          {
            "code" : "12116C"
          },
          {
            "code" : "12117B"
          },
          {
            "code" : "12118B"
          },
          {
            "code" : "12120B"
          },
          {
            "code" : "12121C"
          },
          {
            "code" : "12122B"
          },
          {
            "code" : "12123C"
          },
          {
            "code" : "12124B"
          },
          {
            "code" : "12125C"
          },
          {
            "code" : "12126B"
          },
          {
            "code" : "12127B"
          },
          {
            "code" : "12128B"
          },
          {
            "code" : "12129C"
          },
          {
            "code" : "12130B"
          },
          {
            "code" : "12131B"
          },
          {
            "code" : "12132B"
          },
          {
            "code" : "12133B"
          },
          {
            "code" : "12134C"
          },
          {
            "code" : "12135B"
          },
          {
            "code" : "12136B"
          },
          {
            "code" : "12137B"
          },
          {
            "code" : "12138B"
          },
          {
            "code" : "12139B"
          },
          {
            "code" : "12140B"
          },
          {
            "code" : "12141B"
          },
          {
            "code" : "12142B"
          },
          {
            "code" : "12143B"
          },
          {
            "code" : "12144B"
          },
          {
            "code" : "12145B"
          },
          {
            "code" : "12146B"
          },
          {
            "code" : "12147B"
          },
          {
            "code" : "12148B"
          },
          {
            "code" : "12149B"
          },
          {
            "code" : "12150B"
          },
          {
            "code" : "12151C"
          },
          {
            "code" : "12152B"
          },
          {
            "code" : "12153B"
          },
          {
            "code" : "12154B"
          },
          {
            "code" : "12155B"
          },
          {
            "code" : "12156B"
          },
          {
            "code" : "12157B"
          },
          {
            "code" : "12158B"
          },
          {
            "code" : "12159B"
          },
          {
            "code" : "12160B"
          },
          {
            "code" : "12161B"
          },
          {
            "code" : "12162B"
          },
          {
            "code" : "12163B"
          },
          {
            "code" : "12164B"
          },
          {
            "code" : "12165C"
          },
          {
            "code" : "12166B"
          },
          {
            "code" : "12167B"
          },
          {
            "code" : "12168B"
          },
          {
            "code" : "12169B"
          },
          {
            "code" : "12170B"
          },
          {
            "code" : "12171B"
          },
          {
            "code" : "12172C"
          },
          {
            "code" : "12173B"
          },
          {
            "code" : "12174B"
          },
          {
            "code" : "12175B"
          },
          {
            "code" : "12176B"
          },
          {
            "code" : "12177B"
          },
          {
            "code" : "12178C"
          },
          {
            "code" : "12179C"
          },
          {
            "code" : "12180C"
          },
          {
            "code" : "12181C"
          },
          {
            "code" : "12182C"
          },
          {
            "code" : "12183C"
          },
          {
            "code" : "12184C"
          },
          {
            "code" : "12185C"
          },
          {
            "code" : "12186C"
          },
          {
            "code" : "12187C"
          },
          {
            "code" : "12188C"
          },
          {
            "code" : "12189C"
          },
          {
            "code" : "12190C"
          },
          {
            "code" : "12191C"
          },
          {
            "code" : "12192C"
          },
          {
            "code" : "12193C"
          },
          {
            "code" : "12194B"
          },
          {
            "code" : "12195B"
          },
          {
            "code" : "12196B"
          },
          {
            "code" : "12197B"
          },
          {
            "code" : "12198C"
          },
          {
            "code" : "12199B"
          },
          {
            "code" : "12200B"
          },
          {
            "code" : "12201B"
          },
          {
            "code" : "12202C"
          },
          {
            "code" : "12203B"
          },
          {
            "code" : "12204B"
          },
          {
            "code" : "12205B"
          },
          {
            "code" : "12206B"
          },
          {
            "code" : "12207B"
          },
          {
            "code" : "12208B"
          },
          {
            "code" : "12209B"
          },
          {
            "code" : "12210B"
          },
          {
            "code" : "12211B"
          },
          {
            "code" : "12212B"
          },
          {
            "code" : "12213B"
          },
          {
            "code" : "13001C"
          },
          {
            "code" : "13002B"
          },
          {
            "code" : "13003B"
          },
          {
            "code" : "13004B"
          },
          {
            "code" : "13005B"
          },
          {
            "code" : "13006C"
          },
          {
            "code" : "13007C"
          },
          {
            "code" : "13008C"
          },
          {
            "code" : "13009C"
          },
          {
            "code" : "13010C"
          },
          {
            "code" : "13011C"
          },
          {
            "code" : "13012C"
          },
          {
            "code" : "13013C"
          },
          {
            "code" : "13014B"
          },
          {
            "code" : "13015C"
          },
          {
            "code" : "13016B"
          },
          {
            "code" : "13017C"
          },
          {
            "code" : "13018C"
          },
          {
            "code" : "13019B"
          },
          {
            "code" : "13020C"
          },
          {
            "code" : "13021B"
          },
          {
            "code" : "13022B"
          },
          {
            "code" : "13023C"
          },
          {
            "code" : "13024C"
          },
          {
            "code" : "13025C"
          },
          {
            "code" : "13026C"
          },
          {
            "code" : "13028B"
          },
          {
            "code" : "13029B"
          },
          {
            "code" : "14001B"
          },
          {
            "code" : "14002B"
          },
          {
            "code" : "14003B"
          },
          {
            "code" : "14004B"
          },
          {
            "code" : "14005C"
          },
          {
            "code" : "14006B"
          },
          {
            "code" : "14007B"
          },
          {
            "code" : "14008B"
          },
          {
            "code" : "14009C"
          },
          {
            "code" : "14010B"
          },
          {
            "code" : "14011B"
          },
          {
            "code" : "14012B"
          },
          {
            "code" : "14013B"
          },
          {
            "code" : "14014B"
          },
          {
            "code" : "14015B"
          },
          {
            "code" : "14016B"
          },
          {
            "code" : "14017B"
          },
          {
            "code" : "14018B"
          },
          {
            "code" : "14019B"
          },
          {
            "code" : "14020B"
          },
          {
            "code" : "14021B"
          },
          {
            "code" : "14022B"
          },
          {
            "code" : "14023B"
          },
          {
            "code" : "14024B"
          },
          {
            "code" : "14025C"
          },
          {
            "code" : "14026C"
          },
          {
            "code" : "14027C"
          },
          {
            "code" : "14028B"
          },
          {
            "code" : "14029B"
          },
          {
            "code" : "14030C"
          },
          {
            "code" : "14031C"
          },
          {
            "code" : "14032C"
          },
          {
            "code" : "14033C"
          },
          {
            "code" : "14034C"
          },
          {
            "code" : "14035C"
          },
          {
            "code" : "14036C"
          },
          {
            "code" : "14037C"
          },
          {
            "code" : "14038C"
          },
          {
            "code" : "14039C"
          },
          {
            "code" : "14040C"
          },
          {
            "code" : "14041B"
          },
          {
            "code" : "14042B"
          },
          {
            "code" : "14043B"
          },
          {
            "code" : "14044B"
          },
          {
            "code" : "14045B"
          },
          {
            "code" : "14046B"
          },
          {
            "code" : "14047B"
          },
          {
            "code" : "14048B"
          },
          {
            "code" : "14049C"
          },
          {
            "code" : "14050B"
          },
          {
            "code" : "14051C"
          },
          {
            "code" : "14052B"
          },
          {
            "code" : "14053B"
          },
          {
            "code" : "14054B"
          },
          {
            "code" : "14055B"
          },
          {
            "code" : "14056B"
          },
          {
            "code" : "14057B"
          },
          {
            "code" : "14058C"
          },
          {
            "code" : "14059B"
          },
          {
            "code" : "14060B"
          },
          {
            "code" : "14061B"
          },
          {
            "code" : "14062B"
          },
          {
            "code" : "14063B"
          },
          {
            "code" : "14064C"
          },
          {
            "code" : "14065C"
          },
          {
            "code" : "14066C"
          },
          {
            "code" : "14067B"
          },
          {
            "code" : "14068B"
          },
          {
            "code" : "14069B"
          },
          {
            "code" : "14070B"
          },
          {
            "code" : "14071B"
          },
          {
            "code" : "14072B"
          },
          {
            "code" : "14073B"
          },
          {
            "code" : "14074C"
          },
          {
            "code" : "14075C"
          },
          {
            "code" : "14076C"
          },
          {
            "code" : "14077C"
          },
          {
            "code" : "14078C"
          },
          {
            "code" : "14079C"
          },
          {
            "code" : "14080C"
          },
          {
            "code" : "14081B"
          },
          {
            "code" : "14083C"
          },
          {
            "code" : "15001C"
          },
          {
            "code" : "15007C"
          },
          {
            "code" : "15017C"
          },
          {
            "code" : "15018B"
          },
          {
            "code" : "15020B"
          },
          {
            "code" : "15021C"
          },
          {
            "code" : "15022C"
          },
          {
            "code" : "16001C"
          },
          {
            "code" : "16002C"
          },
          {
            "code" : "16003C"
          },
          {
            "code" : "16004C"
          },
          {
            "code" : "16005B"
          },
          {
            "code" : "16006C"
          },
          {
            "code" : "16007C"
          },
          {
            "code" : "16008C"
          },
          {
            "code" : "16009C"
          },
          {
            "code" : "16010C"
          },
          {
            "code" : "16011C"
          },
          {
            "code" : "16012C"
          },
          {
            "code" : "16013C"
          },
          {
            "code" : "27001C"
          },
          {
            "code" : "27002B"
          },
          {
            "code" : "27003B"
          },
          {
            "code" : "27004C"
          },
          {
            "code" : "27005B"
          },
          {
            "code" : "27006B"
          },
          {
            "code" : "27007B"
          },
          {
            "code" : "27008B"
          },
          {
            "code" : "27009B"
          },
          {
            "code" : "27010B"
          },
          {
            "code" : "27011B"
          },
          {
            "code" : "27012B"
          },
          {
            "code" : "27013B"
          },
          {
            "code" : "27014B"
          },
          {
            "code" : "27015C"
          },
          {
            "code" : "27016B"
          },
          {
            "code" : "27017B"
          },
          {
            "code" : "27018B"
          },
          {
            "code" : "27019B"
          },
          {
            "code" : "27020B"
          },
          {
            "code" : "27021B"
          },
          {
            "code" : "27022B"
          },
          {
            "code" : "27023B"
          },
          {
            "code" : "27024B"
          },
          {
            "code" : "27025B"
          },
          {
            "code" : "27026B"
          },
          {
            "code" : "27027B"
          },
          {
            "code" : "27028B"
          },
          {
            "code" : "27029B"
          },
          {
            "code" : "27030B"
          },
          {
            "code" : "27031B"
          },
          {
            "code" : "27032B"
          },
          {
            "code" : "27033C"
          },
          {
            "code" : "27034B"
          },
          {
            "code" : "27035B"
          },
          {
            "code" : "27036B"
          },
          {
            "code" : "27037B"
          },
          {
            "code" : "27038B"
          },
          {
            "code" : "27039C"
          },
          {
            "code" : "27040B"
          },
          {
            "code" : "27041B"
          },
          {
            "code" : "27042B"
          },
          {
            "code" : "27043B"
          },
          {
            "code" : "27044B"
          },
          {
            "code" : "27045B"
          },
          {
            "code" : "27046B"
          },
          {
            "code" : "27047B"
          },
          {
            "code" : "27048B"
          },
          {
            "code" : "27049C"
          },
          {
            "code" : "27050C"
          },
          {
            "code" : "27051B"
          },
          {
            "code" : "27052C"
          },
          {
            "code" : "27053C"
          },
          {
            "code" : "27054B"
          },
          {
            "code" : "27055C"
          },
          {
            "code" : "27056B"
          },
          {
            "code" : "27057B"
          },
          {
            "code" : "27058B"
          },
          {
            "code" : "27059B"
          },
          {
            "code" : "27060B"
          },
          {
            "code" : "27061B"
          },
          {
            "code" : "27062B"
          },
          {
            "code" : "27063B"
          },
          {
            "code" : "27064B"
          },
          {
            "code" : "27065B"
          },
          {
            "code" : "27066B"
          },
          {
            "code" : "27067B"
          },
          {
            "code" : "27068B"
          },
          {
            "code" : "27069B"
          },
          {
            "code" : "27070B"
          },
          {
            "code" : "27071B"
          },
          {
            "code" : "27072B"
          },
          {
            "code" : "27073B"
          },
          {
            "code" : "27074B"
          },
          {
            "code" : "27076B"
          },
          {
            "code" : "27077B"
          },
          {
            "code" : "27078B"
          },
          {
            "code" : "27079B"
          },
          {
            "code" : "27080B"
          },
          {
            "code" : "27081B"
          },
          {
            "code" : "27082B"
          },
          {
            "code" : "27083B"
          },
          {
            "code" : "30001C"
          },
          {
            "code" : "30002C"
          },
          {
            "code" : "30005B"
          },
          {
            "code" : "30006B"
          },
          {
            "code" : "30007B"
          },
          {
            "code" : "30008B"
          },
          {
            "code" : "30009B"
          },
          {
            "code" : "30010B"
          },
          {
            "code" : "30011B"
          },
          {
            "code" : "30012B"
          },
          {
            "code" : "30013B"
          },
          {
            "code" : "30014B"
          },
          {
            "code" : "30015C"
          },
          {
            "code" : "30016B"
          },
          {
            "code" : "30017B"
          },
          {
            "code" : "30018B"
          },
          {
            "code" : "30019B"
          },
          {
            "code" : "30020B"
          },
          {
            "code" : "30021C"
          },
          {
            "code" : "30022C"
          },
          {
            "code" : "30023B"
          },
          {
            "code" : "30024B"
          },
          {
            "code" : "30025B"
          },
          {
            "code" : "30026B"
          },
          {
            "code" : "30027B"
          },
          {
            "code" : "30028B"
          },
          {
            "code" : "30029B"
          },
          {
            "code" : "30030C"
          },
          {
            "code" : "30101B"
          },
          {
            "code" : "30102B"
          },
          {
            "code" : "30103B"
          },
          {
            "code" : "30104B"
          },
          {
            "code" : "30105B"
          },
          {
            "code" : "30501C"
          },
          {
            "code" : "30502C"
          },
          {
            "code" : "30503B"
          },
          {
            "code" : "30504B"
          },
          {
            "code" : "30505B"
          },
          {
            "code" : "30506B"
          },
          {
            "code" : "30507B"
          },
          {
            "code" : "30508C"
          },
          {
            "code" : "30509B"
          },
          {
            "code" : "30510B"
          },
          {
            "code" : "30511B"
          },
          {
            "code" : "30512C"
          },
          {
            "code" : "30513C"
          },
          {
            "code" : "30514C"
          },
          {
            "code" : "30515B"
          },
          {
            "code" : "30516B"
          },
          {
            "code" : "30517C"
          },
          {
            "code" : "30518C"
          },
          {
            "code" : "30519C"
          },
          {
            "code" : "30521B"
          },
          {
            "code" : "30522C"
          },
          {
            "code" : "30523B"
          },
          {
            "code" : "30524B"
          },
          {
            "code" : "30525B"
          },
          {
            "code" : "30526B"
          },
          {
            "code" : "24007B"
          },
          {
            "code" : "25013B"
          },
          {
            "code" : "17009B"
          },
          {
            "code" : "22015B"
          },
          {
            "code" : "22001C"
          },
          {
            "code" : "22025B"
          }
        ]
      }
    ]
  }
}

```
