# 臺灣健保署2023年中文版ICD-10-PCS值集 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## ValueSet: 臺灣健保署2023年中文版ICD-10-PCS值集 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2023-tw | *Version*:2024-11-18 |
| Active as of 2024-11-18 | *Computable Name*:TW2023ICD10PCS |

 
臺灣健保署2023年中文版ICD-10-PCS值集。 資料所屬單位：衛生福利部中央健康保險署。 
此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱 

 **References** 

* [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)
* [TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)
* [TW Core Procedure](StructureDefinition-Procedure-twcore.md)
* [TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "icd-10-pcs-2023-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2023-tw",
  "version" : "2024-11-18",
  "name" : "TW2023ICD10PCS",
  "title" : "臺灣健保署2023年中文版ICD-10-PCS值集",
  "status" : "active",
  "experimental" : false,
  "date" : "2024-11-18",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣健保署2023年中文版ICD-10-PCS值集。\n資料所屬單位：衛生福利部中央健康保險署。\n\n此值集所涵蓋代碼量較大會使載入頁面時間較長，為方便使用者瀏覽，此處(本頁、XML、JSON、TTL)僅擷取部分代碼，完整代碼可至[全國專門術語服務平臺－值集(Value Set)](https://fhir.mohw.gov.tw/ts/valueset.jsp)查閱",
  "compose" : {
    "include" : [
      {
        "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2023-tw",
        "filter" : [
          {
            "property" : "USE",
            "op" : "=",
            "value" : "1"
          }
        ]
      }
    ]
  }
}

```
