# TWCDI - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## TWCDI

### TWCDI資料元素與TW Core Profiles之對應關係與使用

TW Core IG會定期更新實作指引，以滿足後續的台灣核心資料(TWCDI)互通性應用需求。TWCDI和TW Core是互補的存在，TWCDI定義核心共通資料需求，TW Core則提供基於FHIR的Profile(設定檔)結構規範，以滿足臨床實作要求。

* TWCDI資料類別和元素名稱可能與TW Core Profile (設定檔)名稱和元素名稱不同。
* 並非每個TWCDI資料類別和元素都對應到單一TW Core Profile (設定檔)。
* TW Core Profile中的欄位資料不會完全對應到TWCDI資料類別和元素，因為TW Core的用途更為廣泛，並且需要額外的TW Core欄位資料來實現FHIR的實作。

#### 與接觸某種物質相關的有害或不良的生理反應：

| | |
| :--- | :--- |
| - Substance （Medication） | [臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）](StructureDefinition-AllergyIntolerance-twcore.md) |
| - Substance （Drug Class） | [臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）](StructureDefinition-AllergyIntolerance-twcore.md) |
| - Substance （Non-Medication） | [臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）](StructureDefinition-AllergyIntolerance-twcore.md) |
| - Reaction | [臺灣核心-過敏或不耐症（TW Core AllergyIntolerance）](StructureDefinition-AllergyIntolerance-twcore.md) |

#### 有關參與或預計參與患者護理的人員資訊：

| | |
| :--- | :--- |
| - Name | [臺灣核心-健康照護服務提供者（TW Core Practitioner）](StructureDefinition-Practitioner-twcore.md)[臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md)[臺灣核心-相關人士（TW Core RelatedPerson）](StructureDefinition-RelatedPerson-twcore.md) |
| - Identifier | [臺灣核心-健康照護服務提供者（TW Core Practitioner）](StructureDefinition-Practitioner-twcore.md)[臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Location | [臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）](StructureDefinition-PractitionerRole-twcore.md)[臺灣核心-健康照護服務提供者（TW Core Practitioner）](StructureDefinition-Practitioner-twcore.md)[臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md)[臺灣核心-相關人士（TW Core RelatedPerson）](StructureDefinition-RelatedPerson-twcore.md) |
| - Telecom | [臺灣核心-健康照護服務提供者角色（TW Core PractitionerRole）](StructureDefinition-PractitionerRole-twcore.md)[臺灣核心-健康照護服務提供者（TW Core Practitioner）](StructureDefinition-Practitioner-twcore.md)[臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md)[臺灣核心-相關人士（TW Core RelatedPerson）](StructureDefinition-RelatedPerson-twcore.md) |
| - Role | [臺灣核心-照護團隊（TW Core CareTeam）](StructureDefinition-CareTeam-twcore.md) |
| - Organization | [臺灣核心-醫事機構（TW Core Organization Hospital Department）](StructureDefinition-Organization-hosp-twcore.md) |

#### 患者臨床資料描述：

| | |
| :--- | :--- |
| - Consultation Note | [臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md) |
| - Discharge Summary Note | [臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md) |
| - History & Physical | [臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md) |
| - Imaging Narrative | [臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md) |
| - Procedure Note | [臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md) |
| - Progress Note | [臺灣核心-文件參照（TW Core DocumentReference）](StructureDefinition-DocumentReference-twcore.md) |

#### 進行非影像和非實驗室測試，得出針對患者的結構化或非結構化結果，以促進病情的診斷和管理：

| | |
| :--- | :--- |
| - Clinical Test | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md) |
| - Clinical Test Result/Report | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md) |

#### 產生需要具有資格的專業人士解讀的醫學影像測試：

| | |
| :--- | :--- |
| - Diagnostic Imaging Test | [臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result）](StructureDefinition-Observation-clinical-result-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md)[臺灣核心-影像檢查（TW Core ImagingStudy）](StructureDefinition-ImagingStudy-twcore.md) |
| - Diagnostic Imaging Result/Report | [臺灣核心-臨床檢驗檢查（TW Core Observation Clinical Result）](StructureDefinition-Observation-clinical-result-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md)[臺灣核心-影像檢查（TW Core ImagingStudy）](StructureDefinition-ImagingStudy-twcore.md) |

#### 與醫療保健提供者和患者之間的互動相關的資訊：

| | |
| :--- | :--- |
| - Identifier | [臺灣核心-就醫事件（TW Core Encounter）](StructureDefinition-Encounter-twcore.md) |
| - Type | [臺灣核心-就醫事件（TW Core Encounter）](StructureDefinition-Encounter-twcore.md) |
| - Diagnosis | [臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md) |
| - Time | [臺灣核心-就醫事件（TW Core Encounter）](StructureDefinition-Encounter-twcore.md) |
| - Location | [臺灣核心-就醫事件（TW Core Encounter）](StructureDefinition-Encounter-twcore.md) |
| - Disposition | [臺灣核心-就醫事件（TW Core Encounter）](StructureDefinition-Encounter-twcore.md) |

#### 可用服務或資源的實體位置：

| | |
| :--- | :--- |
| - Identifier | [臺灣核心-地點（TW Core Location）](StructureDefinition-Location-twcore.md) |
| - Type | [臺灣核心-地點（TW Core Location）](StructureDefinition-Location-twcore.md) |
| - Name | [臺灣核心-地點（TW Core Location）](StructureDefinition-Location-twcore.md) |

#### 目標：

| | |
| :--- | :--- |
| - Patient Goals | [臺灣核心-目標（TW Core Goal）](StructureDefinition-Goal-twcore.md) |
| - SDOH Goals | [臺灣核心-目標（TW Core Goal）](StructureDefinition-Goal-twcore.md) |
| - Treatment Intervention Preference | [臺灣核心-病人治療偏好註記（TW Core Observation Treatment Intervention Preference）](StructureDefinition-Observation-treatment-intervention-preference-twcore.md) |
| - Care Experience Preference | [臺灣核心-病人照護偏好註記（TW Core Observation Care Experience Preference）](StructureDefinition-Observation-careExperiencePreference-twcore.md) |

#### 與個人醫療保險範圍相關的資料：

| | |
| :--- | :--- |
| - Coverage Status | [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md) |
| - Coverage Type | [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md) |
| - Relationship to Subscriber | [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md) |
| - Member Identifier | [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md) |
| - Subscriber Identifier | [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md) |
| - Group Number | [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md) |
| - Payer Identifier | [臺灣核心-給付範圍（TW Core Coverage）](StructureDefinition-Coverage-twcore.md)[臺灣核心-機構（TW Core Organization](StructureDefinition-Organization-twcore.md) |

#### 對患者、患者家屬或患者的醫療保健提供者感興趣、重要性或擔憂的健康相關問題進行評估，以識別需求、問題或狀況：

| | |
| :--- | :--- |
| - Health Concerns | [臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md) |
| - Functional Status | [臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)[臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)[臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md) |
| - Disability Status | [臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)[臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)[臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md) |
| - Mental/Cognitive Status | [臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)[臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)[臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md) |
| - Pregnancy Status | [臺灣核心-妊娠狀態（TW Core Observation Pregnancy Status）](StructureDefinition-Observation-pregnancy-status-twcore.md)[臺灣核心-妊娠計畫（TW Core Observation Pregnancy Intent）](StructureDefinition-Observation-pregnancy-intent-twcore.md) |
| - Alcohol Use | [臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)[臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)[臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md) |
| - Substance Use | [臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)[臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)[臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md) |
| - Physical Activity | [臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)[臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)[臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md) |
| - SDOH Assessment | [臺灣核心-通用檢驗檢查（TW Core Simple Observation）](StructureDefinition-Observation-simple-twcore.md)[臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md)[臺灣核心-健康狀態篩檢與評估（TW Core Observation Screening Assessment）](StructureDefinition-Observation-screening-assessment-twcore.md)[臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）](StructureDefinition-QuestionnaireResponse-twcore.md) |
| - Smoking Status | [臺灣核心-吸菸狀態（TW Core Smoking Status Observation）](StructureDefinition-Observation-smoking-status-twcore.md) |

#### 疫苗接種記錄：

|
|

#### 用於醫療目的的儀器、機器、器具、植入物、軟體或其他物品：

| | |
| :--- | :--- |
| - Unique Device Identifier（s） for a Patient's Implantable Device（s） | [臺灣核心-植入式裝置（TW Core Implantable Device）](StructureDefinition-Device-twcore.md) |

#### 分析臨床樣本以獲得有關患者健康的資訊：

| | |
| :--- | :--- |
| - Tests | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md) |
| - Values/Results | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md) |
| - Specimen Type | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)[臺灣核心-檢體（TW Core Specimen）](StructureDefinition-Specimen-twcore.md) |
| - Result Status | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md) |
| - Result Unit of Measure | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md) |
| - Result Reference Range | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md) |
| - Result Interpretation | [臺灣核心-實驗室檢驗檢查（TW Core Observation Laboratory Result）](StructureDefinition-Observation-laboratoryResult-twcore.md) |
| - Specimen Identifier | [臺灣核心-檢體（TW Core Specimen）](StructureDefinition-Specimen-twcore.md) |
| - Specimen Source Site | [臺灣核心-檢體（TW Core Specimen）](StructureDefinition-Specimen-twcore.md) |
| - Specimen Condition Acceptability | [臺灣核心-檢體（TW Core Specimen）](StructureDefinition-Specimen-twcore.md) |

#### 用於診斷、治癒、緩解、治療或預防疾病的藥物：

| | |
| :--- | :--- |
| - Medications | [臺灣核心-藥品（TW Core Medication）](StructureDefinition-Medication-twcore.md)[臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md) |
| - Dose | [臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md) |
| - Dose Unit of Measure | [臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md) |
| - Indication | [臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md) |
| - Medication Instructions | [臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md) |
| - Medication Adherence | [臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md) |
| - Fill Status | [臺灣核心-藥品請求（TW Core MedicationRequest）](StructureDefinition-MedicationRequest-twcore.md) |

#### 用於對個人進行分類以進行識別、記錄匹配和其他目的的資料：

| | |
| :--- | :--- |
| - 完整中文姓名 | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - First Name | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Last Name | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Previous Name | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - ID Card Number | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Sex | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Date of Birth | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Date of Death | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Race | - |
| - Address | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Previous Address | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Email | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Phone Number | [臺灣核心-病人（TW Core Patient）](StructureDefinition-Patient-twcore.md) |
| - Related Person's Name | [臺灣核心-相關人士（TW Core RelatedPerson）](StructureDefinition-RelatedPerson-twcore.md) |
| - Related Person's Relationship | [臺灣核心-相關人士（TW Core RelatedPerson）](StructureDefinition-RelatedPerson-twcore.md) |
| - Occupation | [臺灣核心-職業（TW Core Observation Occupation）](StructureDefinition-Observation-occupation-twcore.md) |
| - Occupation Industry | [臺灣核心-職業（TW Core Observation Occupation）](StructureDefinition-Observation-occupation-twcore.md) |

#### 針對患者治療的結論以及未來治療的建議/規劃：

| | |
| :--- | :--- |
| - Assessment and Plan of Treatment | [臺灣核心-照護計畫（TW Core CarePlan）](StructureDefinition-CarePlan-twcore.md) |

#### 診斷或就醫的原因：

| | |
| :--- | :--- |
| - Date of Resolution | [臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md) |
| - Date of Diagnosis | [臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md) |
| - SDOH Problems/Health Concerns | [臺灣核心-病情、問題或診斷（TW Core Condition）](StructureDefinition-Condition-twcore.md) |

#### 作為提供護理的一部分，為患者或在患者身上進行的相關處置：

| | |
| :--- | :--- |
| - Procedure | [臺灣核心-處置或手術（TW Core Procedure）](StructureDefinition-Procedure-twcore.md) |
| - Performance Time | [臺灣核心-處置或手術（TW Core Procedure）](StructureDefinition-Procedure-twcore.md)[臺灣核心-診斷報告（TW Core DiagnosticReport）](StructureDefinition-DiagnosticReport-twcore.md)[臺灣核心-疫苗接種（TW Core Immunization）](StructureDefinition-Immunization-twcore.md) |
| - Reason for Referral | [臺灣核心-服務請求（TW Core ServiceRequest）](StructureDefinition-ServiceRequest-twcore.md)[臺灣核心-處置或手術（TW Core Procedure）](StructureDefinition-Procedure-twcore.md) |
| - SDOH Interventions | [臺灣核心-服務請求（TW Core ServiceRequest）](StructureDefinition-ServiceRequest-twcore.md)[臺灣核心-處置或手術（TW Core Procedure）](StructureDefinition-Procedure-twcore.md) |

#### 元資料（metadata）或有關資料的額外資訊，涉及資料創建者和創建時間（電子/數位簽章）：

| | |
| :--- | :--- |
| - Author Time Stamp | [臺灣核心-出處（TW Core Provenance）](StructureDefinition-Provenance-twcore.md) |
| - Author Organization | [臺灣核心-出處（TW Core Provenance）](StructureDefinition-Provenance-twcore.md) |

#### 患者的生理測量，顯示身體維持生命功能的狀態：

| | |
| :--- | :--- |
| - Average Blood Pressure | [臺灣核心-平均血壓（TW Core Observation Average Blood Pressure）](StructureDefinition-Observation-averageBloodPressure-twcore.md) |
| - Diastolic blood pressure | [臺灣核心-血壓（TW Core Observation Blood Pressure）](StructureDefinition-Observation-bloodPressure-twcore.md) |
| - Systolic blood pressure | [臺灣核心-血壓（TW Core Observation Blood Pressure）](StructureDefinition-Observation-bloodPressure-twcore.md) |
| - ECG/EKG | [臺灣核心-心電圖（TW Core Observation ECG）](StructureDefinition-Observation-ecg-twcore.md) |
| - Body height | [臺灣核心-身高（TW Core Observation Body Height）](StructureDefinition-Observation-body-height-twcore.md) |
| - Body weight | [臺灣核心-體溫（TW Core Observation Body Temperature）](StructureDefinition-Observation-body-temperature-twcore.md) |
| - Heart rate | [臺灣核心-心率（TW Core Observation Heart Rate）](StructureDefinition-Observation-heart-rate-twcore.md) |
| - Respiratory rate | [臺灣核心-呼吸速率（TW Core Observation Respiratory Rate）](StructureDefinition-Observation-respiratory-rate-twcore.md) |
| - Body temperature | [臺灣核心-體溫（TW Core Observation Body Temperature）](StructureDefinition-Observation-body-temperature-twcore.md) |
| - Pulse oximetry | [臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）](StructureDefinition-Observation-pulse-oximetry-twcore.md) |
| - Inhaled oxygen concentration | [臺灣核心-脈搏血氧飽和度（TW Core Observation Pulse Oximetry）](StructureDefinition-Observation-pulse-oximetry-twcore.md) |
| - BMI Percentile （2-20 years old） | [臺灣核心-兒童及青少年身體質量指數（TW Core Pediatric BMI for Age Observation）](StructureDefinition-Observation-pediatric-bmi-age-twcore.md) |
| - Weight-for-length Percentile （Birth - 36 months） | [臺灣核心-兒童生長曲線（TW Core Pediatric Weight for Height Observation）](StructureDefinition-Observation-pediatric-weight-height-twcore.md) |
| - Occipital Frontal Head Circumference Percentile （Birth - 36 months） | [臺灣核心-兒童頭圍百分位數（TW Core Observation Pediatric Head Occipital Frontal Circumference Percentile）](StructureDefinition-Observation-pediatric-head-circumference-twcore.md) |

