# TW Postal code - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Extension: TW Postal code 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWPostalCode |

臺灣郵遞區號

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [TW Core Address](StructureDefinition-Address-tw.md)
* Examples for this Extension: [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md), [Bundle/bun-example](Bundle-bun-example.md), [Bundle/bun-message-request-example](Bundle-bun-message-request-example.md)...Show 7 more,[Patient/pat-child-example](Patient-pat-child-example.md),[Patient/pat-example](Patient-pat-example.md),[Practitioner/pra-dr-example](Practitioner-pra-dr-example.md),[Practitioner/pra-nurse-example](Practitioner-pra-nurse-example.md),[Practitioner/pra-phc-example](Practitioner-pra-phc-example.md),[Practitioner/pra-radio-example](Practitioner-pra-radio-example.md)and[RelatedPerson/rel-example](RelatedPerson-rel-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/tw-postal-code)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-tw-postal-code.csv), [Excel](StructureDefinition-tw-postal-code.xlsx), [Schematron](StructureDefinition-tw-postal-code.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "tw-postal-code",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code",
  "version" : "1.0.0",
  "name" : "TWPostalCode",
  "title" : "TW Postal code",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣郵遞區號",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Address.postalCode"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "臺灣郵遞區號",
        "definition" : "臺灣郵遞區號"
      },
      {
        "id" : "Extension.id",
        "path" : "Extension.id",
        "short" : "唯一可識別ID，以供資料項目間相互參照。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "short" : "擴充的資料項目名稱",
        "definition" : "擴充的資料項目之定義連結—一個邏輯名稱或URL",
        "comment" : "此定義可直接指向可計算的或人類可讀的擴充資料項目的定義，也可以是其他規範中聲明的邏輯URI。此定義**必須（SHALL）** 定義擴充的結構定義的URI。",
        "fixedUri" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/tw-postal-code"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "擴充的資料項目的內容值",
        "definition" : "擴充的資料項目的內容值—必須是一組受限制的data type中的一個（清單請見[Extensibility](http://hl7.org/fhir/2021Mar/extensibility.html)）",
        "comment" : "並非所有的專門術語使用都符合這個一般模式。在某些情況下，資料模型不應該使用CodeableConcept，而應直接使用Coding，並提供他們自己的結構來管理文字、編碼、翻譯、資料項目之間的關係、先組合配對（pre-）和後組合配對（post-coordination）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ]
      },
      {
        "id" : "Extension.value[x].extension",
        "path" : "Extension.value[x].extension",
        "definition" : "可用於表示不屬於此資料項目基本定義的附加資訊。為了擴充的使用安全和可管理，對擴充的定義和使用有一套嚴格的管理。儘管任何實作者都可以定義一個擴充，但作為擴充定義的一部分，有一套要求 **必須（SHALL）** 滿足。",
        "comment" : "無論使用或定義擴充的機構或管轄區，任何應用程式、專案或標準使用擴充都不背負任何污名（stigma）。使用擴充是允許FHIR規範為每個人保留一個核心的簡易性。"
      },
      {
        "id" : "Extension.value[x].coding",
        "path" : "Extension.value[x].coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "system"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Extension.value[x].coding:PostalCode3",
        "path" : "Extension.value[x].coding",
        "sliceName" : "PostalCode3",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/postal-code3-tw"
        }
      },
      {
        "id" : "Extension.value[x].coding:PostalCode3.id",
        "path" : "Extension.value[x].coding.id",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Extension.value[x].coding:PostalCode3.system",
        "path" : "Extension.value[x].coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code3-tw"
      },
      {
        "id" : "Extension.value[x].coding:PostalCode3.code",
        "path" : "Extension.value[x].coding.code",
        "min" : 1
      },
      {
        "id" : "Extension.value[x].coding:PostalCode5",
        "path" : "Extension.value[x].coding",
        "sliceName" : "PostalCode5",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/postal-code5-tw"
        }
      },
      {
        "id" : "Extension.value[x].coding:PostalCode5.id",
        "path" : "Extension.value[x].coding.id",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Extension.value[x].coding:PostalCode5.system",
        "path" : "Extension.value[x].coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code5-tw"
      },
      {
        "id" : "Extension.value[x].coding:PostalCode5.code",
        "path" : "Extension.value[x].coding.code",
        "min" : 1
      },
      {
        "id" : "Extension.value[x].coding:PostalCode6",
        "path" : "Extension.value[x].coding",
        "sliceName" : "PostalCode6",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/postal-code6-tw"
        }
      },
      {
        "id" : "Extension.value[x].coding:PostalCode6.id",
        "path" : "Extension.value[x].coding.id",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Extension.value[x].coding:PostalCode6.system",
        "path" : "Extension.value[x].coding.system",
        "min" : 1,
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/postal-code6-tw"
      },
      {
        "id" : "Extension.value[x].coding:PostalCode6.code",
        "path" : "Extension.value[x].coding.code",
        "min" : 1
      }
    ]
  }
}

```
