# Identifier Suffix - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Extension: Identifier Suffix 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:IdentifierSuffix |

* 增加Practitioner.identifier.type.coding.code欄位也可使用此Extension，以利實務專案使用

識別碼後綴詞

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [TW Core Patient](StructureDefinition-Patient-twcore.md) and [TW Core Practitioner](StructureDefinition-Practitioner-twcore.md)
* Examples for this Extension: [Bundle/bun-document-example](Bundle-bun-document-example.md), [Bundle/bun-document-uuid-example](Bundle-bun-document-uuid-example.md), [Bundle/bun-example](Bundle-bun-example.md), [Bundle/bun-message-request-example](Bundle-bun-message-request-example.md)...Show 2 more,[Patient/pat-child-example](Patient-pat-child-example.md)and[Patient/pat-example](Patient-pat-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/identifier-suffix)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-identifier-suffix.csv), [Excel](StructureDefinition-identifier-suffix.xlsx), [Schematron](StructureDefinition-identifier-suffix.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "identifier-suffix",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix",
  "version" : "1.0.0",
  "name" : "IdentifierSuffix",
  "title" : "Identifier Suffix",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "\n- 增加Practitioner.identifier.type.coding.code欄位也可使用此Extension，以利實務專案使用  \n\n識別碼後綴詞",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Patient.identifier.type.coding.code"
    },
    {
      "type" : "element",
      "expression" : "Practitioner.identifier.type.coding.code"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "識別碼後綴詞",
        "definition" : "\n- 增加Practitioner.identifier.type.coding.code欄位也可使用此Extension，以利實務專案使用  \n\n識別碼後綴詞",
        "max" : "1"
      },
      {
        "id" : "Extension.id",
        "path" : "Extension.id",
        "short" : "唯一可識別ID，以供資料項目間相互參照。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "Extension.extension:suffix",
        "path" : "Extension.extension",
        "sliceName" : "suffix",
        "short" : "國家代碼",
        "definition" : "國家代碼",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:suffix.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:suffix.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "suffix"
      },
      {
        "id" : "Extension.extension:suffix.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.extension:valueSet",
        "path" : "Extension.extension",
        "sliceName" : "valueSet",
        "short" : "值集",
        "definition" : "ISO 3166三位字母代碼（alpha-3）的值集",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:valueSet.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:valueSet.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "valueSet"
      },
      {
        "id" : "Extension.extension:valueSet.value[x]",
        "path" : "Extension.extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "canonical"
          }
        ],
        "patternCanonical" : "http://hl7.org/fhir/ValueSet/iso3166-1-3"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "short" : "擴充的資料項目名稱",
        "definition" : "擴充的資料項目之定義連結—一個邏輯名稱或URL",
        "comment" : "此定義可直接指向可計算的或人類可讀的擴充資料項目的定義，也可以是其他規範中聲明的邏輯URI。此定義**必須（SHALL）** 定義擴充的結構定義的URI。",
        "fixedUri" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/identifier-suffix"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
