# 臺灣核心-檢體(TW Core Specimen) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-檢體(TW Core Specimen) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWSpecimen | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWSpecimenModel |

 
臺灣核心-檢體(TW Core Specimen) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWSpecimen)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWSpecimen.csv), [Excel](StructureDefinition-TWSpecimen.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWSpecimen",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWSpecimen",
  "version" : "1.0.0",
  "name" : "TWSpecimenModel",
  "title" : "臺灣核心-檢體(TW Core Specimen) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-檢體(TW Core Specimen) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWSpecimen",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWSpecimen",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWSpecimen",
        "path" : "TWSpecimen",
        "short" : "臺灣核心-檢體(TW Core Specimen) 之資料模型",
        "definition" : "臺灣核心-檢體(TW Core Specimen) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWSpecimen",
            "map" : "TWCoreSpecimen"
          }
        ]
      },
      {
        "id" : "TWSpecimen.identifier",
        "path" : "TWSpecimen.identifier",
        "short" : "檢體的外部識別碼。",
        "definition" : "檢體的外部識別碼。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWSpecimen",
            "map" : "TWCoreSpecimen.identifier"
          }
        ]
      },
      {
        "id" : "TWSpecimen.type",
        "path" : "TWSpecimen.type",
        "short" : "檢體的類型。",
        "definition" : "檢體的類型。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWSpecimen",
            "map" : "TWCoreSpecimen.type"
          }
        ]
      },
      {
        "id" : "TWSpecimen.subject",
        "path" : "TWSpecimen.subject",
        "short" : "這可能來自病人、某個地點（例如環境樣本的來源），或是對某種物質或裝置的採樣。",
        "definition" : "這可能來自病人、某個地點（例如環境樣本的來源），或是對某種物質或裝置的採樣。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWSpecimen.subject.patient",
        "path" : "TWSpecimen.subject.patient",
        "short" : "這可能來自某病人的採樣。",
        "definition" : "這可能來自某病人的採樣。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWSpecimen",
            "map" : "TWCoreSpecimen.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWSpecimen.subject.group",
        "path" : "TWSpecimen.subject.group",
        "short" : "這可能來自某團體/群體的採樣。",
        "definition" : "這可能來自某團體/群體的採樣。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWSpecimen",
            "map" : "TWCoreSpecimen.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWSpecimen.subject.device",
        "path" : "TWSpecimen.subject.device",
        "short" : "這可能來自某設備的採樣。",
        "definition" : "這可能來自某設備的採樣。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWSpecimen",
            "map" : "TWCoreSpecimen.subject.Reference(Device)"
          }
        ]
      },
      {
        "id" : "TWSpecimen.subject.substance",
        "path" : "TWSpecimen.subject.substance",
        "short" : "這可能來自某物質的採樣。",
        "definition" : "這可能來自某物質的採樣。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Substance"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWSpecimen",
            "map" : "TWCoreSpecimen.subject.Reference(Substance)"
          }
        ]
      },
      {
        "id" : "TWSpecimen.subject.location",
        "path" : "TWSpecimen.subject.location",
        "short" : "這可能來自某地點的採樣。",
        "definition" : "這可能來自某地點的採樣。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Location"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWSpecimen",
            "map" : "TWCoreSpecimen.subject.Reference(TW Core Location)"
          }
        ]
      }
    ]
  }
}

```
