# 臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPractitioner | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWPractitionerModel |

 
臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWPractitioner)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWPractitioner.csv), [Excel](StructureDefinition-TWPractitioner.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWPractitioner",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPractitioner",
  "version" : "1.0.0",
  "name" : "TWPractitionerModel",
  "title" : "臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWPractitioner",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWPractitioner",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWPractitioner",
        "path" : "TWPractitioner",
        "short" : "臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型",
        "definition" : "臺灣核心-健康照護服務提供者(TW Core Practitioner)之資料模型",
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner"
          }
        ]
      },
      {
        "id" : "TWPractitioner.identifier",
        "path" : "TWPractitioner.identifier",
        "short" : "人員識別碼(例如：員工編號等)。",
        "definition" : "人員識別碼(例如：員工編號等)。",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner.identifier"
          }
        ]
      },
      {
        "id" : "TWPractitioner.active",
        "path" : "TWPractitioner.active",
        "short" : "此健康照護服務人員的基本資料是否使用中。",
        "definition" : "此健康照護服務人員的基本資料是否使用中。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner.active"
          }
        ]
      },
      {
        "id" : "TWPractitioner.name",
        "path" : "TWPractitioner.name",
        "short" : "姓名。",
        "definition" : "姓名。",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "HumanName"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner.name"
          }
        ]
      },
      {
        "id" : "TWPractitioner.telecom",
        "path" : "TWPractitioner.telecom",
        "short" : "聯絡方式。",
        "definition" : "聯絡方式。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner.telecom"
          }
        ]
      },
      {
        "id" : "TWPractitioner.address",
        "path" : "TWPractitioner.address",
        "short" : "地址(戶籍/現居/等)。",
        "definition" : "地址(戶籍/現居/等)。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner.address"
          }
        ]
      },
      {
        "id" : "TWPractitioner.gender",
        "path" : "TWPractitioner.gender",
        "short" : "性別。",
        "definition" : "性別。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner.gender"
          }
        ]
      },
      {
        "id" : "TWPractitioner.birthDate",
        "path" : "TWPractitioner.birthDate",
        "short" : "出生日期。",
        "definition" : "出生日期。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner.birthDate"
          }
        ]
      },
      {
        "id" : "TWPractitioner.photo",
        "path" : "TWPractitioner.photo",
        "short" : "人員影像。",
        "definition" : "人員影像。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Attachment"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWPractitioner",
            "map" : "TWCorePractitioner.photo"
          }
        ]
      }
    ]
  }
}

```
