# 臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMessageHeader | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWMessageHeaderModel |

 
臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWMessageHeader)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWMessageHeader.csv), [Excel](StructureDefinition-TWMessageHeader.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWMessageHeader",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMessageHeader",
  "version" : "1.0.0",
  "name" : "TWMessageHeaderModel",
  "title" : "臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWMessageHeader",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMessageHeader",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWMessageHeader",
        "path" : "TWMessageHeader",
        "short" : "臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型",
        "definition" : "臺灣核心-訊息表頭(TW Core MessageHeader) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWMessageHeader",
            "map" : "TWMessageHeader"
          }
        ]
      },
      {
        "id" : "TWMessageHeader.sender",
        "path" : "TWMessageHeader.sender",
        "short" : "訊息的實際發送端",
        "definition" : "訊息的實際發送端",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMessageHeader.sender.practitioner",
        "path" : "TWMessageHeader.sender.practitioner",
        "short" : "某健康照護服務提供者發送訊息。",
        "definition" : "某健康照護服務提供者發送訊息。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMessageHeader",
            "map" : "TWMessageHeader.sender.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWMessageHeader.sender.practitionerRole",
        "path" : "TWMessageHeader.sender.practitionerRole",
        "short" : "某健康照護服務角色發送訊息。",
        "definition" : "某健康照護服務角色發送訊息。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMessageHeader",
            "map" : "TWMessageHeader.sender.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWMessageHeader.sender.organization",
        "path" : "TWMessageHeader.sender.organization",
        "short" : "某機構發送訊息。",
        "definition" : "某機構發送訊息。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMessageHeader",
            "map" : "TWMessageHeader.sender.Reference(TW Core Organization Hospital Department)"
          }
        ]
      },
      {
        "id" : "TWMessageHeader.focus",
        "path" : "TWMessageHeader.focus",
        "short" : "訊息的實際內容。",
        "definition" : "訊息的實際內容。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Resource"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMessageHeader",
            "map" : "TWMessageHeader.focus.Reference(Resource)"
          }
        ]
      }
    ]
  }
}

```
