# 臺灣核心-用藥聲明(TW Core MedicationStatement) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-用藥聲明(TW Core MedicationStatement) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationStatement | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWMedicationStatementModel |

 
臺灣核心-用藥聲明(TW Core MedicationStatement) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWMedicationStatement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWMedicationStatement.csv), [Excel](StructureDefinition-TWMedicationStatement.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWMedicationStatement",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationStatement",
  "version" : "1.0.0",
  "name" : "TWMedicationStatementModel",
  "title" : "臺灣核心-用藥聲明(TW Core  MedicationStatement) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-用藥聲明(TW Core  MedicationStatement) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWMedicationStatement",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWMedicationStatement",
        "path" : "TWMedicationStatement",
        "short" : "臺灣核心-用藥聲明(TW Core  MedicationStatement) 之資料模型",
        "definition" : "臺灣核心-用藥聲明(TW Core  MedicationStatement) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.identifier",
        "path" : "TWMedicationStatement.identifier",
        "short" : "用藥聲明的外部識別碼。",
        "definition" : "用藥聲明的外部識別碼。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.identifier"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.status",
        "path" : "TWMedicationStatement.status",
        "short" : "一個編碼概念，用以指明用藥聲明的當前狀態。",
        "definition" : "一個編碼概念，用以指明用藥聲明的當前狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.status"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.category",
        "path" : "TWMedicationStatement.category",
        "short" : "一個編碼概念，用以識別用藥聲明中包含的藥品預期將在哪裡被服用或用藥。",
        "definition" : "一個編碼概念，用以識別用藥聲明中包含的藥品預期將在哪裡被服用或用藥。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.category"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.medication",
        "path" : "TWMedicationStatement.medication",
        "short" : "服用的藥品。",
        "definition" : "服用的藥品。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.medication.medication",
        "path" : "TWMedicationStatement.medication.medication",
        "short" : "藥品的定義。",
        "definition" : "藥品的定義。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Medication"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.Medication"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.medication.code",
        "path" : "TWMedicationStatement.medication.code",
        "short" : "服用的藥品。",
        "definition" : "服用的藥品。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.Medication.code"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.subject",
        "path" : "TWMedicationStatement.subject",
        "short" : "用藥聲明的對象。",
        "definition" : "用藥聲明的對象。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.subject.patient",
        "path" : "TWMedicationStatement.subject.patient",
        "short" : "用藥聲明的某病人。",
        "definition" : "用藥聲明的某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.subject.group",
        "path" : "TWMedicationStatement.subject.group",
        "short" : "用藥聲明的某團體/群體。",
        "definition" : "用藥聲明的某團體/群體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.context",
        "path" : "TWMedicationStatement.context",
        "short" : "與此用藥聲明密切相關的就醫事件(Encounter / Episode)。",
        "definition" : "與此用藥聲明密切相關的就醫事件(Encounter / Episode)。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.context.encounter",
        "path" : "TWMedicationStatement.context.encounter",
        "short" : "與此用藥聲明密切相關的某就醫事件。",
        "definition" : "與此用藥聲明密切相關的某就醫事件。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Encounter"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.context.Reference(TW Core Encounter)"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.context.episodeOfCare",
        "path" : "TWMedicationStatement.context.episodeOfCare",
        "short" : "與此用藥聲明密切相關的某照護事件。",
        "definition" : "與此用藥聲明密切相關的某照護事件。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "EpisodeOfCare"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.context.Reference(episodeOfCare)"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.effective",
        "path" : "TWMedicationStatement.effective",
        "short" : "用藥的日期/時間或間隔。",
        "definition" : "用藥的日期/時間或間隔。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.effective"
          }
        ]
      },
      {
        "id" : "TWMedicationStatement.dosage",
        "path" : "TWMedicationStatement.dosage",
        "short" : "藥品現在如何被/曾經被服用或應該如何服用的細節。",
        "definition" : "藥品現在如何被/曾經被服用或應該如何服用的細節。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Dosage"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationStatement",
            "map" : "TWCoreMedicationStatement.dosage"
          }
        ]
      }
    ]
  }
}

```
