# 臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationRequest | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWMedicationRequestModel |

 
臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWMedicationRequest)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWMedicationRequest.csv), [Excel](StructureDefinition-TWMedicationRequest.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWMedicationRequest",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationRequest",
  "version" : "1.0.0",
  "name" : "TWMedicationRequestModel",
  "title" : "臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWMedicationRequest",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWMedicationRequest",
        "path" : "TWMedicationRequest",
        "short" : "臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型",
        "definition" : "臺灣核心-藥品請求(TW Core MedicationRequest) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.identifier",
        "path" : "TWMedicationRequest.identifier",
        "short" : "藥品請求的外部識別碼。",
        "definition" : "藥品請求的外部識別碼。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.identifier"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.status",
        "path" : "TWMedicationRequest.status",
        "short" : "藥品請求的狀態。",
        "definition" : "藥品請求的狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.status"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.intent",
        "path" : "TWMedicationRequest.intent",
        "short" : "藥品請求的意圖。",
        "definition" : "藥品請求的意圖。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.intent"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.category",
        "path" : "TWMedicationRequest.category",
        "short" : "藥品請求的類別。",
        "definition" : "藥品請求的類別。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.category"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.medication",
        "path" : "TWMedicationRequest.medication",
        "short" : "服用的藥品。",
        "definition" : "服用的藥品。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.medication.medication",
        "path" : "TWMedicationRequest.medication.medication",
        "short" : "藥品的定義。",
        "definition" : "藥品的定義。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Medication"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.medication.Reference(TW Core Medication)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.medication.code",
        "path" : "TWMedicationRequest.medication.code",
        "short" : "服用的藥品。",
        "definition" : "服用的藥品。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.medication"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.subject",
        "path" : "TWMedicationRequest.subject",
        "short" : "開立此藥品請求的對象。",
        "definition" : "開立此藥品請求的對象。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.subject.patient",
        "path" : "TWMedicationRequest.subject.patient",
        "short" : "開立此藥品請求的某病人。",
        "definition" : "開立此藥品請求的某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.subject.group",
        "path" : "TWMedicationRequest.subject.group",
        "short" : "開立此藥品請求的某團體/群體。",
        "definition" : "開立此藥品請求的某團體/群體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.encounter",
        "path" : "TWMedicationRequest.encounter",
        "short" : "與此藥品請求紀錄密切相關的就醫。",
        "definition" : "與此藥品請求紀錄密切相關的就醫。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Encounter"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.encounter.Reference(TW Core Encounter)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.authoredOn",
        "path" : "TWMedicationRequest.authoredOn",
        "short" : "藥品請求最初請求時間。",
        "definition" : "藥品請求最初請求時間。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.authoredOn"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.requester",
        "path" : "TWMedicationRequest.requester",
        "short" : "提出藥品請求的人／對象。",
        "definition" : "提出藥品請求的人／對象。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.requester.practitioner",
        "path" : "TWMedicationRequest.requester.practitioner",
        "short" : "提出藥品請求的某健康照護服務提供者。",
        "definition" : "提出藥品請求的某健康照護服務提供者。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.requester.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.requester.practitionerRole",
        "path" : "TWMedicationRequest.requester.practitionerRole",
        "short" : "提出藥品請求的某健康照護服務角色。",
        "definition" : "提出藥品請求的某健康照護服務角色。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.requester.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.requester.organization",
        "path" : "TWMedicationRequest.requester.organization",
        "short" : "提出藥品請求的某機構。",
        "definition" : "提出藥品請求的某機構。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.requester.Reference(TW Core Organization Hospital Department)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.requester.patient",
        "path" : "TWMedicationRequest.requester.patient",
        "short" : "提出藥品請求的某病人。",
        "definition" : "提出藥品請求的某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.requester.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.requester.relatedPerson",
        "path" : "TWMedicationRequest.requester.relatedPerson",
        "short" : "提出藥品請求的某相關人士。",
        "definition" : "提出藥品請求的某相關人士。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "RelatedPerson"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.requester.Reference(RelatedPerson)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.requester.device",
        "path" : "TWMedicationRequest.requester.device",
        "short" : "提出藥品請求的某設備。",
        "definition" : "提出藥品請求的某設備。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.requester.Reference(Device)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.reasonReference",
        "path" : "TWMedicationRequest.reasonReference",
        "short" : "開立處方的原因。",
        "definition" : "開立處方的原因。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.reasonReference.condition",
        "path" : "TWMedicationRequest.reasonReference.condition",
        "short" : "開立處方的病情、問題或診斷原因。",
        "definition" : "開立處方的病情、問題或診斷原因。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Condition"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.reasonReference.Reference(TW Core Condition)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.reasonReference.observation",
        "path" : "TWMedicationRequest.reasonReference.observation",
        "short" : "開立處方的檢驗檢查原因。",
        "definition" : "開立處方的檢驗檢查原因。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Observation"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.reasonReference.Reference(TW Core Observation Laboratory Result)"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.note",
        "path" : "TWMedicationRequest.note",
        "short" : "關於處方的資訊。",
        "definition" : "關於處方的資訊。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Annotation"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.note"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.dosageInstruction",
        "path" : "TWMedicationRequest.dosageInstruction",
        "short" : "應該如何用藥。",
        "definition" : "應該如何用藥。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Dosage"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.dosageInstruction"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.dispenseRequest",
        "path" : "TWMedicationRequest.dispenseRequest",
        "short" : "藥品供應授權。",
        "definition" : "藥品供應授權。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.dispenseRequest"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.dispenseRequest.validityPeriod",
        "path" : "TWMedicationRequest.dispenseRequest.validityPeriod",
        "short" : "處方可用以配藥的有效期限。",
        "definition" : "處方可用以配藥的有效期限。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.dispenseRequest.validityPeriod"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "path" : "TWMedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "short" : "可重複領藥的次數。",
        "definition" : "可重複領藥的次數。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "unsignedInt"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.dispenseRequest.numberOfRepeatsAllowed"
          }
        ]
      },
      {
        "id" : "TWMedicationRequest.dispenseRequest.expectedSupplyDuration",
        "path" : "TWMedicationRequest.dispenseRequest.expectedSupplyDuration",
        "short" : "每次配藥可持續的天數。",
        "definition" : "每次配藥可持續的天數。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Duration"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationRequest",
            "map" : "TWCoreMedicationRequest.dispenseRequest.expectedSupplyDuration"
          }
        ]
      }
    ]
  }
}

```
