# 臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationDispense | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWMedicationDispenseModel |

 
臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWMedicationDispense)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWMedicationDispense.csv), [Excel](StructureDefinition-TWMedicationDispense.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWMedicationDispense",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationDispense",
  "version" : "1.0.0",
  "name" : "TWMedicationDispenseModel",
  "title" : "臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWMedicationDispense",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWMedicationDispense",
        "path" : "TWMedicationDispense",
        "short" : "臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型",
        "definition" : "臺灣核心-配藥或藥品調劑(TW Core MedicationDispense) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.identifier",
        "path" : "TWMedicationDispense.identifier",
        "short" : "配藥/藥品調劑的外部識別碼。",
        "definition" : "配藥/藥品調劑的外部識別碼。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.identifier"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.status",
        "path" : "TWMedicationDispense.status",
        "short" : "一個編碼概念，用以具體說明配藥/藥品調劑事件的狀態。",
        "definition" : "一個編碼概念，用以具體說明配藥/藥品調劑事件的狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.status"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.category",
        "path" : "TWMedicationDispense.category",
        "short" : "配藥/藥品調劑的類別，描述預期將服用或用藥的地點之代碼。",
        "definition" : "配藥/藥品調劑的類別，描述預期將服用或用藥的地點之代碼。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.category"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.medication",
        "path" : "TWMedicationDispense.medication",
        "short" : "服用的藥品。",
        "definition" : "服用的藥品。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.medication.medication",
        "path" : "TWMedicationDispense.medication.medication",
        "short" : "藥品的定義。",
        "definition" : "藥品的定義。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Medication"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.Medication"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.medication.code",
        "path" : "TWMedicationDispense.medication.code",
        "short" : "服用的藥品。",
        "definition" : "服用的藥品。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.Medication.code"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.subject",
        "path" : "TWMedicationDispense.subject",
        "short" : "配藥/藥品調劑的對象。",
        "definition" : "配藥/藥品調劑的對象。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.subject.patient",
        "path" : "TWMedicationDispense.subject.patient",
        "short" : "配藥/藥品調劑的某病人。",
        "definition" : "配藥/藥品調劑的某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.subject.group",
        "path" : "TWMedicationDispense.subject.group",
        "short" : "配藥/藥品調劑的某團體/群體。",
        "definition" : "配藥/藥品調劑的某團體/群體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.context",
        "path" : "TWMedicationDispense.context",
        "short" : "與此配藥/藥品調劑密切相關的就醫事件(Encounter/Episode)。",
        "definition" : "與此配藥/藥品調劑密切相關的就醫事件(Encounter/Episode)。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Encounter"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.context.Reference(TW Core Encounter)"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.performer",
        "path" : "TWMedicationDispense.performer",
        "short" : "執行此配藥/藥品調劑的人員。",
        "definition" : "執行此配藥/藥品調劑的人員。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.performer"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.authorizingPrescription",
        "path" : "TWMedicationDispense.authorizingPrescription",
        "short" : "授權此配藥/藥品調劑的處方。",
        "definition" : "授權此配藥/藥品調劑的處方。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "MedicationRequest"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.authorizingPrescription.Reference(TW Core MedicationRequest)"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.type",
        "path" : "TWMedicationDispense.type",
        "short" : "執行的配藥/藥品調劑事件類型。例如：試用填充、試用完成、部分填充、緊急填充、樣品等",
        "definition" : "執行的配藥/藥品調劑事件類型。例如：試用填充、試用完成、部分填充、緊急填充、樣品等",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.type"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.quantity",
        "path" : "TWMedicationDispense.quantity",
        "short" : "配藥/藥品調劑的量。",
        "definition" : "配藥/藥品調劑的量。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.quantity"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.whenHandedOver",
        "path" : "TWMedicationDispense.whenHandedOver",
        "short" : "藥品發放的時間。",
        "definition" : "藥品發放的時間。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.whenHandedOver"
          }
        ]
      },
      {
        "id" : "TWMedicationDispense.dosageInstruction",
        "path" : "TWMedicationDispense.dosageInstruction",
        "short" : "應該如何用藥或者由照護者給藥。",
        "definition" : "應該如何用藥或者由照護者給藥。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Dosage"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedicationDispense",
            "map" : "TWCoreMedicationDispense.dosageInstruction"
          }
        ]
      }
    ]
  }
}

```
