# 臺灣核心-藥品(TW Core Medication) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-藥品(TW Core Medication) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedication | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWMedicationModel |

 
臺灣核心-藥品(TW Core Medication) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWMedication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWMedication.csv), [Excel](StructureDefinition-TWMedication.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWMedication",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedication",
  "version" : "1.0.0",
  "name" : "TWMedicationModel",
  "title" : "臺灣核心-藥品(TW Core Medication) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-藥品(TW Core Medication) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWMedication",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWMedication",
        "path" : "TWMedication",
        "short" : "臺灣核心-藥品(TW Core Medication) 之資料模型",
        "definition" : "臺灣核心-藥品(TW Core Medication) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWMedication",
            "map" : "TWCoreMedication"
          }
        ]
      },
      {
        "id" : "TWMedication.code",
        "path" : "TWMedication.code",
        "short" : "指明這種藥品的代碼。",
        "definition" : "指明這種藥品的代碼。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedication",
            "map" : "TWCoreMedication.code"
          }
        ]
      },
      {
        "id" : "TWMedication.form",
        "path" : "TWMedication.form",
        "short" : "藥品劑型。",
        "definition" : "藥品劑型。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedication",
            "map" : "TWCoreMedication.form"
          }
        ]
      }
    ]
  }
}

```
