# 臺灣核心-多媒體(TW Core Media) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-多媒體(TW Core Media) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedia | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWMediaModel |

 
臺灣核心-多媒體(TW Core Media) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWMedia)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWMedia.csv), [Excel](StructureDefinition-TWMedia.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWMedia",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedia",
  "version" : "1.0.0",
  "name" : "TWMediaModel",
  "title" : "臺灣核心-多媒體(TW Core Media) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-多媒體(TW Core Media) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWMedia",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWMedia",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWMedia",
        "path" : "TWMedia",
        "short" : "臺灣核心-多媒體(TW Core Media) 之資料模型",
        "definition" : "臺灣核心-多媒體(TW Core Media) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWMedia",
            "map" : "TWCoreMedia"
          }
        ]
      },
      {
        "id" : "TWMedia.subject",
        "path" : "TWMedia.subject",
        "short" : "多媒體的對象。",
        "definition" : "多媒體的對象。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWMedia.subject.patient",
        "path" : "TWMedia.subject.patient",
        "short" : "多媒體的某病人。",
        "definition" : "多媒體的某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedia",
            "map" : "TWCoreMedia.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWMedia.subject.practitioner",
        "path" : "TWMedia.subject.practitioner",
        "short" : "多媒體的某健康照護服務提供者。",
        "definition" : "多媒體的某健康照護服務提供者。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedia",
            "map" : "TWCoreMedia.subject.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWMedia.subject.practitionerRole",
        "path" : "TWMedia.subject.practitionerRole",
        "short" : "多媒體的某健康照護服務角色。",
        "definition" : "多媒體的某健康照護服務角色。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedia",
            "map" : "TWCoreMedia.subject.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWMedia.subject.group",
        "path" : "TWMedia.subject.group",
        "short" : "多媒體的某團體/群體。",
        "definition" : "多媒體的某團體/群體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedia",
            "map" : "TWCoreMedia.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWMedia.subject.device",
        "path" : "TWMedia.subject.device",
        "short" : "多媒體的某設備。",
        "definition" : "多媒體的某設備。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedia",
            "map" : "TWCoreMedia.subject.Reference(Device)"
          }
        ]
      },
      {
        "id" : "TWMedia.subject.specimen",
        "path" : "TWMedia.subject.specimen",
        "short" : "多媒體的某檢體。",
        "definition" : "多媒體的某檢體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Specimen"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedia",
            "map" : "TWCoreMedia.subject.Reference(TW Core Specimen)"
          }
        ]
      },
      {
        "id" : "TWMedia.subject.location",
        "path" : "TWMedia.subject.location",
        "short" : "多媒體的某地點。",
        "definition" : "多媒體的某地點。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Location"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWMedia",
            "map" : "TWCoreMedia.subject.Reference(TW Core Location)"
          }
        ]
      }
    ]
  }
}

```
