# 臺灣核心-地點(TW Core Location) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-地點(TW Core Location) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWLocation | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWLocationModel |

 
臺灣核心-地點(TW Core Location) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWLocation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWLocation.csv), [Excel](StructureDefinition-TWLocation.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWLocation",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWLocation",
  "version" : "1.0.0",
  "name" : "TWLocationModel",
  "title" : "臺灣核心-地點(TW Core Location) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-地點(TW Core Location) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWLocation",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWLocation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWLocation",
        "path" : "TWLocation",
        "short" : "臺灣核心-地點(TW Core Location) 之資料模型",
        "definition" : "臺灣核心-地點(TW Core Location) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWLocation",
            "map" : "TWCoreLocation"
          }
        ]
      },
      {
        "id" : "TWLocation.status",
        "path" : "TWLocation.status",
        "short" : "地點的狀態，指示該地點是否仍在使用中。",
        "definition" : "地點的狀態，指示該地點是否仍在使用中。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWLocation",
            "map" : "TWCoreLocation.status"
          }
        ]
      },
      {
        "id" : "TWLocation.name",
        "path" : "TWLocation.name",
        "short" : "地點的名稱。",
        "definition" : "地點的名稱。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWLocation",
            "map" : "TWCoreLocation.name"
          }
        ]
      },
      {
        "id" : "TWLocation.telecom",
        "path" : "TWLocation.telecom",
        "short" : "地點的聯絡細節。",
        "definition" : "地點的聯絡細節。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWLocation",
            "map" : "TWCoreLocation.telecom"
          }
        ]
      },
      {
        "id" : "TWLocation.address",
        "path" : "TWLocation.address",
        "short" : "使用郵政規範表達的地址（相對於GPS或其他位置定義格式）",
        "definition" : "使用郵政規範表達的地址（相對於GPS或其他位置定義格式）",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWLocation",
            "map" : "TWCoreLocation.address"
          }
        ]
      },
      {
        "id" : "TWLocation.managingOrganization",
        "path" : "TWLocation.managingOrganization",
        "short" : "負責地點的提供與維護之組織。",
        "definition" : "負責地點的提供與維護之組織。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWLocation",
            "map" : "TWCoreLocation.managingOrganization"
          }
        ]
      }
    ]
  }
}

```
