# 臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWImagingStudy | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWImagingStudyModel |

 
臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWImagingStudy)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWImagingStudy.csv), [Excel](StructureDefinition-TWImagingStudy.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWImagingStudy",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWImagingStudy",
  "version" : "1.0.0",
  "name" : "TWImagingStudyModel",
  "title" : "臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWImagingStudy",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWImagingStudy",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWImagingStudy",
        "path" : "TWImagingStudy",
        "short" : "臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型",
        "definition" : "臺灣核心-影像檢查(TW Core ImagingStudy) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.identifier",
        "path" : "TWImagingStudy.identifier",
        "short" : "整個影像檢查的識別碼。",
        "definition" : "整個影像檢查的識別碼。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.identifier"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.modality",
        "path" : "TWImagingStudy.modality",
        "short" : "如果是實際的照影儀器，所有系列的儀器。",
        "definition" : "如果是實際的照影儀器，所有系列的儀器。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.modality"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.subject",
        "path" : "TWImagingStudy.subject",
        "short" : "影像檢查的對象。",
        "definition" : "影像檢查的對象。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.subject.patient",
        "path" : "TWImagingStudy.subject.patient",
        "short" : "影像檢查的某病人。",
        "definition" : "影像檢查的某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.subject.device",
        "path" : "TWImagingStudy.subject.device",
        "short" : "影像檢查的某設備。",
        "definition" : "影像檢查的某設備。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.subject.Reference(Device)"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.subject.group",
        "path" : "TWImagingStudy.subject.group",
        "short" : "影像檢查的某團體/群體。",
        "definition" : "影像檢查的某團體/群體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.started",
        "path" : "TWImagingStudy.started",
        "short" : "影像檢查何時開始。",
        "definition" : "影像檢查何時開始。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.started"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.procedureCode",
        "path" : "TWImagingStudy.procedureCode",
        "short" : "影像檢查的處置或手術代碼。",
        "definition" : "影像檢查的處置或手術代碼。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.procedureCode"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.reasonCode",
        "path" : "TWImagingStudy.reasonCode",
        "short" : "為什麼進行影像檢查。",
        "definition" : "為什麼進行影像檢查。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.reasonCode"
          }
        ]
      },
      {
        "id" : "TWImagingStudy.series",
        "path" : "TWImagingStudy.series",
        "short" : "每項影像檢查有一個或多個實例系列。",
        "definition" : "每項影像檢查有一個或多個實例系列。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWImagingStudy",
            "map" : "TWCoreImagingStudy.series"
          }
        ]
      }
    ]
  }
}

```
