# 臺灣核心-就醫事件(TW Core Encounter) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-就醫事件(TW Core Encounter) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWEncounter | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWEncounterModel |

 
臺灣核心-就醫事件(TW Core Encounter) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWEncounter)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWEncounter.csv), [Excel](StructureDefinition-TWEncounter.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWEncounter",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWEncounter",
  "version" : "1.0.0",
  "name" : "TWEncounterModel",
  "title" : "臺灣核心-就醫事件(TW Core Encounter) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-就醫事件(TW Core Encounter) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWEncounter",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWEncounter",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWEncounter",
        "path" : "TWEncounter",
        "short" : "臺灣核心-就醫事件(TW Core Encounter) 之資料模型",
        "definition" : "臺灣核心-就醫事件(TW Core Encounter) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter"
          }
        ]
      },
      {
        "id" : "TWEncounter.identifier",
        "path" : "TWEncounter.identifier",
        "short" : "就醫事件的識別碼。",
        "definition" : "就醫事件的識別碼。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.identifier"
          }
        ]
      },
      {
        "id" : "TWEncounter.status",
        "path" : "TWEncounter.status",
        "short" : "就醫現況。",
        "definition" : "就醫現況。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.status"
          }
        ]
      },
      {
        "id" : "TWEncounter.class",
        "path" : "TWEncounter.class",
        "short" : "就醫的分類。",
        "definition" : "就醫的分類。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Coding"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.class"
          }
        ]
      },
      {
        "id" : "TWEncounter.serviceType",
        "path" : "TWEncounter.serviceType",
        "short" : "服務的特定型別。",
        "definition" : "服務的特定型別。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.serviceType"
          }
        ]
      },
      {
        "id" : "TWEncounter.subject",
        "path" : "TWEncounter.subject",
        "short" : "就醫的病人或實體集合（Group）。",
        "definition" : "就醫的病人或實體集合（Group）。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWEncounter.subject.patient",
        "path" : "TWEncounter.subject.patient",
        "short" : "就醫的病人。",
        "definition" : "就醫的病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWEncounter.subject.group",
        "path" : "TWEncounter.subject.group",
        "short" : "就醫的實體集合。",
        "definition" : "就醫的實體集合。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWEncounter.participant",
        "path" : "TWEncounter.participant",
        "short" : "參與就醫的健康照護服務提供者。",
        "definition" : "參與就醫的健康照護服務提供者。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.participant"
          }
        ]
      },
      {
        "id" : "TWEncounter.period",
        "path" : "TWEncounter.period",
        "short" : "就醫的開始和結束時間。",
        "definition" : "就醫的開始和結束時間。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.period"
          }
        ]
      },
      {
        "id" : "TWEncounter.reasonCode",
        "path" : "TWEncounter.reasonCode",
        "short" : "發生此就醫事件的原因。",
        "definition" : "發生此就醫事件的原因。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.reasonCode"
          }
        ]
      },
      {
        "id" : "TWEncounter.dischargeDisposition",
        "path" : "TWEncounter.dischargeDisposition",
        "short" : "出院後的地點類別或種類。",
        "definition" : "出院後的地點類別或種類。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.hospitalization.dischargeDisposition"
          }
        ]
      },
      {
        "id" : "TWEncounter.location",
        "path" : "TWEncounter.location",
        "short" : "病人曾去過的一個或多個地點。",
        "definition" : "病人曾去過的一個或多個地點。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWEncounter",
            "map" : "TWCoreEncounter.location"
          }
        ]
      }
    ]
  }
}

```
