# 臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWDiagnosticReport | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWDiagnosticReportModel |

 
臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWDiagnosticReport)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWDiagnosticReport.csv), [Excel](StructureDefinition-TWDiagnosticReport.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWDiagnosticReport",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWDiagnosticReport",
  "version" : "1.0.0",
  "name" : "TWDiagnosticReportModel",
  "title" : "臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWDiagnosticReport",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWDiagnosticReport",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWDiagnosticReport",
        "path" : "TWDiagnosticReport",
        "short" : "臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型",
        "definition" : "臺灣核心-診斷報告(TW Core DiagnosticReport) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.status",
        "path" : "TWDiagnosticReport.status",
        "short" : "診斷報告的狀態。",
        "definition" : "診斷報告的狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.status"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.category",
        "path" : "TWDiagnosticReport.category",
        "short" : "診斷報告的類別。",
        "definition" : "診斷報告的類別。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.category"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.code",
        "path" : "TWDiagnosticReport.code",
        "short" : "診斷報告。",
        "definition" : "診斷報告。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.code"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.subject",
        "path" : "TWDiagnosticReport.subject",
        "short" : "診斷對象。",
        "definition" : "診斷對象。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.subject.patient",
        "path" : "TWDiagnosticReport.subject.patient",
        "short" : "診斷某病人。",
        "definition" : "診斷某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.subject.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.subject.group",
        "path" : "TWDiagnosticReport.subject.group",
        "short" : "診斷某團體/群體。",
        "definition" : "診斷某團體/群體。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Group"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.subject.Reference(Group)"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.subject.device",
        "path" : "TWDiagnosticReport.subject.device",
        "short" : "診斷某設備。",
        "definition" : "診斷某設備。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Device"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.subject.Reference(Device)"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.subject.location",
        "path" : "TWDiagnosticReport.subject.location",
        "short" : "診斷某地點。",
        "definition" : "診斷某地點。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Location"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.subject.Reference(TW Core Location)"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.effective",
        "path" : "TWDiagnosticReport.effective",
        "short" : "臨床相關報告時間。",
        "definition" : "臨床相關報告時間。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.effective[x]"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.issued",
        "path" : "TWDiagnosticReport.issued",
        "short" : "診斷報告時間。",
        "definition" : "診斷報告時間。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.issued"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.performer",
        "path" : "TWDiagnosticReport.performer",
        "short" : "負責此診斷報告人員/機構。",
        "definition" : "負責此診斷報告人員/機構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.performer.practitioner",
        "path" : "TWDiagnosticReport.performer.practitioner",
        "short" : "負責此診斷的某健康照護服務提供。",
        "definition" : "負責此診斷的某健康照護服務提供者。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.performer.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.performer.practitionerRole",
        "path" : "TWDiagnosticReport.performer.practitionerRole",
        "short" : "負責此診斷的某健康照護服務角色。",
        "definition" : "負責此診斷的某健康照護服務角色。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.performer.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.performer.organization",
        "path" : "TWDiagnosticReport.performer.organization",
        "short" : "負責此診斷的某機構。",
        "definition" : "負責此診斷的某機構。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Organization"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.performer.Reference(TW Core Organization)"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.performer.careTeam",
        "path" : "TWDiagnosticReport.performer.careTeam",
        "short" : "負責此診斷的某照護團隊。",
        "definition" : "負責此診斷的某照護團隊。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CareTeam"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.performer.Reference(CareTeam)"
          }
        ]
      },
      {
        "id" : "TWDiagnosticReport.result",
        "path" : "TWDiagnosticReport.result",
        "short" : "診斷報告結果。",
        "definition" : "診斷報告結果。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Observation"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWDiagnosticReport",
            "map" : "TWCoreDiagnosticReport.result"
          }
        ]
      }
    ]
  }
}

```
