# 臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWCondition | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWConditionModel |

 
臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWCondition)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWCondition.csv), [Excel](StructureDefinition-TWCondition.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWCondition",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWCondition",
  "version" : "1.0.0",
  "name" : "TWConditionModel",
  "title" : "臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWCondition",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWCondition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWCondition",
        "path" : "TWCondition",
        "short" : "臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型",
        "definition" : "臺灣核心-病情、問題或診斷(TW Core Condition) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition"
          }
        ]
      },
      {
        "id" : "TWCondition.clinicalStatus",
        "path" : "TWCondition.clinicalStatus",
        "short" : "病情、問題或診斷的臨床狀態。",
        "definition" : "病情、問題或診斷的臨床狀態。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.clinicalStatus"
          }
        ]
      },
      {
        "id" : "TWCondition.verificationStatus",
        "path" : "TWCondition.verificationStatus",
        "short" : "病情、問題或診斷的臨床狀態的驗證狀態。",
        "definition" : "病情、問題或診斷的臨床狀態的驗證狀態。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.verificationStatus"
          }
        ]
      },
      {
        "id" : "TWCondition.category",
        "path" : "TWCondition.category",
        "short" : "病情、問題或診斷的類別。",
        "definition" : "病情、問題或診斷的類別。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.category"
          }
        ]
      },
      {
        "id" : "TWCondition.severity",
        "path" : "TWCondition.severity",
        "short" : "病情、問題或診斷的主觀嚴重程度。",
        "definition" : "病情、問題或診斷的主觀嚴重程度。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.severity"
          }
        ]
      },
      {
        "id" : "TWCondition.code",
        "path" : "TWCondition.code",
        "short" : "病情、問題或診斷的識別。",
        "definition" : "病情、問題或診斷的識別。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.code"
          }
        ]
      },
      {
        "id" : "TWCondition.bodySite",
        "path" : "TWCondition.bodySite",
        "short" : "解剖位置。",
        "definition" : "解剖位置。",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.bodySite"
          }
        ]
      },
      {
        "id" : "TWCondition.subject",
        "path" : "TWCondition.subject",
        "short" : "有此病情、問題或診斷的病人。",
        "definition" : "有此病情、問題或診斷的病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.subject.Reference(TW Core Patient | Group)"
          }
        ]
      },
      {
        "id" : "TWCondition.onset",
        "path" : "TWCondition.onset",
        "short" : "估計的或實際的日期。",
        "definition" : "估計的或實際的日期。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.onsetDateTime"
          }
        ]
      },
      {
        "id" : "TWCondition.abatement",
        "path" : "TWCondition.abatement",
        "short" : "何時解決/緩解。",
        "definition" : "何時解決/緩解。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.abatement.as(dateTime)"
          }
        ]
      },
      {
        "id" : "TWCondition.asserter",
        "path" : "TWCondition.asserter",
        "short" : "聲稱有此病情、問題或診斷的人。",
        "definition" : "聲稱有此病情、問題或診斷的人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "TWCondition.asserter.practitioner",
        "path" : "TWCondition.asserter.practitioner",
        "short" : "聲稱有此病情、問題或診斷的某健康照護服務提供者。",
        "definition" : "聲稱有此病情、問題或診斷的某健康照護服務提供者。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Practitioner"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.asserter.Reference(TW Core Practitioner)"
          }
        ]
      },
      {
        "id" : "TWCondition.asserter.practitionerRole",
        "path" : "TWCondition.asserter.practitionerRole",
        "short" : "聲稱有此病情、問題或診斷的某健康照護服務角色。",
        "definition" : "聲稱有此病情、問題或診斷的某健康照護服務角色。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "PractitionerRole"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.asserter.Reference(TW Core PractitionerRole)"
          }
        ]
      },
      {
        "id" : "TWCondition.asserter.patient",
        "path" : "TWCondition.asserter.patient",
        "short" : "聲稱有此病情、問題或診斷的某病人。",
        "definition" : "聲稱有此病情、問題或診斷的某病人。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Patient"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.asserter.Reference(TW Core Patient)"
          }
        ]
      },
      {
        "id" : "TWCondition.asserter.relatedPerson",
        "path" : "TWCondition.asserter.relatedPerson",
        "short" : "聲稱有此病情、問題或診斷的某相關人士。",
        "definition" : "聲稱有此病情、問題或診斷的某相關人士。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "RelatedPerson"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWCondition",
            "map" : "TWCoreCondition.asserter.Reference(RelatedPerson)"
          }
        ]
      }
    ]
  }
}

```
