# 臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型 - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Logical Model: 臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWBundle | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWBundleModel |

 
臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/TWBundle)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-TWBundle.csv), [Excel](StructureDefinition-TWBundle.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "TWBundle",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWBundle",
  "version" : "1.0.0",
  "name" : "TWBundleModel",
  "title" : "臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "TWBundle",
      "uri" : "https://twcore.mohw.gov.tw/ig/twcore",
      "name" : "TW Core IG"
    }
  ],
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/TWBundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "TWBundle",
        "path" : "TWBundle",
        "short" : "臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型",
        "definition" : "臺灣核心-資料交換基本單位(TW Core Bundle) 之資料模型",
        "mapping" : [
          {
            "identity" : "TWBundle",
            "map" : "TWCoreBundle"
          }
        ]
      },
      {
        "id" : "TWBundle.identifier",
        "path" : "TWBundle.identifier",
        "short" : "一組Reources的捆綁/打包/捆包(Bundle)的識別碼。",
        "definition" : "一組Reources的捆綁/打包/捆包(Bundle)的識別碼。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWBundle",
            "map" : "TWCoreBundle.identifier"
          }
        ]
      },
      {
        "id" : "TWBundle.timestamp",
        "path" : "TWBundle.timestamp",
        "short" : "組成Bundle的時間。",
        "definition" : "組成Bundle的時間。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ],
        "mapping" : [
          {
            "identity" : "TWBundle",
            "map" : "TWCoreBundle.timestamp"
          }
        ]
      }
    ]
  }
}

```
