# TW Core Specimen - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Specimen 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreSpecimen |

 
此臺灣核心-檢體（TW Core Specimen） Profile說明本IG如何進一步定義FHIR的Specimen Resource以呈現檢體的詳細資料。 

## Resource Specimen - 內容

用於分析的樣本。

### 範圍與使用

任何物質樣本：

* 來自生物實體，無論是活著或死亡的
* 來自實體物件或環境

有些檢體（Specimen）是生物性的，可能包含一個或多個組成部分，這些部分包括但不限於細胞分子、細胞、組織、器官、體液、胚胎以及身體排泄物（來源：[NCI Thesaurus](http://ncit.nci.nih.gov/)修改後）。

Specimen resource 涵蓋了用於診斷和環境檢測的物質。Specimen resource 的焦點（focus）在於檢體的採集、維護和處理過程，以及檢體的來源地。這與使用 Substance resource 的情況不同，只有在這些其他方面不適用時，才會使用 Substance。

### 背景

Specimen resource 的定義只包括關於檢體容器的基本資訊，但未涉及容器之間可能存在的層級關係，或是一個容器在其上級容器中位置的追蹤問題（例如：一個試管位於托盤中，該托盤又放在架子上，而架子則存放在冷凍櫃中）。這些資料項目被追蹤的頻率可能會根據使用情境有所不同，比如是在一般的實驗室中使用，還是在生物銀行等特定場合。

此 resource 被診斷報告 （[DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)）、影像檢查 （[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、多媒體 （[Media](StructureDefinition-Media-twcore.md)）、分子序列 （[MolecularSequence](https://hl7.org/fhir/R4/molecularsequence.html#MolecularSequence)）、檢驗檢查 （[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）、服務請求 （[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）及檢體（[Specimen](StructureDefinition-Specimen-twcore.md)）所參照。

**Usages:**

* Refer to this Profile: [TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md), [TW Core Media](StructureDefinition-Media-twcore.md), [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md), [TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md)...Show 19 more,[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)and[TW Core Specimen](StructureDefinition-Specimen-twcore.md)
* Examples for this Profile: [Specimen/spe-ance-example](Specimen-spe-ance-example.md), [Specimen/spe-blood-example](Specimen-spe-blood-example.md), [Specimen/spe-stool-example](Specimen-spe-stool-example.md) and [Specimen/spe-ur-example](Specimen-spe-ur-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Specimen-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Specimen-twcore.csv), [Excel](StructureDefinition-Specimen-twcore.xlsx), [Schematron](StructureDefinition-Specimen-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Specimen-id.md)**查詢所有Specimen：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Specimen?_id=[id]`
`GET [base]/Specimen/[id]`例子：
(1) GET [base]/Specimen?_id=spe-blood-example
(2) GET [base]/Specimen/spe-blood-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-Specimen-status.md)**查詢所有Specimen：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Specimen?status=[code]`例子：
(1) GET [base]/Specimen?status=available
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-Specimen-identifier.md)**查詢所有Specimen：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Specimen?identifier={system|}[code]`例子：
(1) GET [base]/Specimen?identifier=https://www.tph.mohw.gov.tw|1a3f5b7d-9e2c-4f6a-8c1e-0b2d4e6f8a9c
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Specimen-subject.md)**查詢所有Specimen：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Specimen?subject={Type/}[id]`例子：:
(1) GET [base]/Specimen?subject=Patient/pat-example



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Specimen-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreSpecimen",
  "title" : "TW Core Specimen",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-檢體（TW Core Specimen） Profile說明本IG如何進一步定義FHIR的Specimen Resource以呈現檢體的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Specimen",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Specimen",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Specimen",
        "path" : "Specimen",
        "short" : "用於分析的檢體",
        "definition" : "用於分析的檢體"
      },
      {
        "id" : "Specimen.id",
        "path" : "Specimen.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Specimen紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Specimen.meta",
        "path" : "Specimen.meta",
        "short" : "此Specimen Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Specimen.implicitRules",
        "path" : "Specimen.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Specimen.language",
        "path" : "Specimen.language",
        "short" : "用以表述Specimen Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Specimen.text",
        "path" : "Specimen.text",
        "short" : "Specimen Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Specimen.identifier",
        "path" : "Specimen.identifier",
        "short" : "檢體的外部識別碼",
        "definition" : "檢體的ID",
        "mustSupport" : true
      },
      {
        "id" : "Specimen.accessionIdentifier",
        "path" : "Specimen.accessionIdentifier",
        "short" : "實驗室指定的識別碼",
        "definition" : "當實驗室接收檢體時，會給檢體一個特定的編號。這個編號和檢體本身的識別碼可能不一樣，這取決於每個實驗室的操作方式。"
      },
      {
        "id" : "Specimen.status",
        "path" : "Specimen.status",
        "definition" : "檢體的可取得性",
        "comment" : "此資料項目被標記為修飾用(modifier)，因為狀態包含標記 resource 為當前無效的代碼。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SpecimenStatus"
            }
          ],
          "strength" : "required",
          "description" : "檢體的可取得性；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/specimen-status|4.0.1"
        }
      },
      {
        "id" : "Specimen.type",
        "path" : "Specimen.type",
        "short" : "檢體的種類",
        "definition" : "檢體是由什麼類型的物質組成的",
        "comment" : "檢體的類型會影響其處理方式，並決定了可以對檢體進行哪些適當的分析。這在診斷工作流程的決策系統中經常被使用。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0487"
        }
      },
      {
        "id" : "Specimen.subject",
        "path" : "Specimen.subject",
        "short" : "檢體取自哪邊？檢體的來源可能有幾種，它可能來自病人，來自某個地方（例如：從環境中取得的樣本），或者是對某種物質或設備的抽樣。",
        "definition" : "檢體取自哪邊？檢體的來源可能有幾種，它可能來自病人，來自某個地方（例如：從環境中取得的樣本），或者是對某種物質或設備的抽樣。",
        "requirements" : "必須了解檢體取得對象的情境背景",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Substance",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Specimen.receivedTime",
        "path" : "Specimen.receivedTime",
        "short" : "收到此檢體進行處理的時間",
        "definition" : "收到檢體進行處理或檢驗的時間"
      },
      {
        "id" : "Specimen.parent",
        "path" : "Specimen.parent",
        "short" : "此檢體的來源檢體",
        "definition" : "母體（來源）檢體的參考，當檢體來自另一檢體或為另一檢體的組成部分時使用。",
        "comment" : "母樣本可以是當前檢體通過某些處理步驟（如等分、分離或從臨床樣本中提取核酸）獲得的來源，也可以是合併成集合樣本的許多樣本之一。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.request",
        "path" : "Specimen.request",
        "short" : "採集檢體的原因",
        "definition" : "需要採集檢體的服務請求的相關細節",
        "comment" : "請求可以是明確的，也可以是隱含的，例如需要抽血採樣的服務請求(ServiceRequest)。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection",
        "path" : "Specimen.collection",
        "short" : "採集細節",
        "definition" : "有關檢體採集的詳細資訊"
      },
      {
        "id" : "Specimen.collection.collector",
        "path" : "Specimen.collection.collector",
        "short" : "誰採集了檢體",
        "definition" : "採集檢體的人員",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Specimen.collection.collected[x]",
        "path" : "Specimen.collection.collected[x]",
        "short" : "採集檢體的時間",
        "definition" : "從檢體對象採集檢體的時間--生理相關時間。生理相關時間是指生理狀態或生物活動達到特定條件或狀態時所收集的時間點。"
      },
      {
        "id" : "Specimen.collection.duration",
        "path" : "Specimen.collection.duration",
        "short" : "採集檢體需要多長時間",
        "definition" : "採集檢體的時間長度"
      },
      {
        "id" : "Specimen.collection.quantity",
        "path" : "Specimen.collection.quantity",
        "short" : "採集檢體的數量",
        "definition" : "檢體採集的數量，例如：血樣的體積，或測量解剖病理樣本的實際尺寸或特性。"
      },
      {
        "id" : "Specimen.collection.method",
        "path" : "Specimen.collection.method",
        "short" : "用於執行檢體採集的技術",
        "definition" : "一個編碼值，具體說明用於執行此程序的技術。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/specimen-collection-method"
        }
      },
      {
        "id" : "Specimen.collection.bodySite",
        "path" : "Specimen.collection.bodySite",
        "short" : "解剖採集部位",
        "definition" : "檢體採集的解剖位置（如果檢體對象是病人），這是指目標部位，此資料項目不適用於環境檢體。",
        "comment" : "如果特定的使用情境需要將 BodySite 視為一個獨立的 resource，而不是內置的資料項目（例如：需要單獨辨識和追蹤），那麼可以使用名為 bodySite 的擴充資料項目來處理它。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Specimen.collection.fastingStatus[x]",
        "path" : "Specimen.collection.fastingStatus[x]",
        "short" : "病人是否禁食/禁飲料，或禁食/禁飲料多長時間",
        "definition" : "在採集檢體前的一段時間內，禁食或減少部分或全部食物、飲料或兩者。",
        "comment" : "比起使用Observation.code=LOINC 2005-7（2小時尿液中的鈣[Moles/​time] - 禁食12小時）或者使用Observation.component code = LOINC 49541-6（禁食狀態 - 報告）這樣的「先組合配對/前組合式(pre-coordinated)」代碼，更推薦使用此資料項目來表示禁食狀態。",
        "requirements" : "許多診斷測試需要禁食，以便準確判讀。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          },
          {
            "code" : "Duration"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "FastingStatus"
            }
          ],
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0916"
        }
      },
      {
        "id" : "Specimen.processing",
        "path" : "Specimen.processing",
        "short" : "處理和處理步驟細節",
        "definition" : "有關檢體處理和處理步驟的細節資訊"
      },
      {
        "id" : "Specimen.processing.description",
        "path" : "Specimen.processing.description",
        "short" : "程序的文字描述",
        "definition" : "程序的文字描述"
      },
      {
        "id" : "Specimen.processing.procedure",
        "path" : "Specimen.processing.procedure",
        "short" : "表明應用於檢體的處理步驟",
        "definition" : "一個編碼值，具體說明用於處理檢體的程序。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SpecimenProcessingProcedure"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/specimen-processing-procedure"
        }
      },
      {
        "id" : "Specimen.processing.additive",
        "path" : "Specimen.processing.additive",
        "short" : "處理步驟中使用的物質",
        "definition" : "處理步驟中使用的物質"
      },
      {
        "id" : "Specimen.processing.time[x]",
        "path" : "Specimen.processing.time[x]",
        "short" : "檢體處理的日期和時間",
        "definition" : "記錄了進行檢體處理的具體時間或持續期間。例如，可以是檢體進行固定處理的時間，或者檢體浸泡在福馬林(formalin)中的時長。"
      },
      {
        "id" : "Specimen.container",
        "path" : "Specimen.container",
        "short" : "檢體的直接容器（試管/玻片等）",
        "definition" : "此處指的是存放檢體的容器。沒有涉及到容器的層層嵌套特性；也就是說，不討論像血液放在試管裡，試管放在托盤裡，托盤放在架子上這樣的情況。"
      },
      {
        "id" : "Specimen.container.identifier",
        "path" : "Specimen.container.identifier",
        "short" : "容器的ID",
        "definition" : "容器的識別碼。可能會有多種類型的識別碼，如製造商的條碼、實驗室分配的識別碼等。在某些情況下，容器的識別碼可能與檢體的識別碼不同。"
      },
      {
        "id" : "Specimen.container.description",
        "path" : "Specimen.container.description",
        "short" : "容器的文字說明",
        "definition" : "容器的文字說明"
      },
      {
        "id" : "Specimen.container.type",
        "path" : "Specimen.container.type",
        "short" : "與檢體直接相關的容器類型",
        "definition" : "與檢體相關的容器類型（例如：玻片、分液管等）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/specimen-container-type"
        }
      },
      {
        "id" : "Specimen.container.capacity",
        "path" : "Specimen.container.capacity",
        "short" : "容器的體積或大小",
        "definition" : "容器可容納的容量（體積或其他度量）"
      },
      {
        "id" : "Specimen.container.specimenQuantity",
        "path" : "Specimen.container.specimenQuantity",
        "short" : "容器內的檢體量",
        "definition" : "容器裡檢體的量；可能是以體積、尺寸或根據檢體類型的其他適當計量方式來表示"
      },
      {
        "id" : "Specimen.container.additive[x]",
        "path" : "Specimen.container.additive[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "與容器相關的添加劑",
        "definition" : "為保存、維護或增強檢體而引入的物質。例如：福馬林(Formalin)、檸檬酸鹽(Citrate)、EDTA。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SpecimenContainerAdditive"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0371"
        }
      },
      {
        "id" : "Specimen.container.additive[x]:additiveCodeableConcept",
        "path" : "Specimen.container.additive[x]",
        "sliceName" : "additiveCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SpecimenContainerAdditive"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0371"
        }
      },
      {
        "id" : "Specimen.condition",
        "path" : "Specimen.condition",
        "short" : "檢體狀態",
        "definition" : "描述檢體性質的模式或狀態",
        "comment" : "檢體狀態是對檢體所做的觀察，它是一個特定時間點的評估。它可以用來評估檢體的品質或其對於特定檢測的適用性。",
        "requirements" : "檢體狀態可用來評估其對特定檢測的品質或適用性",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SpecimenCondition"
            }
          ],
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v2-0493"
        }
      },
      {
        "id" : "Specimen.note",
        "path" : "Specimen.note",
        "short" : "評論或意見",
        "definition" : "用以傳達有關檢體或在檢體採集過程中的任何細節或問題。（例如：破損的小瓶、與病人一起寄送、冷凍）"
      }
    ]
  }
}

```
