# TW Core RelatedPerson - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core RelatedPerson 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreRelatedPerson |

 
此臺灣核心-相關人士（TW Core RelatedPerson） Profile說明本IG如何進一步定義FHIR的RelatedPerson Resource以呈現相關人士資料。 

**Usages:**

* Refer to this Profile: [TW Core AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md), [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md), [TW Core Composition](StructureDefinition-Composition-twcore.md)...Show 17 more,[TW Core Condition](StructureDefinition-Condition-twcore.md),[TW Core Coverage](StructureDefinition-Coverage-twcore.md),[TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md),[TW Core Encounter](StructureDefinition-Encounter-twcore.md),[TW Core Goal](StructureDefinition-Goal-twcore.md),[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Patient](StructureDefinition-Patient-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core Provenance](StructureDefinition-Provenance-twcore.md),[TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [RelatedPerson/rel-example](RelatedPerson-rel-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/RelatedPerson-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-RelatedPerson-twcore.csv), [Excel](StructureDefinition-RelatedPerson-twcore.xlsx), [Schematron](StructureDefinition-RelatedPerson-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`_id`](SearchParameter-RelatedPerson-id.md)**或**`id`**查詢所有RelatedPerson：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/RelatedPerson?_id=[id]`
`GET [base]/RelatedPerson/[id]`例子：
(1) GET [base]/RelatedPerson?_id=rel-per-example
(2) GET [base]/RelatedPerson/rel-example

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-RelatedPerson-patient.md)**查詢所有RelatedPerson：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/RelatedPerson?patient={Type/}[id]`例子：
(1) GET [base]/RelatedPerson?patient=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-RelatedPerson-patient.md)**及**[`name`](SearchParameter-RelatedPerson-name.md)**查詢所有RelatedPerson：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/RelatedPerson?patient={Type/}[id]&name=[string]`例子：
(1) GET [base]/RelatedPerson?patient=Patient/pat-example&name=李立偉



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "RelatedPerson-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreRelatedPerson",
  "title" : "TW Core RelatedPerson",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-相關人士（TW Core RelatedPerson） Profile說明本IG如何進一步定義FHIR的RelatedPerson Resource以呈現相關人士資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "RelatedPerson",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/RelatedPerson",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "RelatedPerson",
        "path" : "RelatedPerson"
      },
      {
        "id" : "RelatedPerson.active",
        "path" : "RelatedPerson.active",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.patient",
        "path" : "RelatedPerson.patient",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.relationship",
        "path" : "RelatedPerson.relationship",
        "condition" : ["tw-core-4"],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "PatientRelationshipType"
            }
          ],
          "strength" : "preferred",
          "description" : "病人與相關人士之間關係的類型。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype"
        }
      },
      {
        "id" : "RelatedPerson.name",
        "path" : "RelatedPerson.name",
        "condition" : ["tw-core-4"],
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.telecom",
        "path" : "RelatedPerson.telecom",
        "mustSupport" : true
      },
      {
        "id" : "RelatedPerson.address",
        "path" : "RelatedPerson.address",
        "mustSupport" : true
      }
    ]
  }
}

```
