# TW Core QuestionnaireResponse - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core QuestionnaireResponse 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreQuestionnaireResponse |

 
此臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）Profile說明本IG如何進一步定義FHIR的QuestionnaireResponse Resource以呈現問卷題目回覆資料。 

**Usages:**

* Refer to this Profile: [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md), [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md), [TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md), [TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md)...Show 16 more,[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Laboratory Result](StructureDefinition-Observation-laboratoryResult-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)and[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)
* Examples for this Profile: [QuestionnaireResponse/qr-example](QuestionnaireResponse-qr-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/QuestionnaireResponse-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-QuestionnaireResponse-twcore.csv), [Excel](StructureDefinition-QuestionnaireResponse-twcore.xlsx), [Schematron](StructureDefinition-QuestionnaireResponse-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`_id`](SearchParameter-QuestionnaireResponse-id.md)**查詢所有QuestionnaireResponse：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))`GET [base]/QuestionnaireResponse?_id=[id]`
`GET [base]/QuestionnaireResponse/[id]`例子：
(1) GET [base]/QuestionnaireResponse?_id=que-res-example
(2) GET [base]/QuestionnaireResponse/que-res-example
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-QuestionnaireResponse-patient.md)**查詢所有QuestionnaireResponse：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))`GET [base]/QuestionnaireResponse?patient={Type/}[id]`例子：
(1) GET [base]/QuestionnaireResponse?patient=Patient/pat-example

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-QuestionnaireResponse-patient.md)**及**[`status`](SearchParameter-QuestionnaireResponse-status.md)**查詢所有QuestionnaireResponse：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/QuestionnaireResponse?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/QuestionnaireResponse?patient=Patient/pat-example&status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-QuestionnaireResponse-patient.md)**及**[`authored`](SearchParameter-QuestionnaireResponse-authored.md)**查詢所有QuestionnaireResponse：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))`GET [base]/QuestionnaireResponse?patient={Type/}[id]&authored={gt|lt|ge|le}[date]{&authored={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/QuestionnaireResponse?Patient/pat-example&date=ge2021
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-QuestionnaireResponse-patient.md)**及**[`questionnaire`](SearchParameter-QuestionnaireResponse-questionnaire.md)**查詢所有QuestionnaireResponse：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))`GET [base]/QuestionnaireResponse?patient={Type/}[id]&questionnaire={Type/}[id]`例子：
(1) GET [base]/QuestionnaireResponse?Patient/pat-example&questionnaire=http://hl7.org/fhir/uv/sdc/Questionnaire/questionnaire-sdc-test-fhirpath-prepop-source-query



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "QuestionnaireResponse-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreQuestionnaireResponse",
  "title" : "TW Core QuestionnaireResponse",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-問卷題目回覆（TW Core QuestionnaireResponse）Profile說明本IG如何進一步定義FHIR的QuestionnaireResponse  Resource以呈現問卷題目回覆資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "QuestionnaireResponse",
  "baseDefinition" : "http://hl7.org/fhir/uv/sdc/StructureDefinition/sdc-questionnaireresponse",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "QuestionnaireResponse",
        "path" : "QuestionnaireResponse"
      },
      {
        "id" : "QuestionnaireResponse.basedOn",
        "path" : "QuestionnaireResponse.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.partOf",
        "path" : "QuestionnaireResponse.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore"
            ]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.questionnaire.extension:url",
        "path" : "QuestionnaireResponse.questionnaire.extension",
        "sliceName" : "url",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/questionnaire-url"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "QuestionnaireResponse.subject",
        "path" : "QuestionnaireResponse.subject",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.encounter",
        "path" : "QuestionnaireResponse.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.author",
        "path" : "QuestionnaireResponse.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              null,
              null,
              null,
              null,
              null
            ]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.source",
        "path" : "QuestionnaireResponse.source",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "QuestionnaireResponse.item.answer.value[x]",
        "path" : "QuestionnaireResponse.item.answer.value[x]",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "boolean"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "date"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "time"
          },
          {
            "code" : "decimal"
          },
          {
            "code" : "integer"
          },
          {
            "code" : "string"
          },
          {
            "code" : "Coding"
          },
          {
            "code" : "uri"
          },
          {
            "code" : "Quantity"
          },
          {
            "code" : "Attachment"
          }
        ]
      }
    ]
  }
}

```
