# TW Core Provenance - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Provenance 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Provenance-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreProvenance |

 
此臺灣核心-出處（TW Core Provenance） Profile說明本IG如何進一步定義FHIR的Provenance Resource以呈現出處資料。 

**Usages:**

* Refer to this Profile: [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md) and [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)
* Examples for this Profile: [Provenance/pov-example](Provenance-pov-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Provenance-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Provenance-twcore.csv), [Excel](StructureDefinition-Provenance-twcore.xlsx), [Schematron](StructureDefinition-Provenance-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

TW Core Provenance應支援以下TW Core Profile resource types：

* AllergyIntolerance
* CarePlan
* CareTeam
* Condition
* Coverage
* Device
* DiagnosticReport
* DocumentReference
* Encounter
* Goal
* Immunization
* MedicationDispense
* MedicationRequest
* Observation
* Patient
* Procedure
* QuestionnaireResponse
* RelatedPerson
* ServiceRequest

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**`patient`**及**[`_revinclude`](http://hl7.org/fhir/R4/search.html#include)**查詢所有上面列出的TW Core Profile resource types及這些Resource的Provenance紀錄：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/[Resource]?patient=[id]&_revinclude=Provenance:target`例子：
(1) GET [base]/AllergyIntolerance?patient=Patient/pat-example&_revinclude=Provenance:target
1. **必須（SHALL）**支援透過查詢參數**`_id`**及**[`_revinclude`](http://hl7.org/fhir/R4/search.html#include)**查詢所有上面列出的TW Core Profile resource types及這些Resource的Provenance紀錄：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/[Resource]?_id=[id]&_revinclude=Provenance:target`例子：
(1) GET [base]/AllergyIntolerance?_id=all-cat-example&_revinclude=Provenance:target



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Provenance-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Provenance-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreProvenance",
  "title" : "TW Core Provenance",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-出處（TW Core Provenance） Profile說明本IG如何進一步定義FHIR的Provenance Resource以呈現出處資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "fhirauditevent",
      "uri" : "http://hl7.org/fhir/auditevent",
      "name" : "FHIR AuditEvent Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Provenance",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Provenance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Provenance",
        "path" : "Provenance"
      },
      {
        "id" : "Provenance.target",
        "path" : "Provenance.target",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.target.reference",
        "path" : "Provenance.target.reference",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.recorded",
        "path" : "Provenance.recorded",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.location",
        "path" : "Provenance.location",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Provenance.agent",
        "path" : "Provenance.agent",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "type"
            }
          ],
          "rules" : "open"
        },
        "constraint" : [
          {
            "key" : "provenance-1",
            "severity" : "error",
            "human" : "onBehalfOf SHALL be present when Provenance.agent.who is a Practitioner or Device",
            "expression" : "who.exists((resolve() is Practitioner) or (resolve() is Device)) implies onBehalfOf.exists()",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Provenance-twcore"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.type",
        "path" : "Provenance.agent.type",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/provenance-participant-type-hl7-tw"
        }
      },
      {
        "id" : "Provenance.agent.who",
        "path" : "Provenance.agent.who",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent.onBehalfOf",
        "path" : "Provenance.agent.onBehalfOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceAuthor",
        "path" : "Provenance.agent",
        "sliceName" : "ProvenanceAuthor",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceAuthor.type",
        "path" : "Provenance.agent.type",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/provenance-participant-type",
              "code" : "author"
            }
          ]
        }
      },
      {
        "id" : "Provenance.agent:ProvenanceAuthor.who",
        "path" : "Provenance.agent.who",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceAuthor.onBehalfOf",
        "path" : "Provenance.agent.onBehalfOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceTransmitter",
        "path" : "Provenance.agent",
        "sliceName" : "ProvenanceTransmitter",
        "definition" : "The entity that provided the copy to your system.",
        "min" : 0,
        "max" : "*",
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceTransmitter.type",
        "path" : "Provenance.agent.type",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/provenance-participant-type-tw",
              "code" : "transmitter"
            }
          ]
        }
      },
      {
        "id" : "Provenance.agent:ProvenanceTransmitter.who",
        "path" : "Provenance.agent.who",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Provenance.agent:ProvenanceTransmitter.onBehalfOf",
        "path" : "Provenance.agent.onBehalfOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
