# TW Core Procedure - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Procedure 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreProcedure |

 
此臺灣核心-處置或手術（TW Core Procedure） Profile說明本IG如何進一步定義FHIR的Procedure Resource以呈現處置或手術基本資料。 

## Resource Procedure - 內容

這是指一項針對病人執行的或已經執行過的活動。這種活動可能是像手術那樣的身體介入，或者是像長期服務、諮詢或催眠療法等更少侵入性的活動。

### 範圍與使用

Procedure 在 FHIR [工作流程（workflow）](https://hl7.org/fhir/R4/workflow.html) 規範中被歸類為 [事件（event）](https://hl7.org/fhir/R4/workflow.html#event) resource。

這個 resource 被用來詳細記錄對病人進行的當前和過往的處置。處置是一種作為照護提供的一部分，對病人進行、與病人一同進行，或者為病人進行的活動。例如：這包括外科處置、診斷處置、內視鏡處置、活組織切片、諮詢、物理治療、個人支援服務、成人日間照護服務、非緊急運輸、家庭改造、運動等。這些處置可能由醫療專業人員、醫療服務提供者、朋友或親戚執行，或在某些情況下由病人自己執行。

這個 resource 主要提供關於處置發生的摘要資訊，並不是在提供處置展開過程中的即時快照。儘管對於如心理治療等長期進行的處置，它可以提供有關整體進展的摘要資訊，然而，當談到創建一個用於支援更詳細即時的處置資訊的 resource 時，這意味著需要有一個具體的應用場景或使用案例，才能決定如何分享這類詳細資訊。

### 界限與關聯

Procedure resource 不應該用來記錄事件，如果已經有一個更具體的 resource 存在，例如[疫苗接種（immunizations）](https://hl7.org/fhir/R4/immunization.html)、[給藥（drug administrations）](https://hl7.org/fhir/R4/medicationadministration.html) 和 [通訊（communications）](https://hl7.org/fhir/R4/communication.html)。判斷一個活動是屬於 Procedure（如培訓或諮詢）還是 Communication 的界限，取決於是否有明確的意圖去改變病人的心態，若只是訊息披露則屬於 Communication；但若涉及驗證病人理解或改變病人心理狀態的過程會被視為 Procedure。

請注意，許多診斷過程即為處置，處置會產生 [Observations](StructureDefinition-Observation-laboratoryResult-twcore.md) 和 [DiagnosticReports](StructureDefinition-DiagnosticReport-twcore.md)。 有時，創建這些「Observation」不需要詳細記錄如何進行的「Procedure」，但如果有需要知道診斷活動如何進行的細節，那麼就會使用「Procedure」來描述這些活動。

並非所有診斷性處置都需要有一個「Procedure」紀錄，只有在需要記錄進行診斷所需的身體介入（例如：麻醉、手術切口、內視鏡大小等）資訊時，才會創建「Procedure」紀錄。

任務（[Task](https://hl7.org/fhir/R4/task.html)）是工作流程的一個步驟，比如取消一個醫令、完成一個醫令、簽署一個醫令、合併一組紀錄、接收一位病人。Procedures 是指那些目的在於對病人產生身體或心理變化的活動（例如：手術、物理治療、培訓、諮詢）。[Task](https://hl7.org/fhir/R4/task.html) resource 經常與臨床 resources 一起使用。例如：一個「[Task](https://hl7.org/fhir/R4/task.html)」可能是要求執行一個 Procedure，這時它會連結到一個要求提供處置服務的請求（[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html)），這樣的請求就明確指定了要完成的臨床活動。

Procedure resource 被以下 resources 所參照：醫療不良事件（[AdverseEvent](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)）、預約（[Appointment](https://hl7.org/fhir/R4/appointment.html#Appointment)）、費用項目（[ChargeItem](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)）、理賠申請（[Claim](https://hl7.org/fhir/R4/claim.html#Claim)）、設備使用聲明（[DeviceUseStatement](https://hl7.org/fhir/R4/deviceusestatement.html#DeviceUseStatement)）、就醫事件（[Encounter](StructureDefinition-Encounter-twcore.md)）、利益說明（[ExplanationOfBenefit](https://hl7.org/fhir/R4/explanationofbenefit.html#ExplanationOfBenefit)）、標記（[Flag](https://hl7.org/fhir/R4/flag.html#Flag)）、影像檢查（[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、給藥（[MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html#MedicationAdministration)）、配藥或調劑藥品（[MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)）、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）、診斷報告(Procedure)及問卷題目回覆（[QuestionnaireResponse](https://hl7.org/fhir/R4/questionnaireresponse.html#QuestionnaireResponse)）。

**Usages:**

* Refer to this Profile: [TW Core Encounter](StructureDefinition-Encounter-twcore.md), [TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md), [TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md), [TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)...Show 18 more,[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md)and[TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md)
* Examples for this Profile: [Procedure/pro-appendectomy-example](Procedure-pro-appendectomy-example.md) and [Procedure/pro-example](Procedure-pro-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Procedure-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Procedure-twcore.csv), [Excel](StructureDefinition-Procedure-twcore.xlsx), [Schematron](StructureDefinition-Procedure-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Procedure-id.md)**查詢所有Procedure：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Procedure?_id=[id]`
`GET [base]/Procedure/[id]`例子：
(1) GET [base]/Procedure?_id=pro-example
(2) GET [base]/Procedure/pro-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`code`](SearchParameter-Procedure-code.md)**查詢所有Procedure：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Procedure?code={system|}[code]`例子：
(1) GET [base]/Procedure?code=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-pcs-2021-tw|BU46ZZZ
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-Procedure-status.md)**查詢所有Procedure：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Procedure?status=[code]`例子：
(1) GET [base]/Procedure?status=completed
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Procedure-subject.md)**查詢所有Procedure：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Procedure?subject={Type/}[id]`例子：:
(1) GET [base]/Procedure?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`date`](SearchParameter-Procedure-date.md)**查詢所有Procedure：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Procedure?date={gt|lt|ge|le}[date]`例子：:
(1) GET [base]/Procedure?date=gt2022-08-12



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Procedure-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreProcedure",
  "title" : "TW Core Procedure",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-處置或手術（TW Core Procedure） Profile說明本IG如何進一步定義FHIR的Procedure Resource以呈現處置或手術基本資料。\n\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Procedure",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Procedure",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Procedure",
        "path" : "Procedure",
        "short" : "正在或曾經對病人執行的動作",
        "definition" : "正在或曾經對病人執行的動作。這可以是像手術這樣的身體介入，也可以是像長照服務、諮詢或催眠療法這樣的非侵入性介入。HL7 FHIR官網另有提到的例子包括例如包括診斷處置/手術、內視鏡處置/手術、活體組織切片、諮詢、物理治療、個人支持服務、日照服務、非緊急運輸、改善家居設施、健身活動等。處置/手術可以由醫護人員、服務提供人員、朋友或親屬或在某些情況下由病人自己執行。"
      },
      {
        "id" : "Procedure.id",
        "path" : "Procedure.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Procedure紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Procedure.meta",
        "path" : "Procedure.meta",
        "short" : "此Procedure Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Procedure.implicitRules",
        "path" : "Procedure.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Procedure.language",
        "path" : "Procedure.language",
        "short" : "用以表述Procedure Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Procedure.text",
        "path" : "Procedure.text",
        "short" : "Procedure Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Procedure.identifier",
        "path" : "Procedure.identifier",
        "short" : "此處置/手術的外部識別碼",
        "definition" : "由執行者或其他系統指定給此處置/手術的業務用識別碼，即使此resource作更新及在伺服器之間的傳遞，此識別碼仍保持不變。",
        "comment" : "這是一個業務識別碼，不是一個resource識別碼（詳見討論）。最好的做法是該識別碼只出現在單個resource實例上，但是業務實務有可能會規定可以在多個resource實例中具有相同識別碼—甚至可能具有不同的resource型例。例如：多個 「Patient（病人）」和 「Person（個人）」resource實例可能共用同一個社會保險號碼。",
        "requirements" : "允許識別各參與系統所知的此處置/手術資訊，並在各伺服器之間保持一致的方式。"
      },
      {
        "id" : "Procedure.instantiatesCanonical",
        "path" : "Procedure.instantiatesCanonical",
        "short" : "實例化FHIR計畫書（protocol）或定義",
        "definition" : "指向此處置/手術全部或部分遵守的FHIR定義的計畫書（protocol）、指南（guideline）、醫令集（orderset）或其他定義的URL。"
      },
      {
        "id" : "Procedure.instantiatesUri",
        "path" : "Procedure.instantiatesUri",
        "short" : "實例化外部計畫書（protocol）或定義",
        "definition" : "指向此處置/手術全部或部分的外部維護之計畫書（protocol）、指南（guideline）、醫令集（orderset）或其他定義的URL。",
        "comment" : "這可能是一個HTML頁面、PDF等，也可能只是一個不可分解的URI識別碼。"
      },
      {
        "id" : "Procedure.basedOn",
        "path" : "Procedure.basedOn",
        "short" : "此Procedure是基於什麼而履行",
        "definition" : "對一個resource的參照，此resource包含此處置/手術請求的細節。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.partOf",
        "path" : "Procedure.partOf",
        "short" : "參照事件的一部分",
        "definition" : "這個特定的處置/手術是一個更大的事件中的一個組成部分或步驟",
        "comment" : "MedicationAdministration.partOf有一個Procedure參照，但這不是一個迴圈參照。例如：麻醉的給藥（MedicationAdministration）是手術處置/手術的一部分（MedicationAdministration.partOf = Procedure）。例如：為靜脈給藥插入靜脈口的處置/手術是給藥的一部分（Procedure.partOf = MedicationAdministration）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore",
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.status",
        "path" : "Procedure.status",
        "short" : "preparation ｜ in-progress ｜ not-done ｜on-hold ｜stopped ｜ completed ｜ entered-in-error ｜ unknown",
        "definition" : "一個指定處置/手術當前狀態的代碼。一般來說，它是進行中或完成的狀態。",
        "comment" : "「未知」代碼不能用來表達其他狀態。當其中一個狀態適用時但編輯系統不知道此處置/手術的當前狀態，應該使用「未知」代碼。 \n \n此資料項目被標記為修飾用，因為狀態包含標記resource當前無效的代碼。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ProcedureStatus"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/event-status|4.0.1"
        }
      },
      {
        "id" : "Procedure.statusReason",
        "path" : "Procedure.statusReason",
        "short" : "當前狀態的原因。",
        "definition" : "捕捉Procedure當前狀態的原因",
        "comment" : "這通常只用於「例外」狀態像是「未完成」、「暫停」或「終止」。執行此處置/手術的原因是在reasonCode中說明，而不是在這裡。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-not-performed-reason"
        }
      },
      {
        "id" : "Procedure.category",
        "path" : "Procedure.category",
        "short" : "處置/手術的分類。",
        "definition" : "對處置/手術進行分類的代碼（例如：「手術處置/手術」）。主要為了搜尋、排序和顯示時使用。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-category"
        }
      },
      {
        "id" : "Procedure.code",
        "path" : "Procedure.code",
        "short" : "處置/手術的識別碼。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "所進行的特定處置/手術。如果不能對處置/手術的確切種類進行編碼，則使用文字（例如：「腹腔鏡闌尾切除術」）。",
        "requirements" : "0..1主要僅用於解釋敘述性的resource。",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.code.coding",
        "path" : "Procedure.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "由專門術語系統（terminology system）定義的代碼。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼"
      },
      {
        "id" : "Procedure.code.coding:icd10-pcs-2023",
        "path" : "Procedure.code.coding",
        "sliceName" : "icd10-pcs-2023",
        "short" : "此為臺灣衛生福利部中央健康保險署（NHI）維護之2023年中文版ICD-10-PCS代碼，涵蓋範圍相對完整，可免費使用，可優先選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "處置/手術的識別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2023-tw"
        }
      },
      {
        "id" : "Procedure.code.coding:icd10-pcs-2021",
        "path" : "Procedure.code.coding",
        "sliceName" : "icd10-pcs-2021",
        "short" : "此為臺灣衛生福利部中央健康保險署（NHI）維護之2021年中文版ICD-10-PCS代碼，涵蓋範圍相對完整，可免費使用，可優先選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "處置/手術的識別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2021-tw"
        }
      },
      {
        "id" : "Procedure.code.coding:icd10-pcs-2014",
        "path" : "Procedure.code.coding",
        "sliceName" : "icd10-pcs-2014",
        "short" : "此為臺灣衛生福利部中央健康保險署（NHI）維護之2014年中文版ICD-10-PCS代碼，涵蓋範圍相對完整，可免費使用，可優先選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "處置/手術的識別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-pcs-2014-tw"
        }
      },
      {
        "id" : "Procedure.code.coding:medical-service-payment",
        "path" : "Procedure.code.coding",
        "sliceName" : "medical-service-payment",
        "short" : "此為臺灣衛生福利部中央健康保險署（NHI）維護之醫療服務給付項目，主要針對申報使用，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "處置/手術的識別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/procedure-tw"
        }
      },
      {
        "id" : "Procedure.code.coding:sct-procedures",
        "path" : "Procedure.code.coding",
        "sliceName" : "sct-procedures",
        "short" : "此為SNOMED CT處置/手術代碼，若機構已有購買相關授權，亦可使用。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "處置/手術的識別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-code"
        }
      },
      {
        "id" : "Procedure.code.coding:loinc-procedures",
        "path" : "Procedure.code.coding",
        "sliceName" : "loinc-procedures",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Procedure.code.text",
        "path" : "Procedure.code.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.subject",
        "path" : "Procedure.subject",
        "short" : "處置/手術服務的對象",
        "definition" : "進行處置/手術的病人、動物或實體集合（例如：特定的一群人）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.encounter",
        "path" : "Procedure.encounter",
        "short" : "就醫（Encounter）紀錄作為處置/手術的一部分",
        "definition" : "此「處置/手術（Procedure）」記載在哪次的「就醫（Encounter）」紀錄或者與此處置/手術紀錄密切相關的「就醫（Encounter）」紀錄",
        "comment" : "通常是此處置/手術發生的就醫事件（Encounter），雖然有些活動可能在就醫結束之前或之後開始，但仍與就醫事件的情境有關。這筆紀錄表明與此處置/手術紀錄相關的就醫事件。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.performed[x]",
        "path" : "Procedure.performed[x]",
        "short" : "此處置/手術何時執行的？",
        "definition" : "進行處置/手術的估計或實際日期、日期時間、時間區間或年齡。允許一個時間區間來支持跨越一個日期以上的複雜處置/手術，也允許捕捉處置/手術的執行時間長度。",
        "comment" : "年齡一般用於病人報告其進行手術的年齡，像是20到25歲時。 dateTime支援一定的精度範圍，因為有些處置/手術被報告為過去的處置/手術，可能沒有毫秒的精度，而其他在就醫期間執行和記錄的處置/手術可能有更精確的UTC時間戳記和時區。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "string"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Range"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.recorder",
        "path" : "Procedure.recorder",
        "short" : "誰記錄此處置/手術",
        "definition" : "記錄處置/手術內容並對其內容負責的個人",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.asserter",
        "path" : "Procedure.asserter",
        "short" : "聲稱有此處置/手術的人",
        "definition" : "提出此處置/手術說明的人",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.performer",
        "path" : "Procedure.performer",
        "short" : "執行處置/手術的人員",
        "definition" : "限於「真正的」人而不是設備",
        "mustSupport" : true
      },
      {
        "id" : "Procedure.performer.function",
        "path" : "Procedure.performer.function",
        "short" : "執行的型別",
        "definition" : "區分執行者在處置/手術中的參與型別，例如：外科醫生、麻醉師、內視鏡醫生。",
        "requirements" : "允許針對不同執行者的參與型別進行澄清以消除歧義",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/performer-role"
        }
      },
      {
        "id" : "Procedure.performer.actor",
        "path" : "Procedure.performer.actor",
        "short" : "參照至健康照護服務提供者",
        "definition" : "參與處置/手術的健康照護服務提供者",
        "requirements" : "一個參照至裝置（Device）的使用案例，例如：心律調整器。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.performer.onBehalfOf",
        "path" : "Procedure.performer.onBehalfOf",
        "short" : "此裝置（Device）或健康照護服務提供者所屬機構（Organization）",
        "definition" : "此裝置或健康照護服務提供者所代表的機構",
        "requirements" : "健康照護服務提供者和裝置可以與多個機構相關聯，此資料項目表明他們在執行行動時代表哪個機構。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Procedure.location",
        "path" : "Procedure.location",
        "short" : "處置/手術發生的地點（Location）？",
        "definition" : "實際發生處置/手術的地點（Location）。例如：新生兒在家裡出生、在餐廳做氣管切開術。",
        "requirements" : "將一個處置/手術與可能保存紀錄的地點（Location）聯繫起來",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.reasonCode",
        "path" : "Procedure.reasonCode",
        "short" : "處置/手術執行原因代碼",
        "definition" : "進行此處置/手術的原因代碼。這可能是某種型別的編碼，也可能只是文字表述。",
        "comment" : "當一個代碼足以描述原因時，使用Procedure.reasonCode。當參照一個resource時，使用Procedure.reasonReference以傳達更多的資訊，如發病日期。Procedure.reasonCode和Procedure.reasonReference不應該是重複的。對於一個單一的原因，Procedure.reasonCode或Procedure.reasonReference都可以被使用。Procedure.reasonCode可以是一個摘要代碼，或者Procedure.reasonReference可以用Condition | Observation | Procedure | DiagnosticReport | DocumentReference來參照一個非常精確的原因定義。如果Procedure.reasonCode和Procedure.reasonReference描述的是處置/手術的不同原因，則兩者都可以使用。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-reason"
        }
      },
      {
        "id" : "Procedure.reasonReference",
        "path" : "Procedure.reasonReference",
        "short" : "執行此處置/手術的原因",
        "definition" : "為什麼進行此處置/手術的原因",
        "comment" : "一個處置/手術有可能成為另一個處置/手術（如C-Section）的理由（如硬膜外）。其他的例子包括擴張的內窺鏡檢查和活檢（診斷和治療的結合）。\n 當一個代碼充分地描述了原因時，使用Procedure.reasonCode。當引用一個resource時，使用Procedure.reasonReference，這樣可以傳達更多的資訊，如發病日期。Procedure.reasonCode和Procedure.reasonReference不應該是重複的。對於一個單一的原因，Procedure.reasonCode或Procedure.reasonReference都可以被使用。Procedure.reasonCode可以是一個摘要代碼，或者Procedure.reasonReference可以用Condition | Observation | Procedure | DiagnosticReport | DocumentReference來引用一個非常精確的原因定義。如果Procedure.reasonCode和Procedure.reasonReference描述的是處置/手術的不同原因，則兩者都可以使用。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.bodySite",
        "path" : "Procedure.bodySite",
        "short" : "目標身體部位。",
        "definition" : "詳細和結構化的解剖學位置資訊。允許多個位置—例如：一個病灶的多個活體組織切片。",
        "comment" : "如果案例需要BodySite resource的屬性（例如：識別和各別追蹤），那麼就使用標準擴充[procedure-targetbodystructure]（擴充-procedure-targetbodystructure.html）。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Procedure.outcome",
        "path" : "Procedure.outcome",
        "short" : "處置/手術的結果。",
        "definition" : "處置/手術的結果—它是否解決了當初執行處置/手術所要解決的問題？",
        "comment" : "如果結果只包含敘述性文字，可用CodeableConcept.text來說明。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-outcome"
        }
      },
      {
        "id" : "Procedure.report",
        "path" : "Procedure.report",
        "short" : "此處置/手術產生的任何報告",
        "definition" : "這可能是組織學結果、病理學報告、手術報告等。",
        "comment" : "有可能會有多份報告—例如：如果這是一個需要進行多次活體組織切片的處置/手術，會產生一些解剖病理報告。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.complication",
        "path" : "Procedure.complication",
        "short" : "處置/手術後的併發症",
        "definition" : "在處置/手術過程中，或在處置/手術後不久發生的任何併發症。這些通常與紀錄分開追蹤，紀錄通常描述處置/手術本身，而不是任何 「處置/手術後」的問題。  ",
        "comment" : "如果併發症僅由敘述性文字表達，可用CodeableConcept.text來說明。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "Procedure.complicationDetail",
        "path" : "Procedure.complicationDetail",
        "short" : "處置/手術後發生的病情、問題或診斷",
        "definition" : "在處置/手術過程中或在執行結束後立即發生的任何併發症",
        "requirements" : "這是用來記錄作為處置/手術結果的病情、問題或診斷，而不是作為處置/手術原因的病情、問題或診斷。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.followUp",
        "path" : "Procedure.followUp",
        "short" : "追蹤說明。",
        "definition" : "如果該處置/手術需要特定的後續行動—例如拆除縫線。 後續行動可以表現為一個簡單的說明，也可能是更複雜的，在這種情況下，可以使用CarePlan resource。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-followup"
        }
      },
      {
        "id" : "Procedure.note",
        "path" : "Procedure.note",
        "short" : "關於此處置/手術的附加資訊",
        "definition" : "關於此處置/手術的任何其他註釋和意見"
      },
      {
        "id" : "Procedure.focalDevice",
        "path" : "Procedure.focalDevice",
        "short" : "處理、植入的或移除的裝置",
        "definition" : "植入、移除或以其他方式操作的裝置（校準、更換電池、安裝義肢、安裝傷口真空裝置等），是處置/手術的重點部分。"
      },
      {
        "id" : "Procedure.focalDevice.action",
        "path" : "Procedure.focalDevice.action",
        "short" : "改變裝置的種類",
        "definition" : "處置/手術過程中，設備改變的類型。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DeviceActionKind"
            }
          ],
          "strength" : "preferred",
          "description" : "鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/device-action"
        }
      },
      {
        "id" : "Procedure.focalDevice.manipulated",
        "path" : "Procedure.focalDevice.manipulated",
        "short" : "被改變的裝置",
        "definition" : "在處置/手術中被處理（改變）的裝置"
      },
      {
        "id" : "Procedure.usedReference",
        "path" : "Procedure.usedReference",
        "short" : "處置/手術中使用的項目／物品",
        "definition" : "指明藥品、裝置和作為處置/手術一部分的任何其他物質",
        "comment" : "對於實際植入或取出的裝置，使用Procedure.device。",
        "requirements" : "用於追蹤污染等",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore",
              "http://hl7.org/fhir/StructureDefinition/Substance"
            ]
          }
        ]
      },
      {
        "id" : "Procedure.usedCode",
        "path" : "Procedure.usedCode",
        "short" : "處置/手術中使用的項目之代碼",
        "definition" : "指明作為處置/手術的一部分而使用的編碼項目",
        "comment" : "對於實際植入或取出的裝置，使用Procedure.device。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/device-kind"
        }
      }
    ]
  }
}

```
