# TW Core Organization Government - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Organization Government 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreOrganizationGovt |

 
此臺灣核心-政府機構（TW Core Organization Government） Profile說明本IG如何進一步定義臺灣核心-機構（TW Core Organization） Profile以呈現機構基本資料。 

**Usages:**

* Examples for this Profile: [衛生福利部](Organization-org-govt-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Organization-govt-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Organization-govt-twcore.csv), [Excel](StructureDefinition-Organization-govt-twcore.xlsx), [Schematron](StructureDefinition-Organization-govt-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Organization-id.md)**查詢所有Organization：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Organization?_id=[id]`
`GET [base]/Organization/[id]`例子：
(1) GET [base]/Organization?_id=org-govt-example
(2) GET [base]/Organization/org-govt-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`identifier`](SearchParameter-Organization-identifier.md)**查詢所有Organization：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Organization?identifier={system|}[code]`例子：
(1) GET [base]/Organization?identifier=https://oid.nat.gov.tw/|A21000000I
1. **建議應該（SHOULD）**支援透過查詢參數**[`name`](SearchParameter-Organization-name.md)**查詢所有Organization：
([如何透過string查詢](http://hl7.org/fhir/R4/search.html#string))
`GET [base]/Organization?name=[name]`例子：
(1) GET [base]/Organization?name=衛生福利部
1. **建議應該（SHOULD）**支援透過查詢參數**[`type`](SearchParameter-Organization-type.md)**查詢所有Organization：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Organization?type={system|}[code]`例子：
(1) GET [base]/Organization?type=http://terminology.hl7.org/CodeSystem/organization-type|govt



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Organization-govt-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-govt-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreOrganizationGovt",
  "title" : "TW Core Organization Government",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-政府機構（TW Core Organization Government） Profile說明本IG如何進一步定義臺灣核心-機構（TW Core Organization） Profile以呈現機構基本資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Organization",
  "baseDefinition" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Organization",
        "path" : "Organization"
      },
      {
        "id" : "Organization.identifier.type",
        "path" : "Organization.identifier.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/v2-0203",
              "code" : "GOI"
            }
          ]
        }
      },
      {
        "id" : "Organization.identifier.system",
        "path" : "Organization.identifier.system",
        "patternUri" : "https://oid.nat.gov.tw/"
      },
      {
        "id" : "Organization.identifier.value",
        "path" : "Organization.identifier.value",
        "short" : "唯一值。例如：機關代號為A21000000I"
      },
      {
        "id" : "Organization.type",
        "path" : "Organization.type",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/organization-type",
              "code" : "govt"
            }
          ]
        }
      }
    ]
  }
}

```
