# TW Core Observation Pregnancy Status - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation Pregnancy Status 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pregnancy-status-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationPregnancyStatus |

 
此臺灣核心-妊娠狀態 (TW Core Observation Pregnancy Status) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現妊娠狀態資料。 

**Usages:**

* Examples for this Profile: [Observation/obs-pregnancy-status-example](Observation-obs-pregnancy-status-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-pregnancy-status-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-pregnancy-status-twcore.csv), [Excel](StructureDefinition-Observation-pregnancy-status-twcore.xlsx), [Schematron](StructureDefinition-Observation-pregnancy-status-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw|social-history`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw|social-history
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|82810-3
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw|social-history&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw|social-history&date=ge2020-01-01T00:00:00Z

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw|social-history&status={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw|social-history&status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`_lastUpdated`](SearchParameter-Observation-lastupdated.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/category-code-tw|laboratory&_lastUpdated=ge2024-01-01T00:00:00Z
1. 支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`code`](SearchParameter-Observation-clinical-code.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|886645&date=ge2020-01-01T00:00:00Z



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-pregnancy-status-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-pregnancy-status-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationPregnancyStatus",
  "title" : "TW Core Observation Pregnancy Status",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-妊娠狀態 (TW Core Observation Pregnancy Status) Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現妊娠狀態資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "用於呈現妊娠狀態資料的觀察紀錄",
        "definition" : "此 Profile 用於記錄患者的妊娠狀態，依據臺灣核心規範進行定義。"
      },
      {
        "id" : "Observation.implicitRules",
        "path" : "Observation.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建 resource 時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對 IG 所定義之特殊規則及其他 profiles 的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此 URL 是對 IG 的參照，此 IG 將這些特殊規則與其他 profiles、value sets 等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Observation.modifierExtension",
        "path" : "Observation.modifierExtension",
        "short" : "用於擴充資料結構且會改變理解方式的擴充欄位",
        "definition" : "用於表示會改變基本元素理解方式的擴充內容。通常用於標示例外、否定或修正的情境。",
        "comment" : "modifierExtension 必須不會改變 resource 的基本意義，只能用於修飾、標示或限定內容。"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "definition" : "指出妊娠狀態觀察紀錄目前的狀態，例如：已完成、進行中等。",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.code"
            },
            {
              "type" : "value",
              "path" : "coding.system"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "觀察紀錄的分類",
        "definition" : "用於分類本觀察紀錄的性質，例如：社會史 (social-history) 等。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:twcore",
        "path" : "Observation.category",
        "sliceName" : "twcore",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:twcore.coding",
        "path" : "Observation.category.coding",
        "min" : 1
      },
      {
        "id" : "Observation.category:twcore.coding.system",
        "path" : "Observation.category.coding.system",
        "short" : "分類系統網址",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/observation-category"
      },
      {
        "id" : "Observation.category:twcore.coding.code",
        "path" : "Observation.category.coding.code",
        "short" : "分類代碼",
        "min" : 1,
        "patternCode" : "social-history"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "妊娠狀態 (Pregnancy Status)",
        "definition" : "本觀察紀錄所記錄的主題為妊娠狀態，對應 LOINC 代碼 82810-3。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82810-3"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "觀察對象 (患者)",
        "definition" : "此觀察紀錄所屬的患者。",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "short" : "相關就醫事件",
        "definition" : "本觀察紀錄所屬的就醫事件。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.effective[x]:effectiveDateTime",
        "path" : "Observation.effective[x]",
        "sliceName" : "effectiveDateTime",
        "short" : "觀察紀錄的生效時間",
        "definition" : "妊娠狀態觀察紀錄的生效或觀察時間。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "執行觀察的對象",
        "definition" : "負責執行本觀察紀錄的個人、組織或團隊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.value[x]:valueCodeableConcept",
        "path" : "Observation.value[x]",
        "sliceName" : "valueCodeableConcept",
        "short" : "妊娠狀態的編碼回應 (Coded Responses from Pregnancy Status Value Set)",
        "definition" : "妊娠狀態的具體值，需使用 Pregnancy Status Value Set 內的編碼。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/snomed-pregnancy-status-code"
        }
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "short" : "檢體資訊",
        "definition" : "本觀察紀錄所使用的檢體。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "short" : "組成本觀察的子項目",
        "definition" : "本觀察紀錄所包含的子觀察項目。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-simple-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "short" : "資料來源參照",
        "definition" : "本觀察紀錄所引用的其他資料來源。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-simple-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      }
    ]
  }
}

```
