# TW Core Observation Occupation - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation Occupation 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-occupation-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationOccupation |

 
此臺灣核心-職業（TW Core Observation Occupation） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現職業資料。 

**Usages:**

* Examples for this Profile: [Observation/obs-occupation-example](Observation-obs-occupation-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-occupation-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-occupation-twcore.csv), [Excel](StructureDefinition-Observation-occupation-twcore.xlsx), [Schematron](StructureDefinition-Observation-occupation-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=social-history`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=social-history
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|11341-5
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category=social-history&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=social-history&date=ge2020-01-01T00:00:00Z

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=social-history&status={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=social-history&status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`_lastUpdated`](SearchParameter-Observation-lastupdated.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=social-history&_lastUpdated=ge2024-01-01T00:00:00Z
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`code`](SearchParameter-Observation-clinical-code.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|11341-5&date=ge2020-01-01T00:00:00Z



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-occupation-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-occupation-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationOccupation",
  "title" : "TW Core Observation Occupation",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-職業（TW Core Observation Occupation） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現職業資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "測量與簡單陳述",
        "definition" : "關於病人、裝置或其他主體的測量與簡單陳述。",
        "comment" : "用於簡單觀察，例如裝置測量、實驗室原子結果、生命徵象、身高、體重、吸菸狀態、備註等。其他資源則用於提供觀察的上下文，例如實驗室報告等。"
      },
      {
        "id" : "Observation.implicitRules",
        "path" : "Observation.implicitRules",
        "short" : "建立本內容所依據的一組規則",
        "definition" : "指向建構本 resource 時所遵循規則的參照，處理內容時必須理解這些規則。通常是參照定義特殊規則的實作指南（Implementation Guide），以及其他 profiles 等。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解，這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，尚未準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應避免使用此欄位。"
      },
      {
        "id" : "Observation.modifierExtension",
        "path" : "Observation.modifierExtension",
        "short" : "不可被忽略的擴充資訊",
        "definition" : "可用於表示不屬於資源基本定義、且會改變所屬元素或其子元素意義的額外資訊。通常這類元素用於否定或限定。為了讓擴充的使用安全且可管理，FHIR 對擴充的定義與使用有嚴格治理規範。",
        "comment" : "任何應用、專案或標準都不應因使用擴充而受到歧視，無論其定義或使用的機構或法域為何。擴充的使用讓 FHIR 規範能維持核心簡潔性。"
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "definition" : "此欄位表示觀察結果的狀態。",
        "comment" : "此元素被標記為修飾性（modifier），因為 status 可能包含標示資源目前無效的代碼。",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.code"
            },
            {
              "type" : "value",
              "path" : "coding.system"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "觀察類型的分類",
        "definition" : "用於分類所進行觀察的一般類型的代碼。",
        "comment" : "除了必要的 category 值集外，此元素也允許根據擁有者自訂的分類方案進行多元分類，且可同時使用多個分類。分類的細緻程度由值集中的 category 概念所決定。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:twcore",
        "path" : "Observation.category",
        "sliceName" : "twcore",
        "short" : "職業觀察",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:twcore.coding",
        "path" : "Observation.category.coding",
        "min" : 1
      },
      {
        "id" : "Observation.category:twcore.coding.system",
        "path" : "Observation.category.coding.system",
        "short" : "專門術語系統（terminology system）的識別碼",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/observation-category"
      },
      {
        "id" : "Observation.category:twcore.coding.code",
        "path" : "Observation.category.coding.code",
        "short" : "系統定義的語法符號",
        "min" : 1,
        "patternCode" : "social-history"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "職業歷史",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11341-5"
            }
          ]
        },
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ObservationCode"
            }
          ],
          "strength" : "preferred",
          "description" : "Codes identifying names of simple observations.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-codes"
        }
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼"
      },
      {
        "id" : "Observation.code.coding.system",
        "path" : "Observation.code.coding.system",
        "short" : "專門術語系統（terminology system）的識別碼"
      },
      {
        "id" : "Observation.code.coding.code",
        "path" : "Observation.code.coding.code",
        "short" : "系統定義的語法符號"
      },
      {
        "id" : "Observation.code.text",
        "path" : "Observation.code.text",
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "此觀察所關於的對象",
        "definition" : "此觀察所關於且將觀察記錄存入其病歷的病人、病人群組、地點或設備。",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "short" : "進行此觀察時的醫療事件",
        "definition" : "此觀察所發生的醫療事件（例如病人與醫療提供者的互動）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "觀察在臨床上相關的時間區間",
        "definition" : "觀察值被視為有效的時間區間。對於生物主體（例如人類患者），這通常被稱為「生理相關時間」。",
        "type" : [
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "對觀察結果負責的人",
        "definition" : "負責確認觀察數值為「真實」的人。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "職業代碼或文字",
        "definition" : "進行觀察後所確定的職業資訊。",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/occupation-lia-roc-tw"
        }
      },
      {
        "id" : "Observation.value[x].coding",
        "path" : "Observation.value[x].coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.value[x].coding:LiaRocOccupation",
        "path" : "Observation.value[x].coding",
        "sliceName" : "LiaRocOccupation",
        "short" : "此為中華民國人壽保險商業同業公會(LIA-ROC)維護的臺灣地區傷害保險個人職業分類表，可免費使用，可依情境選用此代碼。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/occupation-lia-roc-tw"
        }
      },
      {
        "id" : "Observation.value[x].coding:LiaRocOccupation.system",
        "path" : "Observation.value[x].coding.system",
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/occupation-lia-roc-tw"
      },
      {
        "id" : "Observation.value[x].coding:LiaRocOccupation.code",
        "path" : "Observation.value[x].coding.code",
        "min" : 1
      },
      {
        "id" : "Observation.value[x].coding:MolOccupation",
        "path" : "Observation.value[x].coding",
        "sliceName" : "MolOccupation",
        "short" : "此為中華民國勞動部(MOL)維護的職業標準分類，可免費使用，可依情境選用此代碼。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/occupation-mol-tw"
        }
      },
      {
        "id" : "Observation.value[x].coding:MolOccupation.system",
        "path" : "Observation.value[x].coding.system",
        "patternUri" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/occupation-mol-tw"
      },
      {
        "id" : "Observation.value[x].coding:MolOccupation.code",
        "path" : "Observation.value[x].coding.code",
        "min" : 1
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "short" : "用於此觀察的標本",
        "definition" : "進行此觀察時所使用的標本。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component:industry",
        "path" : "Observation.component",
        "sliceName" : "industry",
        "short" : "行業",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:industry.modifierExtension",
        "path" : "Observation.component.modifierExtension",
        "short" : "不可被忽略的擴充資訊"
      },
      {
        "id" : "Observation.component:industry.code",
        "path" : "Observation.component.code",
        "short" : "行業觀察的類型（代碼／類型）",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "86188-0"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:industry.code.coding.system",
        "path" : "Observation.component.code.coding.system",
        "short" : "專門術語系統（terminology system）的識別碼"
      },
      {
        "id" : "Observation.component:industry.code.coding.code",
        "path" : "Observation.component.code.coding.code",
        "short" : "系統定義的語法符號"
      },
      {
        "id" : "Observation.component:industry.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Observation.component:industry.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "short" : "此為行政院主計總處維護的行業分類，可免費使用，可依情境選用此代碼。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/industry-dgbas-tw"
        }
      }
    ]
  }
}

```
