# TW Core Observation ECG - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation ECG 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-ecg-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationECG |

 
此臺灣核心-心電圖（TW Core Observation ECG） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現心電圖（ECG/EKG）資料。 

**Usages:**

* Examples for this Profile: [Observation/obs-ecg-example](Observation-obs-ecg-example.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-ecg-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-ecg-twcore.csv), [Excel](StructureDefinition-Observation-ecg-twcore.xlsx), [Schematron](StructureDefinition-Observation-ecg-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Observation-id.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?_id=[id]`
`GET [base]/Observation/[id]`例子：
(1) GET [base]/Observation?_id=obs-ecg-example
(2) GET [base]/Observation/obs-ecg-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?category={system|}[code]`例子：
(1) GET [base]/Observation?category=http://terminology.hl7.org/CodeSystem/observation-category|procedure
1. **建議應該（SHOULD）**支援透過查詢參數**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?code={system|}[code]`例子：
(1) GET [base]/Observation?code=http://loinc.org|11524-6
1. **建議應該（SHOULD）**支援透過查詢參數**[`performer`](SearchParameter-Observation-performer.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Observation?performer={Type/}[id]`例子：
(1) GET [base]/Observation?performer=Practitioner/pra-dr-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?status=[code]`例子：
(1) GET [base]/Observation?status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Observation-subject.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Observation?subject={Type/}[id]`例子：
(1) GET [base]/Observation?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?date=[date]`例子：
(1) GET [base]/Observation?date=2024-08-23



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-ecg-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-ecg-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationECG",
  "title" : "TW Core Observation ECG",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-心電圖（TW Core Observation ECG） Profile說明本IG如何進一步定義FHIR的Observation Resource以呈現心電圖（ECG/EKG）資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "心電圖檢查",
        "definition" : "心電圖（ECG/EKG）檢查結果，記錄心臟電生理活動的波形資料。"
      },
      {
        "id" : "Observation.id",
        "path" : "Observation.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Observation紀錄，通常又稱為邏輯性ID。"
      },
      {
        "id" : "Observation.meta",
        "path" : "Observation.meta",
        "short" : "此Observation Resource的metadata"
      },
      {
        "id" : "Observation.language",
        "path" : "Observation.language",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ]
      },
      {
        "id" : "Observation.basedOn",
        "path" : "Observation.basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.partOf",
        "path" : "Observation.partOf",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "short" : "registered ｜ preliminary ｜ final ｜ amended +",
        "definition" : "心電圖檢查結果的狀態",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "心電圖檢查分類",
        "definition" : "此心電圖檢查的分類，使用 procedure 表示這是一項診斷程序。",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:twcore",
        "path" : "Observation.category",
        "sliceName" : "twcore",
        "short" : "procedure",
        "min" : 0,
        "max" : "*",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "procedure"
            }
          ]
        },
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "http://hl7.org/fhir/ValueSet/observation-category"
        }
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "心電圖檢查代碼",
        "definition" : "心電圖檢查的LOINC代碼，使用 11524-6 (EKG Study)",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11524-6"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.code.coding",
        "path" : "Observation.code.coding",
        "min" : 1
      },
      {
        "id" : "Observation.code.text",
        "path" : "Observation.code.text",
        "short" : "心電圖檢查"
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "受檢者",
        "definition" : "接受心電圖檢查的病人",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "檢查時間",
        "definition" : "心電圖檢查執行的時間",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Period"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "執行者",
        "definition" : "執行心電圖檢查的醫事人員或機構",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.device",
        "path" : "Observation.device",
        "short" : "心電圖設備",
        "definition" : "用於執行心電圖檢查的設備"
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "心電圖導程資料",
        "definition" : "心電圖各導程（Lead）的測量資料，使用 SampledData 型別記錄波形資料。",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadI",
        "path" : "Observation.component",
        "sliceName" : "LeadI",
        "short" : "Lead I 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadI.code",
        "path" : "Observation.component.code",
        "short" : "Lead I 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131329",
              "display" : "Lead I"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadI.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead I 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadII",
        "path" : "Observation.component",
        "sliceName" : "LeadII",
        "short" : "Lead II 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadII.code",
        "path" : "Observation.component.code",
        "short" : "Lead II 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131330",
              "display" : "Lead II"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadII.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead II 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadIII",
        "path" : "Observation.component",
        "sliceName" : "LeadIII",
        "short" : "Lead III 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadIII.code",
        "path" : "Observation.component.code",
        "short" : "Lead III 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131389",
              "display" : "Lead III"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadIII.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead III 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadAVR",
        "path" : "Observation.component",
        "sliceName" : "LeadAVR",
        "short" : "Lead aVR 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadAVR.code",
        "path" : "Observation.component.code",
        "short" : "Lead aVR 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131390",
              "display" : "Lead aVR"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadAVR.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead aVR 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadAVL",
        "path" : "Observation.component",
        "sliceName" : "LeadAVL",
        "short" : "Lead aVL 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadAVL.code",
        "path" : "Observation.component.code",
        "short" : "Lead aVL 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131391",
              "display" : "Lead aVL"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadAVL.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead aVL 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadAVF",
        "path" : "Observation.component",
        "sliceName" : "LeadAVF",
        "short" : "Lead aVF 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadAVF.code",
        "path" : "Observation.component.code",
        "short" : "Lead aVF 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131392",
              "display" : "Lead aVF"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadAVF.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead aVF 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV1",
        "path" : "Observation.component",
        "sliceName" : "LeadV1",
        "short" : "Lead V1 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV1.code",
        "path" : "Observation.component.code",
        "short" : "Lead V1 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131331",
              "display" : "Lead V1"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadV1.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead V1 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV2",
        "path" : "Observation.component",
        "sliceName" : "LeadV2",
        "short" : "Lead V2 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV2.code",
        "path" : "Observation.component.code",
        "short" : "Lead V2 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131332",
              "display" : "Lead V2"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadV2.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead V2 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV3",
        "path" : "Observation.component",
        "sliceName" : "LeadV3",
        "short" : "Lead V3 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV3.code",
        "path" : "Observation.component.code",
        "short" : "Lead V3 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131333",
              "display" : "Lead V3"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadV3.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead V3 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV4",
        "path" : "Observation.component",
        "sliceName" : "LeadV4",
        "short" : "Lead V4 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV4.code",
        "path" : "Observation.component.code",
        "short" : "Lead V4 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131334",
              "display" : "Lead V4"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadV4.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead V4 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV5",
        "path" : "Observation.component",
        "sliceName" : "LeadV5",
        "short" : "Lead V5 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV5.code",
        "path" : "Observation.component.code",
        "short" : "Lead V5 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131335",
              "display" : "Lead V5"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadV5.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead V5 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV6",
        "path" : "Observation.component",
        "sliceName" : "LeadV6",
        "short" : "Lead V6 導程",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:LeadV6.code",
        "path" : "Observation.component.code",
        "short" : "Lead V6 代碼",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "urn:oid:2.16.840.1.113883.6.24",
              "code" : "131336",
              "display" : "Lead V6"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:LeadV6.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "Lead V6 波形資料",
        "type" : [
          {
            "code" : "SampledData"
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
