# TW Core Observation Average Blood Pressure - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Observation Average Blood Pressure 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-averageBloodPressure-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreObservationAverageBloodPressure |

 
此臺灣核心-平均血壓（TW Core Observation Average Blood Pressure）Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現平均血壓資料。 

**Usages:**

* Examples for this Profile: [Observation/obs-averageBloodPressure-example](Observation-obs-averageBloodPressure-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Observation-averageBloodPressure-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Observation-averageBloodPressure-twcore.csv), [Excel](StructureDefinition-Observation-averageBloodPressure-twcore.xlsx), [Schematron](StructureDefinition-Observation-averageBloodPressure-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`category`](SearchParameter-Observation-category.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**及**[`code`](SearchParameter-Observation-clinical-code.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|8867-4,http://loinc.org|85354-9,http://loinc.org|96607-7
1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&date=ge2020-01-01T00:00:00Z

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`status`](SearchParameter-Observation-status.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Observation?patient={Type/}[id]&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&status={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`category`](SearchParameter-Observation-category.md)**及**[`_lastUpdated`](SearchParameter-Observation-lastupdated.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&category={system|}[code]&_lastUpdated={gt|lt|ge|le}[date]{&_lastUpdated={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&category=http://terminology.hl7.org/CodeSystem/observation-category|vital-signs&_lastUpdated=ge2024-01-01T00:00:00Z
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-Observation-patient.md)**、**[`code`](SearchParameter-Observation-clinical-code.md)**及**[`date`](SearchParameter-Observation-date.md)**查詢所有Observation：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Observation?patient={Type/}[id]&code={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/Observation?patient=Patient/pat-example&code=http://loinc.org|8867-4,http://loinc.org|85354-9,http://loinc.org|96607-7&date=ge2020-01-01T00:00:00Z



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Observation-averageBloodPressure-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-averageBloodPressure-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreObservationAverageBloodPressure",
  "title" : "TW Core Observation Average Blood Pressure",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-平均血壓（TW Core Observation Average Blood Pressure）Profile 說明本 IG 如何進一步定義 FHIR 的 Observation Resource 以呈現平均血壓資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation",
        "short" : "測量與簡單陳述",
        "definition" : "關於病人、裝置或其他主體的測量與簡單陳述。",
        "comment" : "用於簡單觀察，例如裝置測量、實驗室原子結果、生命徵象、身高、體重、吸菸狀態、備註等。其他資源則用於提供觀察的上下文，例如實驗室報告等。"
      },
      {
        "id" : "Observation.implicitRules",
        "path" : "Observation.implicitRules",
        "short" : "建立本內容所依據的一組規則",
        "definition" : "指向建構本 resource 時所遵循規則的參照，處理內容時必須理解這些規則。通常是參照定義特殊規則的實作指南（Implementation Guide），以及其他 profiles 等。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解，這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，尚未準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應避免使用此欄位。通常在使用時，此 URL 是對 IG 的參照，該 IG 將這些特殊規則與其他 profiles、value sets 等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Observation.modifierExtension",
        "path" : "Observation.modifierExtension",
        "short" : "不可被忽略的擴充資訊",
        "definition" : "可用於表示不屬於資源基本定義、且會改變所屬元素或其子元素意義的額外資訊。通常這類元素用於否定或限定。為了讓擴充的使用安全且可管理，FHIR 對擴充的定義與使用有嚴格治理規範。任何實作者都可以定義擴充，但必須符合一系列要求。處理資源的應用程式必須檢查 modifier extensions。",
        "comment" : "任何應用、專案或標準都不應因使用擴充而受到歧視，無論其定義或使用的機構或法域為何。擴充的使用讓 FHIR 規範能維持核心簡潔性。"
      },
      {
        "id" : "Observation.basedOn",
        "path" : "Observation.basedOn",
        "short" : "實現計畫、提案或指示",
        "definition" : "一個由本事件全部或部分實現的計畫、提案或指示。例如，MedicationRequest 可能要求在給藥前，病人需先進行實驗室檢查。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
              "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
              "http://hl7.org/fhir/StructureDefinition/ImmunizationRecommendation",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ServiceRequest-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.partOf",
        "path" : "Observation.partOf",
        "short" : "所屬的參照事件",
        "definition" : "此 Observation 所屬的較大事件或步驟。例如，作為某個處置（procedure）的一部分的觀察。",
        "comment" : "若要將 Observation 連結到 Encounter，請使用 encounter 欄位。關於如何參照其他 Observation，請參見下方說明。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationStatement-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Immunization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.status",
        "path" : "Observation.status",
        "definition" : "此欄位表示觀察結果的狀態。",
        "comment" : "此元素被標記為修飾性（modifier），因為 status 可能包含標示資源目前無效的代碼。",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category",
        "path" : "Observation.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.code"
            },
            {
              "type" : "value",
              "path" : "coding.system"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "觀察類型的分類",
        "definition" : "用於分類所進行觀察的一般類型的代碼。",
        "comment" : "除了必要的 category 值集外，此元素也允許根據擁有者自訂的分類方案進行多元分類，且可同時使用多個分類。分類的細緻程度由值集中的 category 概念所決定。",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:VSCat",
        "path" : "Observation.category",
        "sliceName" : "VSCat",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.category:VSCat.coding",
        "path" : "Observation.category.coding",
        "short" : "由術語系統所定義的代碼",
        "definition" : "參照由術語系統定義的代碼。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如 SNOMED CT—更多資訊見 HL7 v3 核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為 UserSelected = true。",
        "min" : 1
      },
      {
        "id" : "Observation.category:VSCat.coding.system",
        "path" : "Observation.category.coding.system",
        "short" : "術語系統的識別碼",
        "definition" : "定義代碼符號意義的代碼系統之識別。",
        "comment" : "URI 可以是 OID（urn:oid:...）或 UUID（urn:uuid:...）。OID 和 UUID 應參考 HL7 OID 註冊表。否則，URI 應來自 HL7 的 FHIR 特殊 URI 定義列表，或參考某些能清楚且無歧義地建立系統的定義。",
        "min" : 1,
        "patternUri" : "http://terminology.hl7.org/CodeSystem/observation-category"
      },
      {
        "id" : "Observation.category:VSCat.coding.code",
        "path" : "Observation.category.coding.code",
        "short" : "由系統定義的語法符號",
        "definition" : "由系統定義的語法符號。此符號可能是一個預定義的代碼，或是由編碼系統定義的語法中的表達式（例如 post-coordination）。",
        "min" : 1,
        "patternCode" : "vital-signs"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "short" : "血壓",
        "definition" : "描述所觀察到的內容。有時這也被稱為觀察的「名稱」。",
        "comment" : "所有的 code-value 配對，以及（若有的話）component.code 與 component.value 的配對，都需要被考慮，才能正確理解此觀察的意義。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "96607-7"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.subject",
        "path" : "Observation.subject",
        "short" : "此觀察所關於的對象",
        "definition" : "此觀察所關於且將觀察記錄存入其病歷的病人、病人群組、地點或設備。如果觀察的實際焦點與主體不同（或是主體的樣本、部分或區域），則由 focus 元素或代碼本身指定觀察的實際焦點。",
        "comment" : "一般預期此元素的基數為 1..1。唯一可能缺少 subject 的情況是當觀察由不知道病人身分的設備所進行時。在此情況下，觀察必須（SHALL）通過某些上下文/通道匹配技術與病人配對，此時觀察應被更新。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.encounter",
        "path" : "Observation.encounter",
        "short" : "進行此觀察時的醫療事件",
        "definition" : "此觀察所發生的醫療事件（例如病人與醫療提供者的互動）。",
        "comment" : "這通常是發生事件時的就診（encounter），但有些事件可能在就診正式結束之前或之後發起，但仍與就診的上下文有關（例如入院前的實驗室檢查）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "short" : "觀察在臨床上相關的時間/時間區間",
        "definition" : "觀察值被視為有效的時間或時間區間。對於生物主體（例如人類患者），這通常被稱為「生理相關時間」。這通常是處置的時間或標本採集的時間，但很多情況下時間/日期的來源是未知的，僅知道時間/日期本身。",
        "comment" : "除非此觀察是歷史記錄，否則至少應該有一個日期。對於記錄不精確或「模糊」的時間（例如「早餐後」測量的血糖），使用 Timing 資料型別，它允許將測量與日常生活事件相關聯。",
        "min" : 1,
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "Period"
          },
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : false
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Timing"
          },
          {
            "code" : "instant"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.performer",
        "path" : "Observation.performer",
        "short" : "對觀察結果負責的人",
        "definition" : "負責確認觀察數值為「真實」的人。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.value[x]",
        "path" : "Observation.value[x]",
        "short" : "實際結果",
        "definition" : "進行觀察後所確定的資訊，若該資訊具有簡單值。",
        "comment" : "一個觀察可能有：1）在此處有單一值，2）同時有一個值和一組相關或組成值，或 3）只有一組相關或組成值。如果存在值，此元素的資料類型應由 Observation.code 決定。如果欄位通常是編碼的，或者與 Observation.code 相關聯的類型定義了一個編碼值，則應使用只有文字的 CodeableConcept 而非字串。更多指引請參見下方備註。",
        "max" : "0"
      },
      {
        "id" : "Observation.specimen",
        "path" : "Observation.specimen",
        "short" : "用於此觀察的標本",
        "definition" : "進行此觀察時所使用的標本。",
        "comment" : "僅在 Observation.code 的代碼中未隱含標本資訊時才應使用。觀察並非對標本本身進行，而是對主體進行，但許多情況是通過標本進行的。請注意，雖然標本常常會被使用，但並非總是被明確追蹤和報告。同時也請注意，觀察資源可能被用在明確追蹤標本的情境中（例如診斷報告）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Specimen-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Observation.hasMember",
        "path" : "Observation.hasMember",
        "short" : "屬於觀察群組的相關資源",
        "definition" : "此觀察是一個群組觀察（例如一組檢測、一系列檢驗或一組生命徵象測量），包含目標作為群組的成員。",
        "comment" : "使用此元素時，一個觀察通常會有一個值或一組相關資源，但在某些情況下兩者都可能存在。關於觀察如何在群組中組合的方式討論，請參見下方備註。請注意，系統可能會從 QuestionnaireResponse 中計算結果到最終分數，並將該分數表示為一個觀察。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.derivedFrom",
        "path" : "Observation.derivedFrom",
        "short" : "此觀察值衍生自的相關測量",
        "definition" : "代表本觀察值衍生來源的目標資源。例如，根據測量計算的陰離子間隙，或基於超音波影像的胎兒測量。",
        "comment" : "此元素中列出的所有參考選擇都可以代表臨床觀察和其他可能作為衍生值來源的測量。最常見的參考將是另一個觀察（Observation）。關於觀察如何在群組中組合的方式討論，請參見下方備註。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/ImagingStudy-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Media-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/QuestionnaireResponse-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore",
              "http://hl7.org/fhir/StructureDefinition/MolecularSequence"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "平均收縮壓、平均舒張壓及其他相關指標",
        "definition" : "某些觀察有多個組件觀察。這些組件觀察表示為共享相同屬性的獨立代碼-數值對。例如血壓測量的收縮壓和舒張壓組件觀察，以及基因觀察的多個組件觀察。",
        "comment" : "關於觀察如何在群組中組合的方式討論，請參見下方備註。",
        "min" : 2,
        "constraint" : [
          {
            "key" : "tw-core-2",
            "severity" : "error",
            "human" : "If there is no value a data absent reason must be present",
            "expression" : "value.exists() or dataAbsentReason.exists()",
            "source" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-averageBloodPressure-twcore"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.modifierExtension",
        "path" : "Observation.component.modifierExtension",
        "short" : "不可被忽略的擴充資訊",
        "definition" : "可用於表示不屬於資源基本定義、且會改變所屬元素或其子元素意義的額外資訊。通常這類元素用於否定或限定。為了讓擴充的使用安全且可管理，FHIR 對擴充的定義與使用有嚴格治理規範。任何實作者都可以定義擴充，但必須符合一系列要求。處理資源的應用程式必須檢查修飾擴充。",
        "comment" : "任何應用、專案或標準都不應因使用擴充而受到歧視，無論其定義或使用的機構或法域為何。擴充的使用讓 FHIR 規範能維持核心簡潔性。修飾擴充不得改變資源或領域資源上任何元素的意義（包括不能改變修飾擴充本身的意義）。"
      },
      {
        "id" : "Observation.component.code",
        "path" : "Observation.component.code",
        "short" : "組件觀察的類型（代碼/類型）",
        "definition" : "描述觀察到的內容。有時這被稱為觀察「代碼」。",
        "comment" : "所有的代碼-數值配對和組件.代碼-組件.數值配對都需要被考慮，才能正確理解此觀察的意義。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ]
      },
      {
        "id" : "Observation.component.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "生命徵象組成項目數值",
        "definition" : "生命徵象的值通常使用 Quantity 資料型別記錄。對於支援觀察（例如 cuff size）等其他資料型別，可以使用其他資料型別，例如 CodeableConcept。",
        "comment" : "用於觀察具有一組組件觀察時。一個觀察可能同時有一個值（例如 Apgar score）和組件觀察（用於推導 Apgar score 的觀察）。如果存在值，此元素的資料類型應由 Observation.code 決定。如果欄位通常是編碼的，或者與 Observation.code 相關聯的類型定義了一個編碼值，則應使用只有文字的 CodeableConcept 而非字串。更多指引請參見下方備註。",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component.dataAbsentReason",
        "path" : "Observation.component.dataAbsentReason",
        "short" : "為什麼組成項目的結果會缺少",
        "definition" : "提供 Observation.component.value[x] 元素中預期值缺失的原因。",
        "comment" : "在 FHIR 觀察中，「空值」或例外值可以通過兩種方式表示。一種方式是直接將它們包含在值集中並在值中表示例外情況。例如，血清學檢測的測量值可以是「已檢測到」、「未檢測到」、「結果不確定」或「未完成檢測」。另一種方式是使用 value 元素來記錄實際觀察值，並使用明確的 dataAbsentReason 元素來記錄例外值。例如，當測量未完成時，可以使用 dataAbsentReason 代碼「error」。由於存在這些選項，因此需要用例協議來解釋例外值的一般觀察。",
        "condition" : ["tw-core-2"],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic",
        "path" : "Observation.component",
        "sliceName" : "Systolic",
        "short" : "平均收縮壓",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.modifierExtension",
        "path" : "Observation.component.modifierExtension",
        "definition" : "可用於表示不屬於資源基本定義、且會改變所屬元素或其子元素意義的額外資訊。通常這類元素用於否定或限定。為了讓擴充的使用安全且可管理，FHIR 對擴充的定義與使用有嚴格治理規範。任何實作者都可以定義擴充，但必須符合一系列要求。處理資源的應用程式必須檢查修飾擴充。修飾擴充不得改變資源或領域資源上任何元素的意義（包括不能改變修飾擴充本身的意義）。",
        "comment" : "任何應用、專案或標準都不應因使用擴充而受到歧視，無論其定義或使用的機構或法域為何。擴充的使用讓 FHIR 規範能維持核心簡潔性。"
      },
      {
        "id" : "Observation.component:Systolic.code",
        "path" : "Observation.component.code",
        "short" : "平均收縮壓代碼",
        "comment" : "所有的 code-value 配對和 component.code-component.value 配對都需要被考慮，才能正確理解此觀察的意義。",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "96608-5"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "平均收縮壓數值",
        "definition" : "生命徵象的值通常使用 Quantity 資料型別記錄。對於支援觀察（例如 cuff size）等其他資料型別，可以使用其他資料型別，例如 CodeableConcept。進行觀察後所確定的資訊，若該資訊具有簡單值。",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "condition" : ["tw-core-2"]
      },
      {
        "id" : "Observation.component:Systolic.value[x].value",
        "path" : "Observation.component.value[x].value",
        "short" : "數值（具隱含精確度）",
        "definition" : "測量數值的大小。此數值在呈現時包含隱含的精確度。",
        "comment" : "數值中隱含的精確度應始終被尊重。貨幣值有其自己的精確度處理規則（請參照 standard accounting text books）。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.value[x].comparator",
        "path" : "Observation.component.value[x].comparator",
        "short" : "< | <= | >= | > - 如何理解數值",
        "definition" : "說明如何理解與呈現此數值——即實際數值是否因測量問題而大於或小於所述數值。例如，若 comparator 為「<」，則實際數值小於所述數值。"
      },
      {
        "id" : "Observation.component:Systolic.value[x].unit",
        "path" : "Observation.component.value[x].unit",
        "short" : "單位表示",
        "definition" : "單位的人類可讀形式。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.value[x].system",
        "path" : "Observation.component.value[x].system",
        "short" : "定義單位編碼形式的系統",
        "definition" : "提供單位編碼形式的系統識別。",
        "min" : 1,
        "patternUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Systolic.value[x].code",
        "path" : "Observation.component.value[x].code",
        "short" : "單位的編碼形式",
        "definition" : "單位在某些單位表示系統中的可供電腦處理的編碼形式。",
        "comment" : "建議使用 UCUM 系統，但也可使用 SNOMED CT（慣用單位）或 ISO 4217（貨幣）。使用情境可能會要求來自特定系統的代碼。",
        "min" : 1,
        "patternCode" : "mm[Hg]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic",
        "path" : "Observation.component",
        "sliceName" : "Diastolic",
        "short" : "平均舒張壓",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.modifierExtension",
        "path" : "Observation.component.modifierExtension",
        "definition" : "可用於表示不屬於資源基本定義、且會改變所屬元素或其子元素意義的額外資訊。通常這類元素用於否定或限定。為了讓擴充的使用安全且可管理，FHIR 對擴充的定義與使用有嚴格治理規範。任何實作者都可以定義擴充，但必須符合一系列要求。處理資源的應用程式必須檢查修飾擴充。修飾擴充不得改變資源或領域資源上任何元素的意義（包括不能改變修飾擴充本身的意義）。",
        "comment" : "任何應用、專案或標準都不應因使用擴充而受到歧視，無論其定義或使用的機構或法域為何。擴充的使用讓 FHIR 規範能維持核心簡潔性。"
      },
      {
        "id" : "Observation.component:Diastolic.code",
        "path" : "Observation.component.code",
        "short" : "平均舒張壓代碼",
        "definition" : "描述觀察到的內容。有時這被稱為觀察『代碼』。",
        "comment" : "所有的 code-value 配對和 component.code-component.value 配對都需要被考慮，才能正確理解此觀察的意義。",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "96609-3"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.value[x]",
        "path" : "Observation.component.value[x]",
        "short" : "平均舒張壓數值",
        "definition" : "生命徵象的值通常使用 Quantity 資料型別記錄。對於支援觀察（例如袖帶大小）等其他資料型別，可以使用其他資料型別，例如 CodeableConcept。進行觀察後所確定的資訊，若該資訊具有簡單值。",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "condition" : ["tw-core-2"]
      },
      {
        "id" : "Observation.component:Diastolic.value[x].value",
        "path" : "Observation.component.value[x].value",
        "short" : "數值（具隱含精確度）",
        "definition" : "測量數值的大小。此數值在呈現時包含隱含的精確度。",
        "comment" : "數值中隱含的精確度應始終被尊重。貨幣值有其自己的精確度處理規則（請參照 standard accounting text books）。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.value[x].comparator",
        "path" : "Observation.component.value[x].comparator",
        "short" : "< | <= | >= | > - 如何理解數值",
        "definition" : "說明如何理解與呈現此數值——即實際數值是否因測量問題而大於或小於所述數值。例如，若 comparator 為「<」，則實際數值小於所述數值。"
      },
      {
        "id" : "Observation.component:Diastolic.value[x].unit",
        "path" : "Observation.component.value[x].unit",
        "short" : "單位表示",
        "definition" : "單位的人類可讀形式。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.value[x].system",
        "path" : "Observation.component.value[x].system",
        "short" : "定義單位編碼形式的系統",
        "definition" : "提供單位編碼形式的系統識別。",
        "min" : 1,
        "patternUri" : "http://unitsofmeasure.org",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Diastolic.value[x].code",
        "path" : "Observation.component.value[x].code",
        "short" : "單位的編碼形式",
        "definition" : "單位在某些單位表示系統中的可供電腦處理的編碼形式。",
        "comment" : "建議使用 UCUM 系統，但也可使用 SNOMED CT（慣用單位）或 ISO 4217（貨幣）。使用情境可能會要求來自特定系統的代碼。",
        "min" : 1,
        "patternCode" : "mm[Hg]",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Number",
        "path" : "Observation.component",
        "sliceName" : "Number",
        "short" : "測量次數",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Number.modifierExtension",
        "path" : "Observation.component.modifierExtension",
        "definition" : "可用於表示不屬於資源基本定義、且會改變所屬元素或其子元素意義的額外資訊。通常這類元素用於否定或限定。為了讓擴充的使用安全且可管理，FHIR 對擴充的定義與使用有嚴格治理規範。任何實作者都可以定義擴充，但必須符合一系列要求。處理資源的應用程式必須檢查修飾擴充。修飾擴充不得改變資源或領域資源上任何元素的意義（包括不能改變修飾擴充本身的意義）。",
        "comment" : "任何應用、專案或標準都不應因使用擴充而受到歧視，無論其定義或使用的機構或法域為何。擴充的使用讓 FHIR 規範能維持核心簡潔性。"
      },
      {
        "id" : "Observation.component:Number.code",
        "path" : "Observation.component.code",
        "comment" : "所有的 code-value 配對和 component.code-component.value 配對都需要被考慮，才能正確理解此觀察的意義。",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "246432004"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Number.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "Observation.component:Number.value[x]:valueQuantity",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueQuantity",
        "definition" : "生命徵象的值通常使用 Quantity 資料型別記錄。對於支援觀察（例如袖帶大小）等其他資料型別，可以使用其他資料型別，例如 CodeableConcept。進行觀察後所確定的資訊，若該資訊具有簡單值。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Number.value[x]:valueQuantity.value",
        "path" : "Observation.component.value[x].value",
        "short" : "數值（具隱含精確度）",
        "definition" : "測量數值的大小。此數值在呈現時包含隱含的精確度。",
        "comment" : "數值中隱含的精確度應始終被尊重。貨幣值有其自己的精確度處理規則（請參照 standard accounting text books）。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "Observation.component:Number.value[x]:valueQuantity.comparator",
        "path" : "Observation.component.value[x].comparator",
        "short" : "< | <= | >= | > - 如何理解數值",
        "definition" : "說明如何理解與呈現此數值——即實際數值是否因測量問題而大於或小於所述數值。例如，若 comparator 為「<」，則實際數值小於所述數值。"
      }
    ]
  }
}

```
