# TW Core MedicationDispense - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core MedicationDispense 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreMedicationDispense |

 
此臺灣核心-配藥或藥品調劑（TW Core MedicationDispense） Profile說明本IG如何進一步定義FHIR的MedicationDispense Resource以呈現配藥或藥品調劑的詳細資料。 

## Resource MedicationDispense - 內容

這指的是已經或即將為特定的人或病人配藥或調劑藥品，包括對所提供的藥品及如何使用這些藥品的指導說明。藥局依據藥品處方進行配藥或調劑藥品。

### 範圍與使用

這個 resource 涵蓋了向病人供應藥品的過程。例子包括從門診或社區藥局領藥和調劑藥品，從住院藥局向病房病人配藥，以及從病房庫存發放單一劑量給病人服用。 藥品調劑（MedicationDispense）是藥局回應藥品處方的結果。

從 FHIR 工作流程的角度來看，MedicationDispense 是一個事件 resource - 參見 [工作流程事件 （Workflow Event）](https://hl7.org/fhir/R4/workflow.html#relationships)。

### 界限與關聯

**The Medication domain includes a number of related resources**

* Resource: [MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)（藥品請求）
  * 說明: 一個關於供應藥品及病人服藥或用藥指示的醫令。
* Resource: [MedicationDispense](StructureDefinition-MedicationDispense-twcore.md)（配藥或調劑藥品）
  * 說明: 提供一批藥品，旨在隨後由病人使用或服用（通常是回應處方）。
* Resource: [MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html)（給藥）
  * 說明: 當病人實際使用藥品或者以其他方式給予病人藥品時。
* Resource: [MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)（用藥聲明）
  * 說明: 這是一項紀錄，記錄了病人服用藥品或藥品已經給予病人，其中紀錄是基於病人或另一位臨床醫生的報告。藥品聲明不是「處方開立->配藥->給藥」過程中的一部分，而是一個報告，表明這樣的過程（或至少其一部分）確實發生了，從而認為病人已經接受了特定的藥品。

這個 resource 不涉及向病人供應或移交非藥品相關項目。非藥品相關項目例如醫療器材、照護用品相關物資等，包括從基本的生活輔助用品到專門的醫療設備或治療用品。

### 背景

供應和相關的用藥指示可能不會完全遵循原始的處方，這可能是因為在這個過程中某些細節留待此時完成，或因為配藥者運用其臨床判斷進行了一些適當的修改。

這個 resource 被 [費用項目（ChargeItem）](https://hl7.org/fhir/R4/chargeitem.html#ChargeItem)、[用藥聲明 （MedicationStatement）](StructureDefinition-MedicationStatement-twcore.md)和[檢驗檢查 （Observation）](StructureDefinition-Observation-laboratoryResult-twcore.md)參照。

**Usages:**

* Refer to this Profile: [TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md), [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md), [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md), [TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md)...Show 13 more,[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md)and[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)
* Examples for this Profile: [MedicationDispense/med-dis-drop-example](MedicationDispense-med-dis-drop-example.md), [MedicationDispense/med-dis-inflamed-example](MedicationDispense-med-dis-inflamed-example.md), [MedicationDispense/med-dis-injection-example](MedicationDispense-med-dis-injection-example.md) and [MedicationDispense/med-dis-ref-example](MedicationDispense-med-dis-ref-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/MedicationDispense-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-MedicationDispense-twcore.csv), [Excel](StructureDefinition-MedicationDispense-twcore.xlsx), [Schematron](StructureDefinition-MedicationDispense-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-MedicationDispense-id.md)**查詢所有MedicationDispense：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/MedicationDispense?_id=[id]`
`GET [base]/MedicationDispense/[id]`例子：
(1) GET [base]/MedicationDispense?_id=med-dis-ref-example
(2) GET [base]/MedicationDispense/med-dis-ref-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-MedicationDispense-status.md)**查詢所有MedicationDispense：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/MedicationDispense?status=[code]`例子：
(1) GET [base]/MedicationDispense?status=completed
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-MedicationDispense-subject.md)**查詢所有MedicationDispense：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/MedicationDispense?subject={Type/}[id]`例子：:
(1) GET [base]/MedicationDispense?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`medication`](SearchParameter-MedicationDispense-medication.md)**查詢所有MedicationDispense：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/MedicationDispense?medication={Type/}[id]`例子：:
(1) GET [base]/MedicationDispense?medication=Medication/med-example

#### Constraints 限制

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| **mdd-1** | [Rule](https://hl7.org/fhir/R4/conformance-rules.html#rule) | (base) | 藥品發放的時間 (whenHandedOver) 不可早於藥品包裝和審核時間 (whenPrepared) | whenHandedOver.empty() or whenPrepared.empty() or whenHandedOver >= whenPrepared |



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "MedicationDispense-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationDispense-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreMedicationDispense",
  "title" : "TW Core MedicationDispense",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-配藥或藥品調劑（TW Core MedicationDispense） Profile說明本IG如何進一步定義FHIR的MedicationDispense Resource以呈現配藥或藥品調劑的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense",
        "short" : "為指定病人配藥/調劑藥品",
        "definition" : "表明將為或已為指定人員/病人配藥/調劑藥品。這包括所提供藥品（供應品）的描述和給藥說明。配藥/調劑藥品是藥局系統回應藥品請求的結果。"
      },
      {
        "id" : "MedicationDispense.id",
        "path" : "MedicationDispense.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的MedicationDispense紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "MedicationDispense.meta",
        "path" : "MedicationDispense.meta",
        "short" : "此MedicationDispense Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "MedicationDispense.implicitRules",
        "path" : "MedicationDispense.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "MedicationDispense.language",
        "path" : "MedicationDispense.language",
        "short" : "用以表述MedicationDispense Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "MedicationDispense.text",
        "path" : "MedicationDispense.text",
        "short" : "MedicationDispense Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "MedicationDispense.identifier",
        "path" : "MedicationDispense.identifier",
        "short" : "配藥/調劑藥品的外部識別碼",
        "definition" : "與此配藥/調劑藥品相關的識別碼，由業務流程定義，和/或在直接使用 URL 參照resource本身不適當時用來表示它。這些是執行者或其他系統分配給此resource的業務識別碼，隨著resource更新和從伺服器到伺服器的傳送，這些識別碼保持不變。",
        "comment" : "這是配藥/調劑藥品的業務識別碼，不是resource識別碼。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.partOf",
        "path" : "MedicationDispense.partOf",
        "short" : "配藥/調劑藥品事件的一部分",
        "definition" : "觸發配藥/調劑藥品的程序",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Procedure-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.status",
        "path" : "MedicationDispense.status",
        "short" : "preparation | in-progress | cancelled | on-hold | completed +",
        "definition" : "指定配藥/調劑藥品事件集狀態的代碼",
        "comment" : "此資料項目被標記為修飾用(modifier)，因為其中的狀態代碼也包含表示此 resource 目前無效的代碼。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationDispenseStatus"
            }
          ],
          "strength" : "required",
          "description" : "一個編碼概念，用以具體說明配藥/藥品調劑事件的狀態；應填入所綁定值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationdispense-status|4.0.1"
        }
      },
      {
        "id" : "MedicationDispense.statusReason[x]",
        "path" : "MedicationDispense.statusReason[x]",
        "short" : "未進行配藥/調劑藥品的原因\nBinding：可參考Medication dispense status reason codes代碼表，但此代碼表只是針對這個欄位的一個可能值的示例，不預期也不鼓勵使用者一定要使用此代碼表的代碼。",
        "definition" : "表明為何未執行配藥/調劑藥品的原因",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationDispenseStatusReason"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationdispense-status-reason"
        }
      },
      {
        "id" : "MedicationDispense.category",
        "path" : "MedicationDispense.category",
        "short" : "配藥/調劑藥品的類型",
        "definition" : "表明配藥/調劑藥品類型（例如：預計在哪用藥或給藥（如住院病人或門診病人））。",
        "comment" : "類型可用於包含藥品的預期用藥地點或其他類型的配藥/調劑藥品。在建立Profile時，一組規則或條件(Invariant)可用於綁定到不同的值集，例如：可用來確保特定類型的配藥總是與特定的值集代碼關聯，從而保確資料的一致性和準確性。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationDispenseCategory"
            }
          ],
          "strength" : "preferred",
          "description" : "鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationdispense-category"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]",
        "path" : "MedicationDispense.medication[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "所提供的藥品",
        "definition" : "指明目前正在使用的藥品。這可能是一個連結到代表藥品詳細資訊的resource，或者是一個帶有代碼的簡單屬性，從已知藥品清單中表明藥品的代碼。",
        "comment" : "如果只指定了一個代碼，則此代碼必須是特定產品的代碼。如果需要更多資訊，則建議使用medication resource。例如：如果需要藥品的劑型(form)或批號(lot number)，則必須參照Medication resource。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationReference",
        "path" : "MedicationDispense.medication[x]",
        "sliceName" : "medicationReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationCodeableConcept",
        "path" : "MedicationDispense.medication[x]",
        "sliceName" : "medicationCodeableConcept",
        "short" : "所提供的藥品。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "指明所提供的藥品，這是一個指向代表藥品的resource的連接，可以是藥品的細節，也可以是一個帶有代碼的屬性，從已知的藥品列表中指明此藥品。",
        "comment" : "如果只具體說明一個代碼，那麼它需要是一個特定產品的代碼。如果需要更多資訊，那麼建議使用Medication resource。例如：如果您需要劑型或批號，或者如果藥品是複方或臨場調製（extemporaneously prepared）的，那麼您必須參考Medication resource。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationCodeableConcept.coding",
        "path" : "MedicationDispense.medication[x].coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。"
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationCodeableConcept.coding:fda-medication-tw",
        "path" : "MedicationDispense.medication[x].coding",
        "sliceName" : "fda-medication-tw",
        "short" : "此為臺灣食品藥物管理署(TFDA)維護之藥品代碼，涵蓋範圍相對完整，可免費使用，可優先選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-fda-tw"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationCodeableConcept.coding:nhi-medication-tw",
        "path" : "MedicationDispense.medication[x].coding",
        "sliceName" : "nhi-medication-tw",
        "short" : "此為中央健康保險署(NHI)維護之藥品代碼，主要針對申報使用，更新頻率相對頻繁，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-nhi-tw"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationCodeableConcept.coding:nhi-medication-ch-herb-tw",
        "path" : "MedicationDispense.medication[x].coding",
        "sliceName" : "nhi-medication-ch-herb-tw",
        "short" : "此為中央健康保險署(NHI)維護之中藥藥品代碼，主要針對申報使用，更新頻率相對頻繁，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/nhi-medication-ch-herb-tw"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationCodeableConcept.coding:rxnorm-medication-us-core",
        "path" : "MedicationDispense.medication[x].coding",
        "sliceName" : "rxnorm-medication-us-core",
        "short" : "RxNorm為美國Unified Medical Language System®中的藥品代碼，取得UMLS®授權即可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-rxnorm-tw"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationCodeableConcept.coding:atc-medication-code",
        "path" : "MedicationDispense.medication[x].coding",
        "sliceName" : "atc-medication-code",
        "short" : "ATC代碼的版權為世界衛生組織（WHO）Collaborating Centre for Drug Statistics Methodology，可免費使用，可依情境選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medcation-atc-tw"
        }
      },
      {
        "id" : "MedicationDispense.medication[x]:medicationCodeableConcept.coding:snomedct-medication-codes",
        "path" : "MedicationDispense.medication[x].coding",
        "sliceName" : "snomedct-medication-codes",
        "short" : "此為SNOMED CT代碼，若機構已有購買相關授權，亦可使用。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-codes"
        }
      },
      {
        "id" : "MedicationDispense.subject",
        "path" : "MedicationDispense.subject",
        "short" : "配藥/調劑藥品的對象，意即為誰配藥/調劑藥品。",
        "definition" : "一個指向resource的連結，代表接受藥物治療的個人或團體。",
        "comment" : "給藥->對象->病人",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.context",
        "path" : "MedicationDispense.context",
        "short" : "與此配藥/調劑藥品相關的就醫事件(Encounter/Episode)",
        "definition" : "描述此事件發生時所處的醫療環境或治療階段，例如：此事件是在某次就醫或某照護病程中發生的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.supportingInformation",
        "path" : "MedicationDispense.supportingInformation",
        "short" : "支持配藥/調劑藥品的資訊",
        "definition" : "支持配藥/調劑藥品的其他資訊"
      },
      {
        "id" : "MedicationDispense.performer",
        "path" : "MedicationDispense.performer",
        "short" : "執行此配藥/藥品調劑的人員。",
        "definition" : "表明由誰或由什麼執行了此事件",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.performer.function",
        "path" : "MedicationDispense.performer.function",
        "short" : "誰進行了配藥/藥品調劑以及他們做了什麼",
        "definition" : "區分配藥中的執行者類型。例如：資料輸入員、包裝藥品人員、最終核對者。",
        "requirements" : "允許對不同執行者參與類型進行明確區分",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationDispensePerformerFunction"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medicationdispense-performer-function"
        }
      },
      {
        "id" : "MedicationDispense.performer.actor",
        "path" : "MedicationDispense.performer.actor",
        "short" : "執行此操作的個人",
        "definition" : "執行此動作的設備、健康照護服務提供者等。應假設行為人是配藥/調劑藥品人員。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.location",
        "path" : "MedicationDispense.location",
        "short" : "配藥/調劑藥品的位置",
        "definition" : "進行配藥/調劑藥品的主要實體位置"
      },
      {
        "id" : "MedicationDispense.authorizingPrescription",
        "path" : "MedicationDispense.authorizingPrescription",
        "short" : "授權此配藥/調劑藥品的處方",
        "definition" : "表明配藥/調劑藥品所依據的藥品請求",
        "comment" : "對應至事件邏輯模型中的 basedOn",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.type",
        "path" : "MedicationDispense.type",
        "short" : "配藥/調劑藥品類型。例如：試用分裝、部分分裝、緊急分裝等",
        "definition" : "表明執行的配藥/調劑藥品事件類型。例如：試用分裝、試用完成、部分分裝、緊急分裝、樣品等。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationDispenseType"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActPharmacySupplyType"
        }
      },
      {
        "id" : "MedicationDispense.quantity",
        "path" : "MedicationDispense.quantity",
        "short" : "配藥/調劑藥品的量",
        "definition" : "已配發的藥量。包括藥品的計量單位。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.daysSupply",
        "path" : "MedicationDispense.daysSupply",
        "short" : "以時間描述藥品的數量或劑量",
        "definition" : "藥品的劑量，以時間為單位來表示。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.whenPrepared",
        "path" : "MedicationDispense.whenPrepared",
        "short" : "產品包裝和審核時間",
        "definition" : "配製藥品的包裝和審核時間"
      },
      {
        "id" : "MedicationDispense.whenHandedOver",
        "path" : "MedicationDispense.whenHandedOver",
        "short" : "藥品發放的時間",
        "definition" : "病人或其代理人收到配製藥品的時間",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.destination",
        "path" : "MedicationDispense.destination",
        "short" : "藥品被送往何處",
        "definition" : "作為配藥/調劑藥品事件的一部分，識別藥品送達的機構/位置。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.receiver",
        "path" : "MedicationDispense.receiver",
        "short" : "誰領取了藥品",
        "definition" : "識別誰領藥。通常是病人或其照護者，但在某些情況下也可能是醫護專業人員。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.note",
        "path" : "MedicationDispense.note",
        "short" : "有關配藥/調劑藥品的資訊",
        "definition" : "無法在其他屬性中表達的配藥/調劑藥品之額外資訊"
      },
      {
        "id" : "MedicationDispense.dosageInstruction",
        "path" : "MedicationDispense.dosageInstruction",
        "short" : "病人如何使用藥品或者照護者如何給藥",
        "definition" : "指明病人如何使用藥品",
        "comment" : "當劑量或給藥速度在整個給藥期間預計要變化時（例如：逐漸降低劑量處方），需要提供多個劑量指示的說明，以表達不同的劑量/給藥速度。藥劑師在配藥/調劑藥品前會審核藥品醫令，並根據實際配藥更新dosageInstruction。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.sequence",
        "path" : "MedicationDispense.dosageInstruction.sequence",
        "short" : "劑量指示的順序",
        "definition" : "表明使用或解釋劑量指示的順序",
        "requirements" : "如果多個劑量的序號是相同的，那麼就意味著這些指示將被視為同時進行。如果序號不同，那麼這些劑量將是依續使用。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.text",
        "path" : "MedicationDispense.dosageInstruction.text",
        "short" : "純文字表述的劑量指示，例如：SIG。",
        "definition" : "純文字表述的劑量指示，例如：SIG。",
        "requirements" : "純文字表述劑量指示可用於說明太複雜而無法編碼的案例。此屬性的內容不包括藥品的名稱或描述。當有已編碼的指示，純文字表述說明可能仍然存在，以顯示給服用藥品或給藥的人。文字指示預計將始終被填入。如果dosage.timing屬性也被填入，那麼dosage.text應該反映與timing相同的資訊。關於給藥或準備藥品的附加資訊應作為文字包括在內。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.additionalInstruction",
        "path" : "MedicationDispense.dosageInstruction.additionalInstruction",
        "short" : "對病人的補充指示或警告－例如：「隨餐服用」，「可能引起嗜睡」",
        "definition" : "向病人提供關於如何服藥的補充指示（例如 「隨餐服用」或「在進食前半小時服用」）或給病人的藥品警告（例如「可能導致嗜睡 」或「避免皮膚暴露於陽光直射或人工強光燈（日曬用）下」）。",
        "comment" : "應在dosage.text中填入關於用藥或準備藥品的資訊（例如： 「盡可能快地透過腹膜內口輸液」或 「在用 x 藥後立即服用」）。",
        "requirements" : "附加指示是要編碼的，但在沒有編碼的情況下，此資料項目可以包括文字。例如，「用大量的水吞咽」，這可能編碼也可能不編碼。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "AdditionalInstruction"
            }
          ],
          "strength" : "example",
          "description" : "一個編碼的概念，確定額外的指示，如「與水一起服用」或「避免操作重型機器」；可參考所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/additional-instruction-codes"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.patientInstruction",
        "path" : "MedicationDispense.dosageInstruction.patientInstruction",
        "short" : "以病人或消費者為導向的指示",
        "definition" : "用病人或消費者能理解的術語提供指示",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing",
        "path" : "MedicationDispense.dosageInstruction.timing",
        "short" : "應該何時給藥；時間的寫法請參照Timimg datatype。",
        "definition" : "應該何時給藥",
        "comment" : "這個屬性可能並不總是被填入，而Dosage.text預計會被填入。如果兩者都被填入，那麼Dosage.text應反映Dosage.timing的內容。",
        "requirements" : "病人用藥的時間安排。這種data type允許許多不同的表達方式。例如：「每8小時一次」；「一天三次」；「從2011年12月23日開始的10天裡，早餐前半小時」；「2013年10月15日、2013年10月17日和2013年11月1日」。有時，當率值（rate）為總容量／期間，其「期間」意指（例如：500mL／2小時）之持續期間為2小時。但當率值非意指「持續期間」時（例如：250mL／小時），則需要timing.repeat.duration來表達輸液的時間區間。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.event",
        "path" : "MedicationDispense.dosageInstruction.timing.event",
        "short" : "事件發生的時間",
        "definition" : "指明事件發生的特定時間",
        "requirements" : "例如：在一份用藥記錄中，你需要把一個一般的規範變成一個精確的規範。"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat",
        "short" : "事件定期重複發生的時間",
        "definition" : "一組描述事件何時被安排的規則",
        "requirements" : "定期重複的時間安排",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.bounds[x]",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.bounds[x]",
        "short" : "時間或期間長度／長度範圍，或（開始和／或結束）限制",
        "definition" : "時間長度或可能的時間長度範圍，或開始和／或結束時間。"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.count",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.count",
        "short" : "重複的次數",
        "definition" : "在整個持續期間內，期望重複的總次數。如果countMax這個資料項目存在，此count資料項目表示允許次數範圍的下限。",
        "comment" : "如果你同時擁有bounds和count這兩個資料項目，那麼這應該被理解為在bounds期間，發生count的次數。",
        "requirements" : "重複次數可透過設定結束時間或總發生次數作限制",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.countMax",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.countMax",
        "short" : "重複的最大次數",
        "definition" : "如果countMax存在，表示count是一個範圍，如此可在［count］和［countMax］之間的重複次數執行動作。"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.duration",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.duration",
        "short" : "此事件持續多久時間",
        "definition" : "這件事發生的時候會持續多久時間。如果durationMax這個資料項目存在，則此duration資料項目表示持續時間的允許範圍之下限。",
        "comment" : "對於一些事件，持續時間是事件定義的一部分（例如：靜脈輸液，持續時間隱含於特定輸液量及速度）。對於其他事件，它是時間規範的一部分（例如：運動持續時間）。",
        "requirements" : "有些活動不是立即發生，需要維持一段時間。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.durationMax",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.durationMax",
        "short" : "此事件持續多久時間 （最長時間／最大值）",
        "definition" : "如果durationMax這個資料項目存在，表示duration資料項目是一個範圍的下限 — 所以要在［duration］和［durationMax］之間執行此活動。",
        "comment" : "對於一些事件，持續時間是事件定義的一部分（例如：靜脈輸液，持續時間隱含於特定輸液量及速度）。對於其他事件，它是時間規範的一部分（例如：運動持續時間）。",
        "requirements" : "有些活動不是立即發生，需要維持一段時間。"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.durationUnit",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.durationUnit",
        "short" : "s ｜ min ｜ h ｜ d ｜ wk ｜ mo ｜ a - 單位時間 （unit of time，UCUM）",
        "definition" : "持續時間的單位，以UCUM為單位。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "UnitsOfTime"
            }
          ],
          "strength" : "required",
          "description" : "時間的單位（單位來自UCUM）；應填入UnitsOfTime值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/units-of-time|4.0.1"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.frequency",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.frequency",
        "short" : "此事件於每一期間的發生頻率",
        "definition" : "在特定期間內重複動作的次數。如果frequencyMax存在，此frequency資料項目表示頻率的允許範圍的下限。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.frequencyMax",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.frequencyMax",
        "short" : "此事件於每一期間的最大發生頻率",
        "definition" : "如果frequencyMax存在，frequency資料項目表示頻率範圍的下限 – 所以要在［frequency］和［frequencyMax］之間重複執行此活動。"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.period",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.period",
        "short" : "此事件於特定時間區間所發生的頻率",
        "definition" : "表示重複發生的時間區間；例如：為了表示「每天3次」，3次是頻率（frequency），1天是週期（period）。如果存在periodMax資料項目，此period資料項目表示時間區間長度的允許範圍的下限。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.periodMax",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.periodMax",
        "short" : "時間區間的上限（3-4小時）",
        "definition" : "如果periodMax存在，表示時間區間是一個從［period］到［periodMax］的範圍，允許表達像是「每3至5天一次」的概念。"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.periodUnit",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.periodUnit",
        "short" : "s ｜ min ｜ h ｜ d ｜ wk ｜ mo ｜ a - 單位時間 （unit of time，UCUM）",
        "definition" : "持續時間的單位，以UCUM為單位。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "UnitsOfTime"
            }
          ],
          "strength" : "required",
          "description" : "時間的單位（單位來自UCUM）；應填入UnitsOfTime值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/units-of-time|4.0.1"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.dayOfWeek",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.dayOfWeek",
        "short" : "mon ｜ tue ｜ wed ｜ thu ｜ fri ｜ sat ｜ sun",
        "definition" : "如果提供的資訊為一星期中的一天或多天，那麼此活動只發生在這特定的幾天。",
        "comment" : "如果沒有指定天數，則假定該活動每天都會發生，否則就會指定。資料項目frequency和period不能與dayOfWeek同時使用。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DayOfWeek"
            }
          ],
          "strength" : "required",
          "description" : "應填入DaysOfWeek值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/days-of-week|4.0.1"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.timeOfDay",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.timeOfDay",
        "short" : "一天中的活動時間",
        "definition" : "具體說明一天中活動進行的時間",
        "comment" : "當指定了一天中的時間時，就會推斷出該活動每天都會在指定的時間發生（由dayofWeek篩選）。資料項目when、frequency和period不能和timeOfDay一起使用。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.when",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.when",
        "short" : "事件發生的時間區間之代碼",
        "definition" : "一天中的一個大致時段，可能與日常生活中的某一事件有關，表明該活動應在何時發生。",
        "comment" : "當一個以上的事件被列出，則此事件被綁定至合併的數個特定事件。",
        "requirements" : "時間經常由特定事件的發生所決定，例如：起床、吃飯和睡覺。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "EventTiming"
            }
          ],
          "strength" : "required",
          "description" : "與時程表有關的真實世界事件；應填入EventTiming值集中的其中一個代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/event-timing|4.0.1"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.repeat.offset",
        "path" : "MedicationDispense.dosageInstruction.timing.repeat.offset",
        "short" : "事件的分鐘數（之前或之後）",
        "definition" : "距離特定事件發生的分鐘數。如果事件代碼沒有表明該分鐘是在事件之前還是之後，則假定該offset是指特定事件發生後的分鐘數。"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.code",
        "path" : "MedicationDispense.dosageInstruction.timing.code",
        "short" : "BID ｜ TID ｜ QID ｜ AM ｜ PM ｜ QD ｜ QOD ｜ +",
        "definition" : "活動發生時機之代碼（或只是code.text中的文字）。像是BID的一些代碼到處都有，但許多機構定義它們自己的額外代碼。如果提供了一個代碼，此代碼被理解為是結構化時間資料中規定的任何內容的完整陳述，代碼或資料都可用於解釋時機（Timing），但.repeat.bounds適用於代碼（且不包含在代碼中）的例外。",
        "comment" : "BID等被定義為「在機構特定的時間」。例如：一個機構可以選擇BID是 「總是在早上7點和下午6點」。如果這種選項是不合適的，就不應該使用代碼BID。反之，應使用一個獨特的機構特定代碼來代替HL7定義的BID代碼和／或使用一個結構化表示法（在這種情況下，具體說明兩個事件時間）。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "TimingAbbreviation"
            }
          ],
          "strength" : "preferred",
          "description" : "已知／確定的時間模式之代碼；鼓勵使用TimingAbbreviation值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/timing-abbreviation"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.code.coding",
        "path" : "MedicationDispense.dosageInstruction.timing.code.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "type" : [
          {
            "code" : "Coding",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coding-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-frequency-hl7-tw"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing.code.text",
        "path" : "MedicationDispense.dosageInstruction.timing.code.text",
        "short" : "概念的文字標記法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.asNeeded[x]",
        "path" : "MedicationDispense.dosageInstruction.asNeeded[x]",
        "short" : "「根據（對x的）需要」服用\nBinding：一個編碼概念，指明在服用或用藥之前應滿足或評估的先決條件。例如：「疼痛」、「性行為前30分鐘」、「發作時」等；可參考SNOMEDCTMedicationAsNeededReasonCodes值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
        "definition" : "表明此藥品是否只在需要時在特定的用法（Boolean選項）服用，或者表明服用此藥品（CodeableConcept）的前提條件。",
        "comment" : "可以透過設定Boolean = True來表達不用填寫理由的「根據需要」。在這種情況下，CodeableConcept不會被填入任何值。或者你可以透過包括CodeableConcept來表達 「根據需要」的理由。在這種情況下，Boolean值被假定為True。如果您將Boolean值設置為「False」，那麼該劑量是根據時間表給予的，而不是 「prn」或 「根據需要」。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "一個編碼概念，指明在服用或用藥之前應滿足或評估的先決條件。例如：「疼痛」、「性行為前30分鐘」、「發作時」等；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/medication-as-needed-reason"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.site",
        "path" : "MedicationDispense.dosageInstruction.site",
        "short" : "用藥之身體部位",
        "definition" : "用藥的身體部位",
        "comment" : "如果使用案例需要BodySite resource的屬性（例如：分別識別和追蹤），那麼就使用標準extension bodySite。可以是一個摘要代碼，也可以是對一個非常精確的位置定義的參照，或者兩者都是。",
        "requirements" : "對藥品首次進入之人體解剖部位的編碼說明",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "一個編碼概念，描述藥品進入或在身體上的位置；可參考所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/approach-site-codes"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route",
        "path" : "MedicationDispense.dosageInstruction.route",
        "short" : "藥品應如何進入體內",
        "definition" : "藥品應如何進入體內",
        "requirements" : "具體說明治療劑進入或到達病人體內的途徑或生理途徑之代碼",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route.coding",
        "path" : "MedicationDispense.dosageInstruction.route.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "type" : [
          {
            "code" : "Coding",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coding-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/medication-path-sct-tw"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route.text",
        "path" : "MedicationDispense.dosageInstruction.route.text",
        "short" : "概念的文字標記法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.method",
        "path" : "MedicationDispense.dosageInstruction.method",
        "short" : "用藥的技術",
        "definition" : "用藥的技術",
        "comment" : "使用的專門術語通常先組合配對（pre-coordinate）用藥途徑和／或劑型。",
        "requirements" : "表示藥品進入或進入身體的方法的一個編碼值。最常用的方法為注射。例如：慢推、深靜脈。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "一個編碼概念，描述用藥的技術；可參考所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/administration-method-codes"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate",
        "short" : "用藥量",
        "definition" : "用藥量",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.type",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.type",
        "short" : "特定劑量或比率種類",
        "definition" : "特定劑量或比率種類，例如：依處方或計算而來。",
        "requirements" : "如果此type資料項目沒有被填入，則假定為「依處方（ordered）」。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DoseAndRateType"
            }
          ],
          "strength" : "example",
          "description" : "可參考DoseAndRateType值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/dose-rate-type"
        }
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.dose[x]",
        "short" : "每一劑量的藥量",
        "definition" : "每一劑量的藥量",
        "comment" : "請注意這是指特定藥品量，而不是指每種有效成分量。每種成分量都可以在Medication resource中進行溝通。例如：如果想表達一錠375毫克的藥錠，劑量是一錠，你可以使用Medication resource來記錄此藥錠是由375毫克的藥物XYZ組成。或者，如果劑量是375毫克，那麼你可能只需要使用Medication resource來表明這是藥錠。如果是靜脈注射，例如：多巴胺，你想表明400毫克多巴胺被混合在500毫升的靜脈注射液中，那麼這些都將在Medication resource中呈現。如果用藥不打算是即時的（速率是存在的，或者時間是有期限的），這可具體說明以傳達在時間表所指示的時段之總用藥量，例如：500毫升的劑量應該在4小時內完成。",
        "requirements" : "在一次用藥事件中給予的治療用或其他的物質量",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate.rate[x]",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate.rate[x]",
        "short" : "每時間單位內的用藥量",
        "definition" : "每時間單位內的用藥量",
        "comment" : "可同時提供rate和doseQuantity，以提供關於如何用藥和供應藥品的全部細節。如果速率打算隨著時間的推移而改變，根據當地的規則／法規，每次改變都應作為帶有更新速率的新版MedicationRequest來捕捉，或者用帶有新速率的新的MedicationRequest來捕捉。可以使用rateRatio和rateQuantity來指定一段時間內的比率（例如：100毫升／小時）。rateQuantity的方式要求系統有能力解析包含毫升／小時的UCUM語法，而不是將時間指定為分母的特定比率。如果指定了一個2小時500毫升的率值，使用rateRatio可能比使用rateQuantity指定250毫克／小時在語義上更正確。",
        "requirements" : "指明藥品引入病人體內的速度。通常是指輸液的速度，例如：每1小時100毫升或100毫升／小時。也可表示為每單位時間的速度，例如：每2小時500毫升，其他例子如200微克／分鐘或200微克／1分鐘；1升／8小時。有時，當表示為總容量／持續時間時，速率可以隱喻持續時間（例如：500毫升／2小時隱喻持續時間為2小時）。然而，當速率未隱喻持續時間時（例如：250毫升／小時），則需要timing.repeat.duration來表達輸液的時間區間。",
        "mustSupport" : true
      },
      {
        "id" : "MedicationDispense.dosageInstruction.maxDosePerPeriod",
        "path" : "MedicationDispense.dosageInstruction.maxDosePerPeriod",
        "short" : "每時間單位內用藥的上限",
        "definition" : "每時間單位內用藥的上限",
        "comment" : "這是為了在有上限的情況下作為劑量的輔助說明。例如：「每4小時2錠，一天最多8錠」。",
        "requirements" : "在一段時間區間用於某一對象的治療用物質之最大總量。例如：24小時內1,000毫克。"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.maxDosePerAdministration",
        "path" : "MedicationDispense.dosageInstruction.maxDosePerAdministration",
        "short" : "每次用藥的上限",
        "definition" : "每次用藥的上限",
        "comment" : "這是為了在有上限的情況下作為劑量的輔助說明。例如：與體表面積有關的劑量有一個上限，如在5至10分鐘內靜脈注射1.5毫克／平方米（最多2毫克），其doseQuantity為1.5毫克／平方米，maxDosePerAdministration為2毫克。",
        "requirements" : "每次用於某一對象治療用物質的最大總量"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.maxDosePerLifetime",
        "path" : "MedicationDispense.dosageInstruction.maxDosePerLifetime",
        "short" : "病人一生中用藥的上限",
        "definition" : "病人一生中用藥的上限",
        "requirements" : "用於某一對象的治療用物質於其一生的最大總數量"
      },
      {
        "id" : "MedicationDispense.substitution",
        "path" : "MedicationDispense.substitution",
        "short" : "配藥/調劑藥品時是否進行了藥品替代",
        "definition" : "表示配藥/調劑藥品過程中是否進行了藥品替代。在某些情況下，替代是預料之中的，但卻沒有發生；在另一些情況下，替代是預料之外的，但卻發生了。這一部分解釋了替代是否發生或未發生的情況及原因。如果沒有說明，則表示沒有進行替代。"
      },
      {
        "id" : "MedicationDispense.substitution.wasSubstituted",
        "path" : "MedicationDispense.substitution.wasSubstituted",
        "short" : "配藥/調劑藥品時是否進行或未進行藥品替代",
        "definition" : "如果配藥/調劑藥品的藥劑師配了與處方不同的藥品，則為真。"
      },
      {
        "id" : "MedicationDispense.substitution.type",
        "path" : "MedicationDispense.substitution.type",
        "short" : "代碼表示配藥是否與處方要求不同",
        "definition" : "表示是否配製與處方不同藥品的代碼",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationIntendedSubstitutionType"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActSubstanceAdminSubstitutionCode"
        }
      },
      {
        "id" : "MedicationDispense.substitution.reason",
        "path" : "MedicationDispense.substitution.reason",
        "short" : "為什麼要替代",
        "definition" : "表明替代（或不替代）處方的原因",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "MedicationIntendedSubstitutionReason"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-SubstanceAdminSubstitutionReason"
        }
      },
      {
        "id" : "MedicationDispense.substitution.responsibleParty",
        "path" : "MedicationDispense.substitution.responsibleParty",
        "short" : "誰對藥品替代負責",
        "definition" : "對替代負有主要責任的個人或機構",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.detectedIssue",
        "path" : "MedicationDispense.detectedIssue",
        "short" : "臨床問題與行動",
        "definition" : "表明病人的一項或多項實際或潛在的臨床行動之間存在的臨床問題，例如：藥品交互作用、重複治療、劑量警示等。",
        "comment" : "此資料項目可包括決策支援系統或臨床醫生發現的問題，也可包括解決問題所採取步驟資訊。"
      },
      {
        "id" : "MedicationDispense.eventHistory",
        "path" : "MedicationDispense.eventHistory",
        "short" : "相關生命周期事件的清單",
        "definition" : "已發生的相關事件摘要，例如：配藥/調劑藥品是否已審核。",
        "comment" : "這可能不包括請求的所有版本的出處(Provenances) - 只包括那些被認為 「相關 」或重要的版本。 **必須沒有(SHALL NOT)** 包括與當前版本 resource 相關的 Provenance。(如果該Provenance被視為「相關 」的變更，則需要作為後續更新的一部分添加。在此之前，可以使用 _revinclude 直接查詢該版本的Provenance（所有Provenance都應以此請求的某個歷史版本作為其查詢對象）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Provenance-twcore"
            ]
          }
        ]
      }
    ]
  }
}

```
