# TW Core DocumentReference - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core DocumentReference 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreDocumentReference |

 
此臺灣核心-文件參照（TW Core DocumentReference） Profile說明本IG如何進一步定義FHIR的DocumentReference Resource以呈現文件參照的詳細資料。 

## Resource DocumentReference - 內容

這是一個指向任何種類、用於任何用途的文件的參照。它提供了文件的基本資訊，幫助我們找到並管理這個文件。文件可以是任何有MIME類型的序列化物件，包括專門針對病人的正式文件（如CDA）、臨床筆記、掃描過的紙本文件，以及像是政策文件這樣不特定於病人的文件。

### 範圍與使用

DocumentReference resource 是用來索引文件、臨床筆記和其他以二進制格式存儲的資料物件，使它們能被醫療系統存取。文件是一系列可以被識別的位元組序列，它建立了自己的上下文（例如：可以向使用者展示什麼主題、作者等），並且有明確的更新管理。DocumentReference resource 可以用於任何具有公認MIME類型且符合此定義的文件格式。

通常，DocumentReference resources 被用在文件索引系統中，像是[IHE XDS](http://wiki.ihe.net/index.php?title=Cross-Enterprise_Document_Sharing)，如同在[IHE行動式存取健康紀錄文件（Mobile access to Health Documents，MHD)](http://wiki.ihe.net/index.php/Mobile_access_to_Health_Documents_（MHD)）中概述的那樣。

DocumentReference是描述文件的metadata，比如：

* 在FHIR系統中的[CDA](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=7)文件
* 存儲在其他地方的[FHIR文件](https://hl7.org/fhir/R4/documents.html)（即遵循XDS Profile的註冊中心/儲存庫）
* [PDF文件](http://en.wikipedia.org/wiki/Portable_Document_Format)、掃描的紙本文件和傳真的數位紀錄
* 各種形式的臨床筆記
* 影像文件（例如：JPEG、GIF、TIFF）
* 非標準格式（例如：WORD）
* 其他類型的文件，如處方或疫苗接種記錄

### 界限與關聯

FHIR不僅定義[文件](https://hl7.org/fhir/R4/documents.html)格式，還定義了文件參照DocumentReference。FHIR文件是指那些在FHIR中創建和組裝的文件，DocumentReference主要是透用參照找到那些已經組裝好的文件。

被參照的文件可以是另一個伺服器上的FHIR文件、或者儲存在特殊的[FHIR 二進制 resource （Binary Resource）](https://hl7.org/fhir/R4/http.html#binary)中，或者存儲在其他任何伺服器上。DocumentReference也能夠指向透過服務呼叫來查詢文件，例如XDS.b的RetrieveDocumentSet操作、DICOM交換、或是[HL7 v2](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=185)訊息查詢 — 但這些服務的具體運作方式需要在其外部標準或其他文件中明確說明。

DocumentReference 描述另一份文件，這意味著這裡涉及到兩套「基本資訊（provenance）」，意即「文件本身」以及「DocumentReference」的出處、版本號、創建日期等基本資訊。有時候，這些基本資訊是密切相關的，比如當文件製作者也製作了 DocuementReference 時；但在其他工作流中，DocumentReference 可能由其他角色在後續階段產生。在 DocumentReference resource 中， [meta](https://hl7.org/fhir/R4/resource.html#Meta) 內容段指的是參照本身的基本資訊，而其 resource下半部內容描述涉及它所參照的文件。 就像其他所有 resources 一樣， DocumentReference resource 主要資訊和在[Provenance](https://hl7.org/fhir/R4/provenance.html) resource 中的資訊之間有重疊。這在[Provenance resource的描述](https://hl7.org/fhir/R4/provenance.html#overlap)有討論。

這個 resource 被許多其他 FHIR resources 參照，包括醫療不良事件[（AdverseEvent)](https://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)、照護計畫（[CarePlan](https://hl7.org/fhir/R4/careplan.html#CarePlan)）、通訊 （[Communication](https://hl7.org/fhir/R4/communication.html#Communication)）、 通訊請求（[CommunicationRequest](https://hl7.org/fhir/R4/communicationrequest.html#CommunicationRequest)）、同意書（[Consent](https://hl7.org/fhir/R4/consent.html#Consent)）、合約（[Contract](https://hl7.org/fhir/R4/contract.html#Contract)）、設備請求（[DeviceRequest](https://hl7.org/fhir/R4/devicerequest.html#DeviceRequest)）、設備使用聲明（[DeviceUseStatement](https://hl7.org/fhir/R4/deviceusestatement.html#DeviceUseStatement)）、文件參照（DocumentReference）、家庭成員病史（[FamilyMemberHistory](https://hl7.org/fhir/R4/familymemberhistory.html#FamilyMemberHistory)）、指導回應（[GuidanceResponse](https://hl7.org/fhir/R4/guidanceresponse.html#GuidanceResponse)）、影像檢査（[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、 藥品知識（[MedicationKnowledge](https://hl7.org/fhir/R4/medicationknowledge.html#MedicationKnowledge)）、醫藥產品（[MedicinalProduct](https://hl7.org/fhir/R4/medicinalproduct.html#MedicinalProduct)）、檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）、 處置（[Procedure](StructureDefinition-Procedure-twcore.md)）、一組請求（[RequestGroup](https://hl7.org/fhir/R4/requestgroup.html#RequestGroup)）、 風險評估（[RiskAssessment](https://hl7.org/fhir/R4/riskassessment.html#RiskAssessment)）、服務請求（[ServiceRequest](https://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）、物質參照資訊（[SubstanceReferenceInformation](https://hl7.org/fhir/R4/substancereferenceinformation.html#SubstanceReferenceInformation)）、物質規格（[SubstanceSpecification](https://hl7.org/fhir/R4/substancespecification.html#SubstanceSpecification)）及供應品請求（[SupplyRequest](https://hl7.org/fhir/R4/supplyrequest.html#SupplyRequest)）DocumentReference resource 在FHIR框架中扮演著一個重要的角色，連接不同的 resources 和提供關於文件的重要基本資訊。

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md), [TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md), [TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md)...Show 20 more,[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Laboratory Result](StructureDefinition-Observation-laboratoryResult-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [DocumentReference/doc-outpatient-example](DocumentReference-doc-outpatient-example.md) and [DocumentReference/doc-wound-example](DocumentReference-doc-wound-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/DocumentReference-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-DocumentReference-twcore.csv), [Excel](StructureDefinition-DocumentReference-twcore.xlsx), [Schematron](StructureDefinition-DocumentReference-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-DocumentReference-id.md)**查詢所有DocumentReference：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/DocumentReference?_id=[id]`
`GET [base]/DocumentReference/[id]`例子：
(1) GET [base]/DocumentReference?_id=documentReference-example(2) GET [base]/DocumentReference/documentReference-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-DocumentReference-status.md)**查詢所有DocumentReference：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/DocumentReference?status=[code]`例子：
(1) GET [base]/DocumentReference?status=completed
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-DocumentReference-subject.md)**查詢所有DocumentReference：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/DocumentReference?subject={Type/}[id]`例子：
(1) GET [base]/DocumentReference?subject=Patient/pat-example

### 實作注意事項

* 在[臨床文件架構描述 (Composition description)](https://hl7.org/fhir/R4/composition.html#status)中有討論如何使用`.docStatus`代碼。這是關於文件目前狀態（如草稿、最終版等）的一種標記。
* Resources 之間保持著一種單向的關係，這種關係是向後指的 (backwards)：比如，一個取代另一份文件的文件會指回它所取代的那個文件。我們可以利用從 Resources 建立的索引追溯這種反向的關係。如果要取得文件的完整資訊，需考慮到一份文件可能會被其他文件取代或添加，所以當用戶端存取文件時，應該先確認及瞭解這些關係，再透過查詢參數來取得所需的相應文件。 
* 舉個例子，假設有一份關於病人的健康報告（稱為文件A），後來有了一個更新版的健康報告（稱為文件B）來取代它。在這種情況下，文件B會有一個指向文件 A 的參照，表明 B 是 A 的更新版。如果有人查看文件A，系統可以通過這種單向關係指示，該使用者可能想要查看最新的文件B來獲得最準確的資訊。
 

### 產生一份文件參照

用戶端可以要求伺服器從一份已有的文件中創建一個DocumentReference。伺服器會檢視這份文件，然後創建一個匹配的DocumentReference Rresource，或者如果之前已經創建過，就直接回傳那個已創建的DocumentReference。對於以下類型的文件，伺服器可能可以創建或回傳DocumentReference：

| | |
| :--- | :--- |
| [FHIR 文件](https://hl7.org/fhir/R4/documents.html) | uri（網址）直接指向一份現有的文件。 |
| [CDA 文件](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=7) | uri是一個指向[Binary](https://hl7.org/fhir/R4/binary.html)端點的網址，這個端點返回CDA文件或一些CDA套件，伺服器知道如何處理這些文件（例如：一個IHE .zip檔案）。 |
| 其他 | 伺服器也可以被要求為其他類型的文件創建 DocumentReference。例如：PDF文件。只有當服務器已經有了這份文件的DocumentReference，或者對該文件有特殊的了解時，才能提供DocumentReference。 |

伺服器可能會回傳一個包含單一DocumentReference的查詢結果，或者一個錯誤訊息。如果URI指向的是另一個伺服器，是否去查詢那個文件或回傳錯誤，則由伺服器自己決定。

啟動這個過程是透過在/DocumentReference端點使用_query=generate進行的已命名查詢，像這樣：

```
GET [service-url]/DocumentReference/?_query=generate&uri=:url&...

```

這裡的「uri」參數是指向上述某種文件類型的一個網址。還可以提供其他的參數：

| | |
| :--- | :--- |
| persist | 表示一旦文件被創建，是否需要在伺服器的文件端點（Document）儲存這份文件。值可以是true（是）或false（否），預設值則取決於伺服器。 |



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "DocumentReference-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreDocumentReference",
  "title" : "TW Core DocumentReference",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-文件參照（TW Core DocumentReference） Profile說明本IG如何進一步定義FHIR的DocumentReference Resource以呈現文件參照的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "fhircomposition",
      "uri" : "http://hl7.org/fhir/composition",
      "name" : "FHIR Composition"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DocumentReference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DocumentReference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DocumentReference",
        "path" : "DocumentReference",
        "short" : "文件的參照",
        "definition" : "這是對任何目的文件的參照。它提供了有關文件的metadata，以便能夠找到並管理此文件。文件的範圍包括任何具有MIME類型的序列物件(seralized object)，例如：以病人為中心的文件（CDA）、臨床註釋、掃描的紙張，以及非與病人有關的文件，像是政策文字表述。",
        "comment" : "通常，這用於除了由FHIR定義之外的文件。"
      },
      {
        "id" : "DocumentReference.id",
        "path" : "DocumentReference.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的DocumentReference紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "DocumentReference.meta",
        "path" : "DocumentReference.meta",
        "short" : "此DocumentReference Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "DocumentReference.implicitRules",
        "path" : "DocumentReference.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "DocumentReference.language",
        "path" : "DocumentReference.language",
        "short" : "用以表述DocumentReference Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "DocumentReference.text",
        "path" : "DocumentReference.text",
        "short" : "DocumentReference Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "DocumentReference.masterIdentifier",
        "path" : "DocumentReference.masterIdentifier",
        "short" : "主版本的識別碼",
        "definition" : "這個文件的唯一識別碼是由提供該文件的來源所賦予的。這個識別碼僅適用於該文件的特定版本。這個獨特的識別碼也可能在其他情況下用於辨認這一版本的文件",
        "comment" : "CDA 文件 Id extension及root",
        "requirements" : "這個 Id 的結構和格式應與對應於 formatCode 屬性的規範一致。例如：對於 DICOM 標準文件，為64字元數字 UID；對於 HL7 CDA 格式，則為 CDA Document Id extension和 root 的序列化，格式為「oid^extension」，其中 OID 最多64位數字，Id 最多16位 UTF-8 字元。如果 OID 是不帶extension的編碼，則不應包含「^」字元。",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.identifier",
        "path" : "DocumentReference.identifier",
        "short" : "文件的其他的識別碼",
        "definition" : "與文件相關的其他識別碼，包括不分版本的識別碼。"
      },
      {
        "id" : "DocumentReference.status",
        "path" : "DocumentReference.status",
        "definition" : "此文件參照的狀態",
        "comment" : " DocumentReference 物件的狀態，可能與 docStatus 資料項目無關，兩者可以是獨立設定。\n此資料項目被標記為修飾用(modifier)，因為狀態包含標記 resource 為當前無效的代碼。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentReferenceStatus"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "required",
          "description" : "文件參照的狀態；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/document-reference-status|4.0.1"
        }
      },
      {
        "id" : "DocumentReference.docStatus",
        "path" : "DocumentReference.docStatus",
        "definition" : "基礎文件的狀態",
        "comment" : "被參照的文件可能會處在不同的階段或狀態中，例如初稿、完稿等不同的生命週期階段。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ReferredDocumentStatus"
            }
          ],
          "strength" : "required",
          "description" : "基礎文件的狀態；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/composition-status|4.0.1"
        }
      },
      {
        "id" : "DocumentReference.type",
        "path" : "DocumentReference.type",
        "short" : "文件的類型（如果可能，使用 LOINC 代碼）",
        "definition" : "被參照文件的具體類型，例如是關於病人的病史和體檢報告、出院摘要、病程摘要等。這樣的類型通常與文件被創建和使用的目的是一致的。",
        "comment" : "關鍵metadata描述了文件的確切類型，有助於人們在查看文件清單時判斷該文件是否感興趣。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-type-doc-code"
        }
      },
      {
        "id" : "DocumentReference.category",
        "path" : "DocumentReference.category",
        "short" : "文件的類別",
        "definition" : "文件的一個分類標準，用於幫助對文件進行索引和查詢。這個分類可能直接基於或是由 DocumentReference.type 指定的代碼來確定。",
        "comment" : "關鍵metadata描述文件的大類或類型。這種分類是基於文件可能的用途或功能，將具有相似用途的文件劃分為同一組。在進行文件查詢時，這個分類作為一個主要的查詢條件。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-document-classcodes"
        }
      },
      {
        "id" : "DocumentReference.subject",
        "path" : "DocumentReference.subject",
        "short" : "文件描述的對象是誰/是什麼？",
        "definition" : "文件可能涉及的對象範圍。這意味著文件可能描述的是一個人（例如病人或健康照護服務提供者）、一個設備（比如某種醫療機構），或者是一組特定的對象，比如一群農場動物或者一批有著相同健康風險的病人。",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.date",
        "path" : "DocumentReference.date",
        "short" : "文件參照的創建時間是何時？",
        "definition" : "文件參照的創建時間是何時？",
        "comment" : "文件的參照或索引時間被用於來追蹤文件的歷史、組織不同的版本及需要時查詢特定文件。",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.author",
        "path" : "DocumentReference.author",
        "short" : "誰以及/或什麼創建了文件",
        "definition" : "識別誰負責將資訊添加到文件中",
        "comment" : "未必是輸入資料的人（例如：打字員），也不必是提供資訊的人（例如：資訊提供者）。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.authenticator",
        "path" : "DocumentReference.authenticator",
        "short" : "誰/什麼對文件進行了認證",
        "definition" : "哪個人或機構認證這份文件是有效的",
        "comment" : "代表在作者機構內，一位已經合法認證或證實文件的參與者。合法認證意味著一份文件已經被法律認證人手動或電子簽章。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.custodian",
        "path" : "DocumentReference.custodian",
        "short" : "維護此文件的機構",
        "definition" : "負責文件持續維護和存取的機構或團體",
        "comment" : "為了找到文件的最新版本或是報告問題等，需要知道哪個組織（可能是某個軟體系統、供應商或部門）負責。這與文件實際存儲的實體位置（如網路地址、硬碟或伺服器）是不同的。實體位置指的是文件存放的地方，這個位置可能被授權給其他組織來進行管理。簡單來說，就是指明負責文件更新和問題反饋的機構，和文件存放位置之間的區別。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.relatesTo",
        "path" : "DocumentReference.relatesTo",
        "short" : "與其他文件的關係",
        "definition" : "此文件與已經存在的其他文件參照之間的關係",
        "comment" : "這個資料項目被標記為修飾用(modifier)，因為附加到其他文件上的文件本身是不完整的。"
      },
      {
        "id" : "DocumentReference.relatesTo.code",
        "path" : "DocumentReference.relatesTo.code",
        "definition" : "此文件與另一文件的關係類型",
        "comment" : "如果此文件是對另一份文件進行附加，那麼不存取被參照的文件，此文件就無法被完全理解。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentRelationshipType"
            }
          ],
          "strength" : "required",
          "description" : "文件之間的關係類型；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/document-relationship-type|4.0.1"
        }
      },
      {
        "id" : "DocumentReference.relatesTo.target",
        "path" : "DocumentReference.relatesTo.target",
        "short" : "存在此關係的目標文件",
        "definition" : "存在此關係的目標文件",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.description",
        "path" : "DocumentReference.description",
        "short" : "人可讀的描述。",
        "definition" : "來源文件的人可讀描述",
        "comment" : "文件的內容簡介，提供了一個關於文件主要內容的簡明扼要的總結。",
        "requirements" : "有助於人們判斷文件是否具有興趣價值"
      },
      {
        "id" : "DocumentReference.securityLabel",
        "path" : "DocumentReference.securityLabel",
        "short" : "文件的安全標籤(security-tags)",
        "definition" : "在文件的參照資訊中，會使用一系列的安全標籤代碼來指明該文件的隱私和安全等級。其中，DocumentReference.meta.security 用來表示參照這份文件本身的安全標籤，也就是說明參照資訊的安全等級；而 DocumentReference.securityLabel 則展示了被參照文件在那一刻的安全標籤狀態，即原始文件的安全等級。簡單來說，就是有兩種標籤，一種用於標示參照的安全性，另一種用於顯示原文件的安全性。",
        "comment" : "一種用於文件共享環境中的安全性和隱私標籤系統，即HL7醫療隱私和安全分類系統（HCS）。這套系統包括多種與文件保密性、敏感度、資料完整性和特定處理要求相關的標籤或代碼，這些代碼有的是通用的，有的則可能是特定於某一機構或項目的。雖然這套系統被推薦使用於如XDS Affinity Domain這樣的政策領域中，但具體是否採用，以及如何採用，則取決於該領域的管理政策和規範。簡言之，這是一套幫助確定文件如何被標記和處理的標籤系統，但使用與否由各自的政策領域決定。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SecurityLabels"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/security-labels"
        }
      },
      {
        "id" : "DocumentReference.content",
        "path" : "DocumentReference.content",
        "short" : "被參照的文件",
        "definition" : "參照的文件和格式。可能存在多個content資料項目，每個資料項目都有不同的格式。",
        "mustSupport" : true
      },
      {
        "id" : "DocumentReference.content.attachment",
        "path" : "DocumentReference.content.attachment",
        "short" : "存取文件的位置",
        "definition" : "文件或文件的URL以及證明內容具有完整性的關鍵metadata"
      },
      {
        "id" : "DocumentReference.content.format",
        "path" : "DocumentReference.content.format",
        "short" : "文件的格式/內容規則。",
        "definition" : "這個識別碼用來表明文件符合的編碼方式、結構和模板，這些特性是除了在 mimeType（文件類型）裡已指明的基本格式之外的部分。",
        "comment" : "請注意，雖然 IHE 通常為不同格式類型發布統一資源名稱( URN)，但並非所有文件都能透過 統一資源識別碼(URI) 來識別。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentFormat"
            }
          ],
          "strength" : "preferred",
          "description" : "鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/formatcodes"
        }
      },
      {
        "id" : "DocumentReference.context",
        "path" : "DocumentReference.context",
        "short" : "文件的臨床背景",
        "definition" : "文件所涉及的臨床情境或背景",
        "comment" : "這些值主要用於幫助查詢感興趣/相關的文件而添加的"
      },
      {
        "id" : "DocumentReference.context.encounter",
        "path" : "DocumentReference.context.encounter",
        "short" : "文件內容的臨床背景",
        "definition" : "描述文件內容所關聯的臨床就醫事件或類型",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore",
              "http://hl7.org/fhir/StructureDefinition/EpisodeOfCare"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.context.event",
        "path" : "DocumentReference.context.event",
        "short" : "正在記錄的主要臨床行為",
        "definition" : "這個代碼清單代表了正在記錄的主要臨床行為，例如：結腸鏡檢查或闌尾切除手術。在某些情況下，事件已經隱含在類型代碼中，例如在「病史和體檢報告」中，正在記錄的必然是「病史和體檢」行為。",
        "comment" : "事件可以進一步專注於類型中所隱含的行為，例如當它僅為「處置報告」，而該處置是「結腸鏡檢查」。如果包括一個或多個事件代碼，則它們不應與class或type資料項目中的值相衝突，因為這樣的衝突會導致情況變得模糊不清。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentEventType"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActCode"
        }
      },
      {
        "id" : "DocumentReference.context.period",
        "path" : "DocumentReference.context.period",
        "short" : "被記錄的服務時間",
        "definition" : "文件描述的是提供服務的時間範圍"
      },
      {
        "id" : "DocumentReference.context.facilityType",
        "path" : "DocumentReference.context.facilityType",
        "short" : "病人接受治療的機構類型",
        "definition" : "病人接受治療的機構類型",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentC80FacilityType"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-facilitycodes"
        }
      },
      {
        "id" : "DocumentReference.context.practiceSetting",
        "path" : "DocumentReference.context.practiceSetting",
        "short" : "內容創建的額外細節(例如：臨床專業)",
        "definition" : "此屬性可能提供有關創建內容的實務環境細節，通常反映了臨床專業。",
        "comment" : "此資料項目應基於一個粗略的專業實務分類系統，建議使用實務環境(Practice Setting)的分類系統，例如：LOINC中的主題領域(Subject Matter Domain)所描述的。",
        "requirements" : "這是健康照護服務提供者(provider)經常依賴的重要metadata之一，他們通常會用來快速排序和/或篩選以找到特定的內容。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentC80PracticeSetting"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/c80-practice-codes"
        }
      },
      {
        "id" : "DocumentReference.context.sourcePatientInfo",
        "path" : "DocumentReference.context.sourcePatientInfo",
        "short" : "來源的病人人口統計資料",
        "definition" : "文件發佈時已知的病人資訊。可以是對特定版本的參照，也可以是包含在文件中的資訊。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore"
            ]
          }
        ]
      },
      {
        "id" : "DocumentReference.context.related",
        "path" : "DocumentReference.context.related",
        "short" : "相關的識別碼或resources",
        "definition" : "與DocumentReference相關聯的相關識別碼或resources",
        "comment" : "可能是導致創建 DocumentReference 或參照文件的識別碼或resources"
      }
    ]
  }
}

```
