# TW Core Condition - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Condition 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreCondition |

 
此臺灣核心-病情、問題或診斷（TW Core Condition） Profile說明本IG如何進一步定義FHIR的Condition Resource以呈現有關病情、問題或診斷的詳細資料。 

## Resource Condition - 內容

就是指某個健康問題或病情已經到了需要特別注意或處理的地步。

### 範圍與使用

Condition 是FHIR中用於記錄和關注特定臨床狀況、問題、診斷或其他相關事件的一種 resource。它在FHIR的[工作流程](http://hl7.org/fhir/R4/workflow.html)中被劃分為一種[event](http://hl7.org/fhir/R4/workflow.html#event) resource，用來捕捉那些需要特別關注的健康狀況。例如：Condition可以用來記錄在一次診療過程中的診斷，或者記錄在醫生的問題清單（Problem List）上的某個項目，甚至是一些還沒有列入問題清單的關注點。

Condition不僅限於醫生基於臨床推理所做出的診斷，也包括那些醫生認為可能對病人有害或需要進一步調查、持續監測和管理的健康問題。例如：如果一個病人被診斷出有心臟疾病的風險，這將被記錄為一個Condition，因為它需要醫生和病人的持續關注和管理。

Condition resource 也可以用來記錄病人某種通常不會帶來負面結果的健康狀態，例如：懷孕。它也可以用來記錄手術後的狀況，比如截肢手術後的截肢狀況。

雖然 Condition 經常是基於醫生對病人健康狀況某一方面的評估和斷言，但病人、相關人士或任何照護團隊成員也可能表達 Condition。醫生可能會對病人的某個狀況（例如：厭食）感到擔憂，而病人本人可能對此不關心。同樣地，病人可能有一個狀況（例如：脫髮），但這個狀況可能不足夠重要，以至於不需要被列入醫生的問題清單上。

例如以下每一種 Condition 都可能因為直接或間接影響病人健康而變得重要，以至於應該被列入問題或關注清單上。例如：「易跌倒」的Condition可能會讓醫生增加對病人的跌倒預防措施，而「家族心血管疾病史」的Condition則提示醫生和病人需要對心血管健康給予更多的關注。這些Condition的記錄有助於提供一個全面的病人健康概況，並指導臨床決策和病人照護計劃。

* 失業
* 缺乏交通工具（或其他障礙）
* 易跌倒
* 暴露於傳染病
* 家族心血管疾病史
* 對癌症的恐懼
* 安裝心臟起搏器
* 截肢-BKA
* 旅行到某國後的茲卡病毒風險
* 曾經吸煙者
* 計劃旅行到某國（需要接種疫苗）
* 交通事故
* 病人曾經進行過冠狀動脈搭橋手術

這些例子也可以使用其他 resources 來表示，例如：家庭成員病史（[FamilyMemberHistory](http://hl7.org/fhir/R4/familymemberhistory.html)）、檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）或處置（[Procedure](StructureDefinition-Procedure-twcore.md)）。

### 界限與關聯

Condition resource 在 FHIR 中是一個關鍵工具，用於記錄那些達到需要關注程度的健康狀況，如疾病、診斷或其他臨床問題。例如：當一位病人被診斷出有糖尿病時，這個狀態就會被記錄為一個 Condition，這不僅對醫生有重要意義，也關係到病人的未來治療計劃。這個 resource 通常被其他 FHIR resources 參照作為某些行動的「原因」。舉個例子，如果一個病人需要特定的藥物來控制他們的高血壓，藥品請求（[MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)） resource就可能參照一個 Condition resource 來解釋為什麼需要這種藥品。同樣地，一項處置或手術（[Procedure](StructureDefinition-Procedure-twcore.md)）或服務請求（[ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html)）也可能參照 Condition 來說明進行手術或提供服務的原因。

然而，Condition resource 並不是用來記錄導致 Condition 記錄的初步跡象和症狀(不論主觀或客觀資訊)。這些資訊通常是用檢驗檢查（[Observation](StructureDefinition-Observation-laboratoryResult-twcore.md)）resources 來紀錄。例如一位病人初次出現頭痛時，這可能會作為一個 Observation 被記錄，但如果頭痛持續且成為了關注的重點，進而可能與腦膜炎相關，那麼它就可能作為一個 Condition 被記錄下來。

當一個症狀解決了且不需要長期管理時，或當一個症狀有助於確立一個 Condition 時，應該使用 Observation resource。反之，當一個症狀需要長期管理或跟踪，或在醫生尚未確定具體診斷時用作問題的代表時，就應該使用 Condition resource。

特別是在涉及到過敏或不耐症時，Condition 和 [AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md) resources 都可能被使用。但是，為了讓這些資訊對決策支持有實際幫助，僅使用 Condition resource 是不夠的，因為過敏或不耐症需要以 [AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md) 的形式來具體表示。

Condition resource 被廣泛參照於多種 FHIR resources 中，如醫療不良事件（[AdverseEvent](http://hl7.org/fhir/R4/adverseevent.html#AdverseEvent)）、預約（[Appointment](http://hl7.org/fhir/R4/appointment.html#Appointment)）、照護計畫（[CarePlan](http://hl7.org/fhir/R4/careplan.html#CarePlan)）、照護團隊（[CareTeam](http://hl7.org/fhir/R4/careteam.html#CareTeam)）理賠申請（[Claim](http://hl7.org/fhir/R4/claim.html#Claim)）、臨床臆斷（[ClinicalImpression](http://hl7.org/fhir/R4/clinicalimpression.html#ClinicalImpression)）、通訊（[Communication](http://hl7.org/fhir/R4/communication.html#Communication)）、 通訊請求（[CommunicationRequest](http://hl7.org/fhir/R4/communicationrequest.html#CommunicationRequest)）、合約（[Contract](http://hl7.org/fhir/R4/contract.html#Contract)）、承保範圍資格請求（[CoverageEligibilityRequest](http://hl7.org/fhir/R4/coverageeligibilityrequest.html#CoverageEligibilityRequest)）、設備請求（[DeviceRequest](http://hl7.org/fhir/R4/devicerequest.html#DeviceRequest)）、設備使用聲明（[DeviceUseStatement](http://hl7.org/fhir/R4/deviceusestatement.html#DeviceUseStatement)）、就醫事件（[Encounter](StructureDefinition-Encounter-twcore.md)）、照護事件（[EpisodeOfCare](http://hl7.org/fhir/R4/episodeofcare.html#EpisodeOfCare)）、利益說明（[ExplanationOfBenefit](http://hl7.org/fhir/R4/explanationofbenefit.html#ExplanationOfBenefit)）、家族成員病史（[FamilyMemberHistory](https://hl7.org/fhir/R4/familymemberhistory.html#FamilyMemberHistory)）、目標（[Goal](http://hl7.org/fhir/R4/goal.html#Goal)）、指導回應（[GuidanceResponse](http://hl7.org/fhir/R4/guidanceresponse.html#GuidanceResponse)）、 影像檢查（[ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)）、疫苗接種（[Immunization](http://hl7.org/fhir/R4/immunization.html#Immunization)）、給藥（[MedicationAdministration](https://hl7.org/fhir/R4/medicationadministration.html#MedicationAdministration)）、藥品請求（[MedicationRequest](StructureDefinition-MedicationRequest-twcore.md)、用藥聲明（[MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)）、處置或手術（[Procedure](StructureDefinition-Procedure-twcore.md)）、一組請求（[RequestGroup](http://hl7.org/fhir/R4/requestgroup.html#RequestGroup)）、風險評估（[RiskAssessment](http://hl7.org/fhir/R4/riskassessment.html#RiskAssessment)）、服務請求（[ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html#ServiceRequest)）及供應品請求（[SupplyRequest](http://hl7.org/fhir/R4/supplyrequest.html#SupplyRequest)），顯示了它在整個醫療和照護過程中，從診斷到治療計劃制定，再到長期健康管理的關鍵作用。

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md), [TW Core Encounter](StructureDefinition-Encounter-twcore.md), [TW Core Goal](StructureDefinition-Goal-twcore.md)...Show 6 more,[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Immunization](StructureDefinition-Immunization-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [Condition/con-example](Condition-con-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Condition-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Condition-twcore.csv), [Excel](StructureDefinition-Condition-twcore.xlsx), [Schematron](StructureDefinition-Condition-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Condition-id.md)**查詢所有Condition：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Condition?_id=[id]`
`GET [base]/Condition/[id]`例子：
(1) GET [base]/Condition?_id=con-example
(2) GET [base]/Condition/con-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`clinical-status`](SearchParameter-Condition-clinical-status.md)**查詢所有Condition：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Condition?clinical-status=[code]`例子：
(1) GET [base]/Condition?clinical-status=remission
1. **建議應該（SHOULD）**支援透過查詢參數**[`code`](SearchParameter-Condition-code.md)**查詢所有Condition：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Condition?code={system|}[code]`例子：
(1) GET [base]/Condition?code=hhttps://twcore.mohw.gov.tw/ig/twcore/CodeSystem/icd-10-cm-2021-tw|E08.649
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Condition-subject.md)**查詢所有Condition：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Condition?subject={Type/}[id]`例子：
(1) GET [base]/Condition?subject=Patient/pat-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`onset-date`](SearchParameter-Condition-onset-date.md)**查詢所有Condition：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Condition?onset-date={gt|lt|ge|le}[date]`例子：
(1) GET [base]/Condition?onset-date=gt2022-08-01
1. **建議應該（SHOULD）**支援透過查詢參數**[`abatement-date`](SearchParameter-Condition-abatement-date.md)**查詢所有Condition：
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/Condition?abatement-date={gt|lt|ge|le}[date]`例子：
(1) GET [base]/Condition?abatement-date=gt2022-08-01
1. **建議應該（SHOULD）**支援透過查詢參數**[`severity`](SearchParameter-Condition-severity.md)**查詢所有Condition：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Condition?severity={system|}[code]`例子：
(1) GET [base]/Condition?severity=http://loinc.org|LA6752-5



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Condition-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreCondition",
  "title" : "TW Core Condition",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-病情、問題或診斷（TW Core Condition） Profile說明本IG如何進一步定義FHIR的Condition Resource以呈現有關病情、問題或診斷的詳細資料。\n",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Condition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Condition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Condition",
        "path" : "Condition",
        "short" : "有關病情、問題或診斷的詳細資訊",
        "definition" : "一個臨床病情、問題、診斷或其他事件、情況、或臨床概念，已上升到需要關注的程度。"
      },
      {
        "id" : "Condition.id",
        "path" : "Condition.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Condition紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作（create operation）提交給伺服器時，此resource沒有id，它的id在resource被創建後由伺器分配/指定。"
      },
      {
        "id" : "Condition.meta",
        "path" : "Condition.meta",
        "short" : "此Condition Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與resource的版本更改相關聯。"
      },
      {
        "id" : "Condition.implicitRules",
        "path" : "Condition.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對IG所定義之特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此URL是對IG的參照，此IG將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Condition.language",
        "path" : "Condition.language",
        "short" : "用以表述Condition Resource內容的語言。",
        "definition" : "編寫此resource的語言",
        "comment" : "提供語言是為了支援索引和可存取性（通常，文字表述轉語音等服務使用此語言標籤）。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div資料項目（關於xml:lang和html lang屬性之間的關係，見HTML5中的規則）。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用CommonLanguages代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Condition.text",
        "path" : "Condition.text",
        "short" : "Condition Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌（contained）的resource沒有敘述，非內嵌（contained）的resource則 **建議應該（SHOULD）** 有敘述。有時resource可能只有文字表述，很少或沒有額外的結構化資料（只要滿足所有minOccurs=1的資料項目）。這可能出現在舊系統的資料，當資訊以 「文字表述區塊（text blob） 」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。"
      },
      {
        "id" : "Condition.identifier",
        "path" : "Condition.identifier",
        "short" : "此病情、問題或診斷的外部識別碼",
        "definition" : "由執行者或其他系統指定給此病情、問題或診斷的業務用識別碼，即使此resource作更新及在伺服器之間的傳遞，此識別碼仍保持不變。",
        "comment" : "這是一個業務識別碼，不是一個resource識別碼（詳見討論）。最好的做法是該識別碼只出現在單個resource實例上，但是業務實務有可能會規定可以在多個resource實例中具有相同識別碼—甚至可能具有不同的resource型例。例如：多個 「Patient（病人）」和 「Person（個人）」resource實例可能共用同一個社會保險號碼。",
        "requirements" : "允許識別各參與系統所知的此病情、問題或診斷資訊，並在各伺服器之間保持一致的方式。"
      },
      {
        "id" : "Condition.clinicalStatus",
        "path" : "Condition.clinicalStatus",
        "short" : "active | recurrence | relapse | inactive | remission | resolved ，病情、問題或診斷的臨床狀態。",
        "definition" : "此病情、問題或診斷的臨床狀態",
        "comment" : "data type是CodeableConcept，因為clinicalStatus涉及到一些臨床判斷，例如：可能需要比所需的FHIR值集更多的特殊性。例如：SNOMED編碼可能允許更多的特殊性。",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ConditionClinicalStatus"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-clinical|4.0.1"
        }
      },
      {
        "id" : "Condition.verificationStatus",
        "path" : "Condition.verificationStatus",
        "short" : "unconfirmed | provisional | differential | confirmed | refuted | entered-in-error ，支持或拒絕病情、問題或診斷的臨床狀態的驗證狀態。",
        "definition" : "支持此病情、問題或診斷的臨床狀態之驗證狀態",
        "comment" : "verificationStatus不是必須的。例如：當病人在急診室出現腹痛時，不可能出現驗證狀態。資料類型是CodeableConcept，因為verificationStatus涉及到一些臨床判斷，因此可能需要比所需的FHIR值集更多的特殊性。例如：SNOMED編碼可能允許更多的特殊性。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ConditionVerificationStatus"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-ver-status|4.0.1"
        }
      },
      {
        "id" : "Condition.category",
        "path" : "Condition.category",
        "short" : "problem-list-item | encounter-diagnosis ，指定病情、問題或診斷的類別。",
        "definition" : "指定此病情、問題或診斷的類別",
        "comment" : "這種分類往往具有很強的情境性，在其他情境下可能顯得區分度不高，或沒有什麼用處。",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ConditionCategory"
            }
          ],
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-category"
        }
      },
      {
        "id" : "Condition.severity",
        "path" : "Condition.severity",
        "short" : "病情、問題或診斷的主觀嚴重程度",
        "definition" : "臨床醫生對病情、問題或診斷嚴重程度的主觀評估",
        "comment" : "如有可能，最好用專門術語對嚴重程度進行編碼。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "臨床醫生對病情、問題或診斷嚴重程度的主觀評價；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-severity"
        }
      },
      {
        "id" : "Condition.code",
        "path" : "Condition.code",
        "short" : "病情、問題或診斷的識別",
        "definition" : "病情、問題或診斷的識別",
        "requirements" : "0..1，主要用於說明敘述性resource。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ConditionKind"
            }
          ],
          "strength" : "example",
          "description" : "此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-code"
        }
      },
      {
        "id" : "Condition.code.coding",
        "path" : "Condition.code.coding",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "由專門術語系統（terminology system）定義的代碼。此資料項目為可擴充綁定預設國際標準值集，但實作者可視實務專案需求只綁定以下slices中的任一值集。目前未只限定綁定預設值集是因為尚無slice值集與預設國際標準值集的代碼對應表，待後續有相對的代碼對應表後將建議採用國際標準值集作為唯一綁定值集並針對該值集進行擴充與管理，以利進行跨國與跨系統之資料交換。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼"
      },
      {
        "id" : "Condition.code.coding:icd10-cm-2023",
        "path" : "Condition.code.coding",
        "sliceName" : "icd10-cm-2023",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-cm-2023-tw"
        }
      },
      {
        "id" : "Condition.code.coding:icd10-cm-2021",
        "path" : "Condition.code.coding",
        "sliceName" : "icd10-cm-2021",
        "short" : "此為臺灣衛生福利部中央健康保險署維護之2021年中文版ICD-10-CM代碼，涵蓋範圍相對完整，可免費使用，可優先選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "病情、問題或診斷的識別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-cm-2021-tw"
        }
      },
      {
        "id" : "Condition.code.coding:icd10-cm-2014",
        "path" : "Condition.code.coding",
        "sliceName" : "icd10-cm-2014",
        "short" : "此為臺灣衛生福利部中央健康保險署維護之2014年中文版ICD-10-CM代碼，涵蓋範圍相對完整，可免費使用，可優先選用此代碼。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "病情、問題或診斷的識別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-10-cm-2014-tw"
        }
      },
      {
        "id" : "Condition.code.coding:icd9-cm-2001",
        "path" : "Condition.code.coding",
        "sliceName" : "icd9-cm-2001",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/icd-9-cm-2001-tw"
        }
      },
      {
        "id" : "Condition.code.coding:absentOrUnknownProblem",
        "path" : "Condition.code.coding",
        "sliceName" : "absentOrUnknownProblem",
        "short" : "不存在的問題或未知問題的代碼",
        "definition" : "表示「absent problem」或「problems unknown」的代碼",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/absent-or-unknown-problems-uv-ips"
        }
      },
      {
        "id" : "Condition.code.coding:sct",
        "path" : "Condition.code.coding",
        "sliceName" : "sct",
        "short" : "此為SNOMED CT診斷代碼，若機構已有購買相關授權，亦可使用。",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照。",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，如SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許使用者在不知道識別碼系統的情況下利用識別碼",
        "min" : 0,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/condition-code-sct-tw"
        }
      },
      {
        "id" : "Condition.bodySite",
        "path" : "Condition.bodySite",
        "short" : "如果相關請填寫解剖位置",
        "definition" : "此病情、問題或診斷表現出來的解剖位置",
        "comment" : "只有在Condition.code中找到的代碼未隱含此資料項目概念時才使用。如果使用案例（use-case）要求將BodySite作為一個單獨的resource來處理（例如：識別和追踪），那麼就使用標準的資料項目擴充方式來擴充bodySite。可以是一個摘要代碼，也可以是對一個非常精確位置定義的參照，或者兩者都是。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "描述解剖位置的代碼。可包括側面；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      },
      {
        "id" : "Condition.subject",
        "path" : "Condition.subject",
        "short" : "誰有此病情、問題或診斷？",
        "definition" : "表示與此病情、問題或診斷紀錄相關的病人或實體集合（Group resource）",
        "requirements" : "實體集合（Group resource）通常用於獸醫或公共衛生的案例",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.encounter",
        "path" : "Condition.encounter",
        "short" : "作為病情、問題或診斷紀錄的一部分的就醫（Encounter）紀錄",
        "definition" : "此病情、問題或診斷記載在哪次的「就醫（Encounter）」紀錄或者與此病情、問題或診斷紀錄密切相關的「就醫（Encounter）」紀錄",
        "comment" : "通常是此病情、問題或診斷發生的就醫事件，雖然有些活動可能在就醫結束之前或之後開始，但仍與就醫事件的情境有關。這筆紀錄表明與此病情、問題或診斷紀錄相關的就醫事件（Encounter）。「新的」診斷的情況下，反映病情、問題或診斷的持續/修訂資訊可能與首次就醫所知道的病情、問題或診斷不同。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Condition.onset[x]",
        "path" : "Condition.onset[x]",
        "short" : "估計的或實際的日期、日期—時間或年齡。",
        "definition" : "醫師認為此病情、問題或診斷之推估或實際發生時間或日期時間等",
        "comment" : "onsetAge通常是指病人說明病情何時開始發生的年齡",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.abatement[x]",
        "path" : "Condition.abatement[x]",
        "short" : "何時解決/緩解",
        "definition" : "病情、問題或診斷緩解或開始緩解的日期或估計日期。因為與「緩解（remissio）」或 「解決（resolution）」相關的許多過多含義—病情、問題或診斷不會真正解決，但它們可以緩解，所以稱為「緩解 （abatement）」，",
        "comment" : "解決（resolution）和緩解（remission）之間沒有明確的區別，因為在許多情況下，兩者的區別並不明顯。當病人說明病情、問題或診斷緩解的年齡時，一般使用onsetAge。如果沒有abatement這個資料項目，就不知道狀況是否已經解決或緩解；應用程式和使用者一般應假定病情、問題或診斷仍存在。當abatementString存在時，它意味著病情、問題或診斷已緩解。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                "valueBoolean" : true
              }
            ],
            "code" : "dateTime"
          },
          {
            "code" : "Age"
          },
          {
            "code" : "Period"
          },
          {
            "code" : "Range"
          },
          {
            "code" : "string"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.recordedDate",
        "path" : "Condition.recordedDate",
        "short" : "記錄的日期",
        "definition" : "recordedDate表述此Condition記錄何時於系統中建立，這通常是系統產生的日期。"
      },
      {
        "id" : "Condition.recorder",
        "path" : "Condition.recorder",
        "short" : "誰記錄此病情、問題或診斷",
        "definition" : "記錄病情、問題或診斷內容並對其內容負責的個人",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Condition.asserter",
        "path" : "Condition.asserter",
        "short" : "聲稱有此病情、問題或診斷的人",
        "definition" : "提出此病情、問題或診斷說明的人",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Condition.stage",
        "path" : "Condition.stage",
        "short" : "分期（stage）／分級（grade），通常是正式的評估。",
        "definition" : "病情、問題或診斷的臨床分期或分級，可能包括正式的嚴重程度評估。"
      },
      {
        "id" : "Condition.stage.summary",
        "path" : "Condition.stage.summary",
        "short" : "簡單的摘要（特定疾病）。",
        "definition" : "對分期的簡單摘要，如「第3期」。針對特定疾病的分期測定。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "描述病情、問題或診斷分期的代碼（例如：癌症分期）。應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-stage"
        }
      },
      {
        "id" : "Condition.stage.assessment",
        "path" : "Condition.stage.assessment",
        "short" : "正式的評估記錄",
        "definition" : "分期評估所依據的證據之正式記錄",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/ClinicalImpression",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-laboratoryResult-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-vitalSigns-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Condition.stage.type",
        "path" : "Condition.stage.type",
        "short" : "分期的種類",
        "definition" : "分期的種類，如病理分期或臨床分期。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "病情、問題或診斷分期種類的代碼（如臨床或病理）；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/condition-stage-type"
        }
      },
      {
        "id" : "Condition.evidence",
        "path" : "Condition.evidence",
        "short" : "支持的證據",
        "definition" : "作為病情、問題或診斷驗證狀態基礎的支持證據／臨床表現，如證實或反駁病情、問題或診斷的證據。",
        "comment" : "證據可以是一個簡單的編碼症狀／臨床表現的清單，或參考檢驗檢查或者正式評估，或者兩者都是。"
      },
      {
        "id" : "Condition.evidence.code",
        "path" : "Condition.evidence.code",
        "short" : "表現／症狀",
        "definition" : "導致記錄此病情、問題或診斷的表現或症狀",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "病情、問題或診斷的表現或症狀之代碼；應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/manifestation-or-symptom"
        }
      },
      {
        "id" : "Condition.evidence.detail",
        "path" : "Condition.evidence.detail",
        "short" : "在其他地方找到的支持資訊",
        "definition" : "其他相關資訊的連接，包括病理報告。"
      },
      {
        "id" : "Condition.note",
        "path" : "Condition.note",
        "short" : "關於此Condition的附加資訊",
        "definition" : "關於此Condition的附加資訊。這是一個一般的註釋／意見紀錄，用於描述病情、問題或診斷、其診斷和預後。",
        "mustSupport" : true
      }
    ]
  }
}

```
