# TW Core Composition - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core Composition 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreComposition |

 
此臺灣核心-臨床文件架構（TW Core Composition） Profile說明本IG如何進一步定義FHIR的Composition Resource以呈現臨床文件架構的詳細資料。 

## Resource Composition - 內容

一組醫療相關資訊會被整合成一個單一邏輯套件（package），這個套件提供了一個連貫的意義表達，並確立了它自己的上下文。它包含了臨床上的證明，明確指出是誰做出這些陳述。Composition定義了一份文件所需的結構和敘述內容。但是單一個Composition本身並不構成一份完整的文件。反之，Composition必須是在Bundle中的第一個條目，且該`Bundle.type`必須是document。此外，從Composition參照的任何其他resources都必須作為後續條目包含在該Bundle中（例如：病人（Patient）、健康照護服務提供者（Practitioner）、就醫紀錄（Encounter）等）。

### 範圍與使用

Composition是FHIR文件（[documents.html](https://hl7.org/fhir/R4/documents.html)）的基本結構，這些文件是不可更改的bundle，包含經過認證的敘述。一個單一的邏輯Composition可能與一系列衍生文件相關聯，每一份衍生文件都是該Composition的一個固定副本。 例如：想像您是一位醫生，正在使用一個電子健康紀錄（Electronic Health Record）系統。您為一位病人創建了一份初診報告，這份報告就是使用Composition為報告結構。它包括病人的基本資訊、症狀、初步診斷和治療計劃，當這份報告完成並保存後，它就成為Composition的一個「固定副本」，即不可更改的文件。隨後，每當這位病人回診，您都會基於最初的那份報告來創建新的隨訪記錄。這些隨訪記錄也是Composition的衍生文件，每份都是Composition獨立且不可更改的固定副本。它們可能包括更新的診斷、治療反應和新的治療計劃。

因此，「每一份都是該Composition的固定版本」在這個醫療場景中意味著，無論是原始的初診報告還是基於它創建的任何隨訪記錄，都是獨立且不可更改的文件，保留了創建時的準確資訊。

需要注意的是，Composition在EN13606及FHIR這兩項醫療資訊標準中的概念不完全相同。[EN 13606](http://en.wikipedia.org/wiki/EN_13606)中「Composition」這一專門術語是用來指一次對EHR系統的提交，常見的例子包括包含諮詢記錄、進程紀錄、報告或信件、調查報告、處方單或一組床邊護理觀察紀錄的Composition。在EHR中使用Composition作為經過認證的提交是Composition resource的有效應用。但在FHIR中，通常會進行更細微的更新，並為每次更新提供來源聲明。

臨床文件 Profile（[Clinical Document profile](https://hl7.org/fhir/R4/composition-clinicaldocument.html)）對Composition作進一步定義，使其專門用於指定臨床文件（以符合[CDA](https://hl7.org/fhir/R4/comparison-cda.html)格式）。關於與CDA的比較，也有進一步的資訊可供參考。

### 界限與關聯

Composition 是用於將資訊分組的結構，這種結構主要用於資訊的持久保存和可證明性。在 FHIR 中，除了 Composition 外，還有其他幾種用於不同目的的分組結構：

* [List](https://hl7.org/fhir/R4/list.html) resource 主要用於列舉一系列平行結構的 resources，並為管理這些 resources 集合提供功能。一個特定的 List instance 可能代表一個瞬間的「快照（snapshot）」，但從業務流程的角度來看，List 是動態變化會隨時間的推移，會不斷有項目被添加或移除。List resource 會參照其他的 resources。List 可以被精心策劃，並具有特定的業務含義。
* [Group](https://hl7.org/fhir/R4/group.html) resource 在 FHIR 中用於確定一組特定的人群、動物、設備等。這種確定可以是透過直接列出它們，或者描述這些組成成員共有的特質來完成。Group resource 可能會間接地關聯到其他的 resources。Group 的設計初衷是作為一個整體來進行操作或監測，例如：對整個群體進行治療、計算群體的風險等。這個 resource 常用於公共衛生（比如描述一個高風險人群）、臨床試驗（例如確定一組試驗對象）以及其他類似的用途。
* [Bundle](StructureDefinition-Bundle-twcore.md) resource 是 FHIR 中的一種基礎架構容器，用於封裝一組 resources。它不包含敘事性質的內容，而是用於對 resources 進行分組，以便於傳送、保存或處理。這些處理包括訊息傳遞（messages）、文件管理（documents）、異動處理（transactions）、查詢回應（query responses）等。Bundle 中的內容一般是基於特定交換或保存需求，透過演算法自動決定的。
* [Composition](StructureDefinition-Composition-twcore.md) resource 在 FHIR 中的作用是將一組與健康照護相關的資訊整合成一份單一的邏輯文件。這份文件不僅提供了完整且一致的意義表述，而且還設置了自己的上下文環境，並包含了關於聲明者的臨床認證資訊。Composition resource 是構成 FHIR [文件（document）](https://hl7.org/fhir/R4/documents.html)基本架構的核心部分。為了表達文件的完整內容，會使用一個 [Bundle](StructureDefinition-Bundle-twcore.md) resource，這個 [Bundle](StructureDefinition-Bundle-twcore.md) 包括了 Composition 本身和與該 Composition 相關聯的各個 resource 的條目（entry）。

Composition resource 在 FHIR 中用於將臨床和行政內容組織成多個小節。每個小節都包含敘事內容，並參照其他 resources 來提供支持數據。在 Composition 的不同小節中，敘事內容得到了小節條目中參照的 resources 的支持。為了形成完整的文件，需要將 Composition resource 與直接或間接關聯到 Composition 的各種 resources 結合起來，並將它們全部匯集到一個 [Bundle](StructureDefinition-Bundle-twcore.md) 中，以便於傳輸和保存。與以下 Composition 參照相關的 resources **必須（SHALL）** 包含在這個 [Bundle](StructureDefinition-Bundle-twcore.md) 中。

* [`Composition.subject`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.subject)（文件描述之對象，通常指病人）
* [`Composition.encounter`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.encounter) （就醫事件，通常指此文件所記錄的就醫事實之依據）
* [`Composition.author`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.author) （作者，撰寫此份文件者）
* [`Composition.attester.party`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.attester.party) （證明文件正確無誤的參與者，或稱認證者）
* [`Composition.custodian`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.custodian) （文件保管機構）
* [`Composition.event.detail`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.event.detail)（文件描述事件之細節）
* [`Composition.section.author`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.section.author) （文件小節之作者）
* [`Composition.section.focus`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.section.focus) （文件小節之焦點）
* [`Composition.section.entry`](StructureDefinition-Composition-twcore-definitions.md#diff_Composition.section.entry) （文件小節之條目）

當 FHIR 中的 Composition 參照其他 resources 時，這些被參照的 resources 是否包含在 Bundle 中，取決於創建這些 resources 的系統。這種決策會在該系統的操作定義中進行記載（例如：透過 ***$document*** 操作來說明），或者會依照適用的 profiles 進行具體規定。 **簡言之，是否將這些額外的 resources 包括在 Bundle 中，是由創建它的系統根據自己的規則和標準來決定的。FHIR並未規定Bundle是否一定要包含或者一定不要包含這些相關聯的 resources。**

## 背景

### Composition狀態代碼（Status Codes）

每個 Composition 都包含一個資料項目稱為「狀態（`status`）」，它用來描述 Composition 內容的當前狀態，這個狀態是從一系列特定的代碼中選擇的。

### Composition的工作流程或臨床狀態

* 狀態代碼: `preliminary`
  * 中文翻譯: 初步的
  * 代碼定義說明: 這是一個初步的 composition 或文件（也稱為初始或暫時的）。其內容可能是不完整的或未經驗證的。
* 狀態代碼: `final`
  * 中文翻譯: 最終的
  * 代碼定義說明: 這版本的 composition 已經被相關人士完整地完成並進行了驗證，且不打算進行進一步的修改或添加。如果有任何後續的更新，將會在該 composition 的新版本中進行。
* 狀態代碼: `amended`
  * 中文翻譯: 修正的
  * 代碼定義說明: 當一份 composition 被標記為「`amended`」，這表示在該 composition 被定義為「final」後，它的內容或所參照的 resources 已經遭到修改（經過編輯或增加）。此外，這份已修改的 composition 也已由授權人員完成並進行了驗證。
* 狀態代碼: `entered-in-error`
  * 中文翻譯: 錯誤輸入
  * 代碼定義說明: 這個狀態表示該 composition 或文件最初是錯誤地創建或發布的。此一代碼是用來指出整個系列的文件都不應該被認為是有效的。

Composition 狀態通常只會按照以下順序變化：從 `preliminary` 變為 `final` ，然後可能進一步變為 `amended`。值得注意的是，在許多工作流程中，只有 `final` 狀態的 compositions 被公開使用，而 `preliminary` 狀態則不會被使用。

在工作流程中，有極少數的 Composition 是完全錯誤地創建的，通常是涉及錯誤的病人或錯誤的作者所寫，而這個錯誤在 Composition 已經被使用或已從中衍生出文件後才被發現。為了解決這類情況，會將錯誤的 Composition 更新為「`entered-in-error`」狀態，並可以創建一份新的衍生文件。這表示基於該 Composition 衍生出的所有文件系列都被認為是錯誤創建的。因此，那些接收這些基於已撤回 Composition 衍生的文件的系統應從常規使用中移除之前文件的資料，或採取其他適合行動。雖然系統不必強制提供這種工作流程或支持從已撤回的 Composition 衍生的文件，但它們絕不能忽視「`entered-in-error`」的狀態。需要注意的是，那些處理 Composition 或衍生文件但不支援錯誤狀態處理的系統，需要找到其他方法來處理錯誤創建的 Composition；即使這不常見，但有些臨床系統沒有辦法從病人紀錄中移除錯誤資訊，用戶也無法知道這些資訊不適用，這是不安全的。

### 針對熟悉 CDA 的讀者的注意事項

很多使用這個規範的用戶都對[臨床文件架構（Clinical Document Architecture，簡稱 CDA）](http://www.hl7.org/implement/standards/product_brief.cfm?product_id=7)及其相關的規範有所了解。CDA 是構成 Composition resource 的一個重要設計來源，除此之外，還包括其他 HL7 的文件規範和 EN13606。在 CDA 和 Composition resource 這兩者之間，存在著三個主要的結構上的不同。

* Composition是一個邏輯架構，它的識別碼（`identifier`）對應於CDA ClinicalDocument的setId。Composition resource 被封裝在[Document](https://hl7.org/fhir/R4/documents.html)結構中，用於交換整個套件（包括Composition及其各部分）。這個被封裝和密封的單位相當於CDA文件，其中Bundle的id在功能上相似於ClinicalDocument的id，但在將 Composition 轉換為CDA文件或反轉過程中，這兩個不會完全對應，因為這涉及到格式間的轉換）。
* Composition的小節定義了文件的一部分（或子小節）。但不同於CDA，這裡的小節條目實際上是對其他[resources](https://hl7.org/fhir/R4/resourcelist.html)的參照，這些 resource 保存了支持該小節的資料內容，這種設計意味著這些資料可以以許多其他方式被重用。
* CDA中定義的上層資訊自動適用於其文件中的所有部分，其屬上下文流程模型（context flow model）；但不同於CDA，在 Composition 中定義的上下文（例如保密級別、文件對象、作者、事件、事件時間和就醫事件）只適用於Composition本身，並不直接適用於從`section.entry`參照的其他 resources 。FHIR中沒有一個上下文流動的模型，所以從 Composition 中參照的每一個 resource 都會表達它自己的特定上下文。因此，臨床內容可以安全地從 Composition 中分離出來。

另外需要注意的是，代碼列表（例如[`Composition.status`](https://hl7.org/fhir/R4/valueset-composition-status.html)）和 Composition resource 本身都被[對應](https://hl7.org/fhir/R4/composition-mappings.html)到[HL7 v3](https://www.hl7.org/implement/standards/product_brief.cfm?product_id=186)和/或CDA標準。這意味著Composition中使用的特定標準資料項目和值，如其狀態代碼，已經適配於這些更廣泛應用的健康資訊標準中。這種映射確保了不同系統和框架間的相容性和可互操作性。

此外，Composition resource 不僅僅參照自身，還被[Contract](https://hl7.org/fhir/R4/contract.html#Contract)和[Procedure](StructureDefinition-Procedure-twcore.md)等其他FHIR resources 所參照。在FHIR架構中，這種互相參照的設計使得資料項目和資料結構能夠在不同的臨床和行政場景中被重複使用，增強了資料的連接性和一致性。例如：一個特定的 Composition 可能與某個特定的醫療處置或合約直接相關，從而使得這些相關 resources 的關聯和管理變得更加清晰和有序。

**Usages:**

* Use this Profile: [TW Core Bundle Document](StructureDefinition-Bundle-document-twcore.md)
* Refer to this Profile: [TW Core Procedure](StructureDefinition-Procedure-twcore.md)
* Examples for this Profile: [Composition/com-example](Composition-com-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/Composition-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-Composition-twcore.csv), [Excel](StructureDefinition-Composition-twcore.xlsx), [Schematron](StructureDefinition-Composition-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`_id`](SearchParameter-Composition-id.md)**查詢所有Composition：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Composition?_id=[id]`
`GET [base]/Composition/[id]`例子：
(1) GET [base]/Composition?_id=com-example
(2) GET [base]/Composition/com-example
1. **建議應該（SHOULD）**支援透過查詢參數**[`status`](SearchParameter-Composition-status.md)**查詢所有Composition：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Composition?status=[code]`例子：
(1) GET [base]/Composition?status=final
1. **建議應該（SHOULD）**支援透過查詢參數**[`type`](SearchParameter-Composition-type.md)**查詢所有Composition：
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/Composition?type={system|}[code]`例子：
(1) GET [base]/Composition?type=http://loinc.org|18842-5
1. **建議應該（SHOULD）**支援透過查詢參數**[`subject`](SearchParameter-Composition-subject.md)**查詢所有Composition：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
`GET [base]/Composition?subject={Type/}[id]`例子：:
(1) GET [base]/Composition?subject=Patient/pat-example

#### Constraints 限制

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| cmp-1 | Rule | Composition.section | 小節必須包含至少一項：文本、條目或子小節。 | text.exists() or entry.exists() or section.exists() |
| cmp-2 | Rule | Composition.section | 小節是空的才可設定emptyReason | emptyReason.empty() or entry.empty() |

### 實作注意事項

* 通常文件的作者和認證者是同一人，但在某些臨床工作流程中，兩者可能不相同。
* 認證者（attester）的職責是對document resource、subject resource以及 `Composition.section.content` 參照的 resources 內容進行確認及認證，因為這些文件往往是基於 Composition 衍生而來，且 Composition 的認證被認為適用於相關文件，因此當認證者審查 Composition 的內容時，[應該使用一種類似審查最終文件那樣嚴謹和仔細](https://hl7.org/fhir/R4/documents.html#presentation)。這意味者，在 Composition 階段，即使文件還沒有最終完成，認證者也應以正式及詳細的方式來審核內容，就像他們在審核最終文件進行審核一樣。
* 保管者負責維護Composition以及由其衍生的任何文件。對於這些文件，他們還需負責制定有關文件持久性的政策。儘管他們不必一定要保留文件的副本，但 **建議應該（SHOULD）** 這樣做。
* Composition只包含敘述性文字（`Composition.section.text`）而不包含任何條目（`Composition.section.entry`）也是可以接受的。

### 關於多個實體的Compositions

一般來說，一份Composition是針對某個對象製作的，例如：一位病人、一群病人、某個位置或裝置。Composition與描述對象之間的區別在於，Composition是對對象的描述。但是，有些文件中包含的是與文件對象相關的其他參與者或實體的資料。這裡有一些例子：

* 一份新生兒出院病摘，其中包含了有關母親的資訊。
* 一份家族病史文件，包含了針對不同家庭成員的多個小節。
* 一份社交健康評估文件，其中包含了病人家庭成員的資訊。
* 一份處置報告，詳述了植入病人體內的裝置的細節。

在這些例子中，雖然文件主要對象是一位病人，但一些細節實際上與其他人或實體有關。當出現這種情況時，這些其他相關的人員或實體會在 `Composition.section.focus`資料項目中被具體說明。如果沒有明確指出`focus`，那麼預設Composition的主要`suject`即是`focus`。

如果明確指定了`focus`，那麼與該小節相關的resources **必須（SHALL）** 當遵守以下其中一項條件：

* 它們應該明確表示其`subject`（不管是以病人或其他名稱標示）或如果有`focus`資料項目，則該資料項目應該是所指的focus。此外，這些resources不應該包含subject資料項目。
* 有些Composition實際上涉及多個對象—即不同小節關於不同的對象。在這種情況下，`Composition.subject`應該省略，並且在每個小節中使用[section-subject](https://hl7.org/fhir/R4/extension-composition-section-subject.html)這個擴充資料項目來指示相應的對象。



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "Composition-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Composition-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreComposition",
  "title" : "TW Core Composition",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-臨床文件架構（TW Core Composition） Profile說明本IG如何進一步定義FHIR的Composition Resource以呈現臨床文件架構的詳細資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "將一組resources組成一份連貫的臨床聲明，並附有臨床證明。",
        "definition" : "一組與健康照護相關的資訊，這些訊息被組合成一個單一的邏輯套件，提供一個單一的連貫的意義陳述，建立自己的上下文，並且提供有關於是誰做出陳述的臨床認證。",
        "comment" : "雖然此規範的重點在於特定於病人的臨床聲明，但此resource也可適用於其他與健康照護相關的聲明，如研究方案設計、醫療發票和其他不必然與特定於病人或臨床相關的活動。"
      },
      {
        "id" : "Composition.id",
        "path" : "Composition.id",
        "short" : "不重複的ID用以識別儲存在特定FHIR Server中的Composition紀錄，通常又稱為邏輯性ID。",
        "definition" : "resource的邏輯ID，在resource的URL中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個resource使用新增操作(create operation)提交給伺服器時是此resource唯一沒有id的時刻"
      },
      {
        "id" : "Composition.meta",
        "path" : "Composition.meta",
        "short" : "此Composition Resource的metadata",
        "definition" : "關於resource的metadata。這是由基礎建設維護的內容。對內容的改變可能並不總是與resource的版本改變相關。"
      },
      {
        "id" : "Composition.implicitRules",
        "path" : "Composition.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建resource時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是IG定義特殊規則及其他profiles的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的貿易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和(或)規範編寫者應該避免使用這個資料項目。通常，在使用時，此URL是對實作指引的參照，此指引將這些特殊規則與其他profiles、value sets等一起定義為其敘述的一部分。"
      },
      {
        "id" : "Composition.language",
        "path" : "Composition.language",
        "short" : "用以表述Composition Resource內容的語言",
        "definition" : "編寫此resource的基礎語言",
        "comment" : "提供語言是為了支援索引和可存取性(通常，文字表述轉語音等服務使用此語言標籤)。html lanuage tag適用於此敘述。resource上的語言標籤可用於指定從resource中的資料所產成的其他表述之語言。不是所有的內容都必須使用此基礎語言。不應該假定Resource.language自動適用於敘述。如果指定語言，它也應該被指定在html中的div元素(關於xml:lang和html lang屬性之間的關係，見HTML5中的規則)。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "Composition.text",
        "path" : "Composition.text",
        "short" : "Composition Resource之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含resource的摘要，可用於向人表述resource的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource定義可定義哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌(contained)的resource沒有敘述，非內嵌(contained)的resource則 **建議應該(SHOULD)** 有敘述。在某些情況下，resource可能只有文字表述，很少或沒有額外的離散資料(只要滿足所有minOccurs=1的資料項目)。這對於來自舊有系統的資料可能是必要的，在這些系統中，從 「文字表述區塊(text blob) 」獲取訊息，或者文字表述是額外的原始輸入或敘述，而編碼訊息是後來添加的。"
      },
      {
        "id" : "Composition.contained",
        "path" : "Composition.contained",
        "short" : "內嵌的(contained)、行內的Resources",
        "definition" : "這些resource內嵌(contains)的resource不會另外存於任何FHIR伺服器，意即它們無法在任何FHIR伺服器中被找到，也無法有自己獨立的資料異動／交易(transaction)範圍。",
        "comment" : "內嵌(contained)的resource沒有敘述，非內嵌(contained)的resource則 **建議應該(SHOULD)** 有敘述。在某些情況下，resource可能只有文字表述，很少或沒有額外的離散資料(只要滿足所有minOccurs=1的資料項目)。這對於來自舊有系統的資料可能是必要的，在這些系統中，從 「文字表述區塊(text blob) 」獲取訊息，或者文字表述是額外的原始輸入或敘述，而編碼訊息是後來添加的。"
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "short" : "擴充的資料項目",
        "definition" : "可用於表示不屬於此資料項目基本定義的附加資訊。為了擴充的使用安全和可管理，對擴充的定義和使用有一套嚴格的管理。儘管任何實作者都可以定義一個擴充，但作為擴充定義的一部分，有一套要求 **必須（SHALL）** 滿足。",
        "comment" : "無論使用或定義擴充的機構或管轄區，任何應用程式、專案或標準使用擴充都不背負任何污名(stigma)。使用擴充是允許FHIR規範為每個人保留一個核心的簡易性。"
      },
      {
        "id" : "Composition.modifierExtension",
        "path" : "Composition.modifierExtension",
        "short" : "此擴充的資料項目可能會完全修正或改變其他資料項目的意涵，需特別留意。",
        "definition" : "可以用來表示不屬於資料項目的基本定義的附加資訊，並且修改對它所內嵌(contained)的資料項目的理解和(或)對包含資料項目之後續使用的理解。通常，修飾用的資料項目提供否定或限定。為了使擴充的使用安全和可管理，對擴充的定義和使用有一套嚴格的管理。儘管任何實作者都可以定義一個擴充，但作為擴充定義的一部分，有一套要求 **必須（SHALL）** 滿足。處理resource的應用程式被要求檢查修飾用的擴充資料項目。  \n修飾用的擴充資料項目 **必須沒有(SHALL NOT)** 改變resource或DomainResource上任何資料項目的含義(包括不能改變modifierExtension本身的含義)。",
        "comment" : "無論使用或定義擴充的機構或管轄區，任何應用程式、專案或標準使用擴充都不背負任何污名(stigma)。使用擴充是允許FHIR規範為每個人保留一個核心的簡易性。",
        "requirements" : "修飾用的資料項目擴充將不能安全地忽略的擴充與絕大多數可以安全地忽略的擴充明確區分開來。透過消除禁止實作者擴充存在的需求來促進可互操作性。更多訊息，請參見[修飾用的資料項目擴充之定義](http://hl7.org/fhir/R4/extensibility.html#modifierExtension)。"
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "不分版本的臨床文件架構(Composition)識別碼。",
        "definition" : "與版本無關的Composition識別碼。隨著時間的推移，該識別碼將保持不變。",
        "comment" : "類似於 CDA 中的 ClinicalDocument/setId。請參閱resource定義中的討論，了解它們之間的關係。",
        "mustSupport" : true
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "registered | partial | preliminary | final | amended | corrected +",
        "definition" : "此composition的工作流程/臨床狀態。狀態是指文件的臨床狀態的標識。",
        "comment" : "如果一個composition被標記為撤回(withdraw)，那麼該系列中的composition/文件或者此composition或文件系列中的資料，若未被明確標記為(該撤回)不可信的情況下，則不應向用戶展示。「錯誤輸入 (entered-in-error)標籤是此composition為何被標記為修飾用資料項目(modifier)的原因。\n某些報告工作流程要求最終文件的原始敘述永不更改；意即只能添加新的敘述。composition resource 沒有明確的狀態(status)來明確註明是否適用此業務規則。如有需要，這將透過擴充來處理。",
        "requirements" : "需要能夠標記為臨時(interim)、修改(amended)或撤回(withdrawn)的composition或文件。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "CompositionStatus"
            }
          ],
          "strength" : "required",
          "description" : "Composition的工作流程/臨床狀態；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/composition-status|4.0.1"
        }
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "Composition的種類（如果可能請使用LOINC）",
        "definition" : "指定特定類型的composition（如病史和體檢、出院摘要、病程紀錄）。這通常等同於製作composition的目的。",
        "requirements" : "描述composition的關鍵metadata資料項目，用於查詢/篩選。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-type-doc-code"
        }
      },
      {
        "id" : "Composition.category",
        "path" : "Composition.category",
        "short" : "Composition的分類",
        "definition" : "composition類型的分類 - 有助於索引和查詢。這可能是由 Composition Type 中指定的代碼隱含或衍生出來的。",
        "comment" : "\"這是來自XDS/MHD的metadata欄位\"。",
        "requirements" : "幫助人類在檢視composition或規範文件時評估composition是否感興趣。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-document-classcodes"
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "short" : "Composition是關於誰和/或什麼",
        "definition" : "composition是關於誰或什麼的。composition可以是關於一個人（病人或醫護人員）、一個設備（如機器），甚至是一群對象（如關於一群牲畜的文件，或一群有共同曝露的病人）。",
        "comment" : "對於臨床文件來說，這通常是指病人。",
        "requirements" : "查詢composition的基本metadata，指明compoisition/文件的作者和/或內容。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Substance",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.encounter",
        "path" : "Composition.encounter",
        "short" : "Composition的情境",
        "definition" : "描述與該文件相關的臨床就醫事件或照護類型。",
        "requirements" : "為composition提供情境並支持查詢。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "Composition的編輯時間",
        "definition" : "composition編輯時間，即作者最後一次邏輯上更改composition的時間。",
        "comment" : "composition上的最後修改日期可能在文件被證明日期之後而未更改。這意味著修改過的文件上的日期是修改日期，而非原始撰寫之日期。",
        "requirements" : "dateTime 用於追蹤、組織版本和查詢。請注意：這是創作此版本Composition的時間。打包成文檔時，Bundle.timestamp 是打包日期。",
        "mustSupport" : true
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "誰和/或什麼創建了這個Composition",
        "definition" : "指明誰對composition中的資訊負責，而不一定是誰輸入了它。",
        "requirements" : "指明誰對內容負責",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "人類可讀的名稱/標題",
        "definition" : "composition的正式可讀標籤",
        "comment" : "對於許多composition來說，標題與文本或 Composition.type 的顯示名稱相同（如 「會診﹙consultation﹚」或 「病程紀錄﹙progress note﹚」）。請注意：CDA 並不強制要求標題，但目前還沒有發現省略標題有用的情況，因此在此強制要求標題。歡迎在試用區間對這一要求提出反饋意見。",
        "mustSupport" : true
      },
      {
        "id" : "Composition.confidentiality",
        "path" : "Composition.confidentiality",
        "short" : "根據特定技術領域的定義",
        "definition" : "具體說明Composition保密等級的代碼",
        "comment" : "此資料項目的確切使用，以及與高度敏感文件相關的執行和問題超出了基本規範的範圍，並委託給實作Profiles（見安全小節）。 此資料項目被標記為修飾用，因為高度機密的文件不能被當作非機密文件處理。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentConfidentiality"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ConfidentialityClassification|2014-03-26"
        }
      },
      {
        "id" : "Composition.attester",
        "path" : "Composition.attester",
        "short" : "證明Composition的準確性",
        "definition" : "證明composition/文件準確無誤的參與者",
        "comment" : "每位參與者只需每位證明者只列一次",
        "requirements" : "指明對composition內容準確性的責任",
        "mustSupport" : true
      },
      {
        "id" : "Composition.attester.mode",
        "path" : "Composition.attester.mode",
        "definition" : "認證者提供的認證類型",
        "requirements" : "指明認證的權威程度",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "CompositionAttestationMode"
            }
          ],
          "strength" : "required",
          "description" : "認證者提供的認證類型；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/composition-attestation-mode|4.0.1"
        }
      },
      {
        "id" : "Composition.attester.time",
        "path" : "Composition.attester.time",
        "short" : "此Composition被證明的時間",
        "definition" : "當composition被該方證實的時間",
        "requirements" : "指明composition中的資訊何時被認為是準確的。（自那時起可能發生了變化）。"
      },
      {
        "id" : "Composition.attester.party",
        "path" : "Composition.attester.party",
        "short" : "誰證明了此Composition",
        "definition" : "誰以指定的方式證明了此composition",
        "requirements" : "指明由誰承擔composition內容準確性的責任",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Composition.custodian",
        "path" : "Composition.custodian",
        "short" : "維護Composition的機構",
        "definition" : "指明負責持續維護和存取composition/文件資訊的機構或團體",
        "comment" : "當此文件是衍生自composition時非常有用。它提供了如何獲取文件的最新版本的指導。這是可選項，因為有時編寫系統並不知道可以根據情境推斷。不過，在處理派生文件時，了解這一資訊非常重要，因此鼓勵提供一個保管者。",
        "requirements" : "指明在哪裡可以找到當前版本、在哪裡可以報告問題等",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Composition.relatesTo",
        "path" : "Composition.relatesTo",
        "short" : "與其他Composition/文件之間的關係",
        "definition" : "此composition與其他已有的composition或文件之間的關係",
        "comment" : "要參照（使用 relatesTo）「document」type的 Bundle 或其他只有識別碼的 Composition，請使用帶有識別碼的 resourceReference。"
      },
      {
        "id" : "Composition.relatesTo.code",
        "path" : "Composition.relatesTo.code",
        "definition" : "此composition與另一個compoisition或文件的關系類型",
        "comment" : "如果此文件附加了另一個文件，那麼如果不存取參照的文件，就無法完全理解此文件。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentRelationshipType"
            }
          ],
          "strength" : "required",
          "description" : "檔案之間的關係型別；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/document-relationship-type|4.0.1"
        }
      },
      {
        "id" : "Composition.relatesTo.target[x]",
        "path" : "Composition.relatesTo.target[x]",
        "short" : "此關係的目標文件",
        "definition" : "此關係的目標composition/文件"
      },
      {
        "id" : "Composition.event",
        "path" : "Composition.event",
        "short" : "正在記錄的臨床服務",
        "definition" : "記錄的臨床服務，例如：結腸鏡檢查或闌尾切除術。",
        "comment" : "事件需要與類型資料項目保持一致，但如果需求，也可以提供更多的詳細資訊。",
        "requirements" : "為composition提供情境背景，並在描述事件的resource和為描述事件而創建的composition之間建立連結。"
      },
      {
        "id" : "Composition.event.code",
        "path" : "Composition.event.code",
        "short" : "此代碼表代表了正在被記錄的主要臨床行為",
        "definition" : "一個概念可能透過正式參照專門術語或本體論來定義，或者可以由文字提供。",
        "comment" : "一個事件可以進一步專門化 typeCode 中固有的行為，例如：當它僅僅是「處置報告」，而該處置是「結腸鏡檢查」。如果包含一個或多個事件，它們 **必須沒有(SHALL NOT)** 與 classCode、practiceSettingCode 或 typeCode 中固有的值相衝突，因為這樣的衝突會造成模糊不清的情況。這個簡短的代碼清單提供用作某些類型查詢的關鍵字。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "DocumentEventType"
            }
          ],
          "strength" : "example",
          "description" : "可參考所綁定值集，但此值集只是針對這個欄位的一個可能值的範例，不預期也不鼓勵使用者一定要使用此值集的代碼。",
          "valueSet" : "http://terminology.hl7.org/ValueSet/v3-ActCode"
        }
      },
      {
        "id" : "Composition.event.period",
        "path" : "Composition.event.period",
        "short" : "文件所涵蓋的時間區間",
        "definition" : "此文件涵蓋的時間區間，這並不是聲明此文件是這一個時間區間的完整代表，而只是表明它記錄了這段時間內發生的事件。"
      },
      {
        "id" : "Composition.event.detail",
        "path" : "Composition.event.detail",
        "short" : "在描述被記錄下來的事件，這些事件可以是以代碼的形式、參考資料的形式，或者兩者都有的形式來呈現。",
        "definition" : "它描述了正在被記錄的主要臨床活動，比如說進行一次結腸鏡檢查或是闌尾切除手術。在某些情況下，這些臨床事件本身就包含在其typeCode中，例如：在「病史與體檢報告」中，所記錄的過程就必然是進行「病史與體檢」的行為。這些臨床事件可以以代碼的形式被記錄，或者作為對其他resource的參照。",
        "comment" : "事件可以進一步細化類型編碼中的固有行為，例如，事件只是程序報告，而程序是結腸鏡檢查。如果包含一個或多個事件，它們不得與類別編碼、診療設置編碼或類型代碼中固有的值相衝 突，因為這樣的衝突會造成模稜兩可的情況。本編碼簡表可用作某些類型查詢的關鍵詞。"
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "short" : "Composition被分成一個或數個小節",
        "definition" : "構成composition的各小節",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section.title",
        "path" : "Composition.section.title",
        "short" : "小節標籤(例如：目錄ToC)",
        "definition" : "此特定小節的標籤。這將是文件呈現內容的一部分，通常用於建立目錄。",
        "comment" : "標題為人類讀者指明小節。標題必須與作為 section.content 參照目標的resource的敘述一致。通常章節 **建議應該(SHOULD)** 有標題，但在某些文件中，這可能是不必要的或不適當的。通常情況下，當一個小節有其自己足夠區分的標題的子小節，或只有單一小節的文件時，就會這樣。大多數IG會要求小節標題是必填的資料項目。",
        "requirements" : "不同類型的文件常常會有標準化的小節標題，這些標題為人們提供如何組織文件的指引。"
      },
      {
        "id" : "Composition.section.code",
        "path" : "Composition.section.code",
        "short" : "小節分類(建議)",
        "definition" : "一個用於指明小節中所含內容種類的代碼，這個代碼必須與小節的標題相一致。",
        "requirements" : "提供給文件中主題的標籤是標準化的，並且可以被電腦程式識別和處理。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/loinc-doc-section-code"
        }
      },
      {
        "id" : "Composition.section.author",
        "path" : "Composition.section.author",
        "short" : "誰和/或什麼人撰寫了該小節",
        "definition" : "指明誰對小節中的資訊負責，而不一定是誰輸入了它。",
        "requirements" : "指明誰對內容負責",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section.focus",
        "path" : "Composition.section.focus",
        "short" : "當小節與composition描述的對象無關時，此小節是關於誰/什麼。",
        "definition" : "當小節的實際焦點不是composition描述的對象，而是代表與對象相關的某事物或某人時，例如：（對於病人對象）配偶、父母、胎兒或捐贈者。如果沒有指定焦點，則假定焦點為父小節的焦點，或者對於Composition本身中的小節，為Composition的對象。具有焦點的小節只 **必須（SHALL）** 包含對象（病人、對象、焦點等）與小節焦點相匹配的resources，或者是沒有對象的resources（少數resources）。",
        "comment" : "通常，文件中的小節是關於該文件的描述對象，無論是病人、一群病人、位置、設備或其他。對於某些種類的文件，有些小節實際上包含有關的實體資料。典型的例子包括新生兒出院病摘中關於母親的小節，或者家族病史文件中關於每個家庭成員的小節，當然還有很多其他例子。"
      },
      {
        "id" : "Composition.section.text",
        "path" : "Composition.section.text",
        "short" : "將文件中特定小節的內容簡化成容易理解的文字形式，便於人類閱讀和解釋。",
        "definition" : "一個供人閱讀的敘述，包含小節的核實內容，用以展現resource的內容供人類閱讀。這段敘述不需要涵蓋所有結構化的資料，但必須包含足夠的細節，確保僅透過閱讀這段敘述的人能夠在臨床上獲得安全且準確的資訊。",
        "comment" : "文件Profile可能會定義應在敘述中呈現哪些內容，以確保臨床安全。",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section.mode",
        "path" : "Composition.section.mode",
        "short" : "適用於此小節的處理模式",
        "definition" : "條目清單是如何準備的 - 它是一個適合持續維護的工作清單，還是代表從另一個來源截取的項目清單的快照，或者是一個準備好的清單，在該清單中，項目可能被標記為已添加、修改或刪除。",
        "comment" : "這個資料項目被標記為修飾用，是因為不應將變更清單(a change list)誤解為完整清單(a complete list)。",
        "requirements" : "小節有多種使用方式，因此必須清楚地了解如何安全地使用其中的條目。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SectionMode"
            }
          ],
          "strength" : "required",
          "description" : "應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/list-mode|4.0.1"
        }
      },
      {
        "id" : "Composition.section.orderedBy",
        "path" : "Composition.section.orderedBy",
        "short" : "小節條目的順序",
        "definition" : "指定應用於小節條目的項目順序",
        "comment" : "應用程式 **建議應該(SHOULD)** 按照給定的順序來顯示有序清單，但也可以允許用戶按照他們自己的偏好進行重新排序。如果沒有明確指定順序，則該順序是不確定的，雖然清單可能仍有某種排列順序。",
        "requirements" : "這對於展示和呈現是重要的，清單可能會進行排序，以便將重要的資訊放在前面，或將相關的條目分組。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SectionEntryOrder"
            }
          ],
          "strength" : "preferred",
          "description" : "鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/list-order"
        }
      },
      {
        "id" : "Composition.section.entry",
        "path" : "Composition.section.entry",
        "short" : "提供一個連結用於參照或查看支持此小節內容的資料",
        "definition" : "指向那些提供小節中敘述內容的實際resource的參照",
        "comment" : "如果清單中沒有條目，則 **建議應該(SHOULD)** 提供 emptyReason。",
        "mustSupport" : true
      },
      {
        "id" : "Composition.section.emptyReason",
        "path" : "Composition.section.emptyReason",
        "short" : "為什麼此小節是空的原因",
        "definition" : "如果小節為空，則說明清單為空的原因。一個空的小節通常有一些文字說明空的原因。",
        "comment" : "當一個小節是空的，其空白的原因對於理解該小節非常重要。需要注意的是，這個代碼是用於當整個小節的內容都沒有被包括時，它並不適用於個別項目被省略的情形，若為個別項目被省略的情況，開發者可以考慮在該條目中添加文字說明或標記。",
        "requirements" : "允許捕捉像是「不存在」或「未詢問」這樣的情況，這對於大多數清單來說可能很重要。",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw"
            ]
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "SectionEmptyReason"
            }
          ],
          "strength" : "preferred",
          "description" : "鼓勵使用所綁定值集中的代碼，但不強制一定要使用此值集，你也可使用其他值集的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/list-empty-reason"
        }
      },
      {
        "id" : "Composition.section.section",
        "path" : "Composition.section.section",
        "short" : "嵌套的小節",
        "definition" : "此小節中嵌套的小節",
        "comment" : "嵌套小節主要是為了幫助讀者快速找到文件中的特定內容"
      }
    ]
  }
}

```
