# TW CodeableConcept - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Data Type Profile: TW CodeableConcept 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:CodeableConceptTW |

 
此臺灣CodeableConcept Profile說明本IG如何進一步定義FHIR的CodeableConcept資料類型以呈現CodeableConcept [[**FMM1**](http://build.fhir.org/versions.html#maturity)] 

**Usages:**

* Use this DataType Profile: [TW Core AllergyIntolerance](StructureDefinition-AllergyIntolerance-twcore.md), [TW Core Composition](StructureDefinition-Composition-twcore.md), [TW Core Condition](StructureDefinition-Condition-twcore.md), [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md)...Show 41 more,[TW Core DocumentReference](StructureDefinition-DocumentReference-twcore.md),[TW Core Encounter](StructureDefinition-Encounter-twcore.md),[TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md),[TW Core Location](StructureDefinition-Location-twcore.md),[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core Medication](StructureDefinition-Medication-twcore.md),[TW Core MedicationDispense](StructureDefinition-MedicationDispense-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md),[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md),[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Laboratory Result](StructureDefinition-Observation-laboratoryResult-twcore.md),[TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Organization](StructureDefinition-Organization-twcore.md),[TW Core Patient](StructureDefinition-Patient-twcore.md),[TW Core Practitioner](StructureDefinition-Practitioner-twcore.md),[TW Core PractitionerRole](StructureDefinition-PractitionerRole-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core Provenance](StructureDefinition-Provenance-twcore.md),[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md),[TW Core Specimen](StructureDefinition-Specimen-twcore.md),[臺灣核心-用藥聲明(TW Core MedicationStatement) 之資料模型](StructureDefinition-TWMedicationStatement.md)and[TW Postal code](StructureDefinition-tw-postal-code.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/CodeableConcept-tw)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CodeableConcept-tw.csv), [Excel](StructureDefinition-CodeableConcept-tw.xlsx), [Schematron](StructureDefinition-CodeableConcept-tw.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CodeableConcept-tw",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CodeableConcept-tw",
  "version" : "1.0.0",
  "name" : "CodeableConceptTW",
  "title" : "TW CodeableConcept",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣CodeableConcept Profile說明本IG如何進一步定義FHIR的CodeableConcept資料類型以呈現CodeableConcept  [[*FMM1*](http://build.fhir.org/versions.html#maturity)]",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "orim",
      "uri" : "http://hl7.org/orim",
      "name" : "Ontological RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "CodeableConcept",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CodeableConcept",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CodeableConcept",
        "path" : "CodeableConcept",
        "short" : "概念（Concept）— 參照一個專門術語或只是文字表述"
      },
      {
        "id" : "CodeableConcept.id",
        "path" : "CodeableConcept.id",
        "short" : "唯一可識別ID，以供資料項目間相互參照。",
        "definition" : "resource中資料項目的唯一ID（用於內部參照）。這可以是任何不含空格的字串。"
      },
      {
        "id" : "CodeableConcept.extension",
        "path" : "CodeableConcept.extension",
        "short" : "擴充的資料項目",
        "definition" : "擴充的資料項目"
      },
      {
        "id" : "CodeableConcept.coding",
        "path" : "CodeableConcept.coding",
        "short" : "由專門術語系統（terminology system）定義的代碼",
        "definition" : "由專門術語系統（terminology system）所定義之代碼的參照",
        "comment" : "代碼可以在列舉清單（enumerations）或代碼清單（code lists）中非常隨意地定義，直至有非常正式的定義，例如：SNOMED CT—更多資訊見HL7 v3核心原則（Core Principles ）。編碼的排序是未定義的因而 **必須沒有（SHALL NOT）** 被用來推斷意義。一般來說，最多只有一個編碼值（coding values）會被標記為UserSelected = true。",
        "requirements" : "允許代碼系統中的替代編碼，以及翻譯到其他編碼系統。",
        "type" : [
          {
            "code" : "Coding",
            "profile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Coding-tw"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CodeableConcept.text",
        "path" : "CodeableConcept.text",
        "short" : "概念的文字表示法",
        "definition" : "輸入資料的使用者所見／所選／所說的人類可讀文字表述，和（或）其代表使用者的預期含義。",
        "comment" : "很多時候，此文字表述與其中一個代碼的顯示名稱相同。",
        "requirements" : "專門術語中的代碼並不總是能捕捉人類使用的細微差別的正確意義，或者根本就沒有合適的代碼；這些情況下，文字表述被用來捕捉來源的全部意義。",
        "mustSupport" : true
      }
    ]
  }
}

```
