# TW Core CareTeam - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core CareTeam 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreCareTeam |

 
此臺灣核心-照護團隊(TW Core CareTeam) Profile 說明本 IG 如何進一步定義 FHIR 的 CareTeam Resource 以呈現照護團隊資料。 

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core CareTeam](StructureDefinition-CareTeam-twcore.md), [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md), [TW Core ImagingStudy](StructureDefinition-ImagingStudy-twcore.md)...Show 23 more,[TW Core Media](StructureDefinition-Media-twcore.md),[TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md),[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation BMI](StructureDefinition-Observation-bmi-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Care Experience Preference](StructureDefinition-Observation-careExperiencePreference-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Occupation](StructureDefinition-Observation-occupation-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Pregnancy Status](StructureDefinition-Observation-pregnancy-status-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Screening Assessment](StructureDefinition-Observation-screening-assessment-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [CareTeam/careteam-example](CareTeam-careteam-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/CareTeam-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CareTeam-twcore.csv), [Excel](StructureDefinition-CareTeam-twcore.xlsx), [Schematron](StructureDefinition-CareTeam-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-CareTeam-patient.md)**及**[`status`](SearchParameter-CareTeam-status.md)**查詢所有CareTeam：
* 包含支援透過以下`_include`參數：`CareTeam:participant:PractitionerRole,CareTeam:participant:Practitioner,CareTeam:participant:Patient,CareTeam:participant:RelatedPerson` 
 ([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference)) 
 ([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
 `GET [base]/CareTeam?patient={Type/}[id]&status={system|}[code]{,{system|}[code],...}`
例子：
(1) GET [base]/CareTeam?patient=Patient/pat-example&status=active
(1) GET [base]/CareTeam?patient=Patient/pat-example&status=active&_include=CareTeam:participant:RelatedPerson&_include=CareTeam:participant:Patient&_include=CareTeam:participant:Practitioner&_include=CareTeam:participant:PractitionerRole

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-CareTeam-patient.md)**及**[`role`](SearchParameter-CareTeam-role.md)**查詢所有CareTeam：
* 包含支援透過以下`_include`參數：`CareTeam:participant:PractitionerRole,CareTeam:participant:Practitioner,CareTeam:participant:Patient,CareTeam:participant:RelatedPerson` 
 ([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference)) 
 ([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
 `GET [base]/CareTeam?patient={Type/}[id]&role={system|}[code]{,{system|}[code],...}`
例子：
(1) GET [base]/CareTeam?patient=Patient/pat-example&role=http://snomed.info/sct|17561000



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CareTeam-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreCareTeam",
  "title" : "TW Core CareTeam",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-照護團隊(TW Core CareTeam) Profile 說明本 IG 如何進一步定義 FHIR 的 CareTeam Resource 以呈現照護團隊資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CareTeam",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CareTeam",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CareTeam",
        "path" : "CareTeam",
        "short" : "在健康照護過程中提供服務的照護團隊",
        "definition" : "指明受照護者所需要的團隊，此資源用來識別參與關照受照護者或為受照護者(個人或群體)提供醫療保健服務的一群人及其在團隊中的角色。"
      },
      {
        "id" : "CareTeam.id",
        "path" : "CareTeam.id",
        "short" : "不重複的 ID 用以識別儲存在特定 FHIR Server 中的 CareTeam 紀錄，通常又稱為邏輯性 ID。",
        "definition" : "resource 的邏輯 ID，在 resource 的 URL 中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個 resource 使用新增操作(create operation)提交給伺服器時，此 resource 沒有 id，它的 id 在 resource 被創建後由伺器分配/指定。"
      },
      {
        "id" : "CareTeam.meta",
        "path" : "CareTeam.meta",
        "short" : "此 CareTeam Resource 的 metadata",
        "definition" : "關於 resource 的 metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與 resource 的版本更改相關聯。"
      },
      {
        "id" : "CareTeam.language",
        "path" : "CareTeam.language",
        "short" : "用以表述 CareTeam Resource 內容的語言。",
        "definition" : "編寫此 resource 的語言",
        "comment" : "提供語言是為了支援索引和可存取性(通常，文字表述轉語音等服務使用此語言標籤)。html lanuage tag 適用於此敘述。resource 上的語言標籤可用於指定從 resource 中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定 Resource.language 自動適用於敘述。如果指定語言，它也應該被指定在 html 中的 div 資料項目(關於 xml:lang 和 html lang 屬性之間的關係，見 HTML5 中的規則)。",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用 CommonLanguages 代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "CareTeam.status",
        "path" : "CareTeam.status",
        "definition" : "照護團隊目前的狀態。",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "CareTeamStatus"
            }
          ],
          "strength" : "required",
          "description" : "代表照護團隊狀態的代碼；應填入所綁定值集中的其中一個代碼。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/care-team-status|4.0.1"
        }
      },
      {
        "id" : "CareTeam.subject",
        "path" : "CareTeam.subject",
        "short" : "照護團隊所照護的對象是誰？",
        "definition" : "照護團隊所關照的個人或群體。",
        "comment" : "參照可能是相對的，絕對的或內部的。",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.encounter",
        "path" : "CareTeam.encounter",
        "short" : "與此 CareTeam 相關的就醫事件",
        "definition" : "此 CareTeam 是在哪次就醫情境中確定或修正的。",
        "comment" : "此資料項目不用於記錄照護團隊負責的所有就診。就診用來提供建立或變更照護團隊的情境。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CareTeam.participant",
        "path" : "CareTeam.participant",
        "short" : "照護團隊中的成員",
        "definition" : "照護團隊的成員，包含他們在團隊中扮演的角色和負責的時間段。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.participant.role",
        "path" : "CareTeam.participant.role",
        "short" : "照護團隊成員的角色",
        "definition" : "指明此照護團隊成員在團隊中所扮演的角色。",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "description" : "應填入所綁定值集中適合的代碼，確定無適合的代碼才可以使用其他值集的代碼來表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/participant-role"
        }
      },
      {
        "id" : "CareTeam.participant.member",
        "path" : "CareTeam.participant.member",
        "short" : "團隊成員是誰",
        "definition" : "團隊成員可能是個人、組織、照護者，或是具有特定角色的醫事人員，或是將角色代表給特定個人或組織的醫事職務。",
        "comment" : "參照可能是相對的，絕對的或內部的。",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CareTeam.participant.onBehalfOf",
        "path" : "CareTeam.participant.onBehalfOf",
        "short" : "組織成員代表誰",
        "definition" : "團隊成員代表的組織。",
        "comment" : "若成員是個人，此資料項目可用來表示此個人代表某個組織。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CareTeam.reasonReference",
        "path" : "CareTeam.reasonReference",
        "short" : "為何需要此照護團隊",
        "definition" : "描述建立照護團隊的原因或需要照護團隊服務的情況。",
        "comment" : "可能的原因包括：病人目前的健康狀況、潛在的健康問題、複雜的醫療需求、已安排的程序(例如：手術)或出院後服務計畫。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CareTeam.managingOrganization",
        "path" : "CareTeam.managingOrganization",
        "short" : "照護團隊所屬的組織",
        "definition" : "負責召集或管理此照護團隊的組織。",
        "comment" : "此資料項目與 participant.member 中包含的組織不同，它特指負責管理照護團隊的組織。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore"
            ]
          }
        ]
      }
    ]
  }
}

```
