# TW Core CarePlan - 臺灣核心實作指引(TW Core IG) v1.0.0

* [**Home**](index.md)

## Resource Profile: TW Core CarePlan 

| | |
| :--- | :--- |
| *Official URL*:https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore | *Version*:1.0.0 |
| Active as of 2026-01-07 | *Computable Name*:TWCoreCarePlan |

 
此臺灣核心-照護計畫(TW Core CarePlan) Profile 說明本 IG 如何進一步定義 FHIR 的 CarePlan Resource 以呈現照護計畫資料。 

**Usages:**

* Refer to this Profile: [TW Core CarePlan](StructureDefinition-CarePlan-twcore.md), [TW Core DiagnosticReport](StructureDefinition-DiagnosticReport-twcore.md), [TW Core MedicationRequest](StructureDefinition-MedicationRequest-twcore.md), [TW Core MedicationStatement](StructureDefinition-MedicationStatement-twcore.md)...Show 19 more,[TW Core Observation Average Blood Pressure](StructureDefinition-Observation-averageBloodPressure-twcore.md),[TW Core Observation Blood Pressure](StructureDefinition-Observation-bloodPressure-twcore.md),[TW Core Observation Body Height](StructureDefinition-Observation-body-height-twcore.md),[TW Core Observation Body Temperature](StructureDefinition-Observation-body-temperature-twcore.md),[TW Core Observation Body Weight](StructureDefinition-Observation-body-weight-twcore.md),[TW Core Observation Clinical Result](StructureDefinition-Observation-clinical-result-twcore.md),[TW Core Observation ECG](StructureDefinition-Observation-ecg-twcore.md),[TW Core Observation Head Circumference](StructureDefinition-Observation-head-circumference-twcore.md),[TW Core Observation Heart Rate](StructureDefinition-Observation-heart-rate-twcore.md),[TW Core Observation Pregnancy Intent](StructureDefinition-Observation-pregnancy-intent-twcore.md),[TW Core Observation Respiratory Rate](StructureDefinition-Observation-respiratory-rate-twcore.md),[TW Core Observation Sexual Orientation](StructureDefinition-Observation-sexual-orientation-twcore.md),[TW Core Simple Observation](StructureDefinition-Observation-simple-twcore.md),[TW Core Observation Smoking Status](StructureDefinition-Observation-smoking-status-twcore.md),[TW Core Observation Treatment Intervention Preference](StructureDefinition-Observation-treatment-intervention-preference-twcore.md),[TW Core Observation Vital Signs](StructureDefinition-Observation-vitalSigns-twcore.md),[TW Core Procedure](StructureDefinition-Procedure-twcore.md),[TW Core QuestionnaireResponse](StructureDefinition-QuestionnaireResponse-twcore.md)and[TW Core ServiceRequest](StructureDefinition-ServiceRequest-twcore.md)
* Examples for this Profile: [CarePlan/careplan-example](CarePlan-careplan-example.md)
* CapabilityStatements using this Profile: [臺灣核心-用戶端（TW Core Client）](CapabilityStatement-CapabilityStatementTWCoreClient.md) and [臺灣核心-伺服端（TW Core Server）](CapabilityStatement-CapabilityStatementTWCoreServer.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/tw.gov.mohw.twcore|current/StructureDefinition/CarePlan-twcore)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-CarePlan-twcore.csv), [Excel](StructureDefinition-CarePlan-twcore.xlsx), [Schematron](StructureDefinition-CarePlan-twcore.sch) 

### Notes:

以下概述了此Profile所需的RESTful FHIR互動功能。有關TW Core IG支援的RESTful互動功能的完整清單，請參閱[TW Core Server能力聲明](CapabilityStatement-CapabilityStatementTWCoreServer.md)。

#### 必須支援以下查詢參數：

1. **必須（SHALL）**支援透過查詢參數**[`patient`](SearchParameter-CarePlan-patient.md)**及**[`category`](SearchParameter-CarePlan-category.md)**查詢所有CarePlan：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/CarePlan?patient={Type/}[id]&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-twy|assess-plan`例子：
(1) GET [base]/CarePlan?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw|assess-plan

#### 建議應該支援以下查詢參數：

1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-CarePlan-patient.md)**、**[`category`](SearchParameter-CarePlan-category.md)**及**[`date`](SearchParameter-CarePlan-date.md)**查詢所有CarePlan：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/CarePlan?patient={Type/}[id]&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-twy|assess-plan&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/CarePlan?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw|assess-plan&date=ge2019-01-01T00:00:00Z
(2) GET [base]/CarePlan?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw|assess-plan&date=ge2018-01-01T00:00:00Z&date=le2019-01-01T00:00:00Z
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-CarePlan-patient.md)**、**[`category`](SearchParameter-CarePlan-category.md)**及**[`status`](SearchParameter-CarePlan-status.md)**查詢所有CarePlan：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
`GET [base]/CarePlan?patient={Type/}[id]&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-twy|assess-plan&status={system|}[code]{,{system|}[code],...}`例子：
(1) GET [base]/CarePlan?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw|assess-plan&status=active
1. **建議應該（SHOULD）**支援透過查詢參數**[`patient`](SearchParameter-CarePlan-patient.md)**、**[`category`](SearchParameter-CarePlan-category.md)**、**[`status`](SearchParameter-CarePlan-status.md)**及**[`date`](SearchParameter-CarePlan-date.md)**查詢所有CarePlan：
([如何透過reference查詢](http://hl7.org/fhir/R4/search.html#reference))
([如何透過token查詢](http://hl7.org/fhir/R4/search.html#token))
([如何透過date查詢](http://hl7.org/fhir/R4/search.html#date))
`GET [base]/CarePlan?patient={Type/}[id]&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-twy|assess-plan&status={system|}[code]{,{system|}[code],...}&date={gt|lt|ge|le}[date]{&date={gt|lt|ge|le}[date]&...}`例子：
(1) GET [base]/CarePlan?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw|assess-plan&status=active&date=ge2019-01-01T00:00:00Z
(2) GET [base]/CarePlan?patient=Patient/pat-example&category=https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw|assess-plan&status=active&date=ge2018-01-01T00:00:00Z&date=le2019-01-01T00:00:00Z



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "CarePlan-twcore",
  "url" : "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore",
  "version" : "1.0.0",
  "name" : "TWCoreCarePlan",
  "title" : "TW Core CarePlan",
  "status" : "active",
  "date" : "2026-01-07T07:13:09+00:00",
  "contact" : [
    {
      "name" : "衛生福利部",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.mohw.gov.tw/"
        },
        {
          "system" : "email",
          "value" : "CCYU@mohw.gov.tw"
        }
      ]
    }
  ],
  "description" : "此臺灣核心-照護計畫(TW Core CarePlan) Profile 說明本 IG 如何進一步定義 FHIR 的 CarePlan Resource 以呈現照護計畫資料。",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CarePlan",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CarePlan",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CarePlan",
        "path" : "CarePlan",
        "short" : "特定照護目標下為一位患者或一群患者識別的活動、干預和結果計畫",
        "definition" : "描述為實現一個或多個目標而將為一位患者(或一群患者)進行的活動的計畫，包括診斷、監測、評估、治療、藥物治療、追蹤等。"
      },
      {
        "id" : "CarePlan.id",
        "path" : "CarePlan.id",
        "short" : "不重複的 ID 用以識別儲存在特定 FHIR Server 中的 CarePlan 紀錄，通常又稱為邏輯性 ID。",
        "definition" : "resource 的邏輯 ID，在 resource 的 URL 中使用。一旦指定，這個值永遠不會改變。",
        "comment" : "一個 resource 使用新增操作(create operation)提交給伺服器時，此 resource 沒有 id，它的 id 在 resource 被創建後由伺器分配/指定。"
      },
      {
        "id" : "CarePlan.meta",
        "path" : "CarePlan.meta",
        "short" : "此 CarePlan Resource 的 metadata",
        "definition" : "關於 resource 的 metadata。這是由基礎建設維護的內容。內容的更改可能並不總是與 resource 的版本更改相關聯。"
      },
      {
        "id" : "CarePlan.implicitRules",
        "path" : "CarePlan.implicitRules",
        "short" : "創建此內容所依據的一組規則",
        "definition" : "構建 resource 時遵循的一系列規則的參照，在處理內容時必須理解這些規則。通常這是對 IG 所定義之特殊規則及其他 profiles 的參照。",
        "comment" : "宣告這套規則限制了內容只能被有限的交易夥伴所理解。這從本質上限制了資料的長期有用性。然而，現有的健康生態體系高度分裂，還沒有準備好以普遍可計算的方式定義、收集和交換資料。只要有可能，實作者和/或規範編寫者應該避免使用這個資料項目。通常在使用時，此 URL 是對 IG 的參照，此 IG 將這些特殊規則與其他 profiles、value sets 等一起定義為其敘述的一部分。"
      },
      {
        "id" : "CarePlan.language",
        "path" : "CarePlan.language",
        "short" : "用以表述 CarePlan Resource 內容的語言",
        "definition" : "編寫此 resource 的語言",
        "comment" : "提供語言是為了支援索引和可存取性(通常，文字表述轉語音等服務使用此語言標籤)。html lanuage tag 適用於此敘述。resource 上的語言標籤可用於指定從 resource 中的資料所產成的其他表述之語言。不是所有的內容都必須使用此語言。不應該假定 Resource.language 自動適用於敘述。如果指定語言，它也應該被指定在 html 中的 div 資料項目(關於 xml:lang 和 html lang 屬性之間的關係，見 HTML5 中的規則)。",
        "example" : [
          {
            "label" : "Value",
            "valueString" : "zh-TW"
          }
        ],
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet",
              "valueCanonical" : "http://hl7.org/fhir/ValueSet/all-languages"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "Language"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-isCommonBinding",
              "valueBoolean" : true
            }
          ],
          "strength" : "preferred",
          "description" : "人類語言；鼓勵使用 CommonLanguages 代碼表中的代碼，但不強制一定要使用此代碼表，你也可使用其他代碼表的代碼或單純以文字表示。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/languages"
        }
      },
      {
        "id" : "CarePlan.text",
        "path" : "CarePlan.text",
        "short" : "CarePlan Resource 之內容摘要以供人閱讀",
        "definition" : "人可讀的敘述，包含 resource 的摘要，可用於向人表述 resource 的內容。敘述不需要對所有的結構化資料進行編碼，但需要包含足夠的細節使人在閱讀敘述時理解「臨床安全性」。resource 定義有哪些內容應該在敘述中表示，以確保臨床安全。",
        "comment" : "內嵌(contained)的 resource 沒有敘述，非內嵌(contained)的 resource 則 **建議應該(SHOULD)** 有敘述。有時 resource 可能只有文字表述，很少或沒有額外的結構化資料(只要滿足所有 minOccurs=1 的資料項目)。這可能出現在舊系統的資料，當資訊以 「文字表述區塊(text blob)」的形式被取得，或者文字表述是原始輸入或說明，而編碼資訊稍後再添加。",
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.text.status",
        "path" : "CarePlan.text.status",
        "short" : "generated | additional",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "敘述狀態的受限值集。",
          "valueSet" : "https://twcore.mohw.gov.tw/ig/twcore/ValueSet/narrative-status"
        }
      },
      {
        "id" : "CarePlan.text.div",
        "path" : "CarePlan.text.div",
        "short" : "有限的 xhtml 內容",
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.basedOn",
        "path" : "CarePlan.basedOn",
        "short" : "履行或延伸的照護計畫",
        "definition" : "識別此照護計畫所建立的父計畫。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.replaces",
        "path" : "CarePlan.replaces",
        "short" : "被此計畫取代的照護計畫",
        "definition" : "識別被此照護計畫所取代的照護計畫。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.partOf",
        "path" : "CarePlan.partOf",
        "short" : "作為父照護計畫的一部分",
        "definition" : "此照護計畫是另一個照護計畫的一部分。例如，專門針對骨折修復或糖尿病控制的計畫可能是出院護理計畫的一部分。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CarePlan-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.status",
        "path" : "CarePlan.status",
        "short" : "照護計畫目前的狀態",
        "definition" : "指明照護計畫是否正在執行中、表示未來意向或現在已成為歷史記錄。",
        "comment" : "可以在 [[event.html#statemachine | 事件模式]] 文件中找到一個標準的狀態轉換圖。「未知」不代表「其他」狀態 - 必須使用其中一個已定義的狀態，「未知」用於表示不確定當前狀態。",
        "requirements" : "指出計畫是否正在實施、代表未來意圖或是現在的歷史記錄。",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "指出計畫是否正在實施、代表未來意圖或是現在的歷史記錄。",
          "valueSet" : "http://hl7.org/fhir/ValueSet/request-status"
        }
      },
      {
        "id" : "CarePlan.intent",
        "path" : "CarePlan.intent",
        "short" : "照護計畫的意圖",
        "definition" : "表示與照護計畫相關的權威性/意向性程度。",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "description" : "表示與照護計畫相關的權威性/意向性程度的代碼",
          "valueSet" : "http://hl7.org/fhir/ValueSet/care-plan-intent"
        }
      },
      {
        "id" : "CarePlan.category",
        "path" : "CarePlan.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "pattern",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "照護計畫的類型",
        "definition" : "照護計畫的類型。",
        "requirements" : "識別這是什麼「種類」的計畫，以支援多個共存計畫之間的區分；例如：「居家健康」、「精神科」、「氣喘」、「疾病管理」、「保健計畫」等。",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.category:AssessPlan",
        "path" : "CarePlan.category",
        "sliceName" : "AssessPlan",
        "short" : "評估計畫",
        "min" : 1,
        "max" : "1",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://twcore.mohw.gov.tw/ig/twcore/CodeSystem/careplan-category-tw",
              "code" : "assess-plan"
            }
          ]
        },
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.subject",
        "path" : "CarePlan.subject",
        "short" : "照護計畫的對象",
        "definition" : "照護計畫是為了誰。",
        "requirements" : "識別計畫描述其意圖照護的病人或群體。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "http://hl7.org/fhir/StructureDefinition/Group"
            ],
            "_targetProfile" : [
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : true
                  }
                ]
              },
              {
                "extension" : [
                  {
                    "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support",
                    "valueBoolean" : false
                  }
                ]
              }
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "CarePlan.encounter",
        "path" : "CarePlan.encounter",
        "short" : "與此照護計畫相關的就醫事件",
        "definition" : "此照護計畫是在哪個就醫情境產生的。",
        "comment" : "參照可以是相對的、絕對的或內部的。注意：如果 Encounter 參照是一個 Episode of Care 的一部分，則此資料點不足以隱含建立關聯。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Encounter-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.author",
        "path" : "CarePlan.author",
        "short" : "照護計畫的作者",
        "definition" : "負責建立照護計畫內容的個人或組織。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.contributor",
        "path" : "CarePlan.contributor",
        "short" : "對計畫提供資訊的人員",
        "definition" : "對照護計畫的建立提供資訊的個人或組織，但不對照護計畫負責。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.careTeam",
        "path" : "CarePlan.careTeam",
        "short" : "執行照護工作的團隊",
        "definition" : "確定負責執行此照護計畫的照護團隊。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.addresses",
        "path" : "CarePlan.addresses",
        "short" : "本計畫處理的健康問題",
        "definition" : "本照護計畫試圖解決的健康問題(例如：疾病、病情、問題)。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity.reference",
        "path" : "CarePlan.activity.reference",
        "short" : "照護行動的明細",
        "definition" : "包含照護計畫之照護行動(診斷、治療等)明細的 request/request-like 資源。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Appointment",
              "http://hl7.org/fhir/StructureDefinition/CommunicationRequest",
              "http://hl7.org/fhir/StructureDefinition/DeviceRequest",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/MedicationRequest-twcore",
              "http://hl7.org/fhir/StructureDefinition/NutritionOrder",
              "http://hl7.org/fhir/StructureDefinition/Task",
              "http://hl7.org/fhir/StructureDefinition/ServiceRequest",
              "http://hl7.org/fhir/StructureDefinition/VisionPrescription",
              "http://hl7.org/fhir/StructureDefinition/RequestGroup"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity.detail.reasonReference",
        "path" : "CarePlan.activity.detail.reasonReference",
        "short" : "為何需要此行動",
        "definition" : "指出為何此行動是此照護計畫的一部分。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Condition-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Observation-clinical-result-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DiagnosticReport-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/DocumentReference-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity.detail.location",
        "path" : "CarePlan.activity.detail.location",
        "short" : "行動發生的地點",
        "definition" : "預期要執行此行動的地點。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Location-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity.detail.performer",
        "path" : "CarePlan.activity.detail.performer",
        "short" : "執行或提供此行動的人員",
        "definition" : "確定預期要執行此行動的特定人員或組織。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Practitioner-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/PractitionerRole-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Organization-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/RelatedPerson-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Patient-twcore",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/CareTeam-twcore",
              "http://hl7.org/fhir/StructureDefinition/HealthcareService",
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Device-twcore"
            ]
          }
        ]
      },
      {
        "id" : "CarePlan.activity.detail.product[x]",
        "path" : "CarePlan.activity.detail.product[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "CarePlan.activity.detail.product[x]:productReference",
        "path" : "CarePlan.activity.detail.product[x]",
        "sliceName" : "productReference",
        "short" : "物料/主題/產品資訊要參照的資源",
        "definition" : "辨識行動所涉及的物料/主題/產品。",
        "comment" : "參照可以是相對的、絕對的或內部的。",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://twcore.mohw.gov.tw/ig/twcore/StructureDefinition/Medication-twcore",
              "http://hl7.org/fhir/StructureDefinition/Substance"
            ]
          }
        ]
      }
    ]
  }
}

```
